patches-own [ 
  dye-color                                                       ;Variable to adopt dye color from turtles
  true-color ]                                                    ;Output variable from "dye-color" which creates patch color
turtles-own [
  true-speed ]                                                    ;Speed of turtles
globals [ 
  direction                                                       ;Variable for variablity in direction
  hatch-rate                                                      ;Frequency of hatching/spreading dye trails
  color-change-factor                                             ;Variable to alter color constants
  turtle-dyecolor]                                                ;Variable to dye patches a color

to setup
  clear-all                                                       ;Clears all entities and resets all patches
  check-color-change-factor                                       ;Executes the function "check-color-change-factor"
  set turtle-dyecolor (19 + (10 * color-change-factor))           ;Sets the turtle-dyecolor relative to the the color-change-factor
  set-default-shape turtles "circle"                              ;Sets the default shape for all turtles to "circle"
  ask patches [set dye-color (10.1 + (10 * color-change-factor))] ;Sets the default background to the corresponding white color
  ask turtles [set true-speed turtle-speed]                       ;Transfers the slider variable to the turtles-own

  create-turtles 1                                                ;Creates 1 turtle as a dye source
  [ setxy 0 48                                                    ;Sets the coordinates of the turtle to 0 on the x-axis and 48 and the y-axis
    set heading 180                                               ;Sets the heading of the turtle so that it faces down
    hide-turtle                                                   ;Hides the turtles so that only the diffusion pattern that it creates is apparent
    set dye-color (19 + (10 * color-change-factor)) ]             ;Sets the dye-color, an attribute of the patches, relative to the color-change-factor
  heat-check                                                      ;Executes the heat-check function, which sets variables relative to temperature
  invert-dyecolor                                                 ;Executes the invert-dyecolor function, which inverts the values of patch color that is created by the "diffuse" command
  recolor-patches                                                 ;Executes the recolor-patches function, which colors patches based off of the true-color variable
  reset-ticks
end

to check-color-change-factor
  if color-choice = "red" 
    [set color-change-factor 0]                                   ;If the color-choice is red, then the value of the color-change-factor is set to 0
  if color-choice = "orange"
    [set color-change-factor 1]                                   ;If the color-choice is orange, then the value of the color-change factor is set to 1
  if color-choice = "green"
    [set color-change-factor 4]                                   ;If the color-choice is green, then the value of the color-change factor is set to 4
  if color-choice = "blue"
    [set color-change-factor 9]                                   ;If the color-choice is blue, then the value of the color-change factor is set to 9
  if color-choice = "magenta"
    [set color-change-factor 11]                                  ;If the color-choice is magenta, then the value of the color-change factor is set to 11
  if color-choice = "grey"
    [set color-change-factor -1]                                  ;If the color-choice is grey, then the value of the color-change factor is set to -1
end

to heat-check
  set direction (temperature - 295)                               ;Sets the direction, a global variable, relative to the temperature as defined by the slider
  set hatch-rate ((temperature * .19) - 50)                       ;Sets the hatch-rate, a variable that determines the rate at which turtles multiply, relative to the temperature
end


to go
  heat-check                                                      ;Executes the heat-check function, which sets variables relative to temperature
  
  ask turtles [ if turtle-dyecolor < [dye-color] of patch-here    ;If the turtle lands on a patch that is lighter than its turtle-dyecolor value, it dies
     [die]]
  
  ask turtles [ set dye-color turtle-dyecolor ]                   ;The turtle sets the dye-color of the patch that it is on to its turtle-dyecolor
  
  if ticks mod 10 = 0 [ask turtles [                              ;If the remainder ticks divided by 10 is 0, then the turtle-dyecolor is decreased by .01
    set turtle-dyecolor turtle-dyecolor - .01] ]
  ask turtles [if turtle-dyecolor < 
    (12 + (10 * color-change-factor))                             ;If the turtle-dyecolor is less than a value determined by the color-change-factor then the turtle-dyecolor will be set to that value
    [set turtle-dyecolor 12 + (10 * color-change-factor)] ]
 
  ask turtles [                                                   ;Asks the turtles to rotate a random amount that is determined by the variable, direction
    fd turtle-speed]                                              ;Asks turtles to move by the value of turtle-speed as determined by the slider
  
  if ticks > 10 [ ask turtles [                                   ;If ticks are greater than 10
    rt random direction - random direction] ]                     ;turtles will move a random direction right or left

  diffuse dye-color diffusion-rate                                ;Diffuses the value of dye-color accross nearby patches at the rate determined by the diffusion-rate slider
  invert-dyecolor                                                 ;Executes the invert-dyecolor function, which inverts the values of patch color that is created by the "diffuse" command
  recolor-patches                                                 ;Executes the recolor-patches function, which colors patches based off of the true-color variable
  spread                                                          ;Executes the spread function, which randomly hatches turtles at a determined rate
  tick                                                            ;Makes a tick pass
  wait .1                                                         ;Waits a tenth of a second
end

to invert-dyecolor
  if color-choice = "red"                                         ;Sets the value of true-color in relation to dye-color if the color-choice is red
    [ask patches 
      [set true-color (0 - dye-color) + 30] ] 
  if color-choice = "orange"                                      ;Sets the value of true-color in relation to dye-color if the color-choice is orange
    [ask patches 
      [set true-color (0 - dye-color) + 50] ]
  if color-choice = "green"                                       ;Sets the value of true-color in relation to dye-color if the color-choice is green
    [ask patches 
      [set true-color (0 - dye-color) + 110] ]
  if color-choice = "blue"                                        ;Sets the value of true-color in relation to dye-color if the color-choice is blue
    [ask patches 
      [set true-color (0 - dye-color) + 210] ]
  if color-choice = "magenta"                                     ;Sets the value of true-color in relation to dye-color if the color-choice is magenta
    [ask patches 
      [set true-color (0 - dye-color) + 250] ]
  if color-choice = "grey"                                        ;Sets the value of true-color in relation to dye-color if the color-choice is grey
    [ask patches 
      [set true-color (0 - dye-color) + 10] ]
  
end

to recolor-patches  
  ask patches [ set pcolor true-color ]                           ;color patches according to true-color
end

to spread
  if random 100 < hatch-rate [ask turtles [hatch 1                ;If the hatch-rate is less than the randomly generated value, create one turtle
    [ set heading (heading + random 40 - random 40)]]]            ;with random heading
  ask turtles [if count turtles > 100                             ;If there are more than 100 turtles, then turtles will die until there are 100 or less turtles
    [die] ]
end
@#$#@#$#@
GRAPHICS-WINDOW
294
10
738
475
50
50
4.3
1
10
1
1
1
0
0
0
1
-50
50
-50
50
1
1
1
ticks
30.0

BUTTON
12
10
196
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
200
11
290
73
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
13
50
195
83
turtle-speed
turtle-speed
.5
3
1
.5
1
NIL
HORIZONTAL

SLIDER
13
93
195
126
diffusion-rate
diffusion-rate
0
1
0.7
.1
1
NIL
HORIZONTAL

SLIDER
13
137
194
170
temperature
temperature
300
350
320
1
1
K
HORIZONTAL

MONITOR
200
78
291
123
Dye Trails
count turtles
0
1
11

CHOOSER
199
127
291
172
color-choice
color-choice
"red" "orange" "green" "blue" "magenta" "grey"
4

@#$#@#$#@
## WHAT IS IT?

This model primarily simulates the qualittative relationship between liquid diffusion and temperature (K). The model begins with one drop of colored dye at the top of the world which diffuses, or spreads, slowly throughout the clear, in this simulation white, water. 

## HOW IT WORKS

This model utilizes several key procedures and global variables in order to function:

* [turtle-dyecolor] is a global defined as the color of the dye. This variable allows the hidden turtle(s) in motion within the world to change their respective patch color to that of the predefined global.


* [dye-color] & [true-color] are two patches-own variables that allow the patches to change their color. At each [go] iteration, the patches beneath the turtles adopt the [turtle-dyecolor] as their own dyecolor. However, because the [diffuse] command lowers the variable of color, which in turn darkens the color, it is important to invert the numbers. Using equations found for each predefined color, [dye-color] is converted to [true-color] and then [true-color] is set as the new patch color in order to allow proper color diffusion. 


* [temperature] is the main variable that alters how diffusion is carried out. It affects the [direction] and [hatch-rate] of each turtle. Higher temperatures lead to more variability in direction and more frequent splitting, or hatching, of turtles. 


* [color-choice] is defined in the User interface (UI) and defines aesthetic color of the dye. Within the code, this leads the [check-color-change-factor] procedure to define the [color-change-factor]. This factor allows the constants within the code to increase or decrease by multiples of 10 in order to properly adjust color coefficients. For example, selecting orange, which is one set of ten data values away from base color red, creates a [color-change-factor] of 1. This leads the [turtle-dye-color] to increase in value during the set-up by a factor of 1 x 10, giving an orange dye color instead of base red. 

* [dye trials] on the UI defines how many turtles are currently dying the world in the given color. 

## HOW TO USE IT

(1) Choose a color in the [color-choice] input.
(2) Select a temperature in the appropriate slider. Optional: Alter the turtle speed and the diffusion rate. 
(3) Click [setup].
(4) Click [go].

At any point during the model, the "go" button can be deslected to stop the model manually.

As the model runs, changing the color will yeild values that alter the overall dye color incorrectly and provide miscolored dye. 

## THINGS TO NOTICE

As the simulation is running, notice how the dye gradually splits into multiple trails. Also notice how, over time, the dye decreases in saturation. How does this represent diffusion?

## THINGS TO TRY

1) Compare the maximum temperature and minimum temperature? How does directionality of the dye change? 

2) How does diffusion rate affect the final visual result? 

3) Change the [turtle-speed] to 0.5, the minimum. How does this affect the final visual result? 


## EXTENDING THE MODEL

A weakness in the accuracy of this model is the lack of depreciation of the dye trails over time, leading to an unlimited concentration of dye over a large span of time. Extending the model can include the decrease in the initial concentration of dye. 

To make the code more complicated, this model can become mathematical using a matlab extension that calculates gradient of diffusion. More simply, this model can also be upgraded by streamlining color choice procedures to allow a wider array of color choice. 

Lastly, this model can become more complex by allowing the user to define the medium in which the dye runs. For example, instead of pure water, the dye can run inside salt water. 

## NETLOGO FEATURES

Note the use of [globals] at the top of the code to define variables not present in the user interface. 

The cornerstone of this model is the singular use of [diffuse] which allows the patches to spread its [dye-color] to their eight surrounding patches. 

## RELATED MODELS

This model is based on Uri Wilensky's "Diffusion Graphics" model which simulates temperature diffusion. In particular, this liquid diffusion simulation borrows Wilensky's turtle to patch variable exchange, which gives the [turtle-dyecolor] to patches in the form of [dye-color].

## CREDITS AND REFERENCES

Programmed by: Joshua Abraham and Darren Nguyen
Teacher: Mr. Reese
Tracy High School IB Physics Period 1


Credit to NetLogo program and for the "Diffusion Graphics" model for fractions of this simulation's code:

* Wilensky, U. (1997). NetLogo Diffusion Graphics model. http://ccl.northwestern.edu/netlogo/models/DiffusionGraphics. Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.
* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
