;Project by Gagana B

to setup
  ;;
  ;;driver function to setup the world
  ;;
   clear-all
end

to lan
  clear-all
  
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; Local Area Network Architecture ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
  set-default-shape turtles "circle" ;Setting default shape of turtle to circle
  create-turtles 8                   ;Creating 8 turtles
  ask turtles[set color gray]        ;Setting color of turtles to gray
  ;;
  ;;Defining headings of turtles
  ;;
  ask turtle 7[set heading 0]
  ask turtle 0[set heading 0]
  ask turtle 1[set heading 45]
  ask turtle 2[set heading 90]
  ask turtle 3[set heading 135]
  ask turtle 4[set heading 180]
  ask turtle 5[set heading 225]
  ask turtle 6[set heading 270]
  ;making the turtles leave a trail
  ask turtles [set pen-mode "down"]
  ;defining the movement of turtles to form a lan network 
  ask turtle 1[forward 15]
  ask turtle 2[forward 15]
  ask turtle 3[forward 15]
  ask turtle 4[forward 15]
  ask turtle 5[forward 15]
  ask turtle 6[forward 15]
end

to wan
  clear-all
  
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; Wide Area Network Architecture ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
  set-default-shape turtles "circle" ;Setting default shape of turtle to circle
   create-turtles 36                 ;Creating 36 turtles
  ask turtles[set color cyan]        ;Setting color of turtles to cyan
  ;;
  ;;Defining headings of turtles
  ;;
  ask turtle 7[set heading 0]
  ask turtle 0[set heading 0]
  ask turtle 1[set heading 45]
  ask turtle 2[set heading 90]
  ask turtle 3[set heading 135]
  ask turtle 4[set heading 180]
  ask turtle 5[set heading 225]
  ask turtle 6[set heading 270]
  ask turtle 8[set heading 325]
  ask turtle 9[set heading 325]
  ask turtle 10[set heading 325]
  ask turtle 11[set heading 325]
  ask turtle 12[set heading 325]
  ask turtle 13[set heading 325]
  ask turtle 14[set heading 325]
  ask turtle 15[set heading 325]
  ask turtle 16[set heading 205]
  ask turtle 17[set heading 205]
  ask turtle 18[set heading 205]
  ask turtle 19[set heading 205]
  ask turtle 20[set heading 205]
  ask turtle 21[set heading 205]
  ask turtle 22[set heading 205]
  ask turtle 23[set heading 205]
  ask turtle 24[set heading 60]
  ask turtle 25[set heading 60]
  ask turtle 26[set heading 60]
  ask turtle 27[set heading 60]
  ask turtle 28[set heading 60]
  ask turtle 29[set heading 60]
  ask turtle 30[set heading 150]
  ask turtle 31[set heading 150]
  ask turtle 32[set heading 150]
  ask turtle 33[set heading 150]
  ask turtle 34[set heading 150]
  ask turtle 35[set heading 150]
  ;making the turtles leave a trail
  ask turtles [set pen-mode "down"]
  ;defining the movement of turtles
  ;;
  ;;Setting up and connecting many lAN's and Wan's to make a WAN
  ;;
  ask turtle 1[forward 5]
  ask turtle 2[forward 5]
  ask turtle 3[forward 5]
  ask turtle 4[forward 5]
  ask turtle 5[forward 5]
  ask turtle 6[forward 5]
  ask turtle 8[forward 14]
  ask turtle 9[forward 14]
  ask turtle 10[forward 14]
  ask turtle 11[forward 14]
  ask turtle 12[forward 14]
  ask turtle 13[forward 14]
  ask turtle 14[forward 14]
  ask turtle 15[forward 14]
  ask turtle 16[forward 12]
  ask turtle 17[forward 12]
  ask turtle 19[forward 12]
  ask turtle 18[forward 12]
  ask turtle 20[forward 12]
  ask turtle 21[forward 12]
  ask turtle 22[forward 12]
  ask turtle 23[forward 12]
  ask turtle 24[forward 10]
  ask turtle 25[forward 10]
  ask turtle 26[forward 10]
  ask turtle 27[forward 10]
  ask turtle 28[forward 10]
  ask turtle 29[forward 10]
  ask turtle 30[forward 10]
  ask turtle 31[forward 10]
  ask turtle 32[forward 10]
  ask turtle 33[forward 10]
  ask turtle 34[forward 10]
  ;;
  ;;setting heading of turtles
  ;;
  ask turtle 8[set heading 0]
  ask turtle 9[set heading 45]
  ask turtle 10[set heading 90]
  ask turtle 11[set heading 135]
  ask turtle 12[set heading 180]
  ask turtle 13[set heading 225]
  ask turtle 14[set heading 270]
  ask turtle 15[set heading 325]
  ;;making the turtles leave a trail as they move
  ask turtles [set pen-mode "down"]
  ;;defining movement of turtles
  ask turtle 9[forward 5]
  ask turtle 10[forward 5]
  ask turtle 11[forward 5]
  ask turtle 12[forward 5]
  ask turtle 13[forward 5]
  ask turtle 14[forward 5]
  ask turtle 15[forward 5]
  ;;
  ;;setting heading of turtles
  ;;
  ask turtle 16[set heading 0]
  ask turtle 17[set heading 45]
  ask turtle 18[set heading 90]
  ask turtle 19[set heading 135]
  ask turtle 20[set heading 180]
  ask turtle 21[set heading 225]
  ask turtle 22[set heading 270]
  ask turtle 23[set heading 325]
  ask turtle 23[set heading 0]
  ;;defining movement of turtles
  ask turtle 23[forward 5]
  ask turtle 17[forward 5]
  ask turtle 18[forward 5]
  ask turtle 19[forward 5]
  ask turtle 20[forward 5]
  ask turtle 21[forward 5]
  ask turtle 22[forward 5]
  ;;
  ;;setting heading of turtles
  ;;
  ask turtle 24[set heading 0]
  ask turtle 25[set heading 45]
  ask turtle 26[set heading 90]
  ask turtle 27[set heading 135]
  ask turtle 28[set heading 180]
  ask turtle 29[set heading 225]
  ;;defining movement of turtles
  ask turtle 25[forward 3]
  ask turtle 26[forward 3]
  ask turtle 27[forward 3]
  ask turtle 28[forward 3]
  ask turtle 29[forward 3]
  ;;
  ;;setting heading of turtles
  ;;
  ask turtle 30[set heading 0]
  ask turtle 31[set heading 90]
  ask turtle 32[set heading 135]
  ask turtle 33[set heading 180]
  ask turtle 34[set heading 225]
  ask turtle 35[set heading 270]
  ;;defining movement of turtles
  ask turtle 30[forward 3]
  ask turtle 31[forward 3]
  ask turtle 32[forward 3]
  ask turtle 33[forward 3]
  ask turtle 34[forward 3]
  ask turtle 35[forward 3]
end

  
to man
  clear-all
  
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; Metropolitan Area Network Architecture ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
  set-default-shape turtles "circle" ;Setting default shape of turtle to circle
  create-turtles 24                   ;Creating 24 turtles
  ask turtles[set color magenta]        ;Setting color of turtles to magenta
  ;;
  ;;Defining headings of turtles
  ;;
  ask turtle 7[set heading 0]
  ask turtle 0[set heading 0]
  ask turtle 1[set heading 45]
  ask turtle 2[set heading 90]
  ask turtle 3[set heading 135]
  ask turtle 4[set heading 180]
  ask turtle 5[set heading 225]
  ask turtle 6[set heading 270]
  ask turtle 8[set heading 325]
  ask turtle 9[set heading 325]
  ask turtle 10[set heading 325]
  ask turtle 11[set heading 325]
  ask turtle 12[set heading 325]
  ask turtle 13[set heading 325]
  ask turtle 14[set heading 325]
  ask turtle 15[set heading 325]
  ask turtle 16[set heading 205]
  ask turtle 17[set heading 205]
  ask turtle 18[set heading 205]
  ask turtle 19[set heading 205]
  ask turtle 20[set heading 205]
  ask turtle 21[set heading 205]
  ask turtle 22[set heading 205]
  ask turtle 23[set heading 205]
  ;making the turtles leave a trail
  ask turtles [set pen-mode "down"]
  ;defining the movement of turtles
  ;;
  ;;Setting up and connecting many LAN's to make a MAN
  ;;
  ask turtle 1[forward 5]
  ask turtle 2[forward 5]
  ask turtle 3[forward 5]
  ask turtle 4[forward 5]
  ask turtle 5[forward 5]
  ask turtle 6[forward 5]
  ask turtle 8[forward 14]
  ask turtle 9[forward 14]
  ask turtle 10[forward 14]
  ask turtle 11[forward 14]
  ask turtle 12[forward 14]
  ask turtle 13[forward 14]
  ask turtle 14[forward 14]
  ask turtle 15[forward 14]
  ask turtle 16[forward 12]
  ask turtle 17[forward 12]
  ask turtle 19[forward 12]
  ask turtle 18[forward 12]
  ask turtle 20[forward 12]
  ask turtle 21[forward 12]
  ask turtle 22[forward 12]
  ask turtle 23[forward 12]
  ;;
  ;;Defining headings of turtles
  ;;
  ask turtle 8[set heading 0]
  ask turtle 9[set heading 45]
  ask turtle 10[set heading 90]
  ask turtle 11[set heading 135]
  ask turtle 12[set heading 180]
  ask turtle 13[set heading 225]
  ask turtle 14[set heading 270]
  ask turtle 15[set heading 325]
  ;;tracking the movement of turtles
  ask turtles [set pen-mode "down"]
  ;;defining movement of turtles
  ask turtle 9[forward 5]
  ask turtle 10[forward 5]
  ask turtle 11[forward 5]
  ask turtle 12[forward 5]
  ask turtle 13[forward 5]
  ask turtle 14[forward 5]
  ask turtle 15[forward 5]
  ;;
  ;;Defining headings of turtles
  ;;
  ask turtle 16[set heading 0]
  ask turtle 17[set heading 45]
  ask turtle 18[set heading 90]
  ask turtle 19[set heading 135]
  ask turtle 20[set heading 180]
  ask turtle 21[set heading 225]
  ask turtle 22[set heading 270]
  ask turtle 23[set heading 325]
  ask turtle 23[set heading 0]
  ;;defining movement of turtles
  ask turtle 23[forward 5]
  ask turtle 17[forward 5]
  ask turtle 18[forward 5]
  ask turtle 19[forward 5]
  ask turtle 20[forward 5]
  ask turtle 21[forward 5]
  ask turtle 22[forward 5]
end

to line
  clear-all
  
  ;;;;;;;;;;;;;;;;;;;;;;;;
  ;; Line Configuration ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;
  
  set-default-shape turtles "circle" ;Setting default shape of turtle to circle
  create-turtles 10                   ;Creating 10 turtles
  ask turtles[set color violet]      ;Setting color of turtles to violet
  ;;
  ;;Defining headings of turtles
  ;;
  ask turtle 0[set heading 90]
  ask turtle 1[set heading 90]
  ask turtle 2[set heading 90]
  ask turtle 3[set heading 90]
  ask turtle 4[set heading 90]
  ask turtle 5[set heading 270]
  ask turtle 6[set heading 270]  
  ask turtle 7[set heading 270]
  ask turtle 8[set heading 270]
  ;making the turtles leave a trail
  ask turtles [set pen-mode "down"]
  ;defining the movement of turtles
  ask turtle 1[forward 2]
  ask turtle 2[forward 4]
  ask turtle 3[forward 6]
  ask turtle 4[forward 8]
  ask turtle 5[forward 2]
  ask turtle 6[forward 4]
  ask turtle 7[forward 6]
  ask turtle 8[forward 8]
  loop
  [ packetline ;;calling function packetline
    stop
  ]
end

;;function packetline
to packetline
  ;;
  ;;packet transmission in line configuration
  ;;
  ask turtle 9[set pen-mode "up"]
  ask turtle 9[set color blue] ;;setting color of packet to blue
  ask turtle 9[set heading 0]
  ask turtle 9[setxy -6 0]     ;;defining the start point of the packet
  ask turtle 9[set heading 90]
  ask turtle 9[forward 12] 
end

to fullnetwork
   clear-all
   
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;; Fully Connected Configuration ;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
   set-default-shape turtles "circle" ;Setting default shape of turtle to circle
   create-turtles 7                   ;Creating 7 turtles
   ask turtles[set color orange]      ;Setting the color of all turtles to orange
   ;;
   ;;setting the heading of turtles as per their appearance in fully connected topology
   ;;
   ask turtle 0[set heading 270]
   ask turtle 3[set heading 270]
   ask turtle 1[set heading 90]
   ask turtle 4[set heading 90]
   ask turtle 2[set heading 180]
   ask turtles[set pen-mode "down"]  ;Setting pen mode to down so that turtles leave a trail as they move
   ;;
   ;;defining movement of turtles
   ;; 
   ask turtle 0[forward 5]
   ask turtle 3[forward 5]
   ask turtle 1[forward 5]
   ask turtle 4[forward 5]
   ask turtle 2[forward 5]
   ;;setting heading of turtle 4
   ask turtle 3[set heading 135]
   ;;setting movement of turtle 4
   ask turtle 3[forward 7]
   ;;setting heading of turtle 5
   ask turtle 4[set heading 225]
   ;;setting movement of turtle 5
   ask turtle 4[forward 7]
   loop
   [ packetfull ;;calling function packetfull
     stop
   ]
end

;;function packetfull
to packetfull
  ;;
  ;;function to show packet transmission in fully connected network
  ;;
  ask turtle 6[set color blue] ;;setting color of packet to blue
  ask turtle 6[set pen-mode "up"]
  ask turtle 6[set heading 0]
  ask turtle 6[setxy -5 0]  ;;defining the start point of the packet
  ask turtle 6[set heading 90]
  ask turtle 6[forward 10]
end

to star
   clear-all 
     
   ;;;;;;;;;;;;;;;;;;;;;;;;
   ;; Star Configuration ;;
   ;;;;;;;;;;;;;;;;;;;;;;;;
   
   set-default-shape turtles "circle" ;Setting default shape of turtle to circle
   create-turtles 10                   ;Creating 10 turtles
   ask turtles[set color red]         ;Setting the color of all turtles to red
   ;;
   ;;setting the heading of turtles as per appearance in star topology
   ;;
   ask turtle 0[set heading 0] 
   ask turtle 1[set heading 45]
   ask turtle 2[set heading 90]
   ask turtle 3[set heading 135]
   ask turtle 4[set heading 180]
   ask turtle 5[set heading 225]
   ask turtle 6[set heading 270]
   ask turtle 7[set heading 315]
   ask turtle 8[set heading 0]
   ask turtles[set pen-mode "down"]  ;Setting pen mode to down so that turtles leave a trail as they move
   ;;
   ;;defining movement of turtles
   ;; 
   ask turtle 1[forward 10]
   ask turtle 2[forward 10]
   ask turtle 3[forward 10]
   ask turtle 4[forward 10]
   ask turtle 5[forward 10]
   ask turtle 6[forward 10]
   ask turtle 7[forward 10]
   ask turtle 8[forward 10]
      loop
   [
   packetstar ;;calling function packetstar
   stop
   ]
end

;;functioncall
to packetstar
   ;;
   ;;packet transmission in star configuration
   ;;
   ask turtle 9[setxy 0 10] ;;;;defining the start point of the packet
   ask turtle 9[set color blue] ;;setting colour of packet to blue
   ask turtle 9[set heading 180]
   ask turtles[set pen-mode "up"]
   ask turtle 9[forward 10]
   ask turtle 9[set heading 135]
   ask turtle 9[forward 10]
end 

to go
  clear-all
  
  ;;;;;;;;;;;;;;;;;;;;;;;;
  ;; Ring Configuration ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;
  
  set-default-shape turtles "circle" ;Setting default shape of turtle to circle
  create-turtles 7                   ;Creating 7 turtles
  ask turtles[set color yellow]      ;Set color to yellow
  ;;
  ;;Defining headings of different turtles
  ;;
  ask turtles[set heading 0]
  ask turtles [forward 10]
  ask turtles [set pen-mode "down"] ;Setting pen mode to down so that turtles leave a trail as they move
  ;;
  ;;making all turtles move to 72 degrees
  ;;
  ask turtle 1[set heading 72]
  ask turtle 2[set heading 72]
  ask turtle 3[set heading 72]
  ask turtle 4[set heading 72]
  ask turtle 5[set heading 72]
  ;;
  ;;Defining movement of turtles
  ;;
  ask turtle 1[forward 10]
  ask turtle 2[forward 10]
  ask turtle 3[forward 10]
  ask turtle 4[forward 10]
  ask turtle 5[forward 10]
  ;;
  ;;making remaining turtles move by 144 degrees
  ;;
  ask turtle 2[set heading 144]
  ask turtle 3[set heading 144]  
  ask turtle 4[set heading 144]
  ask turtle 5[set heading 144]
  ;;
  ;;Defining movement of turtles
  ;;   
  ask turtle 2[forward 10]
  ask turtle 3[forward 10]
  ask turtle 4[forward 10]
  ask turtle 5[forward 10]
  ;;
  ;;make remaining turtles move by 216 degrees
  ;;
  ask turtle 3[set heading 216]
  ask turtle 4[set heading 216]
  ask turtle 5[set heading 216]
  ;;
  ;;Defining movement of turtles
  ;;
  ask turtle 3[forward 10]
  ask turtle 4[forward 10]
  ask turtle 5[forward 10]
  ;;
  ;;move remaining turtles move by 288 degrees
  ;;
  ask turtle 4[set heading 288]
  ask turtle 5[set heading 288]
  ;;
  ;;Defining movement of turtles
  ;;
  ask turtle 4[forward 10]
  ask turtle 5[forward 10]
  ;;
  ;;moving the last turtles back to 0 degrees
  ;;
  ask turtle 5[set heading 360]
  ;;
  ;;defining movement of turtle
  ;;
  ask turtle 5[forward 10]
  loop
  [ packetring ;;calling function packetring
    stop
  ]
end

to packetring
  ask turtle 6[set pen-mode "up"]
  ask turtle 6[set color blue] ;;setting colour of packet to blue
  ask turtle 6[set heading 72]
  ask turtle 6[forward 10]
  ask turtle 6[set heading 144]
  ask turtle 6[forward 10]
end

to bus
  clear-all
  
  ;;;;;;;;;;;;;;;;;;;;;;;
  ;; Bus Configuration ;;
  ;;;;;;;;;;;;;;;;;;;;;;;
  
  create-turtles 10                  ;Creating 10 turtles
  ;set-default-shape turtles "square" to represent nodes               
  ask turtle 1[set shape "square"]
  ask turtle 2[set shape "square"]
  ask turtle 3[set shape "square"]
  ask turtle 5[set shape "square"]
  ask turtle 6[set shape "square"]
  ask turtle 7[set shape "square"]
  ask turtle 0[set shape "square"]
  ;set-default-shape turtles "circle" for representing terminators of the bus topology   
  ask turtle 4[set shape "circle"]
  ask turtle 8[set shape "circle"]
  ask turtles[set color blue]        ;Setting color of turtles to blue
  ;;
  ;;Defining headings of turtles
  ;;
  ask turtle 0[set heading 90]
  ask turtle 1[set heading 90]
  ask turtle 2[set heading 90]
  ask turtle 3[set heading 90]
  ask turtle 4[set heading 90]
  ask turtle 5[set heading 270]
  ask turtle 6[set heading 270]  
  ask turtle 7[set heading 270]
  ask turtle 8[set heading 270]
  ;making the turtles leave a trail
  ask turtles [set pen-mode "down"]
  ;defining the movement of turtles
  ask turtle 1[forward 2]
  ask turtle 2[forward 4]
  ask turtle 3[forward 6]
  ask turtle 4[forward 8]
  ask turtle 5[forward 2]
  ask turtle 6[forward 4]
  ask turtle 7[forward 6]
  ask turtle 8[forward 8]
  ;movement of turtle 1 upwards
  ask turtle 1[set heading 0]
  ask turtle 1[forward 5]
  ;movement of turtle 2 downwards
  ask turtle 2[set heading 180]
  ask turtle 2[forward 5]
  ;movement of turtle 3 upwards
  ask turtle 3[set heading 0]
  ask turtle 3[forward 5]
  ;movement of turtle 6 downwards
  ask turtle 6[set heading 180]
  ask turtle 6[forward 5]
  ;movement of turtle 5 upwards
  ask turtle 5[set heading 0]
  ask turtle 5[forward 5]
  ;movement of turtle 7 upwards
  ask turtle 7[set heading 0]
  ask turtle 7[forward 5]
  ;movement of turtle 0 downwards
  ask turtle 0[set heading 180]
  ask turtle 0[forward 5]
  ;no movement defined for turtle 4 and 8 since they act as terminators or imply that the pattern continues
  loop
  [ packetbus ;;calling function packetbus
    stop
  ]
end

to packetbus
  ;;
  ;;function to show the packet transmission in bus configuration
  ;;
  ask turtle 9[set pen-mode "up"]
  ask turtle 9[set color pink] ;;setting colour of packet to pink
  ask turtle 9[setxy -6 5] ;;defining the start point of the packet
  ask turtle 9[set heading 180]
  ask turtle 9[forward 5]
  ask turtle 9[set heading 90]
  ask turtle 9[forward 5.8]
  ask turtle 9[set heading 180]
  ask turtle 9[forward 5]
end

to tree
    clear-all
    
    ;;;;;;;;;;;;;;;;;;;;;;;;
    ;; Tree configuration ;;
    ;;;;;;;;;;;;;;;;;;;;;;;;  
    
    create-turtles 12                ;Creating 12 turtles
    ask turtles[set color white]      ;Defining colour of turtles as white to maintain uniformity
    ask turtles[set shape "square"]
    ask turtles [set pen-mode "down"] ;Setting pen mode so that turtles leave a trail
    ;defining turtle heading and movement
    ask turtle 1[set heading 120]     
    ask turtle 1[forward 12]
    ask turtle 2[set heading 180]
    ask turtle 2[forward 7]
    ask turtle 3[set heading 240]
    ask turtle 3[forward 12]
    ask turtle 4[set heading 240]
    ask turtle 4[forward 12]
    ask turtle 5[set heading 240]
    ask turtle 5[forward 12]
    ask turtle 4[set heading 135]
    ask turtle 4[forward 5]
    ask turtle 5[set heading 225]
    ask turtle 5[forward 5]
    ask turtle 6[set heading 180]
    ask turtle 6[forward 7]
    ask turtle 7[set heading 180]
    ask turtle 7[forward 7]
    ask turtle 8[set heading 180]
    ask turtle 8[forward 7]
    ask turtle 6[set heading  180]
    ask turtle 6[forward 5]
    ask turtle 7[set heading 135]
    ask turtle 7[forward 5]
    ask turtle 8[set heading 225]
    ask turtle 8[forward 5]
    ask turtle 9[set heading 120]
    ask turtle 9[forward 12]
    ask turtle 10[set heading 120]
    ask turtle 10[forward 12]
    ask turtle 9[set heading 135]
    ask turtle 9[forward 5]
    ask turtle 10[set heading 225]
    ask turtle 10[forward 5]   
    loop
    [
      packettree ;;calling function packettree
      stop
    ] 
end

to packettree
  ;;
  ;;function to show transmission of packet in tree configration 
  ;;
  ask turtle 11[set color blue] ;;setting colour of packet to blue
  ask turtle 11[set pen-mode "up"]
  ask turtle 11[set heading 180]
  ask turtle 11[setxy -4 -10] ;;defining the start point of the packet
  ask turtle 11[set heading 45]
  ask turtle 11[forward 5]
  ask turtle 11[set heading 0]
  ask turtle 11[forward 7]
  ask turtle 11[set heading 125]
  ask turtle 11[forward 12]
  ask turtle 11[set heading 220]
  ask turtle 11[forward 4.7]
end     

to mesh
  clear-all
  
  ;;;;;;;;;;;;;;;;;;;;;;;;
  ;; Mesh Configuration ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;
  
  ;;
  ;;arbitrary connection of nodes
  ;;
  create-turtles 10 ;Creating 10 turtles
  ask turtles[set color green] ;setting color as green to maintain uniformity in colour
  ask turtles[set pen-mode "down"] ;making the turtles leave a trail
  ;;
  ;;defining heading and movement for turtles
  ;;
  ask turtle 1[set heading 0]
  ask turtle 1[forward 8]
  ask turtle 2[set heading 90]
  ask turtle 2[forward 8]
  ask turtle 3[set heading 180]
  ask turtle 3[forward 8]
  ask turtle 4[set heading 270]
  ask turtle 4[forward 8]
  ask turtle 5[set heading 0]
  ask turtle 5[forward 8]
  ask turtle 6[set heading 90]
  ask turtle 6[forward 8]
  ask turtle 7[set heading 180]
  ask turtle 7[forward 8]
  ask turtle 8[set heading 270]
  ask turtle 8[forward 8]
  ask turtle 5[set heading 270]
  ask turtle 5[forward 8]
  ask turtle 6[set heading 0]
  ask turtle 6[forward 8]
  ask turtle 7[set heading 90]
  ask turtle 7[forward 8]
  ask turtle 8[set heading 180]
  ask turtle 8[forward 8]
  ask turtle 1[set heading 90]
  ask turtle 1[forward 8]
  ask turtle 1[set heading 270]
  ask turtle 1[forward 8]
  ask turtle 5[set heading 180]
  ask turtle 5[forward 8]
  ask turtle 5[set heading 360]
  ask turtle 5[forward 8]
  ask turtle 8[set heading 90]
  ask turtle 8[forward 8]
  ask turtle 8[set heading 270]
  ask turtle 8[forward 8]
  ask turtle 7[set heading 0]
  ask turtle 7[forward 8]
  ask turtle 7[set heading 180]
  ask turtle 7[forward 8] 
  loop
[
 packetmesh ;;calling function packetmesh
 stop 
]
end

;;packetmesh function
to packetmesh
  ;;
  ;;function to show packet transmission in mesh topology
  ;;
  ask turtle 9[set pen-mode "up"]
  ask turtle 9[set color blue] ;;setting color of packet to blue
  ask turtle 9[set heading 0]
  ask turtle 9[setxy -8 8] ;;defining the start point of the packet
  ask turtle 9[set heading 90]
  ask turtle 9[forward 8]
  ask turtle 9[set heading 180]
  ask turtle 9[forward 16]
  ask turtle 9[set heading 90]
  ask turtle 9[forward 8]
end
@#$#@#$#@
GRAPHICS-WINDOW
218
14
657
474
16
16
13.0
1
90
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
18
16
127
49
Star Topology
star
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
19
57
129
90
Ring Topology
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
97
126
130
Bus Topology
bus
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
19
139
130
172
Tree Topology
tree
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
18
179
132
212
Mesh Topology
mesh
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
17
221
191
254
Fully Connected Topology
fullnetwork
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
18
261
123
294
Line topology
line
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
17
300
156
333
Local Area Network
lan
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
855
183
1207
427
NETWORKING 
50
123.0
1

BUTTON
17
342
197
375
Metropolitan Area Network
man
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
17
382
156
415
Wide Area Network
wan
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

Network is an ordered interconnection of autonomous computers that allows the computers to exchange data. Topology of the network or Network topology is the arrangement of links, nodes and other components of a network that may be depicted physically or logically. This model attempts to model network topologies like star, bus, tree, mesh and ring and also the local area network, metropolitan area network and wide area network architectures and how packet transmission occurs in each of them.

## HOW IT WORKS

Star configuration: The turtles move forward at an angle of 45 degrees to each other, and leave a trail as they do so. A star network consists of one central switch, hub or computer, which act as a conduit to transmit messages. This consists of a central node, to which all other nodes are connected; this central node provides a common connection point for all nodes through a hub. Advantages of this network include - better performance, easy detection of faults, and no distruptions while connecting or removing devices. Disadvantages of the configuration includes - limited capacity of nodes, expenses. 

Ring configuration: With n turtles which move 72 degrees with respect to each other,
only n-1 turtles move to the each time to represent the next node. A ring network is a network topology in which each node connects to exactly two other nodes, forming a single continuous pathway for signals through each node - a ring. Data travel from node to node, with each node along the way handling every packet. Advantages of the network include ease of isolation of faults and ease of adding and removing devices due to point line configuration.  The disadvantages are - communication delay since bandwidth is shared among all links and difficulty in configuration. 

Bus configuration: All turtles are assembled on to a straight line and alternatively made to move upwards and downwards to represent a linear sequence of buses. The bus is the data link in a bus network. The bus can only transmit data in one direction, and if any network segment is severed, all network transmission ceases.The advantages of this type of network includes - ease of connection, lesser length of cable required and the disadvantages include - requirement of terminators on both ends, difficulty in debugging, and makes the configuration slow. 

Tree configration: The turtles split up into 3 parts and split up again into a pattern to represent the tree topology.Tree Topology integrates the characteristics of Star and Bus Topology. In Tree Topology, the number of Star networks are connected using Bus. This main cable seems like a main stem of a tree, and other star networks as the branches. It is also called Expanded Star Topology. The advantages are - ease in error detection, easy expansion and disadvantages are - maintainance and scalability. 

Mesh configuration: The turtles are assembled onto a grid or matrix format where each node is connected to adjacent nodes. A mesh network is a network topology in which each node (called a mesh node) relays data for the network. All nodes cooperate in the distribution of data in the network. The advatages include - ability to withstand high traffic, ability to expand and modify without disrupting other nodes. The disadvantages of the topology are - difficulty in maintainance and reducdancy issues. 

Fully connected configuration - The turtles are assembled onto a network such that every node is connected to every other node. The advatages include - ability to connect directly with any other node. The disadvantages of the topology are - it doesn't scale well. 

Local Area Network - A local area network is a computer network that interconnects computers within a limited area such as a home, school, computer laboratory, or office building, using network media.

Metropolitan Area Network - A metropolitan area network (MAN) is computer network larger than a local area network, covering an area of a few city blocks to the area of an entire city, possibly also including the surrounding areas.

Wide Area Network - A wide area network (WAN) is a network that covers a broad area (i.e., any telecommunications network that links across metropolitan, regional, national or international boundaries) using leased telecommunication lines.

## THINGS TO NOTICE

When the star topology button is clicked, the setup procedures run creating 10 turtles arranging themselves to form a star network after setting their headings and moving accordingly and packet transmission occurs thereafter.

When the ring topology button is clicked, the go procedures execute creating 6 turtles arranging themselves in form of a ring network after setting their headings and moving accordingly and packet transmission occurs thereafter. 

When the bus topology button is clicked, the bus procedures execute creating 10 turtles arranging themselves in form of a straight line where the turtles are made to move upwards and downwards to simulate the configuration and packet transmission occurs thereafter.

When the tree topology button is clicked, the tree procedures execute creating 12 turtles arranging themselves to split up in to 3 branches in the first step and unevenly thereon in order to simulate the configuration and packet transmission occurs thereafter. 

When the mesh topology button is clicked, the mesh procedures are executed, creating 10 turtles arranging themselves in form of a grid or a 3X3 matrix to simulate the configuration and packet transmission occurs thereafter..  

## THINGS TO TRY

I suggest users and netlogo enthusiasts to try out other network topologies if any, and try the same above topologies to represent the same in different ways and orientations. Also try packet transmissions for different nodes and you may also randomise them.  

## NETLOGO FEATURES

Simple concepts of netlogo like creating turtles, changing shapes and colours and leaving a trail etc. are extensively used. 

## RELATED MODELS

See other models in the sample tab under Networks category. 

## CREDITS AND REFERENCES
 
The model itself and for the NetLogo software:
Wilensky, U. (2005). NetLogo Small Worlds model. http://ccl.northwestern.edu/netlogo/models/SmallWorlds. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
