globals [genes gcolors grates genecount gnat promotercount promoters xstartloc bindings pbound xcoords preg KB Kd knockout]
turtles-own [gtype age bound]
breed [ rna ]
breed [ protein ]



to setup 
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  ; bindings determines which proteins bind to which promoters
;
; Problem 1
;
  if (problem = 1) [
  set bindings ["E" "C" 
                "C" "D" 
                "A" "D" 
                "E" "B" 
                "C" "A"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [1 0 0 0 0]
; preg is the promoter regulatory function
  set preg [ 1 -2 
            -1  2 
             1 -2 
             1 -1 
             1 -1 ]
 ]
 ;
 ; Problem 2
 ;
   if (problem = 2) [
  set bindings ["D" "E" 
                "A" "C" 
                "B" "E" 
                "B" "E" 
                "E" "D"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [0 0 -1 0 0]
; preg is the promoter regulatory function
  set preg [ -1 -1 
             1   -1 
             1   1 
             1  1 
             1  1 ]
 ]
 ;
 ; Problem 3
 ;
   if (problem = 3) [
  set bindings ["D" "E" 
                "D" "E" 
                "D" "B" 
                "A" "B" 
                "A" "B"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [1 1 0 1 1]
; preg is the promoter regulatory function
  set preg [ -1 -1 
             -1 -1 
             1 1 
             -1 -1 
             -1 -1 ]
 ]
   if (problem = 4) [
  set bindings ["B" "C" 
                "C" "D" 
                "B" "D" 
                "C" "E" 
                "C" "A"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [0 1 0 0 0]
; preg is the promoter regulatory function
  set preg [ 1 -2 
             -1 1 
             1 -2 
             1 -1 
             -1 2 ]
 ]
   if (problem = 5) [
  set bindings ["D" "E" 
                "D" "E" 
                "A" "E" 
                "A" "B" 
                "A" "B"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [1 1 -1 1 1]
; preg is the promoter regulatory function
  set preg [ -1 -1 
             -1 -1 
              1 1 
             -1 -1 
             -1 -1 ]
 ]
   if (problem = 6) [
  set bindings ["A" "C" 
                "A" "E" 
                "D" "A" 
                "C" "D" 
                "C" "D"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [0 0 0 1 0]
; preg is the promoter regulatory function
  set preg [ 1 1 
             -1 1 
             1 1 
             -1 -1 
             -1 1 ]
 ]
   if (problem = 7) [
  set bindings ["C" "B" 
                "D" "A" 
                "D" "A" 
                "C" "B" 
                "D" "B"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [1 1 1 1 0]
; preg is the promoter regulatory function
  set preg [ -2 -1 
             -1 -1 
             -1 -1 
             -2 -1 
             1 1 ]
 ]
   if (problem = 8) [
  set bindings ["B" "A" 
                "D" "A" 
                "A" "B" 
                "B" "E" 
                "B" "D"]
; gnat is the natural tendency of the gene to be transcribed
  set gnat [1 0 1 -2 0]
; preg is the promoter regulatory function
  set preg [ 1  1 
             1  1 
            -2  0 
             1  1 
            1 -1 ]
 ]

; normally you won't change anything down here

  set KB 100 ; binding coefficient
  set Kd 4 ; dissociation coefficient
  set genes ["A" "B" "C" "D" "E" ]
  set promoters 2
  set knockout [0 1 1 1 1 1]
  set gcolors [red blue green magenta yellow ]
  set grates [ 10 10 10 10 10 ]
  set promoters 2
  set pbound [0 0 0 0 0 0 0 0 0 0]
  set xcoords [0 0 0 0 0 0 0 0 0 0]

  set xstartloc (max-pxcor * -1) + 1
  set promotercount 0
  (foreach genes gcolors [
  ; create promoters
    repeat promoters [
      set promotercount promotercount + 1
      ask patches with [(pxcor = (xstartloc)) and (pycor = 0)] [ set pcolor gray set plabel promotercount ]
      set xcoords replace-item (promotercount - 1) xcoords xstartloc
      set xstartloc xstartloc + 1
    ]
    ; create gene
    ask patches with [(pxcor = xstartloc) and (pycor = 0)] [ set pcolor ?2 set plabel ?1 ]
    set xstartloc xstartloc + 1
    ; create white region
    repeat 4 [
      ask patches with [(pxcor = xstartloc) and (pycor = 0)] [ set pcolor white ]
      set xstartloc xstartloc + 1
    ]
    set genecount genecount + 1
  ])
  ; create ribosomes
  ask patches with [ ((pycor < -3) or (pycor > 3))] [ if random 10 = 1 [set pcolor cyan] ]

; create initial population of turtles
;  cct 5 [
;        set breed protein
;        set shape "repressor"
;        set bound false
;        set color red
;        set gtype "A"
;        set age random 25
;        set heading random 360
;        fd random 50
;      ]

end

to go 
 let cnt 0
  
  ;set time time + 1
; set knockouts
ifelse (GENE-A) [set knockout replace-item 1 knockout 1] [set knockout replace-item 1 knockout 0]
ifelse (GENE-B) [set knockout replace-item 2 knockout 1] [set knockout replace-item 2 knockout 0]
ifelse (GENE-C) [set knockout replace-item 3 knockout 1] [set knockout replace-item 3 knockout 0]
ifelse (GENE-D) [set knockout replace-item 4 knockout 1] [set knockout replace-item 4 knockout 0]
ifelse (GENE-E) [set knockout replace-item 5 knockout 1] [set knockout replace-item 5 knockout 0]
; do gene transcription
ask patches [
 without-interruption [
  set cnt 0
  (foreach genes gcolors [
  set cnt cnt + 1
  if (plabel = ?1 and item cnt knockout = 1) [
    if ( random 100 <  item (cnt - 1) grates) [
      if ( ((item ((promoters * cnt) - 1) preg) * (item ((promoters * cnt) - 1) pbound)  + (item ((promoters * cnt) - 2) preg) * (item ((promoters * cnt) - 2) pbound) + item (cnt - 1) gnat) > 0) [
      sprout 1 [
       set breed rna
       set shape "rna"
       set gtype ?1
       set color ?2
       set bound false
       set age random 30
       set heading random 360
       fd 2
      ] ]
    ]
  ]
])
]
]
;; this determines which gate the system emulates
; if (plabel = "C" ) [
;   if (gate = "NAND" ) [if (not (rbound-A = true and rbound-B = true) ) [ express-c] ]
;   if (gate = "NOR" ) [if (rbound-A = false and rbound-B = false) [ express-c]]
;   if (gate = "AND" ) [if (rbound-A = true and rbound-B = true) [ express-c]]
;   if (gate = "OR" ) [if (rbound-A = true or rbound-B = true) [ express-c]]
;   if (gate = "XOR" ) [if ((rbound-A = true or rbound-B = true) and not (rbound-A = true and rbound-B = true)) [ express-c]]
; ]
;]

; this was a bit tricky to get the order of events right
ask protein [
    without-interruption [bind-site]
    ]
ask turtles 
    [wander ;; both rnas and proteins check to see if they bind and otherwise move around
     grow-old] ;; both also are recycled by the cell machinery after a while.
plot-history
plot-levels
end

to bind-site
  let cnt 0
  
  if (bound = false) [
    if (random 100 < Kb and breed = protein) [
      set cnt 0
      (foreach bindings pbound [
        if (gtype = ?1 and ?2 = 0) [
          set bound cnt 
          set pbound replace-item cnt pbound 1 
          setxy item cnt xcoords 0  
          set heading 180
          stop
        ]
        set cnt cnt + 1
      ])
    ]
  ]
end

to unbind-site
  if (random 100 < Kd and bound != false) [
    set pbound replace-item bound pbound 0
    set bound false
    setxy random world-width random world-height
]
end

to grow-old ;; cells break down rnas and proteins after a while.  
   set age age + 1
   if (age > (50 + random 150))  [
     without-interruption[if (bound = false) [die] ]]
end

to wander
  if (pcolor = cyan and shape = "rna") [  ;; this is the ribosome translating
;    set breed protein 
;    set shape "repressor"
;    set age 0 
     hatch 1 [
         set breed protein
         set shape "repressor"
         set bound false
        set age 0
        set heading random 360
      ]
  ] 
  ifelse (bound = false) [rt random 180 - random 180 fd 1 ] [without-interruption [unbind-site]] 
end

to plot-levels ;; this creates creates the bar graph 
  let cnt 0
  
    set-current-plot "Protein Concentrations"
    clear-plot
    set cnt 0
    (foreach genes gcolors [
    set-current-plot-pen ?1
    plot-pen-down
    set cnt cnt + 1
    plotxy cnt count protein with [color = ?2] 
    ])
end

to plot-history ;; this creates the line graph
  set-current-plot "Concentration History"
      (foreach genes  gcolors [
    set-current-plot-pen ?1
  plot ( count protein with [color = ?2]  )
])
end

;; red blue green magenta yellow
to insert-A
     crt 30 [
         set breed protein
         setxy random-xcor random-ycor
         set color red
         set gtype "A"
         set shape "repressor"
         set bound false
         set age 0
         set heading random 360
      ]
end

to insert-B
     crt 30 [
         set breed protein
         setxy random-xcor random-ycor
         set color blue
         set gtype "B"
         set shape "repressor"
         set bound false
         set age 0
         set heading random 360
      ]
end
to insert-C
     crt 30 [
         set breed protein
         setxy random-xcor random-ycor
         set color green
         set gtype "C"
         set shape "repressor"
         set bound false
         set age 0
         set heading random 360
      ]
end
to insert-D
     crt 30 [
         set breed protein
         setxy random-xcor random-ycor
         set color magenta
         set gtype "D"
         set shape "repressor"
         set bound false
         set age 0
         set heading random 360
      ]
end
to insert-E
     crt 30 [
         set breed protein
         setxy random-xcor random-ycor
         set gtype "E"
         set color yellow
         set shape "repressor"
         set bound false
         set age 0
         set heading random 360
      ]
end
@#$#@#$#@
GRAPHICS-WINDOW
321
10
776
245
18
8
12.03
1
10
1
1
1
0
1
1
1
-18
18
-8
8
0
0
1
ticks
30.0

BUTTON
16
67
99
120
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
14
126
100
188
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
116
60
221
93
GENE-A
GENE-A
0
1
-1000

SWITCH
116
96
222
129
GENE-B
GENE-B
0
1
-1000

SWITCH
116
132
221
165
GENE-C
GENE-C
0
1
-1000

SWITCH
116
168
221
201
GENE-D
GENE-D
0
1
-1000

SWITCH
116
203
221
236
GENE-E
GENE-E
0
1
-1000

PLOT
7
250
312
447
Protein Concentrations
Gene
Concentration
0.0
7.0
0.0
50.0
false
true
"" ""
PENS
"A" 1.0 1 -2674135 true "" ""
"B" 1.0 1 -13345367 true "" ""
"C" 1.0 1 -10899396 true "" ""
"D" 1.0 1 -5825686 true "" ""
"E" 1.0 1 -1184463 true "" ""

PLOT
321
250
625
447
Concentration History
Time
Concentration
0.0
500.0
0.0
50.0
true
true
"" ""
PENS
"A" 1.0 0 -2674135 true "" ""
"B" 1.0 0 -13345367 true "" ""
"C" 1.0 0 -10899396 true "" ""
"D" 1.0 0 -5825686 true "" ""
"E" 1.0 0 -1184463 true "" ""

CHOOSER
15
10
116
55
problem
problem
1 2 3 4 5 6 7 8
0

BUTTON
226
61
309
94
NIL
insert-A
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
226
97
309
130
NIL
insert-B
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
226
133
309
166
NIL
insert-C
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
226
168
309
201
NIL
insert-D
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
225
203
309
236
NIL
insert-E
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This is a model that offers a series of "unknown" problems for students to explore  
in learning about gene expression systems.

Genes are represented by colored patches labeled A, B, C, D and E.  Transcription-factor binding sites are numbered 1-10.  Genes are transcribed to produce RNAs (represented as lines) which are translated by ribosomes (cyan patches) to produce proteins (irregular polygons).

## HOW IT WORKS

In this simulation, there are 5 genes: A-E.  Each gene has two promoters and can  
be knocked out (turned-off) using a switch.

## HOW TO USE IT

A pop-up menu allows the user to select a problem.

Click "setup" to create the genes and ribosomes.  

Click "go" to start the model.

Switches allow the user to turn genes A-E on and off.

You can also add some of each of the gene products independent of the gene activity.

Two plots show current and historical concentrations of proteins.

## THINGS TO NOTICE

Does the system begin automatically or is some stimulus required to initiate activity?

You can tell which proteins bind to which sites.  Notice under what conditions genes turn on and off.  Does the system become fixed at some point, or does it oscillate?  Does it always reach fixation in the same state?

## THINGS TO TRY

For each gene, determine what roles the binding sites are playing in the system (enhancer or silencer).  

How does the behavior of the system change when genes are knocked out?  Can you predict  
these changes based on what you know by observing the system?

## EXTENDING THE MODEL

To simplify this model, a number of factors have been de-paramaterized, including the rates of each gene and the coefficients of binding and dissociation (KB and Kd).  By adding sliders, you could extend this model and explore the behavior of the system with different values.  By changing these values you can try to decrease the leakiness of the system and increase the speed of the system turning on or off.

## CREDITS AND REFERENCES

This model is based on work completed during the 2004 BioQUEST Curriculum Consortium Summer Workshop.  

Copyright 2006 by Steven Brewer.  All rights reserved.

This model was inspired by many of the sample Netlogo models and parts were based on functions from the Enzyme Kinetics model.  (Wilensky, U. (2001).  NetLogo Enzyme Kinetics model. http://ccl.northwestern.edu/netlogo/models/EnzymeKinetics. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.)    
Permission to use, modify or redistribute this model is hereby granted,  
provided that both of the following requirements are followed:  
a) this copyright notice is included.  
b) this model will not be redistributed for profit without permission
   from the authors.  
Contact the authors for appropriate licenses for redistribution for  
profit.

To refer to this model in academic publications, please use:  
Brewer, S.D. (2006).  Unknown Gene Expression: Problems for Students.  http://bcrc.bio.umass.edu/netlogo/models/Unknown  
Biology Computer Resource Center

In other publications, please use:  
Copyright 2006 by Steven Brewer.  All rights reserved.  See  
http://bcrc.bio.umass.edu/netlogo/models/Unknown
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

b-complex
true
0
Polygon -10899396 true false 79 46 198 148 78 254
Polygon -13345367 true false 77 48 197 149 77 255 257 254 256 49

box
true
0
Polygon -7500403 true true 45 255 255 255 255 45 45 45

circle
false
0
Circle -7500403 true true 35 35 230

inducer
true
0
Polygon -10899396 true false 76 47 197 151 75 256

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

r-complex
true
0
Polygon -2674135 true false 76 47 197 150 76 254 257 255 257 47
Polygon -10899396 true false 79 46 198 148 78 254

repressor
true
0
Polygon -7500403 true true 76 47 197 150 76 254 257 255 257 47

rna
true
0
Rectangle -7500403 true true 7 126 294 170

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
