globals [ n  ;RNA PXCOR POSITION
          p1 ;PEPTISE PXCORPOSITION
          RNA ;RNA string
          first-base ; item position of 1st base in RNA
          codon ;codon variable
          s-base  ;starting base item position of a codon
          f-base  ;final base item position of a codon
          amino-acid ; translated amino acid
          amino-acid-result ; report the types of amino acids
          protein-length  ;peptide length
          base-candidates  ;nucleotides input from users
          aa1 ; amino acid 1
          aa-num ; assign a number for shuffle AAs
          aa-num-list
          filtered-list ;  find % of input nucleotides
  a-%
  c-%
  g-%
  u-%

  check-index  ;record the position of the nucleotide under check
      ]

Patches-own [base]

breed [nucleotides nucleotide]
breed [units unit]
breed [peptides peptide]
breed [primes prime]




to setup

 ca

  set base-candidates STEP-1-Input-Nucleotides ;user-input "Nucleotides (Capital A C U or G only.No space)"

  ifelse length base-candidates = 0 [user-message "no nucleotide is tested" stop][capitalize-bases]

  find-percentages

  set RNA "5'-"                                    ;create 5' end
  set-default-shape nucleotides "x"               ;set default shape as X in case having an invalid base
  set n 7                                         ;set the first base position in the world
  set first-base 3

  set s-base 3
  set f-base 6
  set p1 10
  set protein-length 0
  set amino-acid-result ""
  set aa-num-list 0
  set aa1 0

  ask patches [set pcolor 9.5 + random-float 0.4 ]
  ask patches with [pycor <= min-pycor + 2 ] [set pcolor 2]

 repeat 18
  [ set RNA word RNA item random (length base-candidates) base-candidates]      ;synthesize the RNA



  set RNA word RNA "-3'"                       ;attach 3' end


 repeat 18
    [ ask patches with [pxcor = n and pycor = 4]               ;assign base to patches
      [set base item first-base RNA]
      set n n + 1
      set first-base first-base + 1]

 ask patches with [base != 0]                                  ;let assigned patches produce bases
 [sprout-nucleotides 1
      [ if base = "A"  [set shape "nn-a"]
        if base = "C"  [set shape "nn-c"]
        if base = "G"  [set shape "nn-g"]
        if base = "U"  [set shape "nn-u"]
    ]]

  create-primes 1               ;MAKE 5' END
  [set shape "5'"
    set size 1.5
    set color 0
    setxy 6.3 4.5]



   create-primes 1               ;MAKE 3' END
  [set shape "3'"
    set size 1.5
    set color 0
    setxy 24.7 4.5]


  if any? nucleotides with [shape = "x"] [user-message "Please input correct nucleotide(s) (A, U, C, G)" stop]

ribosome

reset-ticks

end



to translate

  if f-base > 21 [user-message "Translation has been completed" stop]

   repeat 6 [
    ask units                           ;move ribosome one codon
      [set heading 90
        forward 4
        wait 0.3]


   set codon substring RNA s-base f-base                            ;detetmine the range (the codon)
   if codon = "AUG" [set amino-acid "Met" set aa-num 1]                         ;translate
   if codon = "UUU" or codon = "UUC" [set amino-acid "Phe" set aa-num 2]
   if codon = "UUA" or codon = "UUG" or codon = "CUU" or codon = "CUC" or codon = "CUA" or codon = "CUG"[set amino-acid "Leu" set aa-num 3]
   if codon = "AUU" or codon = "AUC" or codon = "AUA" [set amino-acid "Ile" set aa-num 4]
   if codon = "GUU" or codon = "GUC" or codon = "GUA" or codon = "GUG" [set amino-acid "Val" set aa-num 5]
   if codon = "UCU" or codon = "UCC" or codon = "UCA" or codon = "UCG" or codon = "AGU" or codon = "AGC" [set amino-acid "Ser" set aa-num 6]
   if codon = "CCU" or codon = "CCC" or codon = "CCA" or codon = "CCG" [set amino-acid "Pro" set aa-num 7]
   if codon = "ACU" or codon = "ACC" or codon = "ACA" or codon = "ACG" [set amino-acid "Thr" set aa-num 8]
   if codon = "GCU" or codon = "GCC" or codon = "GCA" or codon = "GCG" [set amino-acid "Ala" set aa-num 9]
   if codon = "UAU" or codon = "UAC"  [set amino-acid "Tyr" set aa-num 10]
   if codon = "CAU" or codon = "CAC"  [set amino-acid "His" set aa-num 11]
   if codon = "CAA" or codon = "CAG"  [set amino-acid "Gln" set aa-num 12]
   if codon = "AAU" or codon = "AAC"  [set amino-acid "Asn" set aa-num 13]
   if codon = "AAA" or codon = "AAG"  [set amino-acid "Lys" set aa-num 14]
   if codon = "GAU" or codon = "GAC"  [set amino-acid "Asp" set aa-num 15]
   if codon = "GAA" or codon = "GAG"  [set amino-acid "Glu" set aa-num 16]
   if codon = "UGU" or codon = "UGC"  [set amino-acid "Cys" set aa-num 17]
   if codon = "UGG" [set amino-acid "Trp" set aa-num 18]
   if codon = "CGU" or codon = "CGC" or codon = "CGA" or codon = "CGG" or codon = "AGA" or codon = "AGG" [set amino-acid "Arg" set aa-num 19]
   if codon = "GGU" or codon = "GGC" or codon = "GGA" or codon = "GGG" [set amino-acid "Gly" set aa-num 20 ]
    if codon = "UAA" or codon = "UAG" or codon = "UGA" [set amino-acid "" user-message "Translation is terminated" ask units [die]]

   set aa-num-list sentence aa-num-list aa-num    ;assign number to aa for removing duplication and shuffle
   set aa-num-list remove-duplicates aa-num-list


       ifelse amino-acid != ""                           ;if not encounter a stop codon,
        [
         create-peptides 1                            ; make amino acid
           [set size 2
            set shape "protein-unit"
            setxy p1  min-pycor + 1
            set color white]

         set p1 p1 + 2          ;set amino acids position

         set s-base s-base + 3    set f-base f-base + 3]

     [set aa-num-list remove 0 aa-num-list
      set aa-num-list shuffle aa-num-list
      show-aa
      stop]


  ]

  set aa-num-list remove 0 aa-num-list
  set aa-num-list shuffle aa-num-list

  show-aa

end

to ribosome

 create-units 1
   [
    set shape "l-unit"
    set size 7
    set color 27
    setxy 3.5 3]

end


to show-aa

  repeat length aa-num-list
   [set aa-num item aa1 aa-num-list
      num-to-aa
      set amino-acid-result word amino-acid-result " "
      set amino-acid-result word amino-acid-result amino-acid
      set aa1 aa1 + 1]

end


to num-to-aa

  if aa-num = 1 [set amino-acid "Met"]
  if aa-num = 2 [set amino-acid "Phe"]
  if aa-num = 3 [set amino-acid "Leu"]
  if aa-num = 4 [set amino-acid "Ile"]
  if aa-num = 5 [set amino-acid "Val"]
  if aa-num = 6 [set amino-acid "Ser"]
  if aa-num = 7 [set amino-acid "Pro"]
  if aa-num = 8 [set amino-acid "Thr"]
  if aa-num = 9 [set amino-acid "Ala"]
  if aa-num = 10 [set amino-acid "Tyr"]
  if aa-num = 11 [set amino-acid "His"]
  if aa-num = 12 [set amino-acid "Gln"]
  if aa-num = 13 [set amino-acid "Asn"]
  if aa-num = 14 [set amino-acid "Lys"]
  if aa-num = 15 [set amino-acid "Asp"]
  if aa-num = 16 [set amino-acid "Glu"]
  if aa-num = 17 [set amino-acid "Cys"]
  if aa-num = 18 [set amino-acid "Trp"]
  if aa-num = 19 [set amino-acid "Arg"]
  if aa-num = 20 [set amino-acid "Gly"]

end

to find-percentages

 ifelse member? "A" base-candidates
   [set filtered-list remove "A" base-candidates
      set a-% ((length base-candidates) - (length filtered-list)) * 100 / (length base-candidates)]
  [set a-% 0]

  ifelse member? "C" base-candidates
   [set filtered-list remove "C" base-candidates
      set c-% ((length base-candidates) - (length filtered-list)) * 100 / (length base-candidates)]
  [set c-% 0]

 ifelse member? "G" base-candidates
   [set filtered-list remove "G" base-candidates
      set g-% ((length base-candidates) - (length filtered-list)) * 100 / (length base-candidates)]
  [set g-% 0]

  ifelse member? "U" base-candidates
   [set filtered-list remove "U" base-candidates
      set u-% ((length base-candidates) - (length filtered-list)) * 100 / (length base-candidates)]
  [set u-% 0]

end

to capitalize-bases
  set check-index 0
  Repeat length base-candidates
  [
  (ifelse
    item check-index base-candidates = "a" [set base-candidates (replace-item check-index base-candidates "A")]
    item check-index base-candidates = "g" [set base-candidates (replace-item check-index base-candidates "G")]
    item check-index base-candidates = "c" [set base-candidates (replace-item check-index base-candidates "C")]
    item check-index base-candidates = "u" [set base-candidates (replace-item check-index base-candidates "U")])

    set check-index check-index + 1]
end
@#$#@#$#@
GRAPHICS-WINDOW
17
10
769
427
-1
-1
24.0
1
10
1
1
1
0
1
1
1
0
30
-8
8
0
0
1
ticks
5.0

BUTTON
603
503
769
544
Step-2 Synthesize mRNA
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
17
433
464
482
Synthesized mRNA Sequence
RNA
17
1
12

MONITOR
398
488
463
533
codon 6
substring RNA 18 21
17
1
11

MONITOR
17
488
89
533
codon 1
substring RNA 3 6
17
1
11

MONITOR
93
488
165
533
codon 2
substring RNA 6 9
17
1
11

MONITOR
170
488
242
533
codon 3
substring RNA 9 12
17
1
11

MONITOR
246
488
318
533
codon 4
substring RNA 12 15
17
1
11

MONITOR
322
488
394
533
codon 5
substring RNA 15 18
17
1
11

BUTTON
603
547
769
588
Step-3 Translate mRNA
translate
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
17
540
463
589
Amino Acids in the Peptide
amino-acid-result
17
1
12

TEXTBOX
156
375
247
398
Peptide
18
9.9
1

TEXTBOX
476
595
770
642
* The input determines the composition of the nucleotides, not the synthesized order. E.g., UG means 50% of U and 50% of G, and it is equivalent to GU, GGUU, or UGUG.
10
125.0
1

TEXTBOX
341
31
596
51
Synthesized mRNA
16
0.0
1

INPUTBOX
603
432
770
500
Step-1-Input-Nucleotides
aa
1
0
String

MONITOR
477
470
534
515
A (%)
a-%
1
1
11

MONITOR
536
470
593
515
C (%)
c-%
1
1
11

MONITOR
477
519
534
564
G (%)
g-%
1
1
11

MONITOR
536
519
594
564
U (%)
u-%
1
1
11

TEXTBOX
478
435
593
477
The Composition of Input Nucleotides: 
11
104.0
1

TEXTBOX
18
595
453
665
* The translation results only provide the types of amino acids. These amino acids are not in the linear translation order.
10
125.0
1

@#$#@#$#@
## WHAT IS IT?

The genetic code was deciphered in the 1960s mainly by a series of ingenious experiments invented by Marshall Nirenberg's team. This model allows you to crack genetic code based on the synthesized mRNA, like Dr. Nirenberg.

## HOW IT WORKS

This model generates an 18-base mRNA based on the nucleotides input by users. Only letters A, C, G, and U are accepted to generate the mRNA. There is no limit to the number of input nucleotides, as the mRNA will be generated based on the proportions of the nucleotides in the input. This gives users some control over the generated sequence. For example, an input of "UUUUA" will generate an mRNA containing more "U" than an input of "UA." E.g.,
1) A means 100% of A, and A is equivalent to AA, AAA, etc.
2) UG means 50% of U and 50% of G, and UG is equivalent to GU,  GGUU, or UGUG.
3) CGGA means 25% of C, 50% of G, and 25% of A.


Once correct nucleotides are input, the model will synthesize the mRNA in the simulation window. Six codons are displayed in the monitors under the simulation window.

The model will translate the sequence and provide the types of amino acids involved in the peptide synthesis. Note the displayed amino acids are not aligned with the coding order. This is what happened in the actual experiments: scientists only knew the types of amino acids and had to infer the genetic code. You need to infer the genetic code just like a scientist. 

## HOW TO USE IT

1. Input nucleotides. It must be the letters A, C, G, and U.

2. Press on "STEP-2 Synthesize mRNA"

3. Press on "STEP-3 Translate mRNA"

## THINGS TO NOTICE

* No start codon is needed in this model.
* Translation will be terminated when the ribosome encounters a stop codon.
* The mRNA is read from the 5' end to the 3' end.


## THINGS TO TRY

Try different compositions of A, C, G, and U to help you strategically determine the genetic code. 

## CREDITS AND REFERENCES

This model is made by Dr. Lin Xiang at Weber State University in 2018 and revised at the University of Kentucky in 2022. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2022). Genetic Code. Department of STEM Education, Unversity of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

3'
false
15
Line -1 true 150 105 135 120
Line -1 true 165 105 150 105
Line -1 true 180 120 165 105
Line -1 true 180 135 180 120
Line -1 true 165 150 180 135
Line -1 true 150 150 165 150
Line -1 true 165 150 180 165
Line -1 true 210 75 195 90
Line -1 true 180 180 180 165
Line -1 true 165 195 180 180
Line -1 true 150 195 165 195
Line -1 true 135 180 150 195

5'
false
15
Line -1 true 135 105 180 105
Line -1 true 135 105 135 150
Line -1 true 150 135 135 150
Line -1 true 165 135 150 135
Line -1 true 180 150 165 135
Line -1 true 180 180 180 150
Line -1 true 165 195 180 180
Line -1 true 150 195 165 195
Line -1 true 135 180 150 195
Line -1 true 210 75 195 90

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

l-unit
false
0
Polygon -7500403 true true 76 102 62 96 55 89 52 78 54 69 59 59 66 49 79 39 96 37 109 35 133 36 162 41 179 46 206 44 223 44 236 52 243 64 242 77 241 85 236 91 229 92 220 100 206 100 181 102 147 104 126 106 99 107
Polygon -16777216 true false 192 91 216 91 240 97 255 111 265 134 270 151 271 171 267 189 260 206 255 221 241 236 228 254 213 261 184 272 154 273 121 269 95 256 75 243 60 229 50 212 40 174 44 131 59 102 78 92 94 91 109 89 127 89 143 91 161 89 177 92
Polygon -7500403 true true 190 95 214 95 238 101 253 115 263 138 268 155 269 175 265 193 258 210 253 225 239 240 226 258 211 265 182 276 152 277 119 273 93 260 73 247 58 233 48 216 38 178 42 135 57 106 76 96 92 95 107 93 125 93 141 95 159 93 175 96

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

n-a
false
0
Circle -8630108 true false 60 240 58
Polygon -6459832 true false 180 105 120 180 180 255 270 225 270 135
Line -1 false 180 255 120 270
Line -1 false 0 240 60 270
Line -1 false 270 225 300 240
Rectangle -955883 true false 180 0 240 75
Line -1 false 180 75 180 105
Line -16777216 false 210 15 191 60
Line -16777216 false 229 60 210 15
Line -16777216 false 200 43 221 43

n-c
false
0
Circle -8630108 true false 60 240 58
Polygon -6459832 true false 180 105 120 180 180 255 270 225 270 135
Line -1 false 180 255 120 270
Line -1 false 0 255 60 270
Line -1 false 270 225 300 255
Rectangle -1184463 true false 180 0 240 75
Line -1 false 180 75 180 105
Line -16777216 false 234 23 219 8
Line -16777216 false 219 8 204 8
Line -16777216 false 188 23 203 8
Line -16777216 false 188 22 188 52
Line -16777216 false 203 66 188 51
Line -16777216 false 203 66 218 66
Line -16777216 false 218 66 233 51

n-g
false
0
Circle -8630108 true false 60 240 58
Polygon -6459832 true false 180 105 120 180 180 255 270 225 270 135
Line -1 false 180 255 120 270
Line -1 false 0 240 60 270
Line -1 false 270 225 300 240
Rectangle -13840069 true false 180 0 240 75
Line -1 false 180 75 180 105
Line -16777216 false 234 23 219 8
Line -16777216 false 219 8 204 8
Line -16777216 false 188 23 203 8
Line -16777216 false 188 22 188 52
Line -16777216 false 203 66 188 51
Line -16777216 false 203 66 218 66
Line -16777216 false 218 66 233 51
Line -16777216 false 217 39 232 39
Line -16777216 false 233 39 233 51

n-u
false
0
Circle -8630108 true false 60 240 58
Polygon -6459832 true false 180 105 120 180 180 255 270 225 270 135
Line -1 false 180 255 120 270
Line -1 false 0 240 60 270
Line -1 false 270 225 300 240
Rectangle -11221820 true false 180 0 240 75
Line -1 false 180 75 180 105
Line -16777216 false 188 14 188 52
Line -16777216 false 199 67 188 51
Line -16777216 false 198 66 222 66
Line -16777216 false 223 66 233 51
Line -16777216 false 233 14 233 52

nn-a
false
0
Polygon -955883 true false 75 30 75 225 180 285 285 225 285 30
Rectangle -2064490 true false 45 15 300 45
Line -6459832 false 45 45 300 45
Circle -13345367 true false 0 0 60
Circle -16777216 false false -2 0 62
Line -16777216 false 180 75 225 210
Line -16777216 false 180 75 135 210
Line -16777216 false 152 166 209 166

nn-c
false
0
Polygon -1184463 true false 75 285 97 262 118 248 136 239 151 235 181 231 208 234 224 238 241 247 264 262 285 285 285 30 75 30
Rectangle -2064490 true false 45 15 300 45
Line -6459832 false 45 45 300 45
Circle -13345367 true false 0 0 60
Line -16777216 false 210 195 180 210
Line -16777216 false 180 210 150 195
Line -16777216 false 150 195 135 165
Line -16777216 false 135 120 135 165
Line -16777216 false 150 90 135 120
Line -16777216 false 180 75 210 90
Line -16777216 false 225 120 210 90
Circle -16777216 false false 0 0 60
Line -16777216 false 210 195 225 165
Line -16777216 false 150 90 180 75

nn-g
false
0
Polygon -13840069 true false 76 224 90 240 105 255 128 273 150 285 172 289 190 289 210 285 231 275 255 255 285 225 285 30 75 30
Rectangle -2064490 true false 45 15 300 45
Line -6459832 false 45 45 300 45
Circle -13345367 true false 0 0 60
Line -16777216 false 225 180 210 210
Line -16777216 false 210 210 180 225
Line -16777216 false 180 225 150 210
Line -16777216 false 150 210 135 180
Line -16777216 false 135 135 135 180
Line -16777216 false 150 105 135 135
Line -16777216 false 180 90 150 105
Line -16777216 false 210 105 180 90
Line -16777216 false 226 139 210 105
Line -16777216 false 225 180 225 165
Line -16777216 false 225 165 180 165
Circle -16777216 false false -2 0 62

nn-u
false
0
Polygon -13791810 true false 75 30 75 270 180 225 285 270 285 30
Rectangle -2064490 true false 45 15 300 45
Line -6459832 false 45 45 300 45
Circle -13345367 true false 0 0 60
Line -16777216 false 225 75 225 180
Line -16777216 false 135 75 135 180
Line -16777216 false 152 196 209 196
Line -16777216 false 225 180 210 195
Line -16777216 false 135 180 150 195
Circle -16777216 false false 0 0 60

nucleotide
false
0
Circle -8630108 true false 60 240 58
Polygon -11221820 true false 180 105 120 180 180 255 270 225 270 135
Line -1 false 180 255 120 270
Line -1 false 0 240 60 270
Line -1 false 270 225 300 240
Rectangle -7500403 true true 180 0 240 75
Line -1 false 180 75 180 105

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

protein-unit
false
0
Rectangle -13791810 true false 0 135 60 165
Rectangle -2674135 true false 225 135 300 165
Circle -1 true false 60 60 180

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
