breed [L1s L1] ;bilingual L1 prototypes
breed [L2s L2] ;L2 prototypes
breed [exemplar1s exemplar1] ;L1 exemplars
breed [exemplar2s exemplar2] ;L2 exemplars
breed [pureL1s pureL1] ;monolingual L1 prototypes

undirected-link-breed [leads lead] ;links between exemplars and prototypes
undirected-link-breed [corrs corr] ;links between corresponding bilingual and monolingual L1 prototypes

L1s-own [
  cluster-max ;distance to farthest exemplar
  cluster-size ;number of exemplars in cluster
  deviation ;distance to corresponding monolingual prototype
]

L2s-own [
  cluster-max
  cluster-size
]

pureL1s-own [
  cluster-max
  cluster-size
]

exemplar1s-own [
  leader ;prototype of category
]

exemplar2s-own [
  leader
]

to setup
  ca
  set-default-shape turtles "circle"
  create-L1s initial-categories [
    set size 2
    set color blue
    setxy random-xcor random-ycor
    set cluster-max min-cluster-max
    set cluster-size 1
  ]
  ask L1s [create-pure]
  ask L1s [init-distro]
  update-links
  update-L
  do-plots
end

to go
  add-exemplar1
  add-exemplar2
  move-L
  update-links
  update-L
  do-plots
end

; create monolingual L1 prototypes
to create-pure ;;L1 method
  hatch-pureL1s 1 [
    set size 2
    set color violet
    set cluster-max min-cluster-max
    set cluster-size 1
    create-corr-with myself [set color orange]
  ]
end

; create initial exemplar population of L1 categories
to init-distro ;;L1 method
  hatch-exemplar1s init-cluster [
    set size 1
    let newx (random-normal [xcor] of myself 5)
    let newy (random-normal [ycor] of myself 5)
    if newx < min-pxcor [set newx min-pxcor + 1]
    if newx >= max-pxcor [set newx max-pxcor - 1]
    if newy < min-pycor [set newy min-pycor + 1]
    if newy >= max-pycor [set newy max-pycor - 1]
    setxy newx newy
    set color pink
    set leader myself
    create-lead-with min-one-of pureL1s [distance myself] [set color yellow] ;linking to monolingual L1 prototypes
  ]
  set cluster-size init-cluster
end

; update cluster-max value
to update-L
  ask turtles with [breed = L1s or breed = L2s] [
    let maxn max-one-of lead-neighbors [distance myself]
    ifelse maxn != nobody and (distance maxn) >= min-cluster-max [
      set cluster-max distance maxn
    ]
    [
      set cluster-max min-cluster-max
    ]
  ]
end

; add a new L1 exemplar
to add-exemplar1
  create-exemplar1s 1 [
    set color pink
    setxy random-xcor random-ycor
    set leader min-one-of L1s [distance myself]
    ask leader [set cluster-size cluster-size + 1]
    ask min-one-of pureL1s [distance myself] [ ; linking to monolingual L1 prototypes
      create-lead-with myself [set color yellow]
      set cluster-size cluster-size + 1
    ]
  ]
end

; add a new L2 exemplar
to add-exemplar2
  create-exemplar2s 1 [
    set color red
    setxy random-xcor random-ycor
    let candidate min-one-of turtles with [breed = L1s or breed = L2s] [distance myself]
    ifelse distance candidate < 0.95 * [cluster-max] of candidate [
      set leader candidate
    ]
    [ ; if outside existing category, form a new L2 category
      hatch-L2s 1 [
        set size 2
        set color green
        set cluster-size 1
        set cluster-max min-cluster-max
        ask myself [set leader myself]
      ]
    ]
    ask leader [set cluster-size cluster-size + 1]
  ]
end

; update prototype locations based on exemplars in category
to move-L
  ask turtles with [breed = L1s or breed = L2s or breed = pureL1s] [
    if cluster-size > 2 [
      let xsum 0
      let ysum 0
      set xsum mean [xcor] of lead-neighbors
      set ysum mean [ycor] of lead-neighbors
      if xsum < min-pxcor [set xsum min-pxcor]
      if xsum >= max-pxcor [set xsum max-pxcor]
      if ysum < min-pycor [set ysum min-pycor]
      if ysum >= max-pycor [set ysum max-pycor]
      setxy xsum ysum
    ]
  ]
  ; update monolingual-bilingual deviation
  ask turtles with [breed = L1s] [
    let minpure min-one-of corr-neighbors [distance myself]
    set deviation distance minpure
  ]
end

; update exemplar-prototype links
to update-links
  ask exemplar1s [create-lead-with leader]
  ask exemplar2s [create-lead-with leader]
end

to do-plots
  set-current-plot "Deviations"
  set-current-plot-pen "dev"
  plot mean([deviation] of L1s)
end

to-report absolute-value [number]
  ifelse number >= 0
    [ report number ]
    [ report (- number) ]
end

@#$#@#$#@
GRAPHICS-WINDOW
353
10
850
528
32
32
7.5
1
10
1
1
1
0
0
0
1
-32
32
-32
32
0
0
1
ticks

BUTTON
23
94
86
127
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
90
94
153
127
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
157
94
220
127
step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
7
53
240
86
initial-categories
initial-categories
2
25
5
1
1
categories
HORIZONTAL

SLIDER
7
14
240
47
init-cluster
init-cluster
1
100
11
5
1
exemplars
HORIZONTAL

SLIDER
7
138
240
171
min-cluster-max
min-cluster-max
1
100
20
1
1
NIL
HORIZONTAL

MONITOR
7
191
73
236
NIL
count L2s
17
1
11

MONITOR
6
244
143
289
NIL
mean ([deviation] of L1s)
17
1
11

PLOT
6
299
346
528
Deviations
time
avg difference
0.0
10.0
0.0
10.0
true
false
PENS
"dev" 1.0 0 -16777216 true

@#$#@#$#@
WHAT IS IT?
-----------
This model is a computational implementation of the Speech Learning Model of bilingual acquisition of phonetic categories (Flege, 1995).  Category prototypes and language exemplars are modeled as agents within the 2D phonetic space.  Language exposure is modeled as addition of new exemplars to the space, and category acquisition is modeled as shifting of L1 categories due to equivalence classification, or creation of new L2 category prototypes.  Three user-controlled behavioral are included in the implementation.


HOW IT WORKS
------------
The initialization of the phonetic space is as follows:
1) Create n initial bilingual L1 category prototypes with random locations (n is user-specified).
2) Each bilingual L1 prototype hatches a monolingual L1 prototype.
3) Each bilingual L1 prototype populates itself with m attached exemplars distributed normally around its location (m is user-specified).
4) Newly hatched exemplars link themselves and their category prototype.
5) Exemplars also link themselves with their prototype's corresponding monolingual L1 prototype.

At each timestep, the phonetic space changes according to the specified agent behavior rules:
1) Create a new randomly located L1 exemplar:
- The new L1 exemplar identifies the nearest bilingual L1 prototype (i.e., distance ? cluster-max of that prototype).  The exemplar joins that prototype's category by setting the prototype as its leader and creating a link between itself and the prototype.  
- The exemplar identifies the nearest monolingual L1 prototype and creates a link between itself and the prototype.
- The L1 exemplar asks both of its newly linked L1 prototypes to increment their cluster-size by one.
2) Create a new randomly located L2 exemplar:
- The new L2 exemplar checks to see if it is located within the maximum radius of the nearest existing bilingual L1 or L2 prototype.  If so, then it joins that prototype's category, sets that prototype as its leader, and links itself to the prototype.
- If the exemplar is not located within the bounds of an existing category cluster, it will proceed to hatch a new L2 prototype at the current location, set that prototype as its leader, and link itself to the new L2 prototype.  This essentially forms a new phonetic category distinct from existing L1 and L2 categories.
- The L2 exemplar then asks its now-leader to increment cluster-size by one.
3) Each prototype agent updates its location, cluster-max parametr, and deviation parameter (if applicable) given the newly added L1 and L2 exemplars:
- The centroid of each cluster is recalculated (using locations of exemplars linked with the prototype), and the prototype agent changes its location to match the centroid if necessary.
- Each prototype agent updates its cluster-max value to be the larger of either the distance from the farthest linked exemplar or the user-specified minimum value.
- Bilingual L1 prototypes recalculate their distance from their corresponding monolingual L1 prototype and update the value of the deviation parameter if necessary.
4) The plot of average deviation values is updated.


HOW TO USE IT
-------------
The behavior of the model can be manipulated using three user-defined parameters:

init-cluster: The number of L1 exemplars with which each L1 prototype is populated during initialization.  This represents a speaker's level of experience with their L1.  Having more initial exemplars corresponds to more language experience (having had more exposure to L1 input), while having fewer exemplars corresponds to less language experience.  Because ease and success of L2 acquisition has been shown to be related to how well-established the L1 categories are, this parameter allows us to model varying degrees of L1 establishment.

initial-categories: The number of L1 prototypes.  Languages around the world vary in terms of how many phonetic categories exist.  For example, while English has 14 vowels in its inventory, Spanish has only 5.  This parameter allows us to model this specific feature of languages and observe how it influences on L2 category formation patterns.

min-cluster-max: The minimum value a prototype's cluster-max parameter is allowed to have.  This reflects how small or large an area of influence any category must minimally have, and correlates with the speaker's likelihood of categorizing a sound as either foreign or non-speech.  This measure is partially language-determined and also individual-determined.  Variations in this likelihood could manifest in how easily or well any given person acquires their L2.  This parameter models the influence of this likelihood on L2 category learning.

Define these three parameters using the provided sliders.

The setup button initializes a phonetic space with the specified number of L1 categories and initial cluster size.

The go button starts the acquisition process.  Press the go button a second time to stop the process.

To observe the acquisition process step-by-step, use the step button.

Monitors for number of L2 categories formed and average bilingual-monolingual deviation are provided.

A plot of the average bilingual-monolingual deviation over the course of a run is also provided.


THINGS TO NOTICE
----------------
Try manipulating each of the behavioral parameters individually.  What effect does each one have on the evolution of the phonetic space?

Are there certain combinations of parameters that result in no L2 categories?

What settings might maximize or minimize bilingual-monolingual deviation?


THINGS TO TRY
-------------
Try moving around the sliders for the behavioral parameters!

What happens when you take them to extremes?  What happens if more than one is at an extreme?


EXTENDING THE MODEL
-------------------
In the current implementation, a new L2 category is formed by a single exemplar that lies outside existing categories.  Is this realistic?  How could you modify the model to make this more true to real life? Perhaps there needs to be a critical mass of exemplars before a new category can form?

What other linguistic behavioral parameters can you think of?  What might they do, and what aspects of language could they model?

What about multilinguals (more than 2 languages)?


NETLOGO FEATURES
----------------
This model makes liberal use of breeds and link-breeds to represent the exemplars and prototypes for the two languages.


RELATED MODELS
--------------
Language Change


CREDITS AND REFERENCES
----------------------
Flege, J. E. (1995). __Second-language speech learning: Theory, findings, and problems,__ in Speech Perception and Linguistic Experience: Issues in Cross-language Research, edited by W. Strange (York, Timonium, MD), pp. 233_272.

Model written by Karen L. Chu, Northwestern University EECS 372/472, Spring 2011.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="Initial Categories" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count L2s</metric>
    <metric>mean([deviation] of L1s)</metric>
    <steppedValueSet variable="initial-categories" first="1" step="2" last="20"/>
    <enumeratedValueSet variable="init-cluster">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-cluster-max">
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="Initial Cluster" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count L2s</metric>
    <metric>mean([deviation] of L1s)</metric>
    <steppedValueSet variable="init-cluster" first="0" step="2" last="100"/>
    <enumeratedValueSet variable="initial-categories">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-cluster-max">
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="Cluster Max" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count L2s</metric>
    <metric>mean([deviation] of L1s)</metric>
    <enumeratedValueSet variable="init-cluster">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-categories">
      <value value="5"/>
    </enumeratedValueSet>
    <steppedValueSet variable="min-cluster-max" first="1" step="5" last="50"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
