breed [farmers farmer]
breed [plants plant]
breed [weeds weed]


turtles-own [energy my-heading]
patches-own [nutrients fertile] ;; nutrients determines the soil quality. fertile determines if a seed can be sprouted there; affected by spacing.

globals [
  total-harvested;; lbs of produce harvested by the farmer
  money;; budget for the project
crop
]

to setup
  clear-all
  setup-patches
  setup-turtles
  make-farmer
  reset-ticks
  set money (budget - (count plants * plant-cost))
end

to setup-patches
  ask patches [
   set nutrients (random 15) ]
  repeat 5 [diffuse nutrients 1]
  ask patches [
   set pcolor scale-color brown nutrients  10 0
   if remainder pxcor spacing = 0 and remainder pycor spacing = 0 [set fertile true ]]
end


to setup-turtles
  create-weeds 0

end

to make-farmer
  create-farmers 1 [
    set color cyan
    set size 3
    set shape "farmer"
    setxy 0 0
    set heading 90
    set my-heading 270
    run "seed"
  ]
end

to seed
  repeat (number-plants)
[
 ask farmers [
  (ask patch-here [
      if fertile = true and not any? plants-here [
        sprout-plants 1 [
          set shape "plant"
          set size 0.2
          set energy 2
        ]]])
  fd (spacing)
  if not can-move? 1 [
    set heading 0
    fd spacing
    set heading my-heading
    ifelse my-heading = 90 [set my-heading 270] [set my-heading 90]

  ]]

]

end

to re-seed
  repeat (number-plants * spacing)
[
  ask farmers [fd spacing
  (ask patch-here [
      if fertile = true and not any? plants-here [
        sprout-plants 1 [
          set shape "plant"
          set size 0.2
          set energy 2
        ]]])
  if not can-move? 1 [
    set heading 0
    fd spacing
    set heading my-heading
    ifelse my-heading = 90 [set my-heading 270] [set my-heading 90]

  ]]]
  end

to go
      animate
       tick
end

to animate
 ask turtles [
   run word breed "-grow"
   run word breed "-check-if-dead"
   run word breed "-eat" ]
  ;wait 1
 if any? patches with [not any? plants-here and nutrients > 5] [
   ask one-of patches with [not any? plants-here and nutrients > 5] [
    sprout-weeds 1 [
      set breed weeds
      set shape "flower budding"
      set color lime
      set energy 1
      set size 0.03;; somehow I want to adjust this so that plants are more likely to appear in spaces with high nutrient level
harvest-plants
 harvest-weeds
    ]]]

end

to plants-grow
  if (energy > 3) [set size size + 0.02]
end

to weeds-grow;;
    if (energy > 2) [set size size + 0.04];; arbitrary numbers but weeds grow faster
end

to farmers-grow
end


to plants-check-if-dead
  if (energy <= 0) [
    set nutrients (nutrients + 0.5)
    set pcolor scale-color brown nutrients 10 0
    die
    ]
  ;;maybe have them "flash" before they die, or 'turn red, wait 3' so we know to look at them **note that i can't get this part to work. they freeze up.
end

to weeds-check-if-dead
  if (energy <= 0) [ die ]
end

to farmers-check-if-dead
end

to plants-eat
  if (nutrients >= 1) [
      set energy energy + 1
      set nutrients (nutrients - 0.2)
      ask neighbors4 [set nutrients (nutrients - 0.05)
        set pcolor scale-color brown nutrients 10 0];; plants slowly take nutrients from soil
      set pcolor scale-color brown nutrients 10 0]
  if (nutrients < 1) [
      set energy energy - 0.1];; if no nutrients in the soil, this arbitrary rate is how fast they will die
end

to weeds-eat
  if (nutrients >= 1) [
  set energy energy + 1
  set nutrients (nutrients - 0.1)
  ask neighbors4 [
    set nutrients (nutrients - 0.08)
    set pcolor scale-color brown nutrients 10 0];; weeds take nutrients from soil less quickly
  set pcolor scale-color brown nutrients 10 0]
  if (nutrients < 1) [
  set energy energy - 0.1];; if no nutrients in the soil, this arbitrary rate is how fast they will die
end

to farmers-eat
end

to harvest-plants
  ask farmers [
    set hidden? not mouse-inside?
    setxy mouse-xcor mouse-ycor
  ]
  if mouse-inside? and mouse-down? [
    set crop plants with [distance one-of farmers < (size / 2)]
    if any? crop [
      let weight sum [size] of crop
      set total-harvested (total-harvested + (ceiling (1.5 * weight * count crop)))



ask crop [ die ]
    ]]

end

to harvest-weeds
  ask farmers [
    set hidden? not mouse-inside?
    setxy mouse-xcor mouse-ycor
  ]
  if mouse-inside? and mouse-down? [
    let weedable weeds with [distance one-of farmers < (size * 2)]
    if any? weedable [

ask weedable [ die ]
    ]
  ]
end
to add-compost
  ask patches [set nutrients (nutrients + 5) set pcolor scale-color brown nutrients 10 0 ]
set money (money - 20)
end

to add-herbicide
  ask weeds [die]
  ask plants [
    set energy energy - 2]
  ask patches [set nutrients (nutrients - 2) set pcolor scale-color brown nutrients 10 0 ]
set money (money - 30)
end
@#$#@#$#@
GRAPHICS-WINDOW
397
78
1209
526
-1
-1
32.1
1
10
1
1
1
0
0
0
1
0
24
0
12
1
1
1
ticks
30.0

SLIDER
135
13
305
46
number-plants
number-plants
0
60
60
1
1
NIL
HORIZONTAL

BUTTON
8
10
106
57
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
7
70
109
123
start / stop
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
211
156
358
207
apply compost
add-compost
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
30
289
379
539
Populations
time
population
0.0
100.0
0.0
60.0
true
false
"" ""
PENS
"Plants" 1.0 0 -14439633 true "" "plot count plants"
"Weeds" 1.0 0 -5825686 true "" "plot count weeds"

MONITOR
222
77
356
122
units of crop harvested
total-harvested
2
1
11

SLIDER
351
13
471
46
spacing
spacing
1
4
4
1
1
NIL
HORIZONTAL

MONITOR
123
76
205
121
money
money
2
1
11

SLIDER
513
14
663
47
plant-cost
plant-cost
0
10.00
5
.05
1
NIL
HORIZONTAL

SLIDER
712
13
884
46
budget
budget
0
500
500
10
1
NIL
HORIZONTAL

BUTTON
66
156
184
207
re-seed
ask farmers [\nsetxy 0 0 \nset heading 90\nset my-heading 270 \nseed]\n\nset money (money - (number-plants * plant-cost))
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
66
221
184
273
sell crop
set money (ceiling money + (total-harvested * plant-cost) )\nset total-harvested 0
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
211
222
359
275
apply herbicide
add-herbicide
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This view of a garden bed shows what happens when a farmer tries to plant and grow a variety of crops.

## HOW IT WORKS

You act as the farmer, and can select how many seeds to plant, how far apart they should be spaced, and what additives you'd like to put into the soil. You can also harvest your plants, sell them, and seed again.

## HOW TO USE IT
Set the slider buttons on the top of the screen to the value that you'd like, then press 'Setup'. When you're ready to start, press 'go', and then the farmer will follow your mouse. Hold down the mouse button to harvest a plant. You can click the interface buttons at any time while the model is running, or press 'go' again to pause it.

## THINGS TO NOTICE

Check out the Populations graph on the lower left. What do you think each line color represents?

What happens to the color of the soil as you let the model run?


## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

caterpillar
true
0
Polygon -7500403 true true 165 210 165 225 135 255 105 270 90 270 75 255 75 240 90 210 120 195 135 165 165 135 165 105 150 75 150 60 135 60 120 45 120 30 135 15 150 15 180 30 180 45 195 45 210 60 225 105 225 135 210 150 210 165 195 195 180 210
Line -16777216 false 135 255 90 210
Line -16777216 false 165 225 120 195
Line -16777216 false 135 165 180 210
Line -16777216 false 150 150 201 186
Line -16777216 false 165 135 210 150
Line -16777216 false 165 120 225 120
Line -16777216 false 165 106 221 90
Line -16777216 false 157 91 210 60
Line -16777216 false 150 60 180 45
Line -16777216 false 120 30 96 26
Line -16777216 false 124 0 135 15

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

drop
false
0
Circle -7500403 true true 73 133 152
Polygon -7500403 true true 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -7500403 true true 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

farmer
false
2
Circle -955883 true true 110 5 80
Polygon -13345367 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -955883 true true 127 79 172 94
Polygon -955883 true true 195 90 240 150 225 180 195 120
Polygon -955883 true true 105 90 60 150 75 180 105 120
Polygon -1184463 true false 75 45 225 45 195 30 180 0 120 0 105 30 75 45
Polygon -6459832 true false 225 240 240 255 255 105 240 105 225 240
Polygon -7500403 true false 270 105 225 105 225 60 240 45 255 45 270 60 270 105
Line -16777216 false 120 90 135 120
Polygon -955883 true true 120 90 135 120 165 120 180 90 120 90

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

flower budding
false
0
Polygon -7500403 true true 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Polygon -7500403 true true 189 233 219 188 249 173 279 188 234 218
Polygon -7500403 true true 180 255 150 210 105 210 75 240 135 240
Polygon -7500403 true true 180 150 180 120 165 97 135 84 128 121 147 148 165 165
Polygon -7500403 true true 170 155 131 163 175 167 196 136

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

leaf 2
false
0
Rectangle -7500403 true true 144 218 156 298
Polygon -7500403 true true 150 263 133 276 102 276 58 242 35 176 33 139 43 114 54 123 62 87 75 53 94 30 104 39 120 9 155 31 180 68 191 56 216 85 235 125 240 173 250 165 248 205 225 247 200 271 176 275

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

mouse side
false
0
Polygon -7500403 true true 38 162 24 165 19 174 22 192 47 213 90 225 135 230 161 240 178 262 150 246 117 238 73 232 36 220 11 196 7 171 15 153 37 146 46 145
Polygon -7500403 true true 289 142 271 165 237 164 217 185 235 192 254 192 259 199 245 200 248 203 226 199 200 194 155 195 122 185 84 187 91 195 82 192 83 201 72 190 67 199 62 185 46 183 36 165 40 134 57 115 74 106 60 109 90 97 112 94 92 93 130 86 154 88 134 81 183 90 197 94 183 86 212 95 211 88 224 83 235 88 248 97 246 90 257 107 255 97 270 120
Polygon -16777216 true false 234 100 220 96 210 100 214 111 228 116 239 115
Circle -16777216 true false 246 117 20
Line -7500403 true 270 153 282 174
Line -7500403 true 272 153 255 173
Line -7500403 true 269 156 268 177

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

plant medium
false
0
Rectangle -7500403 true true 135 165 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 165 120 120 150 90 180 120 165 165

plant small
false
0
Rectangle -7500403 true true 135 240 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 240 120 195 150 165 180 195 165 240

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

strawberry
false
0
Polygon -7500403 false true 149 47 103 36 72 45 58 62 37 88 35 114 34 141 84 243 122 290 151 280 162 288 194 287 239 227 284 122 267 64 224 45 194 38
Polygon -7500403 true true 72 47 38 88 34 139 85 245 122 289 150 281 164 288 194 288 239 228 284 123 267 65 225 46 193 39 149 48 104 38
Polygon -10899396 true false 136 62 91 62 136 77 136 92 151 122 166 107 166 77 196 92 241 92 226 77 196 62 226 62 241 47 166 57 136 32
Polygon -16777216 false false 135 62 90 62 135 75 135 90 150 120 166 107 165 75 196 92 240 92 225 75 195 61 226 62 239 47 165 56 135 30
Line -16777216 false 105 120 90 135
Line -16777216 false 75 120 90 135
Line -16777216 false 75 150 60 165
Line -16777216 false 45 150 60 165
Line -16777216 false 90 180 105 195
Line -16777216 false 120 180 105 195
Line -16777216 false 120 225 105 240
Line -16777216 false 90 225 105 240
Line -16777216 false 120 255 135 270
Line -16777216 false 120 135 135 150
Line -16777216 false 135 210 150 225
Line -16777216 false 165 180 180 195

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
