globals [Allowed lock-down-period-count Alternate-condition original-condition infected-and-cured]
extensions [ vid bitmap ]

turtles-own [
  infected?    ;; has the person been infected with the disease?
  infectionage
  age
]


;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup ;;;
;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  set who-should-move "All people can move"
  set lock-down-period-count 1
  set infected-and-cured 0
  set Alternate-condition "No One should Move"
  set original-condition who-should-move
  set-default-shape turtles "person"
  make-turtles
;  ask patches [ set p-infected? false ]
  infect
  recolor
;  if variant = "network" [ make-network ]
  reset-ticks
end

to make-turtles
  create-turtles num-people [
    set infected? false
    setxy random-xcor random-ycor
    set age 50
  ]
end


to infect
  ask n-of num-infected turtles [
    set infected? true
    set infectionage 1
    ;set age random 50
    ;set infectionage 1
;    if variant = "environmental" [
;      ;; the patch under an infected turtle becomes infected:
;      set p-infected? true
;    ]
  ]

end

to recolor
  ask turtles [
    ;; infected turtles are red, others are gray
    set color ifelse-value infected? [ red ] [ gray ]

  ]
;  ask patches [
;    ;; infected patches are yellow, others are black
;    set pcolor ifelse-value p-infected? [ yellow ] [ black ]
;  ]
end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Main ;;;
;;;;;;;;;;;;;;;;;;;;;;;

to go




  if all? turtles [ infected? ] [ stop ]
  spread-infection
  cure-infection
  recolor

    ;; recording video
   if vid:recorder-status = "inactive" [
    vid:start-recorder
  ]
  vid:record-view

  move
  if all? turtles [ not infected? ] [ vid:save-recording "SImulation1.mp4" stop ]

  tick
end

to spread-infection
;  ask patches with [ p-infected? ] [
;    ;; count down to the end of the patch infection
;    set infect-time infect-time - 1
;  ]
  ask turtles with [ infected? ] [
  ask turtles-here [ set infected? true ]
    ]


end

to cure-infection
  ask turtles with [ infected? ] [
  set  infected? ifelse-value infectionage >= cure-days [ false ] [ true ]
  if  random 100 >= 100 - virus-death-rate [ die ]
  ;ask n-of 1 turtles with [ infected? ]  [ die ]
  set  infectionage ifelse-value infectionage >= 14 [ 0 ] [ infectionage ]
  ;set  infected? ifelse-value infectionage >= 14 [ false ] [ true ]
  ;set color ifelse-value infected? [ red ] [ gray ]
  ]


end

;;;;;;;;;;;;;;
;;; Layout ;;;
;;;;;;;;;;;;;;d
to move

  set Allowed movement-allowed * count turtles / 100
  if who-should-move = "All people can move" [
      ask turtles [
      fd 1
      rt random 30
      lt random 30
    ]
  ]

  if who-should-move = "Limited People can move for essential work" [
        ask n-of Allowed turtles [
      fd 1
      rt random 30
      lt random 30
    ]
  ]

    if who-should-move = "Infected People should not move" [
        ask turtles with [not infected?] [
      fd 1
      rt random 30
      lt random 30
    ]
  ]

      if who-should-move = "No One should Move" [
        ask turtles with [not infected?] [
      fd 0
      rt 0
      lt 0
    ]
  ]

  ;; who chooses what to happen you or me
  if i-will-chose-who-should-move = false [

  ;; lockdown rules
if ticks > 0 and unlimited-lock-down = true [
    set who-should-move Alternate-condition

  ]


  if ticks > 0 and lock-down-period = 0 and unlimited-lock-down = false [
    set who-should-move original-condition

  ]

;  lock down
  if ticks > 0 and lock-down-period > 0 and unlimited-lock-down = false [
    if ticks > 0 and remainder ticks lock-down-period = 0 [set lock-down-period-count lock-down-period-count + 1 print lock-down-period-count]
;   if ticks > 0 and remainder lock-down-period-count 2 = 0 [set lock-down-period-count lock-down-period-count + 1 print lock-down-period-count]
    set who-should-move ifelse-value ticks > 0 and remainder lock-down-period-count 2 = 0 [Alternate-condition] ["All people can move"]
;    set who-should-move ifelse-value ticks > 0 and remainder ticks lock-down-period = 0 [Alternate-condition] ["All people can move"]
  ]

]

    ask turtles with [ infected? ] [
    set infectionage infectionage + 1
    set infected-and-cured infected-and-cured + 1
  ]


end


; Copyright 2020 Mohit Singh.
@#$#@#$#@
GRAPHICS-WINDOW
755
15
1538
799
-1
-1
7.6733
1
12
1
1
1
0
1
1
1
-50
50
-50
50
1
1
1
ticks
30.0

BUTTON
10
280
90
315
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
190
280
270
315
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
15
50
205
83
num-people
num-people
2
2000
2000.0
1
1
NIL
HORIZONTAL

BUTTON
100
280
180
315
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
15
10
192
43
num-infected
num-infected
0
num-people
1.0
1
1
Persons
HORIZONTAL

PLOT
0
370
455
635
Infection vs. Time
Time
NIL
0.0
10.0
0.0
0.01
true
true
"" ""
PENS
"people infected" 1.0 0 -5298144 true "" "plot count turtles with [ infected? ] / count turtles"
"cured" 1.0 0 -7500403 true "" "plot count turtles with [ infectionage = 14 ] / count turtles"

MONITOR
5
225
85
270
Infected
count turtles with [ infected? ]
3
1
11

MONITOR
100
225
157
270
cured
count turtles with [ infectionage = 14 ]
17
1
11

MONITOR
170
225
227
270
Alive
count turtles
17
1
11

SLIDER
215
10
422
43
virus-death-rate
virus-death-rate
0
100
1.0
1
1
percentage
HORIZONTAL

SLIDER
215
50
465
83
movement-allowed
movement-allowed
0
100
3.0
1
1
percentage
HORIZONTAL

MONITOR
240
225
297
270
Dead
num-people - count turtles
17
1
11

SLIDER
375
165
547
198
cure-days
cure-days
0
50
14.0
1
1
days
HORIZONTAL

CHOOSER
250
100
532
145
who-should-move
who-should-move
"All people can move" "Infected People should not move" "No One should Move" "Limited People can move for essential work"
1

SLIDER
15
165
187
198
lock-down-period
lock-down-period
0
100
0.0
1
1
days
HORIZONTAL

TEXTBOX
475
50
760
90
If in \"Who-should-move\" there is \"Limited People for essential work\" then only this is useful
12
0.0
1

TEXTBOX
40
200
190
218
for periodic lock down
11
0.0
1

SWITCH
205
165
367
198
unlimited-lock-down
unlimited-lock-down
1
1
-1000

CHOOSER
5
690
337
735
alternate-who-should-move
alternate-who-should-move
"All people can move" "Infected People should not move" "No One should Move" "Limited People can move for essential work"
2

TEXTBOX
220
200
370
218
for unlimited lock down
13
0.0
1

PLOT
455
370
755
635
Population
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles"

MONITOR
10
320
92
365
days passed
ticks
17
1
11

SWITCH
15
100
240
133
i-will-chose-who-should-move
i-will-chose-who-should-move
0
1
-1000

TEXTBOX
440
10
670
56
percentage of affected people who die because of this virus
13
0.0
1

@#$#@#$#@
## what is it?
this is one model representing the corona virus spread
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="population-density" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>ticks</metric>
    <enumeratedValueSet variable="variant">
      <value value="&quot;mobile&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="connections-per-node">
      <value value="4.1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-people" first="50" step="50" last="200"/>
    <enumeratedValueSet variable="num-infected">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="disease-decay">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="degree" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="50"/>
    <metric>count turtles with [infected?]</metric>
    <enumeratedValueSet variable="num-people">
      <value value="200"/>
    </enumeratedValueSet>
    <steppedValueSet variable="connections-per-node" first="0.5" step="0.5" last="4"/>
    <enumeratedValueSet variable="disease-decay">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="variant">
      <value value="&quot;network&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-infected">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="environmental" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>ticks</metric>
    <enumeratedValueSet variable="num-people">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="connections-per-node">
      <value value="4"/>
    </enumeratedValueSet>
    <steppedValueSet variable="disease-decay" first="0" step="1" last="10"/>
    <enumeratedValueSet variable="variant">
      <value value="&quot;environmental&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-infected">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="density-and-decay" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>ticks</metric>
    <enumeratedValueSet variable="variant">
      <value value="&quot;environmental&quot;"/>
    </enumeratedValueSet>
    <steppedValueSet variable="disease-decay" first="0" step="1" last="10"/>
    <enumeratedValueSet variable="num-infected">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-people" first="50" step="50" last="200"/>
    <enumeratedValueSet variable="connections-per-node">
      <value value="4"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
