extensions [table]
breed [ persons person ] ; agents that need to exit

globals[
  tleft tright ; total number of persons exitting from left and right
  speed using-left using-right last-left last-right max-agents-in-panic-rational max-agents-in-panic-emotional max-panic-value
]

patches-own [structure-type walkable? exit-id doms steps-to-exits patch-value-left patch-value-right ; variables representing environment
  updated? initial-target-exit dom spread-update-left? spread-update-right? ; helping environment varaibles
]

persons-own [curr-dir curr-exit state in-panic-for moving-for waiting-for rational? has-changed?]


to setup
  create-env
  ; creates environment with 2 exits (left and right), environment type: can be 1, 2 or 3; 1 is symmetric, 2 is asymmetric, and 3 is (one exit) invisible, and floor field

  setup-agents
  ; sets up persons, based on
  ; 1: number of persons
  ; 2: rational persons %

  InitializeGlobals
  ; initialies global parameters
end

to go

  ask persons [
  if (strategy = 1) [set curr-exit str1]
  if (strategy = 2) [str2]
  if (strategy = 3) [str3]
  set curr-dir get-direction-to-dest curr-exit
  set heading curr-dir
      move-now
  ]
set-globals

if (strategy = 3) [spread decay setup-exits]

tick
if (count persons < 2) [stop]
end

to-report str1
  let exitsel ""
  let dist 9999
  let patch-ste [steps-to-exits] of patch-here

  let allf table:keys patch-ste
  foreach allf[ [z] ->
    let d table:get patch-ste z
    if (d < dist) [
      set dist d
      set exitsel z
    ]
  ]

  report exitsel
end

to str2
  let cnt count turtles-on neighbors
  if (cnt > 0) [
    let ag one-of turtles-on neighbors
    let exit_ag [curr-exit] of ag
    let exit_a curr-exit
    let payoff -1
    let prob -1
    let r random 10

    if (not rational?) [
      ifelse (exit_ag = exit_a) [
        ;set prob (1 / (9 + (0.644 ^ -0))) ; no change CHANGE WITH with prob 0
        ;set prob int (prob * 10)
        ;if (prob = r) [set curr-exit  exit_ag]
        ]
      [
        if (in-panic-for > 0) [
          set prob (1 / (9 + (0.644 ^ -0))) ; ; no change CHANGE WITH with prob 0.1
          set prob int (prob * 10)
          if (prob = r) [set curr-exit  exit_ag]
          ]

      ]
    ]

    if (rational? and in-panic-for <= 0) [
      ifelse (exit_ag = exit_a) [
        if (not has-changed?)[
          set prob (1 / (9 + (0.644 ^ -0))) ; ; no change CHANGE WITH with prob 0.1
          ;set prob 1 - (1 / (1 + 0.644 ^ -5)) ; definately change with prob 0.9]
          set prob int (prob * 10)
          if (prob = r) [ifelse (curr-exit = "left") [set curr-exit "right" if (allow-one-change) [set has-changed? true]][set curr-exit "left" if (allow-one-change) [set has-changed? true]]]

          ]
        ]
      [
        if (not has-changed?)[
          set prob 1 - (1 / (1 + 0.644 ^ -5)) ; definately change with prob 0.9]
          set prob int (prob * 10)
          if (prob = r) [ifelse (curr-exit = "left") [set curr-exit "right" if (allow-one-change) [set has-changed? true]][set curr-exit "left" if (allow-one-change) [set has-changed? true]]]

          ]

      ]
    ]

    if (rational? and in-panic-for > 0 and not has-changed?) [
      ifelse (exit_ag = exit_a) [

          ifelse (curr-exit = "left") [set curr-exit "right" if (allow-one-change) [set has-changed? true]][set curr-exit "left" if (allow-one-change) [set has-changed? true]]


        ]
      [
        ;set prob (1 / (9 + (0.644 ^ -0))) ; no change CHANGE with prob 0

      ]
    ]

    if (rational? and in-panic-for > 0 and has-changed?) [
      ifelse (exit_ag = exit_a) [

          ifelse (curr-exit = "left") [set curr-exit "right" if (allow-one-change) [set has-changed? true]][set curr-exit "left" if (allow-one-change) [set has-changed? true]]


        ]
      [
        set prob sensitivity ; ; sensitivity
        set prob int (prob * 10)
        if (prob = r) [set curr-exit  exit_ag]
      ]
    ]

  ]
end

to str3

  let cnt count turtles-on neighbors
  if (cnt > 0) [
    let ag one-of turtles-on neighbors
    let exit_ag [curr-exit] of ag
    let exit_a curr-exit
    let payoff -1
    let prob -1
    let r random-float 1

    let pvl patch-value-left ;of patch-here
    let pvr patch-value-right ;of patch-here
    let exit-value ""
    if (pvl > pvr) [set exit-value  "left"]
    if (pvr > pvl) [set exit-value  "right"]

    if (rational? and in-panic-for <= 0) [
      ifelse (exit_ag = exit_a) [
        ifelse(exit_a = exit-value) []
        [
          set prob (1 / (1 + 0.644 ^ 2.5))
          if (prob >= r) [ifelse (curr-exit = "left") [set curr-exit "right"][set curr-exit "left"]]       ;do with prob 0.75
        ]
      ]
      [
        ifelse(exit_a = exit-value) []
        [
          set prob (1 / (1 + 0.644 ^ -2.5))
          if (prob >= r) [ifelse (curr-exit = "left") [set curr-exit "right"][set curr-exit "left"]]       ;do with prob 0.25
        ]
      ]
    ]

    if (rational? and in-panic-for > 0) [
    ifelse (exit_ag = exit_a) [
      ifelse(exit_a = exit-value) [
        set prob (1 / (1 + 0.644 ^ -2.5))
        if (prob >= r) [ifelse (curr-exit = "left") [set curr-exit "right"][set curr-exit "left"]]       ;do with prob 0.25
      ]
      [
        ifelse (curr-exit = "left") [set curr-exit "right"][set curr-exit "left"]
      ]
    ]

    [
      ifelse(exit_a = exit-value) []
        [
          set prob (1 / (1 + 0.644 ^ 2.5))
          if (prob >= r) [ifelse (curr-exit = "left") [set curr-exit "right"][set curr-exit "left"]]       ;do with prob 0.75
        ]
    ]

    ]
  ]
end

to-report get-direction-to-dest [dest]
  let patch-dom [doms] of patch-here
  report table:get patch-dom dest
end

to move-now
  if (state = "start" or state = "walk")[set color green - 2 move-forward]
  if (state = "wait") [set color blue move-forward]
  if (state = "panic") [set color red move-forward]

  if (state = "end")
  [
    ifelse (strategy = 3) [
      ifelse (curr-exit = "left") [announce "left" set using-left using-left + 1 set last-left ticks] [announce "right" set using-right using-right + 1 set last-right ticks]  die
    ]
    [
      ifelse (curr-exit = "left") [set using-left using-left + 1 set last-left ticks] [set using-right using-right + 1 set last-right ticks]  die
    ]
  ]
end

to move-forward

  ifelse not any? other turtles-on patch-ahead speed [fd speed  set in-panic-for 0  set waiting-for 0 set moving-for moving-for + 1 set state "walk"]
    [
      ifelse scan-neighbor-right 45 [rt 45 fd speed set in-panic-for 0  set waiting-for 0 set moving-for moving-for + 1 set state "walk"]
      [
        ifelse scan-neighbor-left 45 [lt 45 fd speed set in-panic-for 0  set waiting-for 0 set moving-for moving-for + 1 set state "walk"]
        [
          ifelse scan-neighbor-right 90 [rt 90 fd speed set in-panic-for 0  set waiting-for 0 set moving-for moving-for + 1 set state "walk"]
          [
            ifelse scan-neighbor-left 90 [lt 90 fd speed set in-panic-for 0  set waiting-for 0 set moving-for moving-for + 1 set state "walk"]
            [
              ifelse scan-neighbor-right 135 [rt 135 fd speed set in-panic-for 0  set waiting-for 0 set moving-for moving-for + 1 set state "walk"]
              [
                ifelse scan-neighbor-left 135 [lt 135 fd speed set in-panic-for 0  set waiting-for 0 set moving-for moving-for + 1 set state "walk"]
                [
                  set waiting-for waiting-for + 1 set moving-for 0 set state "wait"
                  if (waiting-for > 5) [set state "panic" set in-panic-for in-panic-for + 1 if (max-panic-value < in-panic-for) [set max-panic-value in-panic-for] set moving-for 0]

                ]
              ]
            ]
          ]
        ]
      ]
    ]
    if [structure-type] of patch-here = "exit" [set state  "end"]
end

to-report scan-neighbor-right [angle]
  let return? false
  let praa patch-right-and-ahead  angle speed
  ;if ([structure-type] of praa = "wall") [report return?]
  ;let c count other turtles-on praa
  ;ifelse praa = nobody [][if (c <= 3) [set return? true]]
  ifelse praa = nobody [][if not any? other turtles-on praa [set return? true]]
  report return?
end

to-report scan-neighbor-left [angle]
  let return? false
  let plaa patch-left-and-ahead  angle speed
  ;if ([structure-type] of plaa = "wall") [report return?]
  ifelse plaa = nobody [][if not any? other turtles-on plaa [set return? true]]
  report return?
end

to announce [ex]
  let ph patch-here
  ask ph [
    ask neighbors [ifelse ex = "left" [set patch-value-left patch-value-left + 1] [set patch-value-right patch-value-right + 1]]
  ]
end

to set-globals
  let c count persons with [in-panic-for > 0 and rational?]
  if (c > max-agents-in-panic-rational) [set max-agents-in-panic-rational c]
  let d count persons with [in-panic-for > 0 and not rational?]
  if (d > max-agents-in-panic-emotional) [set max-agents-in-panic-emotional d]
end

to spread
  ask patches [set spread-update-left? false set spread-update-right? false]
  ask patches [
    if (patch-value-left > 0) [
      let pvl patch-value-left
      ask neighbors [
        if not spread-update-left? [
          if (patch-value-left <  pvl) [set patch-value-left (pvl - (pvl / 10)) set spread-update-left? true]
          set pcolor orange + patch-value-right
        ]
      ]
    ]

    if (patch-value-right > 0) [
      let pvr patch-value-right
      ask neighbors [
        if not spread-update-right? [
          if (patch-value-left <  pvr) [set patch-value-right  (pvr - (pvr / 10)) set spread-update-right? true]
          set pcolor yellow + patch-value-right
        ]
      ]
    ]

    if (patch-value-left = 0 and patch-value-right = 0) [set pcolor white]

  ]
end

to decay
  ask patches [
    let dl patch-value-left / 10
    let dr patch-value-right / 10
    ifelse (patch-value-left > 0.1) [set patch-value-left patch-value-left - dl] [set patch-value-left 0]
    ifelse (patch-value-right > 0.1) [set patch-value-right patch-value-right - dr] [set patch-value-right 0]
  ]
end

;;;;;;;;;;;;;;;;;;;; INITIALIZE GLOBALS ;;;;;;;;;;;;;;;;;;;;;

to InitializeGlobals
  set speed 1
  set using-left 0
  set using-right 0
  set last-left 0
  set last-right 0
  set max-agents-in-panic-rational 0
  set max-agents-in-panic-emotional 0
  set max-panic-value 0
end

;;;;;;;;;;;;;;;;;;;; PERSONS SETUP ;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup-agents
  clear-turtles
  reset-ticks

  create-persons num-agents [
    move-to one-of patches with [structure-type = "floor" and (not any? other turtles-here)]
    set color black
    set state "start"
    set in-panic-for 0
    set moving-for 0
    set waiting-for 0
    set rational? false
    set has-changed? false
    set curr-exit str1
    ;ifelse (strategy = 1) [] [ifelse (strategy = 2) [set curr-exit find-nearest-exit][set curr-exit set-a-random-exit]]
  ]
  setrational
end

to setrational
  let r  rational *  num-agents / 100
  let i 0
  while [i < r] [
    ask one-of turtles with [rational? = false] [set rational? true set shape "circle"]
    set i i + 1
    ]
end

to-report set-a-random-exit
  let r random 2
  ifelse (r = 0) [report "left"] [report "right"]
end

;;;;;;;;;;;;;;;;;;;;;; ENVIRONMENT SETUP ;;;;;;;;;;;;;;;;;;;;;;;;;;;

to create-env
  clear-all

 ask patches [set pcolor gray set walkable? true set doms table:make set steps-to-exits table:make set updated? false set structure-type "floor" set patch-value-left 0.0 set patch-value-right 0.0]
  ;setup-exterior-walls
  setup-exits
  set-doms-ste-default
  setup-potential-map
end

to setup-exterior-walls
  let walls patches with [((pxcor >= min-pxcor and pxcor <= max-pxcor) and (pycor = max-pycor))]
  ask walls [set structure-type "wall" set walkable? false set pcolor black]
  set walls patches with [((pxcor >= min-pxcor and pxcor <= max-pxcor) and (pycor = min-pycor))]
  ask walls [set structure-type "wall" set walkable? false set pcolor black]
  set walls patches with [((pycor >= min-pycor and pycor <= max-pycor) and (pxcor = max-pxcor))]
  ask walls [set structure-type "wall" set walkable? false set pcolor black]
  set walls patches with [((pycor >= min-pycor and pycor <= max-pycor) and (pxcor = min-pxcor))]
  ask walls [set structure-type "wall" set walkable? false set pcolor black]
end

to setup-exits
  if (env-type = 1) [setup-exit 0 26 0 3 "left"  setup-exit 50 26 0 3 "right"]
  if (env-type = 2) [setup-exit 0 26 0 3 "left"  setup-exit 50 3 0 3 "right"]
  if (env-type = 3) [setup-exit 0 26 0 3 "left"  setup-exit 50 3 0 3 "right" setup-obstacles]

end

to setup-obstacles
  let obstacles patches with [(pxcor >= 25 and pycor <= 5) and (pxcor >= 25 and pycor >= 4)]
  ask obstacles [set walkable? false set structure-type "obstacle" set pcolor gray]
end

to setup-exit [startx starty len wid id]
  let exits patches with [(pxcor >= startx and pycor <= starty) and (pxcor <= startx + len and pycor >= starty - wid)]

  ask exits [set walkable? true set structure-type "exit" set exit-id id set pcolor red]

end

to setup-potential-map
  ask patches with [structure-type = "exit"][
    let gx pxcor
    let gy pycor
    let te exit-id
    let neigh-patches neighbors with [structure-type != "exit" and walkable?]
    ask neigh-patches[
      let o towardsxy gx gy
      let d table:get doms te
      if (d = -1) [table:put doms te o set initial-target-exit te table:put steps-to-exits te 1 set dom o set updated? true]
      ]
  ]


    while [count patches with [structure-type = "floor" and updated? = false] > 0][update-patchleft]
    ask patches with [structure-type = "floor" and initial-target-exit != "right"] [set updated? false]
    while [count patches with [structure-type = "floor" and updated? = false] > 0][update-patchright]

    ask patches with [structure-type = "floor"] [set pcolor white]
end


to update-patchleft
  ask patches with [structure-type = "floor" and table:get doms "left" != -1][
      let gx pxcor
      let gy pycor

      let x table:get steps-to-exits "left"
      let neigh-patches neighbors with [structure-type != "exit" and walkable? and table:get doms "left" = -1]
      ask neigh-patches[
        let o towardsxy gx gy
           if (table:get doms "left" = -1) [
             table:put doms "left" o

             table:put steps-to-exits "left" x + 1
             ]
           set pcolor gray
           set updated? true
      ]
  ]
end

to update-patchright
  ask patches with [structure-type = "floor" and table:get doms "right" != -1][
      let gx pxcor
      let gy pycor

      let x table:get steps-to-exits "right"
      let neigh-patches neighbors with [structure-type != "exit" and walkable? and table:get doms "right" = -1]
      ask neigh-patches[
        let o towardsxy gx gy
           if (table:get doms "right" = -1) [
             table:put doms "right" o

             table:put steps-to-exits "right" x + 1
             ]
           set pcolor black
           set updated? true
      ]
  ]
end

to set-doms-ste-default
  ask patches[

    table:put doms "left" -1
    table:put doms "right" -1

    table:put steps-to-exits "left" 0
    table:put steps-to-exits "right" 0

    ]
end
@#$#@#$#@
GRAPHICS-WINDOW
521
10
1149
639
-1
-1
12.16
1
10
1
1
1
0
0
0
1
0
50
0
50
0
0
1
ticks
30.0

SLIDER
7
10
131
43
env-type
env-type
1
3
2.0
1
1
NIL
HORIZONTAL

SLIDER
140
10
266
43
num-agents
num-agents
500
1500
500.0
500
1
NIL
HORIZONTAL

SLIDER
277
10
421
43
rational
rational
0
100
5.0
5
1
% of total
HORIZONTAL

SLIDER
7
59
131
92
strategy
strategy
1
3
2.0
1
1
NIL
HORIZONTAL

BUTTON
429
11
492
44
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
148
60
211
93
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
151
108
216
153
NIL
using-left
17
1
11

MONITOR
229
109
302
154
NIL
using-right
17
1
11

MONITOR
315
110
373
155
NIL
last-left
17
1
11

MONITOR
389
111
453
156
NIL
last-right
17
1
11

MONITOR
8
163
181
208
NIL
max-agents-in-panic-rational
17
1
11

MONITOR
392
166
497
211
NIL
max-panic-value
17
1
11

MONITOR
197
165
382
210
NIL
max-agents-in-panic-emotional
17
1
11

MONITOR
40
107
132
152
NIL
count persons
17
1
11

PLOT
11
232
211
382
Exit Usage
time
persons count
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"right" 1.0 0 -13840069 true "" "plot using-right"
"left" 1.0 0 -13791810 true "" "plot using-left"

PLOT
237
231
496
381
Panic in populaiton
time
persons count
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"rational" 1.0 0 -13840069 true "" "plot max-agents-in-panic-rational"
"emotional" 1.0 0 -2674135 true "" "plot max-agents-in-panic-emotional"

SLIDER
12
394
218
427
sensitivity
sensitivity
0
0.8
0.0
0.2
1
NIL
HORIZONTAL

SWITCH
228
394
382
427
allow-one-change
allow-one-change
1
1
-1000

@#$#@#$#@
## WHAT IS IT?

Development of crowd evacuation systems is a challenge due to involvement of complex interrelated aspects, diversity of involved individuals and/or environment, and lack of direct evidence. Evacuation modeling and simulation is used to analyze various possible outcomes as different scenarios unfold, typically when the complexity of scenario is high. However, incorporation of different aspect categories in a unified modeling space is a challenge. In this paper, we addressed this challenge by combining individual, social and technological models of people during evacuation, while pivoting all these aspects on a common agent-based modeling framework and a grid-based hypothetical environment. By simulating these models, an insight into the effectiveness of several interesting evacuation scenarios is provided. Based on the simulation results, a couple of useful recommendations are also given. 


## HOW IT WORKS

Our model explores relationship of panic (or not panic) with decision-making while agents are exiting from one of the two exits.

## HOW TO USE IT
SETUP: Sets up the environment, and generates two types of agents (persons). 
GO: Let the persons exit using one of the two exits, left or right, based on one of the three strategies used. 

## THINGS TO NOTICE

Exit usage graph.
Panic graph.

## THINGS TO TRY

Use different environment types, difffernt population densities and % of rational agents and three exit behavior strategies.

## EXTENDING THE MODEL

Try other extensions.

## NETLOGO FEATURES



## RELATED MODELS


## CREDITS AND REFERENCES

To appear: "An Agent-Based Model of Crowd Evacuation: Combining Individual, Social and Technological Aspects" in ACM SIGSIM PADS 2020 scheduled on June 2020 (https://www.acm-sigsim-pads.org/).
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <exitCondition>count persons = 0</exitCondition>
    <metric>ticks</metric>
    <metric>using-left</metric>
    <metric>using-right</metric>
    <metric>max-agents-in-panic-rational</metric>
    <metric>max-agents-in-panic-emotional</metric>
    <enumeratedValueSet variable="strategy">
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="env-type">
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-agents">
      <value value="500"/>
      <value value="1000"/>
      <value value="1500"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="allow-one-change">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rational">
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
