patches-own [class hCount] 
;class 0 - inner lattice
;class 1 - fast surface lattice
;class 2 - air - black

; total hydrogen available in patches and free-roaming 
globals[ hTotal ]

breed [hydrogens hydrogen]  ;;hydrogen
breed [skulls skull]  ;;hydrogen
breed [borders border]  ;;hydrogen

to setup
  clear-all
  
  
  ;patch setup
  ask patches 
  [ set pcolor 32
    set class 2
    sprout-borders 1
    [ set shape "border"
      set color black
      set heading 0]]
  ask patches with [(pxcor > min-pxcor) and (pxcor < max-pxcor) and (pycor > min-pycor) and (pycor < max-pycor)]
  [ set pcolor 76
    set class 1 ]  
  ask patches with [(pxcor > min-pxcor + 1) and (pxcor < max-pxcor - 1) and (pycor > min-pycor + 1) and (pycor < max-pycor - 1)]
  [ set pcolor 76
    set class 0 ]
  ask patches with [class < 2]
  [ set hCount 4 ]
  
  set hTotal ((count patches with [class < 2]) * 3)
      
  
end

to go
  
  ; STOP CONDITIONS
  ;==============================================================================
  if (hTotal < (2883 * endPercent / 100)) 
  [ ask patch 0 0 [set pcolor red]
    stop ]
  
  if (hTotal = 1) 
  [ ask hydrogens [ set size 0 ]
    stop ]
  
  
  
  ; FREEDOM
  ;==============================================================================
  ask patches with [hCount = 2]
  [ if random-float 1.0 < p2to1
    [ set pcolor pcolor - 2
      set hCount hCount - 1
      sprout-hydrogens 1
      [ set shape "circle3"
        set color white
        set size .5]]]
  ask patches with [hCount = 3]
  [ if random-float 1.0 < p3to2
    [ set pcolor pcolor - 2
      set hCount hCount - 1
      sprout-hydrogens 1
      [ set shape "circle3"
        set color white
        set size .5]]]
  
  ask patches with [hCount = 4]
  [ if random-float 1.0 < p4to3
    [ set pcolor pcolor - 2
      set hCount hCount - 1
      sprout-hydrogens 1
      [ set shape "circle3"
        set color white
        set size .5]]]
  
  ; PAIRING-UP AND LEAVING
  ;==============================================================================
  ask patches with [class = 1]
  [ if ((count hydrogens-here) > 1) ; when there are two hydrogens on one surface lattice patch, combine and leave system
    [ ask n-of 2 hydrogens-here
      [ set hTotal hTotal - 1
        die ]]]
  
  
  ; REABSORPTION
  ;==============================================================================
  ask hydrogens
  ;2 to 3 absorption
  [ ifelse ((hCount = 2) and (random-float 1.0 < p2to3))
    [ set hCount hCount + 1 ; patch variable
      set pcolor pcolor + 2 ; patch variable
      die]
  ;3 to 4 absorption
    [ if ((hCount = 3) and (random-float 1.0 < p3to4))
      [ set hCount hCount + 1 ; patch variable
        set pcolor pcolor + 2 ; patch variable
        die]]]
  
  
  ; HYDROGEN MOVEMENT
  ;==============================================================================
  ; lattice hydrogens
  ask hydrogens-on patches with [class = 0]
  [ 
    let norm (count neighbors4 with [hCount = 1]) * blackDiffuse + (count neighbors4 with [hCount > 1]) + 0.00000001
    let pBlack (count neighbors4 with [hCount = 1]) * blackDiffuse / norm ;percent chance to move to black
    
    ifelse (random-float 1.0 < pBlack)
    [ face one-of neighbors4 with [hCount = 1]
      fd 1 ]
    [ ifelse count (neighbors4 with [hCount > 1]) > 0
      [ face one-of neighbors4 with [hCount > 1]
        fd 1 ]
      [ face one-of neighbors4
        fd 1 ]]]
    
  ; surface hydrogen movement
  ask hydrogens-on patches with [class = 1]
  [ setxy pxcor pycor
    face one-of neighbors4 with [class = 1]
    fd 1 ]

  ; VISUALIZATION
  ;==============================================================================
  ; recenter and jiggle
  ask hydrogens
  [ setxy pxcor pycor
    rt random 360
    fd .15 ]
  
  ; MONITORS
  ;==============================================================================
  set-current-plot "h2Count"
  set-current-plot-pen "hydrogens"
  plot hTotal
  
  tick
  
end
@#$#@#$#@
GRAPHICS-WINDOW
370
85
809
545
16
16
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks
BUTTON
23
60
88
93
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
110
60
173
93
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
SLIDER
20
130
175
163
p4to3
p4to3
0
1
0.15
.01
1
NIL
HORIZONTAL
SLIDER
20
180
175
213
p3to2
p3to2
0
2
0.15
.01
1
NIL
HORIZONTAL
SLIDER
20
230
175
263
p2to1
p2to1
0
2
0.15
.01
1
NIL
HORIZONTAL
TEXTBOX
25
115
175
133
4->3 Absolute Probability
11
0.0
1
TEXTBOX
25
165
175
183
3->2 Absolute Probability
11
0.0
1
TEXTBOX
25
215
175
233
2->1 Absolute Probability
11
0.0
1
PLOT
20
395
355
545
h2Count
time
h
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -13345367 true
"hydrogens" 1.0 0 -13345367 true
SLIDER
105
330
275
363
endPercent
endPercent
0
100
12
1
1
NIL
HORIZONTAL
TEXTBOX
108
315
258
333
Simulation Termination %
11
0.0
1
SLIDER
200
130
355
163
p3to4
p3to4
0
1
0.2
.01
1
NIL
HORIZONTAL
SLIDER
200
180
355
213
p2to3
p2to3
0
1
0.2
.01
1
NIL
HORIZONTAL
TEXTBOX
205
115
350
133
3->4 Absorption Probability
11
0.0
1
TEXTBOX
203
165
348
183
2->3 Absorption Probability
11
0.0
1
SLIDER
200
260
355
293
blackDiffuse
blackDiffuse
0
2
0.1
0.01
1
NIL
HORIZONTAL
TEXTBOX
203
230
353
260
% as likely to diffuse to black vs green
11
0.0
1
TEXTBOX
20
15
210
40
Hydrogen Diffusion
20
0.0
1
@#$#@#$#@
WHAT IS IT?
-----------
Complex metal hydrides are a class of materials heavily investigated worldwide for hydrogen storage applications. These are solid state, reversible alloys that absorb hydrogen at high pressures, and release hydrogen at high temperatures. The kinetics of desorption are not well understood. There are many competing parameters that affect the rate of diffusion, including:
Bond break probability
Diffusion Speed
Diffusion through a different phase
Reabsorption property
Kinetics tend to be a serious problem in this field of materials, and it is not clearly understood which of these reactions are rate limiting. This project models hydrogen diffusion through a lattice with the ability to adjust the parameters. In doing so, we are able to investigate the affect of different properties on the material. 
The simulation begins with a fully saturated lattice with all available hydrogen in compound form.  As the hydrogens begin to free themselves, they will diffuse freely through the lattice until they reach the surface of the material, where they must pair off in order to leave the lattice as a H2 gas molecule.The simulation terminates when the available hydrogen reaches a user-set termination percent.
HOW IT WORKS
------------
The SETUP button initializes the model.
The square lattice is represented by each patch representing a XH4 molecule in the lattice, where X marks some central anion atom, like Al, B, or N. 
The GO button begins the diffusion process.
At each tick, the hydrogens will begin to desorb and diffuse until they leave the system.
Free hydrogens within the lattice will move to one of their four neighboring patches with equal probability unless one of them is a depleted (black) patch, where the probability is altered by a factor of blackDiffuse.  
When the free hydrogens reach the surface of the lattice, they still move once per tick, but can only move to other patches on the surface of the material.
The shade of the patches indicate the amount of available desorbable hydrogen.
The XH4 patches start at the brightest shade of green, and gradually darken to black (XH molecules). 
The desorbed hydrogens are represented by white circles that both move from patch to patch, and experience a slight vibration factor for visualization purposes.

HOW TO USE IT
-------------
The probability for desorption and absorption of free hydrogens can be changed using their corresponding sliders.
By varying the desorption sliders, one can control the probability for hydrogens to free themselves from the compound at each of the three stages (4->3, 3->2, 2-1).
Similarly, the absorption sliders control the probability for hydrogens to be re-absorbed back into molecular form (causing the lattice patch to change color accordingly). 
h2Count:
Displays total of both desorbable and free hydrogens remaining in the system at every tick.

EXTENDING THE MODEL
-------------------
There are many interesting properties that are used to accelerate kinetics that this model could eventually be modeled to study. 
First, the properties that are being investigated (bond breaking, diffusion speed, etc), these are are calculable using first-principles Density Functional Theory methods. Having a built in converter that for example, changed binding energy directly to a bond-breaking probability, would allow the model to be greatly extended to model a great number of realistic systems. 
Second, there are several catalytic means that could be investigated by this model. There is the 'magic dust' idea, where some very small percentage of a catalyst can dramatically reduce desorption time. There is alloy seeding, where the existence of depleted patches nearby promote the formation of similar patches nearby, depleting hydrogen. There is finally a size-effect - it is known that nanoparticle materials desorb hydrogen at much lower temperatures (albeit with lower gravimetric capacity), but it is not known why - on a fully parallelized model, size effects could be examined. 

CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
border
true
0
Polygon -7500403 true true 120 0 120 15 15 15 15 120 0 120 0 0
Polygon -7500403 true true 180 0 180 15 285 15 285 120 300 120 300 0
Polygon -7500403 true true 0 180 15 180 15 285 120 285 120 300 0 300
Polygon -7500403 true true 180 285 180 300 300 300 300 180 285 180 285 285
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 0 0 300
circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
circle3
false
0
Circle -16777216 true false 0 0 298
Circle -7500403 true true 15 15 270
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
cylinder
false
0
Circle -7500403 true true 0 0 300
dot
false
0
Circle -7500403 true true 90 90 120
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
line half
true
0
Line -7500403 true 150 0 150 150
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="blackDiffuse" repetitions="2" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <exitCondition>hTotal &lt; (2883 * endPercent / 100)</exitCondition>
    <metric>ticks</metric>
    <enumeratedValueSet variable="p2to3">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blackDiffuse">
      <value value="25"/>
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="p4to3">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="p3to2">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="p3to4">
      <value value="0.01"/>
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="endPercent">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="p2to1">
      <value value="2"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
