turtles-own [emotion appraisal b susceptibility official-regulation]
to setup
  clear-all
  create-turtles N [
    setxy random-xcor random-ycor
    set shape "person"
    set color white
    set official-regulation R
    set size 0.5]
  ask n-of sensitive turtles [set susceptibility 1.2]
  ask n-of neutral turtles with [susceptibility != 1.2] [set susceptibility 1]
  ask n-of firm turtles with [susceptibility != 1.2 and susceptibility != 1][set susceptibility 0.8]
  ask turtles [set appraisal susceptibility * (log(1 + random 9) 10)]
  ask turtles [set emotion appraisal]
  ask turtles with [emotion = 0][set color white]
  ask turtles with [emotion <= 0.4 and emotion > 0][set color green]
  ask turtles with [emotion > 0.4 and emotion <= 0.8][set color yellow]
  ask turtles with [emotion > 0.8 and emotion <= 1][set color red]
  ask turtles with [susceptibility = 1.2][set b 0.6 + random-float 0.4]
  ask turtles with [susceptibility = 1][set b 0.4 + random-float 0.2]
  ask turtles with [susceptibility = 0.8][set b random-float 0.4]
  reset-ticks
end
to go
   while [ticks <= arrival-tick]
    [ask turtles [ifelse (b * (susceptibility * (log (1 + sum sort [emotion] of turtles-here) 10)) + (1 - b) * appraisal) <= 1[set emotion (b * (susceptibility * (log (1 + sum sort [emotion] of turtles-here) 10)) + (1 - b) * appraisal)]
      [set emotion 1]]
      check-color
    ask turtles with [color = green][if xcor <= -6 [facexy -8 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
    ask turtles with [color = green][if xcor > -6 and  xcor <= -2 [facexy -4 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
    ask turtles with [color = green][if xcor > -2 and  xcor <= 2 [facexy 0 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
    ask turtles with [color = green][if xcor > 2 and  xcor <= 6 [facexy 4 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
    ask turtles with [color = green][if xcor > 6 [facexy 8 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
    ask turtles with [color = yellow][if xcor <= -6 [facexy -8 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
    ask turtles with [color = yellow][if xcor > -6 and  xcor <= -2 [facexy -4 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
    ask turtles with [color = yellow][if xcor > -2 and  xcor <= 2 [facexy 0 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
    ask turtles with [color = yellow][if xcor > 2 and  xcor <= 6 [facexy 4 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
    ask turtles with [color = yellow][if xcor > 6 [facexy 8 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
    ask turtles with [color = red][if xcor <= -6 [facexy -8 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
    ask turtles with [color = red][if xcor > -6 and  xcor <= -2 [facexy -4 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
    ask turtles with [color = red][if xcor > -2 and  xcor <= 2 [facexy 0 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
    ask turtles with [color = red][if xcor > 2 and  xcor <= 6 [facexy 4 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
    ask turtles with [color = red][if xcor > 6 [facexy 8 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
      if official? [ask turtles [set emotion emotion * (1 - official-regulation)]]
      tick
  ]
  if random 100 <= P * 100 [ask turtles-on (patch-set patch -8 1 patch -4 1 patch 0 1 patch 4 1 patch 8 1) [die]]
  ifelse official? [ask turtles [set emotion emotion * (1 - official-regulation)]]
     [ask turtles [ifelse (b * (susceptibility * (log (1 + sum sort [emotion] of turtles-here) 10)) + (1 - b) * appraisal) <= 1 [set emotion (b * (susceptibility * (log (1 + sum sort [emotion] of turtles-here) 10)) + (1 - b) * appraisal)]
        [set emotion 1]]]
  check-color
  ask turtles with [color = white][if xcor <= -6 [facexy -8 1 fd random-float 1]]
  ask turtles with [color = white][if xcor > -6 and  xcor <= -2 [facexy -4 1 fd random-float 1]]
  ask turtles with [color = white][if xcor > -2 and  xcor <= 2 [facexy 0 1 fd random-float 1]]
  ask turtles with [color = white][if xcor > 2 and  xcor <= 6 [facexy 4 1 fd random-float 1]]
  ask turtles with [color = white][if xcor > 6 [facexy 8 1 fd random-float 1]]
  ask turtles with [color = green][if xcor <= -6 [facexy -8 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
  ask turtles with [color = green][if xcor > -6 and  xcor <= -2 [facexy -4 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
  ask turtles with [color = green][if xcor > -2 and  xcor <= 2 [facexy 0 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
  ask turtles with [color = green][if xcor > 2 and  xcor <= 6 [facexy 4 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
  ask turtles with [color = green][if xcor > 6 [facexy 8 1 rt asin random-float (1 / 2) lt asin random-float (1 / 2) fd random-float 1]]
  ask turtles with [color = yellow][if xcor <= -6 [facexy -8 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
  ask turtles with [color = yellow][if xcor > -6 and  xcor <= -2 [facexy -4 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
  ask turtles with [color = yellow][if xcor > -2 and  xcor <= 2 [facexy 0 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
  ask turtles with [color = yellow][if xcor > 2 and  xcor <= 6 [facexy 4 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
  ask turtles with [color = yellow][if xcor > 6 [facexy 8 1 rt asin random-float ((sqrt 3) / 2) lt asin random-float ((sqrt 3) / 2) fd random-float 2]]
  ask turtles with [color = red][if xcor <= -6 [facexy -8 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
  ask turtles with [color = red][if xcor > -6 and  xcor <= -2 [facexy -4 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
  ask turtles with [color = red][if xcor > -2 and  xcor <= 2 [facexy 0 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
  ask turtles with [color = red][if xcor > 2 and  xcor <= 6 [facexy 4 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
  ask turtles with [color = red][if xcor > 6 [facexy 8 1 rt asin random-float 1 lt asin random-float 1 fd random-float 3]]
  tick
end
to check-color
  ask turtles with [emotion = 0][set color white]
  ask turtles with [emotion <= 0.4 and emotion > 0][set color green]
  ask turtles with [emotion > 0.4 and emotion <= 0.8][set color yellow]
  ask turtles with [emotion > 0.8 and emotion <= 1][set color red]
end
@#$#@#$#@
GRAPHICS-WINDOW
226
66
1055
182
-1
-1
35.7143
1
10
1
1
1
0
0
0
1
-11
11
-1
1
1
1
1
ticks
30.0

BUTTON
10
19
76
52
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
101
20
164
53
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
9
82
181
115
N
N
0
300
300.0
1
1
NIL
HORIZONTAL

PLOT
478
205
996
480
emotion of people
time
emotion
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"pen-0" 1.0 0 -16777216 true "" "plot [emotion] of turtle 0"
"pen-1" 1.0 0 -16777216 true "" "plot [emotion] of turtle 1"
"pen-2" 1.0 0 -16777216 true "" "plot [emotion] of turtle 2"
"pen-3" 1.0 0 -16777216 true "" "plot [emotion] of turtle 3"
"pen-4" 1.0 0 -16777216 true "" "plot [emotion] of turtle 4"
"pen-5" 1.0 0 -16777216 true "" "plot [emotion] of turtle 5"
"pen-6" 1.0 0 -16777216 true "" "plot [emotion] of turtle 6"
"pen-7" 1.0 0 -16777216 true "" "plot [emotion] of turtle 7"
"pen-8" 1.0 0 -16777216 true "" "plot [emotion] of turtle 8"
"pen-9" 1.0 0 -16777216 true "" "plot [emotion] of turtle 9"
"pen-10" 1.0 0 -16777216 true "" "plot [emotion] of turtle 10"
"pen-11" 1.0 0 -16777216 true "" "plot [emotion] of turtle 11"
"pen-12" 1.0 0 -16777216 true "" "plot [emotion] of turtle 12"
"pen-13" 1.0 0 -16777216 true "" "plot [emotion] of turtle 13"
"pen-14" 1.0 0 -16777216 true "" "plot [emotion] of turtle 14"
"pen-15" 1.0 0 -16777216 true "" "plot [emotion] of turtle 15"
"pen-16" 1.0 0 -16777216 true "" "plot [emotion] of turtle 16"
"pen-17" 1.0 0 -16777216 true "" "plot [emotion] of turtle 17"
"pen-18" 1.0 0 -16777216 true "" "plot [emotion] of turtle 18"
"pen-19" 1.0 0 -16777216 true "" "plot [emotion] of turtle 19"
"pen-20" 1.0 0 -16777216 true "" "plot [emotion] of turtle 20"
"pen-21" 1.0 0 -16777216 true "" "plot [emotion] of turtle 21"
"pen-22" 1.0 0 -16777216 true "" "plot [emotion] of turtle 22"
"pen-23" 1.0 0 -16777216 true "" "plot [emotion] of turtle 23"
"pen-24" 1.0 0 -16777216 true "" "plot [emotion] of turtle 24"
"pen-25" 1.0 0 -16777216 true "" "plot [emotion] of turtle 25"
"pen-26" 1.0 0 -16777216 true "" "plot [emotion] of turtle 26"
"pen-27" 1.0 0 -16777216 true "" "plot [emotion] of turtle 27"
"pen-28" 1.0 0 -16777216 true "" "plot [emotion] of turtle 28"
"pen-29" 1.0 0 -16777216 true "" "plot [emotion] of turtle 29"
"pen-30" 1.0 0 -16777216 true "" "plot [emotion] of turtle 30"
"pen-31" 1.0 0 -16777216 true "" "plot [emotion] of turtle 31"
"pen-32" 1.0 0 -16777216 true "" "plot [emotion] of turtle 32"
"pen-33" 1.0 0 -16777216 true "" "plot [emotion] of turtle 33"
"pen-34" 1.0 0 -16777216 true "" "plot [emotion] of turtle 34"
"pen-35" 1.0 0 -16777216 true "" "plot [emotion] of turtle 35"
"pen-36" 1.0 0 -16777216 true "" "plot [emotion] of turtle 36"
"pen-37" 1.0 0 -16777216 true "" "plot [emotion] of turtle 37"
"pen-38" 1.0 0 -16777216 true "" "plot [emotion] of turtle 38"
"pen-39" 1.0 0 -16777216 true "" "plot [emotion] of turtle 39"
"pen-40" 1.0 0 -16777216 true "" "plot [emotion] of turtle 40"
"pen-41" 1.0 0 -16777216 true "" "plot [emotion] of turtle 41"
"pen-42" 1.0 0 -16777216 true "" "plot [emotion] of turtle 42"
"pen-43" 1.0 0 -16777216 true "" "plot [emotion] of turtle 43"
"pen-44" 1.0 0 -16777216 true "" "plot [emotion] of turtle 44"
"pen-45" 1.0 0 -16777216 true "" "plot [emotion] of turtle 45"
"pen-46" 1.0 0 -16777216 true "" "plot [emotion] of turtle 46"
"pen-47" 1.0 0 -16777216 true "" "plot [emotion] of turtle 47"
"pen-48" 1.0 0 -16777216 true "" "plot [emotion] of turtle 48"
"pen-49" 1.0 0 -16777216 true "" "plot [emotion] of turtle 49"
"pen-50" 1.0 0 -16777216 true "" "plot [emotion] of turtle 50"
"pen-51" 1.0 0 -16777216 true "" "plot [emotion] of turtle 51"
"pen-52" 1.0 0 -16777216 true "" "plot [emotion] of turtle 52"
"pen-53" 1.0 0 -16777216 true "" "plot [emotion] of turtle 53"
"pen-54" 1.0 0 -16777216 true "" "plot [emotion] of turtle 54"
"pen-55" 1.0 0 -16777216 true "" "plot [emotion] of turtle 55"
"pen-56" 1.0 0 -16777216 true "" "plot [emotion] of turtle 56"
"pen-57" 1.0 0 -16777216 true "" "plot [emotion] of turtle 57"
"pen-58" 1.0 0 -16777216 true "" "plot [emotion] of turtle 58"
"pen-59" 1.0 0 -16777216 true "" "plot [emotion] of turtle 59"
"pen-60" 1.0 0 -16777216 true "" "plot [emotion] of turtle 60"
"pen-61" 1.0 0 -16777216 true "" "plot [emotion] of turtle 61"
"pen-62" 1.0 0 -16777216 true "" "plot [emotion] of turtle 62"
"pen-63" 1.0 0 -16777216 true "" "plot [emotion] of turtle 63"
"pen-64" 1.0 0 -16777216 true "" "plot [emotion] of turtle 64"
"pen-65" 1.0 0 -16777216 true "" "plot [emotion] of turtle 65"
"pen-66" 1.0 0 -16777216 true "" "plot [emotion] of turtle 66"
"pen-67" 1.0 0 -16777216 true "" "plot [emotion] of turtle 67"
"pen-68" 1.0 0 -16777216 true "" "plot [emotion] of turtle 68"
"pen-69" 1.0 0 -16777216 true "" "plot [emotion] of turtle 69"
"pen-70" 1.0 0 -16777216 true "" "plot [emotion] of turtle 70"
"pen-71" 1.0 0 -16777216 true "" "plot [emotion] of turtle 71"
"pen-72" 1.0 0 -16777216 true "" "plot [emotion] of turtle 72"
"pen-73" 1.0 0 -16777216 true "" "plot [emotion] of turtle 73"
"pen-74" 1.0 0 -16777216 true "" "plot [emotion] of turtle 74"
"pen-75" 1.0 0 -16777216 true "" "plot [emotion] of turtle 75"
"pen-76" 1.0 0 -16777216 true "" "plot [emotion] of turtle 76"
"pen-77" 1.0 0 -16777216 true "" "plot [emotion] of turtle 77"
"pen-78" 1.0 0 -16777216 true "" "plot [emotion] of turtle 78"
"pen-79" 1.0 0 -16777216 true "" "plot [emotion] of turtle 79"
"pen-80" 1.0 0 -16777216 true "" "plot [emotion] of turtle 80"
"pen-81" 1.0 0 -16777216 true "" "plot [emotion] of turtle 81"
"pen-82" 1.0 0 -16777216 true "" "plot [emotion] of turtle 82"
"pen-83" 1.0 0 -16777216 true "" "plot [emotion] of turtle 83"
"pen-84" 1.0 0 -16777216 true "" "plot [emotion] of turtle 84"
"pen-85" 1.0 0 -16777216 true "" "plot [emotion] of turtle 85"
"pen-86" 1.0 0 -16777216 true "" "plot [emotion] of turtle 86"
"pen-87" 1.0 0 -16777216 true "" "plot [emotion] of turtle 87"
"pen-88" 1.0 0 -16777216 true "" "plot [emotion] of turtle 88"
"pen-89" 1.0 0 -16777216 true "" "plot [emotion] of turtle 89"
"pen-90" 1.0 0 -16777216 true "" "plot [emotion] of turtle 90"
"pen-91" 1.0 0 -16777216 true "" "plot [emotion] of turtle 91"
"pen-92" 1.0 0 -16777216 true "" "plot [emotion] of turtle 92"
"pen-93" 1.0 0 -16777216 true "" "plot [emotion] of turtle 93"
"pen-94" 1.0 0 -16777216 true "" "plot [emotion] of turtle 94"
"pen-95" 1.0 0 -16777216 true "" "plot [emotion] of turtle 95"
"pen-96" 1.0 0 -16777216 true "" "plot [emotion] of turtle 96"
"pen-97" 1.0 0 -16777216 true "" "plot [emotion] of turtle 97"
"pen-98" 1.0 0 -16777216 true "" "plot [emotion] of turtle 98"
"pen-99" 1.0 0 -16777216 true "" "plot [emotion] of turtle 99"
"pen-100" 1.0 0 -16777216 true "" "plot [emotion] of turtle 100"
"pen-101" 1.0 0 -16777216 true "" "plot [emotion] of turtle 101"
"pen-102" 1.0 0 -16777216 true "" "plot [emotion] of turtle 102"
"pen-103" 1.0 0 -16777216 true "" "plot [emotion] of turtle 103"
"pen-104" 1.0 0 -16777216 true "" "plot [emotion] of turtle 104"
"pen-105" 1.0 0 -16777216 true "" "plot [emotion] of turtle 105"
"pen-106" 1.0 0 -16777216 true "" "plot [emotion] of turtle 106"
"pen-107" 1.0 0 -16777216 true "" "plot [emotion] of turtle 107"
"pen-108" 1.0 0 -16777216 true "" "plot [emotion] of turtle 108"
"pen-109" 1.0 0 -16777216 true "" "plot [emotion] of turtle 109"
"pen-110" 1.0 0 -16777216 true "" "plot [emotion] of turtle 110"
"pen-111" 1.0 0 -16777216 true "" "plot [emotion] of turtle 111"
"pen-112" 1.0 0 -16777216 true "" "plot [emotion] of turtle 112"
"pen-113" 1.0 0 -16777216 true "" "plot [emotion] of turtle 113"
"pen-114" 1.0 0 -16777216 true "" "plot [emotion] of turtle 114"
"pen-115" 1.0 0 -16777216 true "" "plot [emotion] of turtle 115"
"pen-116" 1.0 0 -16777216 true "" "plot [emotion] of turtle 116"
"pen-117" 1.0 0 -16777216 true "" "plot [emotion] of turtle 117"
"pen-118" 1.0 0 -16777216 true "" "plot [emotion] of turtle 118"
"pen-119" 1.0 0 -16777216 true "" "plot [emotion] of turtle 119"
"pen-120" 1.0 0 -16777216 true "" "plot [emotion] of turtle 120"
"pen-121" 1.0 0 -16777216 true "" "plot [emotion] of turtle 121"
"pen-122" 1.0 0 -16777216 true "" "plot [emotion] of turtle 122"
"pen-123" 1.0 0 -16777216 true "" "plot [emotion] of turtle 123"
"pen-124" 1.0 0 -16777216 true "" "plot [emotion] of turtle 124"
"pen-125" 1.0 0 -16777216 true "" "plot [emotion] of turtle 125"
"pen-126" 1.0 0 -16777216 true "" "plot [emotion] of turtle 126"
"pen-127" 1.0 0 -16777216 true "" "plot [emotion] of turtle 127"
"pen-128" 1.0 0 -16777216 true "" "plot [emotion] of turtle 128"
"pen-129" 1.0 0 -16777216 true "" "plot [emotion] of turtle 129"
"pen-130" 1.0 0 -16777216 true "" "plot [emotion] of turtle 130"
"pen-131" 1.0 0 -16777216 true "" "plot [emotion] of turtle 131"
"pen-132" 1.0 0 -16777216 true "" "plot [emotion] of turtle 132"
"pen-133" 1.0 0 -16777216 true "" "plot [emotion] of turtle 133"
"pen-134" 1.0 0 -16777216 true "" "plot [emotion] of turtle 134"
"pen-135" 1.0 0 -16777216 true "" "plot [emotion] of turtle 135"
"pen-136" 1.0 0 -16777216 true "" "plot [emotion] of turtle 136"
"pen-137" 1.0 0 -16777216 true "" "plot [emotion] of turtle 137"
"pen-138" 1.0 0 -16777216 true "" "plot [emotion] of turtle 138"
"pen-139" 1.0 0 -16777216 true "" "plot [emotion] of turtle 139"
"pen-140" 1.0 0 -16777216 true "" "plot [emotion] of turtle 140"
"pen-141" 1.0 0 -16777216 true "" "plot [emotion] of turtle 141"
"pen-142" 1.0 0 -16777216 true "" "plot [emotion] of turtle 142"
"pen-143" 1.0 0 -16777216 true "" "plot [emotion] of turtle 143"
"pen-144" 1.0 0 -16777216 true "" "plot [emotion] of turtle 144"
"pen-145" 1.0 0 -16777216 true "" "plot [emotion] of turtle 145"
"pen-146" 1.0 0 -16777216 true "" "plot [emotion] of turtle 146"
"pen-147" 1.0 0 -16777216 true "" "plot [emotion] of turtle 147"
"pen-148" 1.0 0 -16777216 true "" "plot [emotion] of turtle 148"
"pen-149" 1.0 0 -16777216 true "" "plot [emotion] of turtle 149"
"pen-150" 1.0 0 -16777216 true "" "plot [emotion] of turtle 150"
"pen-151" 1.0 0 -16777216 true "" "plot [emotion] of turtle 151"
"pen-152" 1.0 0 -16777216 true "" "plot [emotion] of turtle 152"
"pen-153" 1.0 0 -16777216 true "" "plot [emotion] of turtle 153"
"pen-154" 1.0 0 -16777216 true "" "plot [emotion] of turtle 154"
"pen-155" 1.0 0 -16777216 true "" "plot [emotion] of turtle 155"
"pen-156" 1.0 0 -16777216 true "" "plot [emotion] of turtle 156"
"pen-157" 1.0 0 -16777216 true "" "plot [emotion] of turtle 157"
"pen-158" 1.0 0 -16777216 true "" "plot [emotion] of turtle 158"
"pen-159" 1.0 0 -16777216 true "" "plot [emotion] of turtle 159"
"pen-160" 1.0 0 -16777216 true "" "plot [emotion] of turtle 160"
"pen-161" 1.0 0 -16777216 true "" "plot [emotion] of turtle 161"
"pen-162" 1.0 0 -16777216 true "" "plot [emotion] of turtle 162"
"pen-163" 1.0 0 -16777216 true "" "plot [emotion] of turtle 163"
"pen-164" 1.0 0 -16777216 true "" "plot [emotion] of turtle 164"
"pen-165" 1.0 0 -16777216 true "" "plot [emotion] of turtle 165"
"pen-166" 1.0 0 -16777216 true "" "plot [emotion] of turtle 166"
"pen-167" 1.0 0 -16777216 true "" "plot [emotion] of turtle 167"
"pen-168" 1.0 0 -16777216 true "" "plot [emotion] of turtle 168"
"pen-169" 1.0 0 -16777216 true "" "plot [emotion] of turtle 169"
"pen-170" 1.0 0 -16777216 true "" "plot [emotion] of turtle 170"
"pen-171" 1.0 0 -16777216 true "" "plot [emotion] of turtle 171"
"pen-172" 1.0 0 -16777216 true "" "plot [emotion] of turtle 172"
"pen-173" 1.0 0 -16777216 true "" "plot [emotion] of turtle 173"
"pen-174" 1.0 0 -16777216 true "" "plot [emotion] of turtle 174"
"pen-175" 1.0 0 -16777216 true "" "plot [emotion] of turtle 175"
"pen-176" 1.0 0 -16777216 true "" "plot [emotion] of turtle 176"
"pen-177" 1.0 0 -16777216 true "" "plot [emotion] of turtle 177"
"pen-178" 1.0 0 -16777216 true "" "plot [emotion] of turtle 178"
"pen-179" 1.0 0 -16777216 true "" "plot [emotion] of turtle 179"
"pen-180" 1.0 0 -16777216 true "" "plot [emotion] of turtle 180"
"pen-181" 1.0 0 -16777216 true "" "plot [emotion] of turtle 181"
"pen-182" 1.0 0 -16777216 true "" "plot [emotion] of turtle 182"
"pen-183" 1.0 0 -16777216 true "" "plot [emotion] of turtle 183"
"pen-184" 1.0 0 -16777216 true "" "plot [emotion] of turtle 184"
"pen-185" 1.0 0 -16777216 true "" "plot [emotion] of turtle 185"
"pen-186" 1.0 0 -16777216 true "" "plot [emotion] of turtle 186"
"pen-187" 1.0 0 -16777216 true "" "plot [emotion] of turtle 187"
"pen-188" 1.0 0 -16777216 true "" "plot [emotion] of turtle 188"
"pen-189" 1.0 0 -16777216 true "" "plot [emotion] of turtle 189"
"pen-190" 1.0 0 -16777216 true "" "plot [emotion] of turtle 190"
"pen-191" 1.0 0 -16777216 true "" "plot [emotion] of turtle 191"
"pen-192" 1.0 0 -16777216 true "" "plot [emotion] of turtle 192"
"pen-193" 1.0 0 -16777216 true "" "plot [emotion] of turtle 193"
"pen-194" 1.0 0 -16777216 true "" "plot [emotion] of turtle 194"
"pen-195" 1.0 0 -16777216 true "" "plot [emotion] of turtle 195"
"pen-196" 1.0 0 -16777216 true "" "plot [emotion] of turtle 196"
"pen-197" 1.0 0 -16777216 true "" "plot [emotion] of turtle 197"
"pen-198" 1.0 0 -16777216 true "" "plot [emotion] of turtle 198"
"pen-199" 1.0 0 -16777216 true "" "plot [emotion] of turtle 199"
"pen-200" 1.0 0 -16777216 true "" "plot [emotion] of turtle 200"
"pen-201" 1.0 0 -16777216 true "" "plot [emotion] of turtle 201"
"pen-202" 1.0 0 -16777216 true "" "plot [emotion] of turtle 202"
"pen-203" 1.0 0 -16777216 true "" "plot [emotion] of turtle 203"
"pen-204" 1.0 0 -16777216 true "" "plot [emotion] of turtle 204"
"pen-205" 1.0 0 -16777216 true "" "plot [emotion] of turtle 205"
"pen-206" 1.0 0 -16777216 true "" "plot [emotion] of turtle 206"
"pen-207" 1.0 0 -16777216 true "" "plot [emotion] of turtle 207"
"pen-208" 1.0 0 -16777216 true "" "plot [emotion] of turtle 208"
"pen-209" 1.0 0 -16777216 true "" "plot [emotion] of turtle 209"
"pen-210" 1.0 0 -16777216 true "" "plot [emotion] of turtle 210"
"pen-211" 1.0 0 -16777216 true "" "plot [emotion] of turtle 211"
"pen-212" 1.0 0 -16777216 true "" "plot [emotion] of turtle 212"
"pen-213" 1.0 0 -16777216 true "" "plot [emotion] of turtle 213"
"pen-214" 1.0 0 -16777216 true "" "plot [emotion] of turtle 214"
"pen-215" 1.0 0 -16777216 true "" "plot [emotion] of turtle 215"
"pen-216" 1.0 0 -16777216 true "" "plot [emotion] of turtle 216"
"pen-217" 1.0 0 -16777216 true "" "plot [emotion] of turtle 217"
"pen-218" 1.0 0 -16777216 true "" "plot [emotion] of turtle 218"
"pen-219" 1.0 0 -16777216 true "" "plot [emotion] of turtle 219"
"pen-220" 1.0 0 -16777216 true "" "plot [emotion] of turtle 220"
"pen-221" 1.0 0 -16777216 true "" "plot [emotion] of turtle 221"
"pen-222" 1.0 0 -16777216 true "" "plot [emotion] of turtle 222"
"pen-223" 1.0 0 -16777216 true "" "plot [emotion] of turtle 223"
"pen-224" 1.0 0 -16777216 true "" "plot [emotion] of turtle 224"
"pen-225" 1.0 0 -16777216 true "" "plot [emotion] of turtle 225"
"pen-226" 1.0 0 -16777216 true "" "plot [emotion] of turtle 226"
"pen-227" 1.0 0 -16777216 true "" "plot [emotion] of turtle 227"
"pen-228" 1.0 0 -16777216 true "" "plot [emotion] of turtle 228"
"pen-229" 1.0 0 -16777216 true "" "plot [emotion] of turtle 229"
"pen-230" 1.0 0 -16777216 true "" "plot [emotion] of turtle 230"
"pen-231" 1.0 0 -16777216 true "" "plot [emotion] of turtle 231"
"pen-232" 1.0 0 -16777216 true "" "plot [emotion] of turtle 232"
"pen-233" 1.0 0 -16777216 true "" "plot [emotion] of turtle 233"
"pen-234" 1.0 0 -16777216 true "" "plot [emotion] of turtle 234"
"pen-235" 1.0 0 -16777216 true "" "plot [emotion] of turtle 235"
"pen-236" 1.0 0 -16777216 true "" "plot [emotion] of turtle 236"
"pen-237" 1.0 0 -16777216 true "" "plot [emotion] of turtle 237"
"pen-238" 1.0 0 -16777216 true "" "plot [emotion] of turtle 238"
"pen-239" 1.0 0 -16777216 true "" "plot [emotion] of turtle 239"
"pen-240" 1.0 0 -16777216 true "" "plot [emotion] of turtle 240"
"pen-241" 1.0 0 -16777216 true "" "plot [emotion] of turtle 241"
"pen-242" 1.0 0 -16777216 true "" "plot [emotion] of turtle 242"
"pen-243" 1.0 0 -16777216 true "" "plot [emotion] of turtle 243"
"pen-244" 1.0 0 -16777216 true "" "plot [emotion] of turtle 244"
"pen-245" 1.0 0 -16777216 true "" "plot [emotion] of turtle 245"
"pen-246" 1.0 0 -16777216 true "" "plot [emotion] of turtle 246"
"pen-247" 1.0 0 -16777216 true "" "plot [emotion] of turtle 247"
"pen-248" 1.0 0 -16777216 true "" "plot [emotion] of turtle 248"
"pen-249" 1.0 0 -16777216 true "" "plot [emotion] of turtle 249"
"pen-250" 1.0 0 -16777216 true "" "plot [emotion] of turtle 250"
"pen-251" 1.0 0 -16777216 true "" "plot [emotion] of turtle 251"
"pen-252" 1.0 0 -16777216 true "" "plot [emotion] of turtle 252"
"pen-253" 1.0 0 -16777216 true "" "plot [emotion] of turtle 253"
"pen-254" 1.0 0 -16777216 true "" "plot [emotion] of turtle 254"
"pen-255" 1.0 0 -16777216 true "" "plot [emotion] of turtle 255"
"pen-256" 1.0 0 -16777216 true "" "plot [emotion] of turtle 256"
"pen-257" 1.0 0 -16777216 true "" "plot [emotion] of turtle 257"
"pen-258" 1.0 0 -16777216 true "" "plot [emotion] of turtle 258"
"pen-259" 1.0 0 -16777216 true "" "plot [emotion] of turtle 259"
"pen-260" 1.0 0 -16777216 true "" "plot [emotion] of turtle 260"
"pen-261" 1.0 0 -16777216 true "" "plot [emotion] of turtle 261"
"pen-262" 1.0 0 -16777216 true "" "plot [emotion] of turtle 262"
"pen-263" 1.0 0 -16777216 true "" "plot [emotion] of turtle 263"
"pen-264" 1.0 0 -16777216 true "" "plot [emotion] of turtle 264"
"pen-265" 1.0 0 -16777216 true "" "plot [emotion] of turtle 265"
"pen-266" 1.0 0 -16777216 true "" "plot [emotion] of turtle 266"
"pen-267" 1.0 0 -16777216 true "" "plot [emotion] of turtle 267"
"pen-268" 1.0 0 -16777216 true "" "plot [emotion] of turtle 268"
"pen-269" 1.0 0 -16777216 true "" "plot [emotion] of turtle 269"
"pen-270" 1.0 0 -16777216 true "" "plot [emotion] of turtle 270"
"pen-271" 1.0 0 -16777216 true "" "plot [emotion] of turtle 271"
"pen-272" 1.0 0 -16777216 true "" "plot [emotion] of turtle 272"
"pen-273" 1.0 0 -16777216 true "" "plot [emotion] of turtle 273"
"pen-274" 1.0 0 -16777216 true "" "plot [emotion] of turtle 274"
"pen-275" 1.0 0 -16777216 true "" "plot [emotion] of turtle 275"
"pen-276" 1.0 0 -16777216 true "" "plot [emotion] of turtle 276"
"pen-277" 1.0 0 -16777216 true "" "plot [emotion] of turtle 277"
"pen-278" 1.0 0 -16777216 true "" "plot [emotion] of turtle 278"
"pen-279" 1.0 0 -16777216 true "" "plot [emotion] of turtle 279"
"pen-280" 1.0 0 -16777216 true "" "plot [emotion] of turtle 280"
"pen-281" 1.0 0 -16777216 true "" "plot [emotion] of turtle 281"
"pen-282" 1.0 0 -16777216 true "" "plot [emotion] of turtle 282"
"pen-283" 1.0 0 -16777216 true "" "plot [emotion] of turtle 283"
"pen-284" 1.0 0 -16777216 true "" "plot [emotion] of turtle 284"
"pen-285" 1.0 0 -16777216 true "" "plot [emotion] of turtle 285"
"pen-286" 1.0 0 -16777216 true "" "plot [emotion] of turtle 286"
"pen-287" 1.0 0 -16777216 true "" "plot [emotion] of turtle 287"
"pen-288" 1.0 0 -16777216 true "" "plot [emotion] of turtle 288"
"pen-289" 1.0 0 -16777216 true "" "plot [emotion] of turtle 289"
"pen-290" 1.0 0 -16777216 true "" "plot [emotion] of turtle 290"
"pen-291" 1.0 0 -16777216 true "" "plot [emotion] of turtle 291"
"pen-292" 1.0 0 -16777216 true "" "plot [emotion] of turtle 292"
"pen-293" 1.0 0 -16777216 true "" "plot [emotion] of turtle 293"
"pen-294" 1.0 0 -16777216 true "" "plot [emotion] of turtle 294"
"pen-295" 1.0 0 -16777216 true "" "plot [emotion] of turtle 295"
"pen-296" 1.0 0 -16777216 true "" "plot [emotion] of turtle 296"
"pen-297" 1.0 0 -16777216 true "" "plot [emotion] of turtle 297"
"pen-298" 1.0 0 -16777216 true "" "plot [emotion] of turtle 298"
"pen-299" 1.0 0 -16777216 true "" "plot [emotion] of turtle 299"

MONITOR
215
404
318
449
number of red
count turtles with [color = red]
17
1
11

MONITOR
215
340
339
385
number of yellow
count turtles with [color = yellow]
17
1
11

MONITOR
216
279
333
324
number of green
count turtles with [color = green]
17
1
11

SLIDER
8
131
180
164
P
P
0
1
0.9
1
1
NIL
HORIZONTAL

SLIDER
5
245
177
278
arrival-tick
arrival-tick
0
300
100.0
1
1
NIL
HORIZONTAL

SWITCH
8
299
156
332
official?
official?
1
1
-1000

SLIDER
7
189
179
222
R
R
0
1
0.0
1
1
NIL
HORIZONTAL

MONITOR
340
250
422
295
all number
count turtles
17
1
11

PLOT
1022
240
1222
390
proportion of different states of people
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -2674135 true "" "plot (count turtles with [color = red] / N)"
"pen-1" 1.0 0 -1184463 true "" "plot (count turtles with [color = yellow] / N)"
"pen-2" 1.0 0 -13840069 true "" "plot (count turtles with [color = green] / N)"
"pen-3" 1.0 0 -7500403 true "" "plot (count turtles with [color = white] / N)"

SLIDER
17
396
189
429
neutral
neutral
0
300
20.0
1
1
NIL
HORIZONTAL

SLIDER
112
451
284
484
sensitive
sensitive
0
300
20.0
1
1
NIL
HORIZONTAL

SLIDER
287
464
459
497
firm
firm
0
300
20.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment4.1 N=300" repetitions="50" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="160"/>
    <metric>count turtles with [color = red] / N</metric>
    <metric>count turtles with [color = yellow] / N</metric>
    <metric>count turtles with [color = green] / N</metric>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
