;; This model was designed by Lilly A. Whitney and Lawrence A. Whitney

globals [
  wheading
]

breed [ bats bat ]
breed [ moths moth ]
breed [ waves wave ]

bats-own [ food ]
waves-own [ energy ]

to setup
  clear-all
  create-bats number-of-bats
  [
   set shape "hawk"
   set color brown
   set size 3
   setxy random-xcor random-ycor
  ]
  ;; Give each bat a consecutive number starting at 0.
  let num 0
  ask bats [
    set label num
    set num num + 1
  ]
  create-moths number-of-moths
  [
    set shape "butterfly 2"
    set color white
    set size 1
    setxy random-xcor random-ycor
  ]
  reset-ticks
end

to go
  ask turtles [
    if breed = moths [ moth-fly ]
    if breed = bats
    [
      chirp  ;; Has bats create sound waves that help them find moths.
      bat-fly  ;; Has bats fly towards moths that they find using chirp.
    ]
  ]
  if not any? moths [ stop ]
  tick
end

to moth-fly
  set heading heading + ( 360 * random-normal 0 0.1 )
  repeat 5 [ ask moths [ fd 0.1 ] display ]
end

to chirp
  ;; wave grows outward from bat
  ;; waves that intersect moth stop, all others die
  ;; bat turns to face waves/moth
  let degree 0
  ;; creates a wave of 72 agents, 1 agent per 5 degrees
  hatch-waves 72 [
    set shape "dot"
    set size 0.5
    set color 96
    set label ""
    set energy wave-energy
    set heading heading + degree
    set degree degree + 5
  ]
  ;; Wave moves outward until it hits a moth.
  ;; Energy is how far a wave can go before it dies out.
  loop [
    ifelse count waves > 1 [
      ask waves [
        if energy < 1 [ die ]
        fd 0.3
        display
        set energy energy - 1
        if any? moths-here [
          ask other waves [ die ]
          set wheading heading
          stop
        ]
      ]
    ]
    [ ifelse count waves = 1 [
      ;; Determines if the moth the wave found is within the bats detection range.
      ;; If moth is within detection range, turns bat toward the moth.
      ifelse abs ( subtract-headings heading wheading ) <= detection-range [
        face one-of waves
        ask waves [ die ]
        stop
      ]
      [ ask waves [ die ]
        stop
      ]
      ]
      [ stop ]
    ]
  ]
end

to bat-fly
  ;; Bats move according to their headings and eat any moths they encounter.
  repeat 15 [
    ;; bats determine if other bats are in their way, and if so turn to try to avoid them
    if any? other bats in-cone 5 detection-range [
      let direction random 2
      if direction = 0 [ set heading heading - bat-avoid ]
      if direction = 1 [ set heading heading + bat-avoid ]
    ]
    fd 0.2
    display
    if any? moths-here [
     set food food + count moths-here
     ask moths-here [ die ]
    ]
  ]
  output-show food  ;; Keeps a running tab of how many moths each bat has eaten.
  ask waves [ die ]
end
@#$#@#$#@
GRAPHICS-WINDOW
240
10
721
492
-1
-1
14.33333333333334
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
27
82
90
115
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
130
85
193
118
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
23
158
226
191
number-of-bats
number-of-bats
1
10
5.0
1
1
NIL
HORIZONTAL

SLIDER
21
214
229
247
number-of-moths
number-of-moths
0
100
11.0
1
1
NIL
HORIZONTAL

SLIDER
20
266
226
299
wave-energy
wave-energy
1
30
15.0
1
1
NIL
HORIZONTAL

OUTPUT
748
373
988
453
11

TEXTBOX
752
350
902
368
Moths each bat has eaten:
11
0.0
1

SLIDER
20
319
226
352
detection-range
detection-range
5
180
45.0
5
1
degrees
HORIZONTAL

SLIDER
22
375
227
408
bat-avoid
bat-avoid
1
30
30.0
1
1
degrees
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This is a model of bats using echolocation to catch moths. The bats chirp, producing sound waves that indicate the direction of any moths they intersect.

## HOW IT WORKS

Bats and moths are randomly distributed in the world of the model. The bats then echolocate the moths by chirping sound waves that move outward from the bat until they intersect with the nearest moth, if any. The bat turns to face the moth identified by the sound wave it generated. When bats fly into the same space as a moth, they catch and eat it. Bats ignore moths identified outside of their detection range, a cone of variable degree set by the user. They also avoid other bats that fly into their detection range. When there are no moths left, the model stops.

## HOW TO USE IT

When you press the setup button, bats and moths will be randomly distributed throughout the world of the model and the bats will be labeled with a number. Interface sliders may be used prior to setup to set the population of bats, the population of moths, the energy of the echolocation waves the bats generate, which determines the radius of each echolocation sound wave, the detection range, which is the angle in front of each bat in which detected moths will be hunted, and the angle at which bats will turn to avoid other bats. When you press go, the bats and moths fly in random order, the moths turning randomly and then moving, whereas the bats only turn before moving if their echolocation identifies a moth or they will run into another bat. Each bat hatches a sound wave that moves outward, stopping if it detects a moth or when it runs out of energy. Bats turn toward any moths their sound waves identify. To be able to see the sound waves propagate, turn the tick rate slower. The number of moths each bat has eaten is shown in the monitor.

## THINGS TO NOTICE

First, if you cannot see the sound waves the bats are generating, turn down the tick rate and they will become visible. You may also notice that moth flight is mostly random whereas the bats fly in a straight line unless they find a moth or encounter another bat. Because bats and moths cycle through their procedures in random order each turn, it is possible for a moth to escape getting eaten if it gets two moves after being identified before the bat moves again as long as its movement carries it outside the detection range of the bat. 

## THINGS TO TRY

How does increasing or decreasing the number of bats, the number of moths, or both change the average number of ticks it takes for the bats to catch all of the moths? You could answer this question by conducting an experiment with the model in BehaviorSpace. You may also want to see how expanding or contracting the detection range of the bats improves or hinders their hunting ability. Likewise, you can see how increasing to decreasing the energy of the echolocation waves, which impacts how far they range from the bat that chirps them, impacts hunting effectiveness.


## EXTENDING THE MODEL

Right now, bats simply avoid other bats that are in their detection range within three patches. You could program them to avoid other bats using their echolocation. You could also add obstacles, such as trees or stalagmites or stalactites, and have the bats use their echolocation to avoid them, and have them die if they fail. 

## NETLOGO FEATURES

This model uses three breeds, one of which, waves, is hatched from the bat breed, spreading out and identifying the direction of any adjacent moth all during a single tick. The model uses subtract-headings to determine whether an identified moth is within the detection range of the bat that found it, and uses in-cone to avoid other bats in the detection-range. The use of subtract-headings with respect to the moths is to more closely mimic the way that bats use their echolocation to determine whether a moth is in-cone rather than relying on background functions in NetLogo, meaning it's more like real life.

## RELATED MODELS

Flocking Model (in the model library)
Wolf Sheep Predation (in the model library)
[Doppler Effect Model] (https://ccl.northwestern.edu/netlogo/models/community/doppler_effect_model)

## CREDITS AND REFERENCES

This model was created by Lilly A. Whitney and Lawrence A. Whitney.

We were aided in understanding bats and echolocation by reading an article on [How Stuff Works] (https://animals.howstuffworks.com/mammals/bat.htm) and by visiting an exhibit on bats at the Peabody Essex Museum in Salem, Massachusetts. This model is available on Netlogo User Community Models.

## LICENSE

Attribution should be made to Lilly A. Whitney and Lawrence A. Whitney.
This work is licensed under [CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/?ref=chooser-v1)
![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

butterfly 2
true
0
Polygon -16777216 true false 151 76 138 91 138 284 150 296 162 286 162 91
Polygon -7500403 true true 164 106 184 79 205 61 236 48 259 53 279 86 287 119 289 158 278 177 256 182 164 181
Polygon -7500403 true true 136 110 119 82 110 71 85 61 59 48 36 56 17 88 6 115 2 147 15 178 134 178
Polygon -7500403 true true 46 181 28 227 50 255 77 273 112 283 135 274 135 180
Polygon -7500403 true true 165 185 254 184 272 224 255 251 236 267 191 283 164 276
Line -7500403 true 167 47 159 82
Line -7500403 true 136 47 145 81
Circle -7500403 true true 165 45 8
Circle -7500403 true true 134 45 6
Circle -7500403 true true 133 44 7
Circle -7500403 true true 133 43 8

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

hawk
true
0
Polygon -7500403 true true 151 170 136 170 123 229 143 244 156 244 179 229 166 170
Polygon -16777216 true false 152 154 137 154 125 213 140 229 159 229 179 214 167 154
Polygon -7500403 true true 151 140 136 140 126 202 139 214 159 214 176 200 166 140
Polygon -16777216 true false 151 125 134 124 128 188 140 198 161 197 174 188 166 125
Polygon -7500403 true true 152 86 227 72 286 97 272 101 294 117 276 118 287 131 270 131 278 141 264 138 267 145 228 150 153 147
Polygon -7500403 true true 160 74 159 61 149 54 130 53 139 62 133 81 127 113 129 149 134 177 150 206 168 179 172 147 169 111
Circle -16777216 true false 144 55 7
Polygon -16777216 true false 129 53 135 58 139 54
Polygon -7500403 true true 148 86 73 72 14 97 28 101 6 117 24 118 13 131 30 131 22 141 36 138 33 145 72 150 147 147

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wave
true
0
Circle -1 false false 87 -198 426
Circle -1 false false 114 -156 342
Circle -1 false false 147 -123 277
Circle -1 false false 179 -91 212
Circle -1 false false 210 -60 150
Circle -1 false false 243 -27 85

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
