<?xml version="1.0" encoding="utf-8"?>
<model version="NetLogo 7.0.3" snapToGrid="false">
  <code><![CDATA[; ------------------------------------------------------------------------------
; When Network Density Weakens Intention–Action Alignment:
; An Agent-Based Model of Financial Support Networks in Entrepreneurial Ecosystems
;
; Authors:
;
; Model description:
; This agent-based model simulates the dynamics of financial support networks
; within entrepreneurial ecosystems. Entrepreneurs form growth intentions based
; on attitudes, subjective norms, and perceived behavioral control, following the
; Theory of Planned Behavior.
; The model captures how network structure, particularly network density and the
; presence of venture-capital-backed peers, shapes access to venture capital and
; conditions the alignment between individual growth intentions and realized
; venture growth at the aggregate level.
;
; The model initializes with a population of entrepreneurs and a single venture
; capitalist (included primarily for visualization purposes and represented by
; a red node). Entrepreneurs shown in white represent the initial population with
; no growth-related behavior. Entrepreneurs shown in yellow indicate agents with
; high growth intention who are preparing to act. Entrepreneurs shown in green
; represent agents that have established a formal financial relationship with
; the venture capitalist.
;
; White links represent informal social relationships among entrepreneurs. Green
; links indicate formal financial relationships between entrepreneurs and the
; venture capitalist. Blue links indicate that an entrepreneur has applied for
; funding and is undergoing evaluation by the venture capitalist.
;
; ------------------------------------------------------------------------------


breed [entreps entrep] ; entrepreneurs
breed [vcs vc] ; venture capital firms

undirected-link-breed [entrep-links entrep-link] ; links between entrepreneurs
undirected-link-breed [both-links both-link] ; links between venture capital firms and entrepreneurs



;;;;;;;;;  1: VARIABLES    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

globals [
  
  number-entreps

  prob-invest ; probability of receiving funding

  ; GROWTH
  growth ; average number of entrepreneurs who obtain capital to develop their venture in a given time step
  g ; list storing the growth variable for each tick
  growth_mean ; mean of list g, representing a final outcome
  ;growth_sd ; standard deviation of list g

  ;;; POPULATION BEHAVIOR 
  pop-growth-intention ; mean growth intention of the entire population
  pgi ; list storing population growth intention
  pop_intention_mean ; mean of list pgi

  pcb ; mean perceived behavioral control of the population
  p ; list storing perceived control values
  pcb_mean ; mean of list p
  

  max-behav-aux; auxiliar variable
]

extensions [ nw ]

links-own ; 
[
  known ; knowledge-based relationship
  financial ; financial relationship
]

entreps-own [

  funds ; individual financial resources; start at 0, if interaction is successful funds increase by 100
  behavior ; entrepreneurial behavior
  intention ; entrepreneurial intention of the agent
  attitude ; agent’s attitude toward growth
  subjective-norm ; subjective norm perceived by the agent
  percep-control ; perceived behavioral control
  pf ; perceived power of the specific control factor (f: financial capital) to facilitate or inhibit behavior; constant over time
  motivation ; agent’s motivation derived from known entrepreneurs
  refunds ; number of times the agent has received funding

  my-neighbors ; immediate neighbors at one-link distance

  ;; Coefficients
  w1 ; weight of attitude
  w2 ; weight of subjective norm
  w3 ; weight of perceived behavioral control (w1 + w2 + w3 = 1)


 ; Relationship attributes
  monitoring-time ; time at which monitoring occurs to decide on further funding rounds and relationship continuation
  evaluation-time ; time required to evaluate whether funding is granted initially
  tie-to-vc ; equals 1 if linked to a VC through a successful funding relationship; financial ties may end while knowledge ties persist
  cycles

  behav-aux
  b0 ; auxiliary behavior indicator
  entreps-vc
  
]



vcs-own
[
  funds
]


;;;;;;;;; 2. SETUP   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  setup-globals
  setup-entreps
  setup-vcs
  setup-fsn
  reset-ticks
end

to setup-globals
  
 set number-entreps 140
 set prob-invest 0.04

 ; POPULATION
 set pgi [] ; intention
 set p [] ; perceived control
 set g [] ; growth

end




to setup-entreps 
  
;building-initial-net
 create-entreps number-entreps [
    set heading who * 360 / number-entreps
    setxy 0 0
    fd 60
    set color white
    set size 2
  ]
  
  ;; red regular: k vecinos
  ask entreps [
    let my-id who
    let half-k floor (connectivity / 2)
    let i 1

    while [i <= half-k] [
      let neighbor (my-id + i) mod number-entreps
      if not link-neighbor? turtle neighbor [
        create-entrep-link-with turtle neighbor
      ]
      set i i + 1
    ]
  ]

  ;; rewiring tipo Watts–Strogatz
  ask entrep-links [
    if random-float 1 < 1 [
      let source end1
      ask source [
        let candidates other entreps with [not link-neighbor? source]
        if any? candidates [
          let new-target one-of candidates
          ask myself [ die ]
          create-entrep-link-with new-target
        ]
      ]
    ]
  ]
  
  ask entrep-links
    [
      set known true
      set financial false
    ]
  
  ask entreps [
  
    set color white
    set shape "person"
    set size 3

    ; Set agent attributes
    set behavior 0
    set funds random-poisson 200
    set attitude random-normal 0.5 0.1 ; value between 0 and 1

    ; Perceived power of the specific control factor (f: financial capital) to facilitate or inhibit behavior
    ; Control belief regarding the presence or absence of resources and opportunities required to perform the behavior
    set pf 1
    set motivation 1
    set refunds 0

    set w1 random-float 1 ; value between 0 and 1
    set w2 random-float 1 ; value between 0 and 1
    set w3 random-float 1 ; value between 0 and 1

    ; Relationship attributes
    set evaluation-time 0
    set monitoring-time 0
    set tie-to-vc 0

  ]
  

end

to setup-vcs

  create-vcs 1 [
  set color red
  set shape "circle"
  set size 6
  ]

end

to setup-fsn ; financial support network initial condition
  ; A financial network is created between some entrepreneurs and VCs.
  ; The purpose                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           