globals [last-patch]

to setup
  clear-all
  reset-ticks

end

to step
  ask patches [change-color]
  tick
end


to change-color
  run word "run_" function-name
end

to add-cell
  if mouse-down?
  [
    set last-patch patch mouse-xcor mouse-ycor
    ask last-patch [set pcolor white]

  ]
end

to clear-cell
  if mouse-down?
  [ask patch mouse-xcor mouse-ycor [set pcolor black]]
end

to run_function1
  ifelse pcolor = black
  [ if count neighbors4 with [pcolor != black] = 2
    [
      set pcolor white
      ask neighbors4 with [pcolor != black] [set pcolor black]
    ]
    if count neighbors4 with [pcolor != black] = 3
    [
      set pcolor white
      ask neighbors4 with [pcolor = black] [set pcolor white]
    ]
  ]
  [
    if count neighbors4 with [pcolor = white] = 2
    [set pcolor (pcolor + 1)
    ]
  ]
      
end

to run_function2
  ifelse pcolor != white
  [ if count neighbors with [pcolor = black] < 2
    [
      set pcolor white
      ask neighbors with [pcolor = black] [set pcolor red]
    ]
    if count neighbors with [pcolor != black] < 3
    [
      set pcolor (pcolor + 1)
      ask neighbors4 with [pcolor != black] [
        set pcolor red
      ]
    ]
  ]
  [
    if count neighbors4 with [pcolor = white] < 2
    [set pcolor (black)
    ]
  ]
      
end


to run_function3
  ifelse pcolor = white
  [ if count neighbors4 with [pcolor = white] = 2
    [
      set pcolor black
      ask neighbors4 with [pcolor = white] [set pcolor black]
    ]
    if [pcolor] of one-of neighbors = white
    [
      set pcolor (pcolor + 0.1 )
      ask neighbors4 with [pcolor = black] [set pcolor white]
    ]
  ]
  [
    if count neighbors4 with [pcolor = white] > 2
    [set pcolor (pcolor - 0.1)
    ]
  ]
      
end

to run_function4
  if pcolor = black
  [ if count neighbors with [pcolor = green] = 2
    [
      set pcolor green
      ask neighbors with [pcolor = red] [set pcolor green]
    ]
    if count neighbors4 with [pcolor = white] = 2
    [
      set pcolor green
      ask neighbors4 with [pcolor = black] [set pcolor white]
    ]
  ]
  
  if pcolor = black
    [
      set pcolor (red)
      ask neighbors4 with [pcolor != white] [set pcolor white]
      
    ]
  
  if pcolor = red
      [ask neighbors [set pcolor [pcolor] of one-of neighbors]]
      
end


to run_function5
  if pcolor = white
  [ 
    if count neighbors4 with [pcolor = red] = 1
    [
      set pcolor red
      ask neighbors4 with [pcolor = white] [set pcolor red]
    ]
    
    if count neighbors4 with [pcolor = green] = 1
    
    [
      set pcolor green
      ask neighbors4 with [pcolor = black] [set pcolor red]
    ]
    
    if count neighbors4 with [pcolor = black] = 4
      [
        set pcolor red
        ask neighbors4 with [pcolor = black] [set pcolor green]
      ]
    
    
  ]
  if pcolor = green
  [
    if count neighbors4 with [pcolor = red] = 4
    [
      set pcolor (white)
      ask neighbors4 with [pcolor = red] [set pcolor green]
    ]
  ]

  if pcolor = red
  [  
    set pcolor (white)
    ask neighbors4 with [pcolor = red] [set pcolor green] 
  ]
        
end

to run_function6
  if count neighbors4 with [pcolor = white] = 2
  [
    ifelse pcolor = white
    [
      set pcolor orange
    ]
    [set pcolor white]
  ]
  if count neighbors4 with [pcolor = white] = 1
  [
    ifelse pcolor < red + 5 and pcolor > red - 5
    [
      set pcolor (pcolor + 1)
      if pcolor > red + 5
      [set pcolor (red - 5)]
    ]
    [set pcolor white]
  ]
   if count neighbors4 with [pcolor = black] = 2
   [
     set pcolor [pcolor] of one-of neighbors4
     ask one-of neighbors4 [set pcolor red]
     ]
    
end


to run_function7

  if [pcolor] of patch-at 0 1 = black and not ([pcolor] of patch-at 1 0 = white)
  [
    set pcolor black
    ;ask patch-at 0 -1 [set pcolor white]
  ] 
  
  if [pcolor] of patch-at -1 0 = white and not ([pcolor] of patch-at 0 -1  = black)
  [
    set pcolor white
  ]
    
    
  if [pcolor] of patch-at -1 0 = black and not ([pcolor] of patch-at 0 -1  = black)
  
  [
    ask one-of neighbors4 [set pcolor red]
  ]
end

to run_function8

  if count neighbors4 with [pcolor = black] = 2
  [
    ask patch-at  0  1 [set pcolor white]
    ask patch-at  0 -1 [set pcolor black]
  ]

  if count neighbors4 with [pcolor = white] = 4
  [
    ask patch-at  0  1 [set pcolor white]
    ask patch-at -1  0 [set pcolor green]
  ]
  
  if count neighbors4 with [pcolor = green] = 2
  [
    ask patch-at  0  1 [set pcolor green]
    ask patch-at  0 -1 [set pcolor white]

  ]

  if count neighbors4 with [pcolor = red] >= 2
  [
    ask patch-at  1  0 [set pcolor white]
    ask patch-at -1  0 [set pcolor white]
  ]
    
end


to run_function9
  if [pcolor] of one-of neighbors4 = white
  [
    ask one-of neighbors [set pcolor black]
    ask patch-at 1 1 [set pcolor blue + 13]
  ]
  
  if [pcolor] of one-of neighbors4 = blue + 13
  [
    ask one-of neighbors [set pcolor blue ]
    ask patch-at 1 1 [set pcolor yellow]
  ]
  
end

to run_function10
  
  if [pcolor] of one-of neighbors = black
  [ 
    ask neighbors with [pcolor = green] [set pcolor pcolor + 1]
  ]
  if pcolor = white
  [
    ask neighbors4 with [pcolor = black] [set pcolor green]
  ]
   
end

to run_function11
  
  if [pcolor] of one-of neighbors4 = white
  [ 
    ask neighbors with [pcolor = black] [set pcolor green]
  ]
  if pcolor = white
  [
    ask patch-at 0 1 [set pcolor white]
    ask neighbors in-radius 5 [set pcolor green]
  ]
  
  
end

to run_function12
  if pcolor = white
    [      
      if any? other patches in-radius 5 with [pcolor = white]
      [
        set pcolor black
        ask patch-at 1 0 [set pcolor white]
      ] 
    ]
end
 
to run_function13
  if count neighbors with [pcolor = black] = 3
    [set pcolor white]
  if count neighbors with [pcolor = black] = 6
    [set pcolor [pcolor] of one-of neighbors]
  if count neighbors with [pcolor = black] = 0
    [set pcolor white]
  if count neighbors with [pcolor = white] = 5
    [set pcolor white]
end

to run_function14
  if pcolor = black
  [
    if [pcolor] of patch-at 0 1 = white
    [
      set pcolor orange
      ask neighbors4 [set pcolor white]
    ]
  ]
  
  if [pcolor] of patch-at 1 0 = white
  [ 
    set pcolor orange
  ]
  
  if pcolor = orange
  [
      set pcolor mean [pcolor] of neighbors
  ]
  
end

to debug
  ask patches [debug-patch]
end

to debug-patch
  if pcolor = white
  [
    ask other patches in-radius 4 with [pcolor = white and (distance myself) > 2] [set pcolor red]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
141
39
538
457
64
-1
3.0
1
10
1
1
1
0
1
1
1
-64
64
-128
0
0
0
1
ticks
30.0

BUTTON
890
82
959
115
Clear
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
891
119
954
152
step
step
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
900
175
998
208
Add a cell
add-cell
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
900
211
1002
244
Clear Cell
clear-cell
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1006
123
1106
156
go forever
step
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

CHOOSER
988
64
1126
109
function-name
function-name
"function1" "function2" "function3" "function4" "function5" "function6" "function7" "function8" "function9" "function10" "function11" "function12" "function13" "function14"
7

PLOT
902
255
1102
405
White & Green cells
Ticks
Cells
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"White" 1.0 0 -2674135 true "" "plot count patches with [pcolor = white]"
"Green" 1.0 0 -14439633 true "" "plot count patches with [pcolor = green]"

MONITOR
1102
297
1190
342
Green cells
count patches with [pcolor = green]
17
1
11

MONITOR
1102
254
1190
299
White cells
count patches with [pcolor = white]
17
1
11

BUTTON
1045
205
1119
238
debug
debug
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

An experiment on very random cellular automata

## HOW IT WORKS

Each patch changes its color depending on the color of its neighbors

## HOW TO USE IT

Click add a cell then click on the grid to create some new white cells. Choose of the functions in the functions selector, then click go forever to see the animation that each function produces on your initial state (the position of initial white cells). You may want to click on step to follow a step by step execution of the algorithme.

## THINGS TO NOTICE
Function 1 : form a round shape of white cells and start the simulation. If the cells don't spread, stop the simulation and try again by adding more white cells, always in a rounded shape. A few cells (20 to 30 cells) should be enough. The cells spread all around.

Function 2 : don't turn any cell on, start right off with a black grid and click go forever. The screen will look like a circuit board, except it is red. After less than 500 ticks you should see a white cells explosion coming from a random place that invades all the screen in 10 ticks or so. This doesn't always happen. If it's the case, keep the go forever button toggled and click the clear button. This will reset the screen and keep the simulation going. If nothing happens in less than 500 ticks you may try again until you see that white cell explosion.

Function 3 : Keep the simulation button toggeld and add cells on the go. They will move like an animated worms and then die in a matter of some ticks. The celles look like a living organisme. I didn't manage to get them fill the screen.

Funciton 4: Don't add any cell, just start the simulation on a blank screen. You should see a red screen after 2 or 3 ticks only, with white cells and a few green cells. The green cells are like microbes that white cells, like antibody, try to kill. After a few ticks all the green cells are killed by the white ones. But sometimes green cells win :)

Function 5 : Clear the field, draw a few cells, and clck on the step button this time. You will see that this kind of cells advance in one specific direction, not randomly in all directions. They go one direction for a certain amount of steps, and then they sort of "split", changing direction orthogonically and so on.

Function 6 : turn on some cells (5 to 10), then click go forever. After coloring all the grid, there are a couple of long animated curved lines of patches. The grid looks like a geographical map.

Function 7 : draw some shapes at different locations then click go forever and watch them burn.

Function 8 : Fill up the screen with another fuction (example function 2), then click the go forever button, wait for around 200 ticks then "let it snow, let it snow, let it snoooooow !"

Function 9 : Click on the go forever button and draw anything on the grid, a 3D effect should be appllied.

Function 10 : [...] applies a green contour to your drawings, giving it a funky neon style.

Function 11 : blinky blinky :) (one random patch at a time)

Function 12 : Draw something that looks like a vertical line, it's ok to doodle around a bit, then click go forever. Adjust the simulation speed and look at the moving objects. After a few seconds of observation and a little bit of imagination, you should be seeing a cylindric object, rolling from left to right around itself. If you'r lucky enough you may see a ballet dancer :)

Function 13 : Create some white cells and watch the curious living creature that results from it. The organisme seem to only develop from certain extremities it chooses randomly and grows very slowly, extending its 'arms' a little by little at each tick.

Function 14 : Create some white cells then click on the go forever button, a white marble square will appear with angular lines (black "nerves")


## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL


## NETLOGO FEATURES


## RELATED MODELS



## CREDITS AND REFERENCES

Yacine Chaouche 
yacinechaouche@yahoo.com
http://ychaouche.wikispot.org
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -7500403 true true 135 285 195 285 270 90 30 90 105 285
Polygon -7500403 true true 270 90 225 15 180 90
Polygon -7500403 true true 30 90 75 15 120 90
Circle -1 true false 183 138 24
Circle -1 true false 93 138 24

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
