;;; Asmaa aljuhani
;;; Agent Based Modeling
;; Aquaponics

breed [fish a-fish]
breed [water a-water]
breed [Nitrosomonas a-Nitrosomonas] ; convert ammonia (brown) to Nitrites (yellow)
breed [Nitrobacter a-Nitrobacter]  ; conver Nitrites (yellow) to Nitrates (Green)


water-own [
  head-to ;; this variable is to arrange the flow of water ( to make crossing tunnels easy)
  clean  ;; this variable holds arrange of int from 1-5 (1 is clean and 5 is toxic)
  nitrites?
  nitrates?
  ]


fish-own [
  tank ;; variable that hold how the amount of food a fish eat 
       ;;if it reach the max-amount-0f-food-afish-can-eat fish will stop eat
  waste ;; amount of waste a-fish produce
  
]

Nitrosomonas-own [ life-span]
Nitrobacter-own [life-span]

globals[
  window-edge
  day
 day-change?
 t2b-entrance
 b2t-exit 
]

to setup
  ca
  
   ask patches [set pcolor brown + 3]
   
  draw-tank
  draw-walls
  draw-tunnels
 
  set t2b-entrance tank-to-bed-tunnel-entrance
  set b2t-exit bed-to-tank-tunnel-exit
  
 
  
  set day-change? false
  
     ;;;create fish
  create-fish number-of-fish [
   set shape "fish"
   set color orange
   set size 2
   set tank 0
   set waste 0
   arrange-within-tank
  ]
  
  ;;;create water
  create-water tank-size * 50 [
   set shape "drop"
   set color scale-color (blue) ((random-float 2.0) + 5) 0 10
   set size 1
   set clean 1
   set nitrites? false
   set nitrates? false
   arrange-within-tank
  ]
  

  

  
  reset-ticks
end

to go
  
  ask fish [
    swim
    produce-ammonia
  ]
  
  ask water[
    
    circulate 
    grow-Nitrosomonas
    grow-Nitrobacter
    cross-tunnels
    recolor ;; to recolor water depends on how clean it is
    
  ]
  
 if any? Nitrosomonas
 [
  ask Nitrosomonas
  [
    swim
   convert-ammonia-to-Nitrites
   calculate-life-span
  ] 
 ] 

if any? Nitrobacter
 [
  ask Nitrobacter
  [
    swim
   convert-Nitrites-to-Nitrates
   calculate-life-span
  ] 
 ] 
  

    
 ifelse ticks mod 100 = 0
 [
   set day day + 1
   set day-change? true
 ]
 [
   set day-change? false
 ]
 tick 
end


;;;;;;;;;;;;;;;;;;;;;;;;; setup functions ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to draw-tank
  ask patches 
  [
   set pcolor blue ;scale-color (blue) ((random-float 2.0) + 5) 0 10
  ]
  

end

to draw-walls

  ask patches with [pxcor = max-pycor or 
                    pxcor = min-pycor + 1 or
                    pycor = max-pxcor or
                    pycor = min-pxcor]
    [ set pcolor black ]
    
  ask patches with [pxcor = min-pycor]
  [
    set pcolor brown + 3
  ]
 
end

to draw-tunnels
  ask patches with [(pycor = max-pycor / 2 + 1 or pycor = max-pycor / 2 - 1)
                     or (pycor = (- max-pycor / 2 + 1) or pycor =(- max-pycor / 2 - 1))]
  [
    if (pxcor <= min-pycor + 1 )[
      set pcolor black
    ]
   
  ]
  ask patches with [pycor = max-pycor / 2 or pycor = (- max-pycor / 2)]
  [
    if (pxcor <= min-pycor + 1 )[
      set pcolor brown + 3
    ]
  ]
end

;; turtle procedure that randomizes  position on the tanks

to arrange-within-tank
   setxy random-xcor
        random-ycor
  if any? patches in-radius 2 with [pcolor = black or pcolor = brown + 3]
    [ arrange-within-tank ] ;; try again until we don't land on or near black
end

;;;                          ;;;
;;;    turtles procedures    ;;;
;;;                          ;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;FISH PROCEDURS;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;turtle procedure that let fish to swim within the tank
to swim
  fd 1
  rt 3
 if any? patches in-radius 2 with [pcolor = black]
 [
  rt 180
 ]
  
end

to produce-ammonia 

   let drops  one-of water in-radius (size / 2)
   if drops != nobody and random 10 = 5
   [ 
     set waste waste - 1
     ask drops
     [
       if clean < 5
       [
         set clean (clean + 1) 
       ]
     ]
    
 
   ]
 
end


to empty-fish-tank
  ask fish [
   set tank 0 
  ]
end

to grow-produce
  if day-change?
  [
    set size size + .01
  ]
  
  
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;WATER PROCEDURS;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to circulate

  if ( head-to = 0)
  [
    flow
  ]
  ;; for water in the lower part of the tank --> move towards the tunnel
  if (random 10 = 1 and floor ycor = [pycor] of t2b-entrance); max-pycor / -3 and xcor > max-pxcor / 3)
  [ face t2b-entrance
    set head-to t2b-entrance
   ; set color red
    ]
  
  if (head-to = b2t-exit and ycor > 0 and xcor > min-pxcor / 2)
  [
   set head-to 0 
  ]

 ;; for water in the upper part of the grow-bed --> move towards the tunnle
   if (random 10 = 1 and floor ycor = [pycor] of b2t-exit and xcor < 0)
   [
       face b2t-exit
       set head-to b2t-exit
      ; set color yellow
     
    ]

end 

to flow
  fd 1
  rt random 10
  if any? patches in-radius 2 with [pcolor = black][
  rt 180
  ]
  
end

to cross-tunnels
  if (head-to = t2b-entrance or head-to = b2t-exit )
  [
    fd 1
    
    if ( xcor < min-pxcor + .5)
    [
      set ycor [pycor] of b2t-exit
     ; set color green
      set heading 90
      set head-to b2t-exit
      ;; return clean water
      set clean 1
      set nitrites? false
      set nitrates? false
      
    ]
  ]
  
  
  
end


to recolor
  ifelse clean > 1 and (not nitrites?) and (not nitrates?)
  [
    set color scale-color (brown) (( 2.0) + 5) clean 10
  ]
  [ ifelse nitrites?
    [ 
      set color yellow
    ]
    [ ifelse nitrates?
      [
        set color green - 1
      ]
      [
         set color scale-color (blue) ((random-float 2.0) + 5) 0 10
      ]
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;BACTERIA PROCEDURS;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to grow-Nitrosomonas
  if all? water in-radius 2 [clean > 1]
  [
    hatch-Nitrosomonas 1[
      set shape "bacteria"
      set color blue
      set size 1
      set life-span bacteria-life-span * 100
    ]
  ]
end

to grow-Nitrobacter
  if all? water in-radius 2 [nitrites?]
  [
    hatch-Nitrobacter 1[
      set shape "bacteria2"
      set color pink
      set size 1
      set life-span bacteria-life-span * 100
    ]
  ]

end 

to convert-ammonia-to-Nitrites
   let drops  water with [clean > 2] in-radius 1
   if drops != nobody 
   [ 
     ask drops
     [
      set nitrites? true
     ]
   ]
  
end

to convert-Nitrites-to-Nitrates
   let drops  water with [nitrites?] in-radius 1
   if drops != nobody 
   [ 
     ask drops
     [
       set nitrites? false
      set nitrates? true
     ]
   ]
  
end

to calculate-life-span
  ifelse life-span > 1
  [
    set life-span life-span - 1
  ]
  [
    die
  ]
  
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;                          ;;;
;;;    helper reporters      ;;;
;;;                          ;;;

to-report tank-to-bed-tunnel-entrance
  report patch ((min-pxcor ) ) (max-pycor / -2)
end



to-report bed-to-tank-tunnel-exit
  report patch ((max-pxcor)) (max-pycor / 2)
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
30
27
97
60
NIL
setup
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
101
27
164
60
NIL
go
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

SLIDER
22
89
194
122
tank-size
tank-size
1
100
10
1
1
Gallon
HORIZONTAL

SLIDER
22
131
194
164
number-of-fish
number-of-fish
0
100
28
1
1
NIL
HORIZONTAL

MONITOR
681
36
738
89
NIL
day
17
1
13

SLIDER
21
168
195
201
bacteria-life-span
bacteria-life-span
1
5
1
1
1
day
HORIZONTAL

PLOT
676
109
939
259
Minerals
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Nitrites" 1.0 0 -7171555 true "" "plot count water with [nitrites? = true]"
"Nitrates" 1.0 0 -14439633 true "" "plot count water with [nitrates? = true]"
"Ammonia" 1.0 0 -6459832 true "" "plot count water with [clean > 1 and nitrates? = false and nitrites? = false]"

MONITOR
668
274
745
327
Nitrites %
(count water with [nitrites? = true] / count water ) * 100
3
1
13

MONITOR
750
274
827
327
Nitrates %
(count water with [nitrates? = true] / count water ) * 100
3
1
13

@#$#@#$#@
## THIS IS A COMPLEMENTRY MODEL FOR AQUAPONICS-EDU
Please refere to the original model to understand the big picture of the system.
You can find the model here : http://modelingcommons.org/browse/one_model/3774

## WHAT IS AQUAPONICS?

Aquaponics consist of two main parts : Aquaculture (fish farming) and Hydroponics (soil-less growing of plants). It combines fish and plants in a "closed" integrated system. Closed means that there is no water loss - so Aquaponics is a very water efficient way of growing plants and fish, requiring only one tenth the water!
Fish wastes in the water are converted by beneficial bacteria to nutrients (plant food). Plants then use the nutrients to grow and clean water is then returned to the fish tank. The fish, plants and bacteria create a mutually beneficial relationship where the only input needed is to feed the fish and top up the water.
In order to create a balance in the aquaponic system, fish and plants need to be balanced. If there are too many fish, then the plants will not be able to extract enough of the nutrients and clean the water, if there are too many plants, then there will not be enough nutrients in the water for all of the plants. 

## WHAT IS IT?

This model focus on how nutrient-rich water that result from raising fish provides a source of natural fertilizer for the growing plants. This conversion is done by 2 types of bacteria: Nitrosomonas ( turns ammonia into Nitrites) , and Nitrobacter (turns Nitrites into Nitrates). This conversions create a sustainable ecosystem where both the fish and plants can thrive.
The interface for this model shows the fish tank with number of fish that can be specified by the user. when fish produce ammonia, The first type of bacteria (Nitrosomonas) grow and convert the ammonia to Nitrites which is intermediate compound. This Nitrites is then converted to Nitrates  (NO3- ) by the second type of the bacteria (Nitrobacter). It is beneficial for plants to consume because it serves as an essential plant nutrient helping with tissue development and building immune systems, and it helps plants develop and produce seeds. In the system, water is the carrier for all these compounds that circulate the system from the tank to growbed, then it is filtered by the plants and return clean to the tank.

## HOW IT WORKS

When fish produce ammonia, The first type of bacteria (Nitrosomonas) grow and convert the ammonia to Nitrites (water drop become yellow) which is intermediate compound. This Nitrites is then converted to Nitrates  NO3-  (water drop become green) by the second type of the bacteria (Nitrobacter).

## HOW TO USE IT

1)	Choose the amount of water in the tank
2)	Choose number of fish in the system
3)	Choose the lifespan for bacteria
4)	Press (setup)
5)	press (go) button


## THINGS TO NOTICE

Notice that when you have few fish in large tank, Bacteria take long time to grow. Also, notice the effect of the bacteria life-span on the model.
One important thing to notice by observing the plot that components reaches a stable state where the amount of Ammonia remain stable when the amount of the other minerals become stable.

## THINGS TO TRY

You can try to have a lot of fish in a small tank, or vice versa. Try to play with the bacteria life-span to see how this will affect material conversion.

## EXTENDING THE MODEL

An interesting extension would be to add antibiotics to the system and see how this will affect the whole system.

## NETLOGO FEATURES

This model had to do a lot of generalizations of breed-related functions. Each component (fish,water,Nitrosomonas,Nitrobacter) corresponds to a breed of turtles which increase the readability of the code and the model performance.

## RELATED MODELS

Aquaponics-Edu
http://modelingcommons.org/browse/one_model/3774

## CREDITS AND REFERENCES


Aquaponics-Details
http://modelingcommons.org/browse/one_model/3791

Source for information on Aquaponics:

http://aquaponics.com/
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bacteria
true
0
Polygon -7500403 true true 15 135 15 165 75 180 165 195 240 180 285 165 285 135 255 120 180 105 135 105 45 120
Polygon -1184463 true false 45 165 30 150 30 135 90 120 150 120 210 120 270 150 270 165 210 180 165 180 105 180 45 165 30 150
Polygon -7500403 true true 150 135 120 135 90 150 105 165 150 165 195 165 210 150 180 135
Circle -955883 true false 135 135 30

bacteria2
true
0
Polygon -7500403 true true 15 150 15 165 75 180 165 195 240 180 285 165 270 135 255 120 180 45 135 45 30 120
Polygon -13840069 true false 45 165 30 150 30 135 105 90 150 60 210 105 270 150 270 165 210 180 165 180 105 180 45 165 30 150
Polygon -7500403 true true 150 90 90 135 90 150 105 165 150 165 195 165 210 150 195 120
Circle -955883 true false 135 120 30

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

drop
true
0
Circle -7500403 true true 60 120 180
Polygon -7500403 true true 60 210 75 150 150 0 195 105 240 195

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
