turtles-own [
  speed   ;; agent speed in cells per tick
  goal    ;; goal list
  carrier ;; agent carrying this agent (or "nobody")
]

globals [
  wolf
  goat
  cabbage
  man
  boat
  verbose? ;; if true, agents print what they are doing 
  bank     ;; location of river bank (+ or -)
]

to setup
  clear-all
  set bank 13
  set verbose? true
  ask patches with [ pxcor <= (- bank) or pxcor >= bank ] [set pcolor green ]
  ask patches with [ pxcor > (- bank) and pxcor < bank ] [set pcolor blue ]
  
  crt 5 [ setxy (bank + 3) 0
    set speed 0.01
    set size 3
    set carrier nobody
    set goal [ ] ]
  
  set wolf (turtle 0)
  set goat (turtle 1)
  set cabbage (turtle 2)
  set man (turtle 3)
  set boat (turtle 4)
  
  let labels [ "wolf" "goat" "cabbage" "man" "boat" ]
  ask turtles [ set label (item who labels) ]
  
  ask man [ set shape "person"
    set size 4
    set goal wgc-plan
    set color red ]

  ask cabbage [ set shape "plant"
    set carrier man
    set color 53 ]

  ask boat [ set size 5
    set xcor (bank - 1)
    set speed (speed * 2)
    set color brown ]

  ask goat [ set shape "cow"
    set goal (list "eat" cabbage)
    set carrier man
    set color white ]

  ask wolf [ set shape "wolf"
    set goal (list "eat" goat)
    set carrier man
    set color black ]
  
  reset-ticks
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; NetLogo code for obeying instructions ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to obey
  if (carrier != nobody) [
    move-to carrier
  ]
  if (goal != []) [
    let kind (item 0 goal)

    if-else (kind = "goto") [ if (obey-goto (item 1 goal) (item 2 goal)) [ drop3-goal ] ] [

    if-else (kind = "meet") [ if (obey-meet (item 1 goal)) [ drop2-goal ] ] [

    if-else (kind = "eat") [ if (obey-eat (item 1 goal)) [ drop2-goal ] ] [

    if-else (kind = "pickup") [ obey-pickup (item 1 goal)
                                drop2-goal ] [

    if-else (kind = "wait") [ if (runresult (item 1 goal)) [ drop2-goal ] ] [

    if-else (kind = "drop") [ obey-drop (item 1 goal)
                              drop2-goal ] [

    if-else (kind = "instruct") [ obey-instruct (item 1 goal) (item 2 goal)
                                  drop3-goal ] [

    if-else (kind = "go-left") [ obey-go-left ] [

    if-else (kind = "go-right") [ obey-go-right ] [

    if-else (kind = "embark") [ obey-embark
                                drop-goal ] [

    if-else (kind = "disembark") [ obey-disembark
                                   drop-goal ] [

    obey-unknown kind ] ] ] ] ] ] ] ] ] ] ] ]
end

to drop-goal
  set goal (bf goal)
end

to drop2-goal
  set goal (bf (bf goal))
end

to drop3-goal
  set goal (bf (bf (bf goal)))
end

to obey-unknown [ g ]
  show (list "unknown goal" g)
  drop-goal
end

to-report at-left
  report xcor = (1 - bank)
end

to-report at-right
  report xcor = (bank - 1)
end

to obey-go-left
  if (verbose?) [ show (list "going left") ]
  let g (list "goto" (1 - bank) 0)
  set goal (sentence (list "meet" boat "embark" "instruct" boat g "wait" (task at-left) "disembark" "goto" (- (bank + 3)) 0) (bf goal))
end

to obey-go-right
  if (verbose?) [ show (list "going right") ]
  let g (list "goto" (bank - 1) 0)
  set goal (sentence (list "meet" boat "embark" "instruct" boat g "wait" (task at-right) "disembark" "goto" (bank + 3) 0) (bf goal))
end

to obey-disembark
  if (verbose?) [ show (list "disembarking") ]
  set carrier nobody
end

to obey-embark
  if (verbose?) [ show (list "embarking") ]
  set carrier boat
end

to obey-pickup [ him ]
  ask him [ set carrier myself ]
  if (verbose?) [ show (list "picking up" ([label] of him)) ]
end

to obey-drop [ him ]
  if-else ([ carrier ] of him = self)
    [ ask him [ set carrier nobody ]
      if (verbose?) [ show (list "dropping" ([label] of him)) ] ]
    [ show (list "CANNOT DROP" ([label] of him)) ]
end

to obey-instruct [ him g ]
  if-else (g = [])
    [ ask him [ set goal [] ] ]
    [ ask him [ set goal (sentence goal g) ] ]
  if (verbose?) [ show (list "instructing" ([label] of him) "to" g) ]
end

to-report obey-goto [ x y ]  ;; obey "goto x y" command; report true when achieved
  let d (distancexy x y)
  if-else (d = 0)
    [ if (verbose?) [ show (list "already at" x y) ]
      report true ]
    
    [ facexy x y
      if-else (d <= speed)
        [ setxy x y
          if (verbose?) [ show (list "have reached" x y) ]
          report true ]
      
        [ fd speed
          report false ] ]
end

to-report obey-meet [ him ]  ;; obey "meet agent" command; report true when achieved
  if-else (him = self)
    [ if (verbose?) [ show (list "i am" him) ]
      report true ]
    
    [ face him
      let d (distance him)
      
      if-else (d <= speed)
        [ move-to him
          if (verbose?) [ show (list "have met" ([label] of him)) ]
          report true ]
        
        [ fd speed
          report false ] ]
end 

to-report obey-eat [ him ]  ;; obey "eat agent" command; report true when achieved
  if-else (carrier != nobody or distance him > 2 or ([ carrier ] of him) != nobody)
    [ report false ]
    
    [ face him
      let d (distance him)
      
      if-else (d <= speed)
        [ move-to him
          show (list "eating" ([label] of him))
          ask him [ die ]
          report true ]
        
        [ fd speed
          report false ] ]
end 

to go
  if (count (turtles with [ goal != []]) = 0) [ stop ]
  ask turtles [ obey ]
  tick
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; NetLogo code for planning ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; state format is [ w g c m ]
;; w = wolf, -1 for free on left, +1 for free on right, 0 for being carried
;; g = goat, c = cabbage, similarly
;; m = man, -1 for on left, +1 for on right

to-report wgc-plan ;; top-level reporter to return the full plan
  let init-state [0 0 0 1]
  let p (planner init-state [] [] [])
  ;; add final entries to erase wolf and goat plans after the problem has been solved
  set p (sentence p (list "instruct" wolf [] "instruct" goat []))
  show (fput "THE PLAN IS:" p)
  report p
end

to-report best-of [ x y ] ;; find the best of two solutions
  if-else (length x < length y and x != [])
    [ report x ]
    [ report y]
end

to-report acceptable [ state ] ;; everybody is on the left (possibly being carried)
  report ((item 0 state <= 0) and (item 1 state <= 0) and
          (item 2 state <= 0) and (item 3 state = -1))
end

to-report bad [ state ] ;; wolf and goat loose together, or goat and cabbage loose together
  report ((item 0 state = -1 and item 1 state = -1) or
          (item 0 state = 1 and item 1 state = 1) or
          (item 1 state = -1 and item 2 state = -1) or
          (item 1 state = 1 and item 2 state = 1))
end

to-report count-zeros [ x y z ] ;; count-zeros is used to count how much the man is carrying
  let n 0
  if (x = 0) [ set n (n + 1) ]
  if (y = 0) [ set n (n + 1) ]
  if (z = 0) [ set n (n + 1) ]
  report n
end

to-report planner [ state history partial-solution best-so-far ] ;; the planner itself
  if-else ((bad state) or (member? state history) or 
           (length best-so-far <= length partial-solution and best-so-far != []))
    [ report best-so-far ]
    
    [ if-else (acceptable state)
        [ report best-of best-so-far partial-solution ]
        
        [ let h (lput state history)
          let b best-so-far
          let w (item 0 state)
          let g (item 1 state)
          let c (item 2 state)
          let m (item 3 state)
          
          ;; Can drop carried items on the current bank
          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          if (item 0 state = 0)
            [ let s (list m g c m)
              let new-partial (sentence partial-solution (list "drop" wolf))
              set b (planner s h new-partial b) ]
          if (item 1 state = 0)
            [ let s (list w m c m)
              let new-partial (sentence partial-solution (list "drop" goat))
              set b (planner s h new-partial b) ]
          if (item 2 state = 0)
            [ let s (list w g m m)
              let new-partial (sentence partial-solution (list "drop" cabbage))
              set b (planner s h new-partial b) ]
          
          ;; Can pick up items on the current bank
          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          if (item 0 state = m)
            [ let s (list 0 g c m)
              let new-partial (sentence partial-solution (list "pickup" wolf))
              set b (planner s h new-partial b) ]
          if (item 1 state = m)
            [ let s (list w 0 c m)
              let new-partial (sentence partial-solution (list "pickup" goat))
              set b (planner s h new-partial b) ]
          if (item 2 state = m)
            [ let s (list w g 0 m)
              let new-partial (sentence partial-solution (list "pickup" cabbage))
              set b (planner s h new-partial b) ]
          
          ;; Can go left or right if at most one item is being carried
          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          if ((m = 1) and (count-zeros w g c <= 1))
            [ let s (list w g c -1)
              let new-partial (sentence partial-solution [ "go-left" ])
              set b (planner s h new-partial b) ]
          if ((m = -1) and (count-zeros w g c <= 1))
            [ let s (list w g c 1)
              let new-partial (sentence partial-solution [ "go-right" ])
              set b (planner s h new-partial b) ]

          report b
        ]
    ]
end
@#$#@#$#@
GRAPHICS-WINDOW
180
14
600
255
20
10
10.0
1
10
1
1
1
0
0
0
1
-20
20
-10
10
0
0
1
ticks
30.0

BUTTON
12
14
75
47
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
96
14
159
47
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
12
63
161
108
Left bank
sort ([label] of (turtles with [xcor <= (- bank)]))
17
1
11

MONITOR
13
159
162
204
Right bank
sort ([label] of (turtles with [xcor >= bank]))
17
1
11

MONITOR
13
111
162
156
River
sort ([label] of (turtles with [xcor > (- bank) and xcor < bank]))
17
1
11

MONITOR
13
218
162
255
Current plan
[goal] of man
17
1
9

@#$#@#$#@
## NETLOGO GOALS EXAMPLE (WITH PLANNING)

This example is explained in the tutorials at http://scientificgems.wordpress.com/2014/01/24/agent-goals-in-netlogo-the-wolf-the-goat-and-the-cabbage/ and http://scientificgems.wordpress.com/2014/01/25/planning-in-netlogo-the-wolf-the-goat-and-the-cabbage-again/

## RUNNING IT

Click SETUP to start, and GO to execute. Execution speed should be set fairly slow.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
