to setup
  ca
  system-dynamics-setup
end

to go
  system-dynamics-go
  plot-stocks
  ;;system-dynamics-do-plot
end

to plot-stocks
  set-current-plot "gov-funds"
  set-current-plot-pen "gov-funds"
  plotxy ticks gov-funds
  set-current-plot "stocks"
  set-current-plot-pen "land-in-NCS"
  plotxy ticks land-in-NCS
  set-current-plot-pen "biorefineries"
  plotxy ticks biorefineries
end
@#$#@#$#@
GRAPHICS-WINDOW
426
10
865
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
12
216
85
249
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
90
216
153
249
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
8
270
416
452
stocks
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"land-in-NCS" 1.0 0 -16777216 true "" ""
"biorefineries" 1.0 0 -7500403 true "" ""

MONITOR
102
10
162
55
NIL
palmoil
17
1
11

MONITOR
196
10
265
55
NIL
biodiesel
17
1
11

MONITOR
196
61
298
106
NIL
export-biodiesel
17
1
11

MONITOR
304
10
397
55
NIL
energy-import
17
1
11

MONITOR
302
60
397
105
NIL
profit-biodiesel
17
1
11

MONITOR
105
60
190
105
NIL
profit-palmoil
17
1
11

MONITOR
7
59
100
104
NIL
export-palmoil
17
1
11

MONITOR
7
10
99
55
NIL
biorefineries
17
1
11

MONITOR
198
111
276
156
NIL
gov-funds
17
1
11

MONITOR
309
111
399
156
exp-earnings
export-earnings
17
1
11

MONITOR
7
112
193
157
private-profit-plant-biodiesel
precision private-profit-plant-biodiesel 5
17
1
11

MONITOR
8
164
103
209
ROI-biodiesel
precision ROI-biodiesel 5
17
1
11

MONITOR
110
164
167
209
NIL
ROI-alt
17
1
11

MONITOR
199
164
292
209
demand-res
demand-residual
17
1
11

MONITOR
313
164
398
209
NIL
new-plants
17
1
11

BUTTON
172
220
245
253
go-10
repeat 10 [go]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
420
270
640
449
gov-funds
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"gov-funds" 1.0 0 -16777216 true "" ""

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
1.0
    org.nlogo.sdm.gui.AggregateDrawing 98
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 220 281 60 40
            org.nlogo.sdm.gui.WrappedStock "land-in-NCS" "10" 0
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 368 437 60 40
            org.nlogo.sdm.gui.WrappedStock "biorefineries" "1" 0
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 374 280 50 50
            org.nlogo.sdm.gui.WrappedConverter "land-in-NCS * 100" "palmoil"
        org.nlogo.sdm.gui.BindingConnection 2 292 302 374 304 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.jhotdraw.contrib.ChopDiamondConnector REF 5
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 494 278 50 50
            org.nlogo.sdm.gui.WrappedConverter "min list (biorefineries * unit-size) palmoil" "biodiesel"
        org.nlogo.sdm.gui.BindingConnection 2 423 425 508 317 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.jhotdraw.contrib.ChopDiamondConnector REF 10
        org.nlogo.sdm.gui.BindingConnection 2 423 304 494 303 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 5
            org.jhotdraw.contrib.ChopDiamondConnector REF 10
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 496 152 50 50
            org.nlogo.sdm.gui.WrappedConverter "2" "price-crude"
        org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 12 271 30 30
        org.nlogo.sdm.gui.RateConnection 3 42 287 125 292 208 297 NULL NULL 0 0 0
            org.jhotdraw.figures.ChopEllipseConnector REF 20
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.WrappedRate "ifelse-value (land-in-NCS < total-land) [rate-of-uptake][0]" "new-contracts"
                org.nlogo.sdm.gui.WrappedReservoir  REF 2 0
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 40 189 50 50
            org.nlogo.sdm.gui.WrappedConverter "1" "rate-of-uptake"
        org.nlogo.sdm.gui.BindingConnection 2 75 228 125 292 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 26
            org.nlogo.sdm.gui.ChopRateConnector REF 21
        org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 208 456 30 30
        org.nlogo.sdm.gui.RateConnection 3 238 471 297 465 356 460 NULL NULL 0 0 0
            org.jhotdraw.figures.ChopEllipseConnector REF 31
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.WrappedRate "capacity-new / unit-size" "new-plants"
                org.nlogo.sdm.gui.WrappedReservoir  REF 4 0
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 26 504 50 50
            org.nlogo.sdm.gui.WrappedConverter "5000" "investment-cost"
        org.nlogo.sdm.gui.RateConnection 3 440 455 497 454 554 450 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.jhotdraw.figures.ChopEllipseConnector
                org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 553 434 30 30
            org.nlogo.sdm.gui.WrappedRate "0" "retired-plants" REF 4
                org.nlogo.sdm.gui.WrappedReservoir  0   REF 42
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 828 156 50 50
            org.nlogo.sdm.gui.WrappedConverter "palmoil - biodiesel" "export-palmoil"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 632 349 50 50
            org.nlogo.sdm.gui.WrappedConverter "energy-demand - domestic-biodiesel" "energy-import"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 735 248 50 50
            org.nlogo.sdm.gui.WrappedConverter "ifelse-value (demand-EU > biodiesel) [biodiesel] [demand-EU]" "export-biodiesel"
        org.nlogo.sdm.gui.BindingConnection 2 541 300 737 275 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 10
            org.jhotdraw.contrib.ChopDiamondConnector REF 49
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 404 721 50 50
            org.nlogo.sdm.gui.WrappedConverter "ifelse-value (gov-funds <= 0) [0][1000]" "subsidy-biorefineries"
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 406 646 60 40
            org.nlogo.sdm.gui.WrappedStock "gov-funds" "20000" 0
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 493 348 50 50
            org.nlogo.sdm.gui.WrappedConverter "10000" "energy-demand"
        org.nlogo.sdm.gui.BindingConnection 2 542 373 632 373 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 58
            org.jhotdraw.contrib.ChopDiamondConnector REF 47
        org.nlogo.sdm.gui.RateConnection 3 269 725 331 701 394 679 NULL NULL 0 0 0
            org.jhotdraw.figures.ChopEllipseConnector
                org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 240 714 30 30
            org.jhotdraw.standard.ChopBoxConnector REF 56
            org.nlogo.sdm.gui.WrappedRate "annual-budget + export-earnings" "gov-income"
                org.nlogo.sdm.gui.WrappedReservoir  REF 57 0
        org.nlogo.sdm.gui.RateConnection 3 478 664 564 662 651 660 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 56
            org.jhotdraw.figures.ChopEllipseConnector
                org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 650 645 30 30
            org.nlogo.sdm.gui.WrappedRate ";; subsidy to the investment cost only of the plant. \n;; Any surplus biodiesel is bought at cost price\n(subsidy-biorefineries * new-plants) + (subsidy-import * energy-import) + (domestic-biodiesel * cost-biodiesel)" "gov-expense" REF 57
                org.nlogo.sdm.gui.WrappedReservoir  0   REF 72
        org.nlogo.sdm.gui.BindingConnection 2 444 736 564 662 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 54
            org.nlogo.sdm.gui.ChopRateConnector REF 69
        org.nlogo.sdm.gui.BindingConnection 2 650 392 564 662 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 47
            org.nlogo.sdm.gui.ChopRateConnector REF 69
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 847 551 50 50
            org.nlogo.sdm.gui.WrappedConverter "export-palmoil * (price-palmoil - cost-palmoil)" "profit-palmoil"
        org.nlogo.sdm.gui.BindingConnection 2 537 296 834 187 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 10
            org.jhotdraw.contrib.ChopDiamondConnector REF 45
        org.nlogo.sdm.gui.BindingConnection 2 418 299 833 186 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 5
            org.jhotdraw.contrib.ChopDiamondConnector REF 45
        org.nlogo.sdm.gui.BindingConnection 2 854 204 870 552 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 45
            org.jhotdraw.contrib.ChopDiamondConnector REF 81
        org.nlogo.sdm.gui.BindingConnection 2 763 294 792 470 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 49
            org.jhotdraw.contrib.ChopDiamondConnector
                org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 771 467 50 50
                    org.nlogo.sdm.gui.WrappedConverter "export-biodiesel * (price-biodiesel - cost-biodiesel)" "profit-biodiesel"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 79 680 50 50
            org.nlogo.sdm.gui.WrappedConverter "10000" "annual-budget"
        org.nlogo.sdm.gui.BindingConnection 2 128 704 331 701 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 97
            org.nlogo.sdm.gui.ChopRateConnector REF 63
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 50 442 50 50
            org.nlogo.sdm.gui.WrappedConverter "0.02" "ROI-alt"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 378 151 50 50
            org.nlogo.sdm.gui.WrappedConverter "22" "price-edibleoil"   REF 95
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 673 420 50 50
            org.nlogo.sdm.gui.WrappedConverter "8" "price-biodiesel"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 910 401 50 50
            org.nlogo.sdm.gui.WrappedConverter "3" "price-palmoil"
        org.nlogo.sdm.gui.BindingConnection 2 927 443 879 558 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 108
            org.jhotdraw.contrib.ChopDiamondConnector REF 81
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 599 153 50 50
            org.nlogo.sdm.gui.WrappedConverter "0" "domestic-palmoil"
        org.nlogo.sdm.gui.BindingConnection 2 423 489 564 662 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.ChopRateConnector REF 69
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 620 689 50 50
            org.nlogo.sdm.gui.WrappedConverter "1" "subsidy-import"
        org.nlogo.sdm.gui.BindingConnection 2 629 704 564 662 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 118
            org.nlogo.sdm.gui.ChopRateConnector REF 69
        org.nlogo.sdm.gui.BindingConnection 2 714 453 779 483 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 106
            org.jhotdraw.contrib.ChopDiamondConnector REF 95
        org.nlogo.sdm.gui.BindingConnection 2 433 698 431 723 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 56
            org.jhotdraw.contrib.ChopDiamondConnector REF 54
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 496 508 50 50
            org.nlogo.sdm.gui.WrappedConverter "(profit-biodiesel - (export-tax-biodiesel * profit-biodiesel)) / biorefineries" "private-profit-plant-biodiesel"
        org.nlogo.sdm.gui.BindingConnection 2 774 495 542 529 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 95
            org.jhotdraw.contrib.ChopDiamondConnector REF 129
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 641 545 50 50
            org.nlogo.sdm.gui.WrappedConverter "(export-tax-biodiesel * profit-biodiesel) + (export-tax-palmoil * profit-palmoil)" "export-earnings"
        org.nlogo.sdm.gui.BindingConnection 2 780 501 681 560 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 95
            org.jhotdraw.contrib.ChopDiamondConnector REF 134
        org.nlogo.sdm.gui.BindingConnection 2 847 575 690 570 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 81
            org.jhotdraw.contrib.ChopDiamondConnector REF 134
        org.nlogo.sdm.gui.BindingConnection 2 496 533 317 535 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 129
            org.jhotdraw.contrib.ChopDiamondConnector
                org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 268 511 50 50
                    org.nlogo.sdm.gui.WrappedConverter ";; includes gov. subsidy on investment cost \nprivate-profit-plant-biodiesel * (exp (- interest-rate * construction-period)) /  (((1 - exp (- interest-rate * amortisation-period)) / interest-rate)* (investment-cost - subsidy-biorefineries))" "ROI-biodiesel"
        org.nlogo.sdm.gui.BindingConnection 2 648 577 331 701 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 134
            org.nlogo.sdm.gui.ChopRateConnector REF 63
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 916 260 50 50
            org.nlogo.sdm.gui.WrappedConverter "2000" "demand-EU"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 186 195 50 50
            org.nlogo.sdm.gui.WrappedConverter "50" "total-land"
        org.nlogo.sdm.gui.BindingConnection 2 197 231 125 292 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 152
            org.nlogo.sdm.gui.ChopRateConnector REF 21
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 913 198 50 50
            org.nlogo.sdm.gui.WrappedConverter "0" "demand-other"
        org.nlogo.sdm.gui.BindingConnection 2 917 283 783 274 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 150
            org.jhotdraw.contrib.ChopDiamondConnector REF 49
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 788 609 50 50
            org.nlogo.sdm.gui.WrappedConverter "0.1" "export-tax-biodiesel"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 789 667 50 50
            org.nlogo.sdm.gui.WrappedConverter "0.1" "export-tax-palmoil"
        org.nlogo.sdm.gui.BindingConnection 2 795 626 683 577 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 162
            org.jhotdraw.contrib.ChopDiamondConnector REF 134
        org.nlogo.sdm.gui.BindingConnection 2 800 680 679 581 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 164
            org.jhotdraw.contrib.ChopDiamondConnector REF 134
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 258 612 50 50
            org.nlogo.sdm.gui.WrappedConverter "0.05" "interest-rate"   REF 145
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 26 561 50 50
            org.nlogo.sdm.gui.WrappedConverter "1" "construction-period"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 80 615 50 50
            org.nlogo.sdm.gui.WrappedConverter "20" "amortisation-period"
        org.nlogo.sdm.gui.BindingConnection 2 285 614 290 558 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 172
            org.jhotdraw.contrib.ChopDiamondConnector REF 145
        org.nlogo.sdm.gui.BindingConnection 2 121 631 276 544 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 176
            org.jhotdraw.contrib.ChopDiamondConnector REF 145
        org.nlogo.sdm.gui.BindingConnection 2 71 581 272 540 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 174
            org.jhotdraw.contrib.ChopDiamondConnector REF 145
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 789 363 50 50
            org.nlogo.sdm.gui.WrappedConverter "price-palmoil + cost-other-inputs" "cost-biodiesel"
        org.nlogo.sdm.gui.BindingConnection 2 810 409 799 470 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 187
            org.jhotdraw.contrib.ChopDiamondConnector REF 95
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 915 480 50 50
            org.nlogo.sdm.gui.WrappedConverter "2" "cost-palmoil"
        org.nlogo.sdm.gui.BindingConnection 2 927 517 884 563 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 192
            org.jhotdraw.contrib.ChopDiamondConnector REF 81
        org.nlogo.sdm.gui.BindingConnection 2 915 420 833 393 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 108
            org.jhotdraw.contrib.ChopDiamondConnector REF 187
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 883 313 50 50
            org.nlogo.sdm.gui.WrappedConverter "1" "cost-other-inputs"
        org.nlogo.sdm.gui.BindingConnection 2 891 346 830 379 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 200
            org.jhotdraw.contrib.ChopDiamondConnector REF 187
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 794 724 50 50
            org.nlogo.sdm.gui.WrappedConverter "0" "taxes-on-profits"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 45 352 50 50
            org.nlogo.sdm.gui.WrappedConverter "demand-EU + demand-other - export-biodiesel" "demand-residual"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 150 401 50 50
            org.nlogo.sdm.gui.WrappedConverter "unit-size * floor ((demand-residual / unit-size) * (ROI-biodiesel / (ROI-biodiesel + ROI-alt))  )" "capacity-new"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 379 346 50 50
            org.nlogo.sdm.gui.WrappedConverter "100" "unit-size"
        org.nlogo.sdm.gui.BindingConnection 2 419 361 503 312 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 211
            org.jhotdraw.contrib.ChopDiamondConnector REF 10
        org.nlogo.sdm.gui.BindingConnection 2 383 375 195 421 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 211
            org.jhotdraw.contrib.ChopDiamondConnector REF 209
        org.nlogo.sdm.gui.BindingConnection 2 87 384 157 418 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 207
            org.jhotdraw.contrib.ChopDiamondConnector REF 209
        org.nlogo.sdm.gui.BindingConnection 2 92 459 157 433 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 102
            org.jhotdraw.contrib.ChopDiamondConnector REF 209
        org.nlogo.sdm.gui.BindingConnection 2 280 523 187 438 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 145
            org.jhotdraw.contrib.ChopDiamondConnector REF 209
        org.nlogo.sdm.gui.BindingConnection 2 75 529 268 535 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 37
            org.jhotdraw.contrib.ChopDiamondConnector REF 145
        org.nlogo.sdm.gui.BindingConnection 2 193 432 297 465 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 209
            org.nlogo.sdm.gui.ChopRateConnector REF 32
        org.nlogo.sdm.gui.BindingConnection 2 390 382 297 465 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 211
            org.nlogo.sdm.gui.ChopRateConnector REF 32
        org.nlogo.sdm.gui.BindingConnection 2 440 482 505 523 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.jhotdraw.contrib.ChopDiamondConnector REF 129
        org.nlogo.sdm.gui.BindingConnection 2 419 730 302 551 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 54
            org.jhotdraw.contrib.ChopDiamondConnector REF 145
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 685 301 50 50
            org.nlogo.sdm.gui.WrappedConverter "biodiesel - export-biodiesel" "domestic-biodiesel"
        org.nlogo.sdm.gui.BindingConnection 2 541 305 687 323 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 10
            org.jhotdraw.contrib.ChopDiamondConnector REF 243
        org.nlogo.sdm.gui.BindingConnection 2 696 337 670 362 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 243
            org.jhotdraw.contrib.ChopDiamondConnector REF 47
        org.nlogo.sdm.gui.BindingConnection 2 747 285 722 313 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 49
            org.jhotdraw.contrib.ChopDiamondConnector REF 243
        org.nlogo.sdm.gui.BindingConnection 2 702 343 564 662 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 243
            org.nlogo.sdm.gui.ChopRateConnector REF 69
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
