globals [
  CFR ;; quantity (kg) of fodder required by cattle herd from current step
  SFR ;; quantity (kg) of fodder required by sheep herd from current step
  CLR ;; area (ha) of land required by cattle herd from current step
  SLR ;; area (ha) of land required by sheep herd from current step
  LR ;; total pastureland (ha) required by both herds from current step
  LB ;; total labour (hrs) required to produce fodder required by both herds from current step
  LBL ;; list of LB values
  MC ;; manure (kg) collected from cattle herd from current step
  R ;; total number of steps per run of model
  AMP ;; average meat (kg) produced by cattle and sheep herd from previous 10 steps
  AMkP ;; average milk (l) produced by cattle and sheep herd from previous 10 steps
  AWP ;; average wool (kg) produced by sheep herd from previous 10 steps
  Cal ;; total calories (kcal) available from milk and meat produced from current step
  CPYC ;; number of cattle remaining at end of previous step
  CTYC ;; number of cattle remaining at end of current step
  SPYC ;; number of sheep remaining at end of previous step
  STYC ;; number of sheep remaining at end of current step
  CGR ;; population growth rate of cattle herd
  CGRL ;; list of CGR values
  CAGR ;; average growth rate of cattle herd per ten steps
  CMP ;; meat (kg) produced by cattle herd from current step
  CMPL ;; list of CMP values
  CMkP ;; milk (l) produced by cattle herd from current step
  CMkPL ;; list of CMkP values
  SGR ;; population growth rate of sheep herd
  SGRL ;; list of SGR values
  SAGR ;; average growth rate of sheep herd per ten steps
  SMP ;; meat (kg) produced by sheep herd from current step
  SMPL ;; list of SMP values
  SMkP ;; milk (l) produced by sheep herd from current step
  SMkPL ;; list of SMkP values
  SWP ;; wool (kg) produced by sheep herd from current step
  SWPL ;; list of SWP values
  CAM ;; number of dead adult cattle from current step
  CIM ;; number of dead immature cattle from current step
  CYM ;; number of dead young cattle from current step
  CNM ;; number of dead newborn cattle from current step
  SAM ;; number of dead adult sheep from current step
  SIM ;; number of dead immature sheep from current step
  SYM ;; number of dead young sheep from current step
  SNM ;; number of dead newborn sheep from current step
  MP ;; total meat (kg) produced by cattle and sheep herds from current step
  MkP ;; total milk (l) produced by cattle and sheep herds from current step
  MPL ;; list of MP values
  MkPL ;; list of Mk values
  C ;; number of ticks
  AWS ;; adult sheep weight
  AWC ;; adult cow weight
  IWS ;; immature sheep weight
  IWC ;; immature cow weight
  YWC ;; young cow weight
  YWS ;; young sheep weight
  SWY ;; annual sheep wool yield
  SMY ;; annual sheep milk yield
  CMY ;; annual cow milk yield
  catastrophe? ;; records whether a castrophic event has occured
  SLE ;; sheep life expectancy
  CLE ;; cow life expectancy
  NCM ;; newborn cattle mortality rate
  NSM ;; newborn sheep mortality rate
]
breed [ ;; creates the various breeds for the two types of animals based on age group
  adultcows adultcow
]
breed [
  immaturecows immaturecow
]
breed [
  youngcows youngcow
]
breed [
  newborncows newborncow
]
breed [
  adultsheeps adultsheep
]
breed [
  immaturesheeps immaturesheep
]
breed [
  youngsheeps youngsheep
]
breed [
  newbornsheeps newbornsheep
]
turtles-own [ ;; stores age of individual animal and whether or not the animal is lactating
  age
  lactating
]
to setup
  ca
  reset-ticks
  set C 0 ;; resets counter value to 0
  set LR 0 ;; resets land requirement to 0
  set R 100 ;; sets number of steps of the model to 100
  set catastrophe? "NO" ;; sets initial value for catastrophe? as no
  set CGRL ( n-values ( R + 1 ) [ 0 ] ) ;; following commands create the various list variables (see above), which comprises 100 empty items (one item per step therefore)
  set CMPL ( n-values R [ 0 ] )
  set CMkPL ( n-values ( R + 1 ) [ 0 ] )
  set SGRL ( n-values (R + 1) [ 0 ] )
  set SMPL ( n-values (R + 1)  [ 0 ] )
  set SMkPL ( n-values (R + 1)  [ 0 ] )
  set SWPL ( n-values (R + 1)  [ 0 ] )
  set MkPL ( n-values ( R + 1 ) [ 0 ] )
  set MPL ( n-values ( R + 1 ) [ 0 ] )
  set LBL ( n-values ( R + 1 ) [ 0 ] )
  set AWS 25 ;; sets weight of adult sheep as 25kg
  set AWC 200 ;; sets weight of adult cattle as 200kg
  set IWS 15 ;; sets weight of immature sheep as 15kg
  set IWC 75 ;; sets weight of immature cattle as 75kg
  set YWC 35 ;; sets weight of young cattle as 35kg
  set YWS 7.5 ;; sets weight of young sheep as 7.5kg
  set SWY 2 ;; sets annual yield of fleece from adult/immature sheep as 2kg
  set SMY 60 ;; sets annual milk yield of adult lactating sheep as 60l
  set CMY 150 ;; sets annual milk yield of adult lactating cattle as 150l
  set SLE 10 ;; sets maximum age of sheep as 10 years
  set CLE 20 ;; sets maximum age of cattle as 20 years
  set NCM 0.3 ;; sets newborn mortality rate of cattle as 30%
  set NSM 0.3 ;; sets newborn mortality rate of sheep as 30%
  create-adultcows 10 [ ;; following commands create turtles of various breeds and assigns a random age for each individual within the ranges assumed per animal species and age cohort
    set age 4 + random 16
  ]
  create-immaturecows 10 [
    set age one-of [ 1 2 3 ]
  ]
  create-youngcows 10 [
    set age 0
  ]
  create-adultsheeps 10 [
    set age 2 + random 8
  ]
  create-immaturesheeps 10 [
    set age 1
  ]
  create-youngsheeps 10 [
    set age 0
  ]
end
to go
  if count turtles = 0 [ ;; model does not run if there are no turtles
    stop
  ]
  if ticks = R [ ;; model does not run if number of ticks exceeds the runtime (100 steps)
    stop
  ]
  set CPYC ( count adultcows + count immaturecows + count youngcows ) ;; sets the value for CPYC (count previous year cattle) as the current number of cattle
  set SPYC ( count adultsheeps + count immaturesheeps + count youngsheeps ) ;; sets the value for SPYC (count previous year sheep) as the current number of sheep
  set CAM 0 ;; following commands reset the number of animals that have died to 0 at the beginning of each step
  set CIM 0
  set CYM 0
  set SAM 0
  set SIM 0
  set SYM 0
  set CNM 0
  set SNM 0
  set MC 0 ;; resets the manure yield of cattle to 0 at the beginning of each step
  set Cal 0 ;; resets the number of calories yielded by the herds to 0 at the beginning of each step
  set CFR 0 ;; following commands reset the fodder requirement of sheep and cattle to 0 at the beginning of each step
  set SFR 0
  GoEpidemic
  GoAnimals
  GoFodder
  GoLand
  GoManure
  GoGrowthRate
  GoProduction
  GoCalories
  set C C + 1 ;; increases value for counter by 1 at end of each step
  tick
end
to GoEpidemic
  if enable-catastrophe? = "TRUE"[ ;; following commands only called if value for enable-catastrophe switch is TRUE
    if catastrophe? = "NO" [ ;; following commands only called if value for global variable catastrophe? is NO, i.e. catastrophic event has not occured yet during model's run
      if count turtles with [ breed != newbornsheeps and breed != newborncows ] >= 50 [ ;; following commands only called if number of animals >= 50
        ask n-of ( count turtles * 0.9 ) turtles [ ;; kills 90% of all turtles
          die
        ]
        set catastrophe? "YES" ;; sets value for catastrophic event to "YES" to prevent further catastrophic events reoccuring during model's run
      ]
    ]
  ]
end
to GoAnimals
  ask adultsheeps [ ;; following commands simulate reproduction by adult sheep of newborn sheep according to probability of birthing (i.e. value for SBa).
    set lactating "N"
    if random-float 1 < SBa [
      hatch 1 [
        set breed newbornsheeps
        set age 0
      ]
      set lactating "Y" ;; sets value for lactating of any adult sheep that has reproduced to "Y" i.e. yes
    ]
    if random-float 1 < sheep-adult-mortality [ ;; simulates death of adult sheep according to probability of occurence
      set SAM SAM + 1 ;; if adult sheep dies, value for SAM is increases by 1
      die
    ]
    set age age + 1 ;; if adult sheep survives, age is increased by 1
    if age > SLE [ ;; if age of adult sheep exceeds life expectancy, the animal is killed
      die
    ]
  ]
  ask adultcows [
    set lactating "N"
    if random-float 1 < CBa [ ;; simulates reproduction by adult cattle, process not different to that of sheep (see above)
      hatch 1 [
        set breed newborncows
        set age 0
      ]
      set lactating "Y"
    ]
    if random-float 100 / 100 < cow-adult-mortality [ ;; simulates death of adult cattle (see description of process affecting adult sheep above)
      set CAM CAM + 1
      die
    ]
    set age age + 1
    if age > CLE [
      die
    ]
  ]
  ask immaturesheeps [ ;; following commands simulate death of individual animals according to probabilities of mortality per species and per age cohort (see mortality processes of adult cattle and sheep above)
    if random-float 100 / 100 < sheep-immature-mortality [
      set SIM SIM + 1
      die
    ]
    set age age + 1
    set breed adultsheeps
  ]
  ask immaturecows [
    if random-float 100 / 100 < cow-immature-mortality [
      set CIM CIM + 1
      die
    ]
    set age age + 1
    if age = 4 [
      set breed adultcows
    ]
  ]
  ask youngsheeps [
    if random-float 100 / 100 < sheep-young-mortality [
      set SYM SYM + 1
      die
    ]
    set age age + 1
    set breed immaturesheeps
  ]
  ask youngcows [
    if random-float 100 / 100 < cow-young-mortality [
      set CYM CYM + 1
      die
    ]
    set age age + 1
    set breed immaturecows
  ]
  ask newbornsheeps [
    if random-float 100 / 100 < NSM [
      set SNM SNM + 1
      die
    ]
    set age age + 1
    set breed youngsheeps
  ]
  ask newborncows [
    if random-float 100 / 100 < NCM [
      set CNM CNM + 1
      die
    ]
    set age age + 1
    set breed youngcows
  ]
end
to GoFodder ;; calculates fodder required (kg) by cattle and sheep herds
    set CFR ( count adultcows * ( 800 * ( AWC / 200 ) ) + count immaturecows * ( 800 * ( IWC / 200 ) ) + count youngcows * ( 800 * ( YWC / 200 ) ) ) ;; sets fodder required by cattle herd
    set SFR ( count adultsheeps * (306 * ( AWS / 30 ) ) + count immaturesheeps * ( 306 * ( IWS / 30 ) ) + count youngsheeps * ( 306 * ( YWS / 30 ) ) ) ;; sets fodder required by sheep herd
    set LB ( ( CFR + SFR ) / 3000 * 4 ) ;; sets labour in hours required to produce fodder
    set LBL replace-item C LBL LB ;; adds value calculated above to list LBL
end
to GoLand ;; calculates pasture land required by cattle and sheep
  set SLR ( ( count adultsheeps + count immaturesheeps + ( count youngsheeps * ( 11 / 12 ) * 0.5 ) ) + ( SFR / 3000 ) ) / 7.5 ;; sets pasture land required by sheep herd
  set CLR ( ( count adultcows + count immaturecows + ( count youngcows * ( 7 / 12 ) * 0.5 ) ) ) * 8 / 12 + ( CFR / 3000 ) / 3 ;; sets pasture land required by cattle herd
  set LR ( SLR + CLR ) ;; sets value for total pastureland required
end
to GoManure ;; calculates quantity of manure (kg) produced by cattle herd for four months during winter
  let manure-output-cow ( ( count adultcows * ( AWC * 0.075 ) ) + ( count immaturecows * ( IWC * 0.075 ) ) + ( count youngcows * ( YWC * 0.075 ) ) ) ;; calculates manure output per day of cattle herd
  set MC manure-output-cow * 240 ;; calculates manure output of cattle herd for total period of time manure available (four months during winter, plus nights for remainder of the year)
end
to GoProduction
  set CMP ( CAM * ( AWC * 0.3 ) + CIM * ( IWC * 0.35 ) + CYM * ( YWC * 0.4 ) ) ;; calculates quantity of meat (kg) produced by cattle herd as number of dead animals adjusted for % of carcass edible
  set CMPL replace-item C CMPL CMP ;; updates list CMPL with value calculated above
  set CMkP ( ( count adultcows with [ lactating = "Y" ] ) * CMY ) ;; calculates quantity of milk (l) produced by cattle herd
  set CMkPL replace-item C CMkPL CMkP ;; updates list CMkPL with value calculate above
  set SMP ( SAM * ( AWS * 0.3 ) + SIM * ( IWS * 0.35 ) + SYM * ( YWS * 0.4 ) ) ;; calculates quantity of meat (kg) produced by shee[ herd as number of dead animals adjusted for % of carcass
  set SMPL replace-item C SMPL SMP ;; updates list CMPL with value calculated above
  set SMkP ( ( count adultsheeps with [ lactating = "Y" ] ) * SMY ) ;; calculates quantity of milk (l) produced by cattle herd
  set SMkPL replace-item C SMkPL SMkP ;; updates list CMPL with value calculated above
  set SWP ( ( count adultsheeps + count immaturesheeps ) * SWY );; calculates quantity of wool (kg) produced by sheep herd
  set SWPL replace-item C SWPL SWP ;; updates list CMPL with value calculated above
  set MP ( CMP + SMP ) ;; calculates total meat produced by both herds
  set MPL replace-item C MPL MP ;; updates list CMPL with value calculated above
  set MkP ( CMkP + SMkP )
  set MkPL replace-item C MkPL MkP ;; updates list CMPL with value calculated above
  if C > 9 [ ;; calculates average output of meat, milk and wool every ten steps
    set AMP mean  ( sublist MPL ( C - 9 ) ( C + 1 ) )
    set AMkP mean ( sublist MkPL ( C - 9 ) ( C + 1 ) )
    set AWP mean ( sublist SWPL ( C - 9) ( C + 1 ) )
    ]
end
to GoGrowthRate ;; calculates % population growth rates of cattle and sheep herds
  set CTYC ( count adultcows + count immaturecows + count youngcows )
  if CTYC > 0 [
    set CGR ( 100 * ( CTYC - CPYC ) / CPYC )
    set CGRL replace-item C CGRL CGR
  ]
  if C > 8 [
    set CAGR mean ( sublist CGRL ( C - 9 ) ( C + 1 ) )
  ]
  set STYC ( count adultsheeps + count immaturesheeps + count youngsheeps )
  if STYC > 0 [
    set SGR ( 100 * ( STYC - SPYC ) / SPYC )
    set SGRL replace-item C SGRL SGR
  ]
  if C > 8 [
    set SAGR mean ( sublist SGRL ( C - 9 ) ( C + 1 ) )
  ]
end
to GoCalories ;; calculates total calories supplied by milk and meat output of sheep and cattle herds
  set Cal ( (CMP * 0.6 * 1700 ) + ( CMP * 0.3 * 8000 ) + ( CMP * 2000 * 0.1 ) + ( SMP * 0.7 * 2930) + ( SMP * 0.2 * 6000 ) + ( SMP * 0.1 * 2000 ) )
end
@#$#@#$#@
GRAPHICS-WINDOW
349
40
795
507
100
100
2.17
1
10
1
1
1
0
1
1
1
-100
100
-100
100
1
1
1
ticks
30.0

BUTTON
7
13
90
46
NIL
setup
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
7
47
90
80
NIL
go
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

PLOT
292
272
673
536
Growth-rate
Time
Growth rate
0.0
100.0
0.0
10.0
true
true
"" ""
PENS
"0" 1.0 0 -16777216 true "" "plot 0"
"Cow average" 1.0 0 -6459832 true "" "plot CaGR"
"Sheep average" 1.0 0 -5825686 true "" "plot SaGR"

PLOT
672
10
1049
273
Pop. size
Time
Size
0.0
100.0
0.0
10.0
true
true
"" ""
PENS
"Sheep" 1.0 0 -2674135 true "" "plot ( count adultsheeps + count immaturesheeps + count youngsheeps )"
"Cow" 1.0 0 -13345367 true "" "plot ( count adultcows + count immaturecows + count youngcows )"
"Total" 1.0 0 -16777216 true "" "plot ( count adultcows + count adultsheeps + count immaturecows + count immaturesheeps + count youngcows + count youngsheeps )"

PLOT
292
10
673
273
Land Use
Time
Land use (ha)
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Land use" 1.0 0 -16777216 true "" "plot LR"

INPUTBOX
140
89
268
149
SBa
0.8
1
0
Number

INPUTBOX
7
265
135
325
cow-adult-mortality
1
1
0
Number

INPUTBOX
140
266
268
326
sheep-adult-mortality
0.25
1
0
Number

INPUTBOX
140
207
268
267
sheep-immature-mortality
0.48
1
0
Number

INPUTBOX
7
206
135
266
cow-immature-mortality
1
1
0
Number

INPUTBOX
140
148
268
208
sheep-young-mortality
0.1
1
0
Number

INPUTBOX
7
147
135
207
cow-young-mortality
1
1
0
Number

PLOT
672
272
1049
537
Sheep
Time
N
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"AS" 1.0 0 -2674135 true "" "plot count adultsheeps"
"IS" 1.0 0 -10899396 true "" "plot count immaturesheeps"
"YS" 1.0 0 -13345367 true "" "plot count youngsheeps"

PLOT
1048
10
1425
274
Cow
Time
N
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"AC" 1.0 0 -2674135 true "" "plot count adultcows"
"IC" 1.0 0 -10899396 true "" "plot count immaturecows"
"YC" 1.0 0 -13345367 true "" "plot count youngcows"

INPUTBOX
7
88
135
148
CBa
0
1
0
Number

SWITCH
6
342
176
375
enable-catastrophe?
enable-catastrophe?
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

The model simulates reproduction and death of sheep and cattle herds to understand how human agency affects population dynamics. It is used to observe the effects of animal husbandry practices reflected by mortality and birth rates on the production of milk, meat, wool and manure from cattle and sheep herds, as well as the population growth rates of the herds.

The model was constructed as part of archaeological research on the agricultural economy of the native population in the Dutch Roman limes zone. Accordingly, many of the assumptions used in the model are region- and period-specific. Most assumptions are immutable but can be changed within the code itself. It now forms part of a more detailed model concerning the complete rural economy of the region in the Roman period.

## HOW IT WORKS

Individual sheep and cattle reproduce and die according to probabilities determined by the user. Surviving animals increase in age by 1 at the end of each step, and, if they reach a certain age, are promoted to the following age cohort (newborn->young->immature->adult). Only adult animals may reproduce, producing a single offspring. Animals automatically die if they reach life expectancy. Outputs of manure, milk, meat and wool are determined by the number of dead and living animals at the end of each step.

## HOW TO USE IT

Inputs on interface are decimal probabilities and determine whether life events of individual animals occur. Input values can not exceed 1 i.e. (100%).

SBa: sheep birthrate i.e. probability that each individual sheep will produce one offspring.

CBa: cattle birthrate i.e. probability that each individual cattle will produce one offspring.

Cow-adult-mortality: probability that adult cow will die

Sheep-adult-mortality: probability that adult sheep will die

Cow-immature-mortality: probability that immature cow will die

Sheep-immature-mortality: probability that immature sheep will die

Cow-young-mortality: probability that young cow will die

Sheep-young-mortality: probability that young sheep will die

Catastrophe?: determines whether 90% of the herd dies out once herd size >= 50. Catastrophe? can be used to determine robusticity of herd i.e. resistance to extinction during catastrophic events.

## CREDITS AND REFERENCES

This model corresponds Appendix 3, Joyce & Verhagen, 2015, in press, Simulating the farm: computational modelling of cattle and sheep herd dynamics for the analysis of past animal husbandry practices.

See article for a more detailed description.

## HOW TO CITE

If you mention this model in a publication, we ask that you include this citations for the model:

Joyce & Verhagen, 2015, in press, Simulating the farm: computational modelling of cattle and sheep herd dynamics for the analysis of past animal husbandry practices.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
