; Adapted from models library by Lada Adamic (see copyright below)
; for the purposes of SI708/CSCS608
; also now contains major improvements by Eytan Bakshy

;This version is created by Alon Sela 7/2013-9/2015 on the base of the above...
 extensions [nw]

;correct - method of choice in WOM -
globals
[
  new-node  ;; the last node we created
  degrees   ;; this is an array that contains each node in proportion to its degree
  num-infected
  tree-mode?
  time-to-90 ;; Alon
  time-to-1  ;; Alon
  time-to-10 ;; Alon
  time-from-1-to-90
  global-infect-rate ;; Alon
  cured?   ;; Alon
  memory-of-t-0 ;; Alon
  prob-to-inf-of-t-0 ;Alon
  final-distribution ;; Alon
  dist-non-zero;;Alon
  initial-num-infected ;;Alon
  remove-zero?
]

turtles-own
[
  group-mates      ;; ALONs addition
  prob-to-inf      ;; ALONs addition, probability of infection
  memory
  message          ;;ALONs addition, message spreading
]

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  ca
  __clear-all-and-reset-ticks
  let partner nobody
  set remove-zero? true
  set-default-shape turtles "circle"
  set degrees []   ;; initialize the array to be empty
  ;; make the initial network of two turtles and an edge
  crt (m + 1)
  ask turtles [
    repeat m [set degrees lput self degrees] ; insert nodes into array
    ask other turtles with [not link-neighbor? myself] [
      create-link-with myself
    ]
  ]

  ;set num-infected 0
  no-display
  repeat (num-nodes - m - 1) [
  crt 1 [
    set new-node self ;; set the new-node global
    repeat m [
      ifelse (random-float 1.0 <= prob-pref) ; if pref attachment
      [set partner new-node
        while [partner = new-node] [
          set partner one-of (degrees)
          ask partner [
            if link-neighbor? self [  ; we can't link to someone we already share an edge with
              set partner new-node    ; so set to self so we redo
            ]
          ]
        ]
      ]
     [  ; if not pref attachment
     set partner one-of other turtles with [(not link-neighbor? new-node)]
     ]
     move-to partner
     fd 5
     create-link-with partner [set color green]
     set degrees lput new-node degrees
     set degrees lput partner degrees
    ]
  ]
  ]
  ;repeat 100 [do-layout]
  repeat 10 [do-layout]
  ask turtles [set color gray
    set shape "circle"
    set size 0.3
    ;set infection-count 0
    ;set infected? false
    ]
  ask links [set color gray]
end

                          ;;;;;;;;;;;;;;;;;;;;;;;;;;
                          ;;; REINFECT ONCE      ;;;
                          ;;;;;;;;;;;;;;;;;;;;;;;;;;

; reset diffusion simulation
to reinfect-once
  clear-all-plots
  ;let init-oppinion []
  set num-infected 0
  set time-to-90 0
  set time-to-1 0
  set time-to-10 0
  set time-from-1-to-90 0
  set memory-of-t-0 0
  set final-distribution 0
  set dist-non-zero 0
  reset-ticks
  ask turtles [
    set color gray
    set shape "circle"
    set size 0.3
    ;set infection-count 0
    ;set infected? false
    set prob-to-inf 0
    set memory 0
    set message 0
  ]

  ask links [set color gray + 2]
  while [count turtles with [message != 0] < num-infected-init]
    [
  ;repeat num-infected-init [
    ask one-of turtles
    [if not (message != 0)
       [;set infected? true
        set memory 1
        set size 3
        set shape "target"
        set num-infected num-infected + 1
        set message (random num-oppinions ) + 1
        set color (message * 10 + 5)]
  ;      set init-oppinion lput message init-oppinion
    ]
  ]
update-plots
set dist-non-zero distribution-no-zeroes
set initial-num-infected length dist-non-zero
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;                             Main SPREAD    procedure                      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to spread


  ;first we construct alist of nodes with an opinion
  let myInfecttedAgentset []
  set myInfecttedAgentset turtles with [message != 0]


  ;create the search engine result list sorten by the PageRank of the believers in the network
  let search-result-list create-search-engine-list myInfecttedAgentset


  ;this function reports a list of non-infected friends of infected nodes (Optional Infected List (OIL)
  let myOptionalToInfectlist []
  ask myInfecttedAgentset
  [ask link-neighbors with [message = 0]
    [set myOptionalToInfectlist lput who myOptionalToInfectlist ] ]
  set myOptionalToInfectlist remove-duplicates myOptionalToInfectlist


  foreach myOptionalToInfectlist
  [ask turtle ?
    [set color green
      set size 1
    ]
  ]

  ; chose opinion to adopt for every agent that is exposed to the message
  foreach optional-infect-list ; OIL
    [ask turtle ?
      [if (Group-influence-type = "WOM")
        [set message vote-message-WOM self         ; good for remove-zero = TRUE as well as remove-zero = FALSE

        ]

      if (Group-influence-type = "WEB")
        [ set message vote-message-WEB2  search-result-list

        ]
      ]
    ]

  ask turtles with [message != 0]
    [ set size 1
      show-turtle
      set color (message * 10 + 5)
      ;set infection-count infection-count + 1 ;; incremement infection-count of the node doing the infection
      set num-infected num-infected + 1
    ]

  do-plotting
  compute-distributions
  tick
  if (all? turtles [message != 0])
    [set final-distribution compute-reporter
      set dist-non-zero distribution-no-zeroes
      stop]

end

;;;;;;;;;;;;;;;;
;;; Plotting ;;;
;;;;;;;;;;;;;;;;
to do-plotting
  ;; plot the number of infected individuals at each step
  set-current-plot "Number infected"
  set-current-plot-pen "num-inf"
  set num-infected count turtles with [message != 0]
  plotxy ticks num-infected /  num-nodes
end


to toggle-tree
  ;; toggle infection tree mode
  ;; when tree-mode is on, only links responsible for contagion and infected nodes
  ;; are displayed. tree-mode also affects layout
  ifelse tree-mode? ;on
    [ask turtles [show-turtle]
      ask links [show-link]
      set tree-mode? false]
    [ask turtles with [message = 0]  [hide-turtle]
      ask turtles with [message != 0] [show-turtle]
      ask links with [color != red - 1] [hide-link]
      ask links with [color = green ] [show-link]
      set tree-mode? true ]
end

;;;;;;;;;;;;;;
;;; Layout ;;;
;;;;;;;;;;;;;;
to do-layout
  if layout?
    [repeat 10 [layout-spring turtles links 0.01 10 1]
      ;repeat 10 [layout-spring (turtles with [color = green]) (links with [color = green]) 0.01 10 5]
      repeat 10 [layout-spring (turtles with [message != 0]) (links with [color = red - 1]) 0.5 20 10]
    ]
  display
end

to-report vote-message-WOM [node]
  ; This reporter receives a non-infected node (in a turtle agent form not just a number) and
  ; reports the oppinion this node would choose if debating between several simmilar oppinions.
  ; The algorithm sample k (with repetition) neigbhors and builds a list "opp-list" of their oppinions.
  ; Then, it randomely choses one opinion from opp-list.

  let mylist []
  ask node
    [ask link-neighbors
      [set mylist lput message mylist]]
  if remove-zero?
    [set mylist remove 0 mylist]
  if k-oppinion < length(mylist)
    [set mylist n-of k-oppinion mylist]
  let result one-of mylist

  report result
end

to-report create-search-engine-list [Agentset]; this function receives as INPUT of an agentset and returns
                                              ; as OUTPUT a list of nodes sorted by the PageRank of their holders
  let oplist []
   let sortagents sort-on [nw:page-rank] Agentset
   foreach sortagents
     [set oplist fput [message] of ? oplist

     ]
  report oplist
end

;OK
to-report vote-message-WEB2 [mylist]  ;turtle procedure
                                      ;this function reports the voted message in the WEB dynamics for one turtle

                                      ;create the list of k opinions of a debating user taking into consideration the SERP function
  let k-opp-list k-list mylist
  let chosenMessage []
  ;choses one opinion by the most common or random of most commons if few have same comonness
  if length(k-opp-list) > 0
    [;set chosenMessage one-of modes k-opp-list
      set chosenMessage one-of modes k-opp-list


    ]
    report chosenMessage
end




to-report histomize [ #list ] ; this amazing (fount in the internet) function receives a list and reports a list of two lists.
                              ;; reports a list of two lists:
                              ;; the first is a sorted list of unique values in given list,
                              ;; the second is a list of corresponding counts of each value.
  set #list sort #list
  report list
  remove-duplicates #list
  but-first reduce [ifelse-value (first ?1 = ?2)  ; if same value...
    [lput (1 + last ?1) but-last ?1]  ; incr count
    [fput ?2 lput 1 but-first ?1]]    ; new value
  fput list (first #list) 1 but-first #list
end


;ok
to-report compute-reporter  ;this function reports the histomize results in a more fitting format
  let result []
  let ans [message] of turtles
  let res histomize ans

  let res-length length ans
  foreach item 1 res
    [set result lput (precision (?1 / res-length) 4) result]
  report sort-by > result
end

to-report compute-reporter-new [chosen] ;this function reports the histomize results in a more fitting format
  let result []
  let ans [message] of chosen

  let res histomize ans

  let res-length length ans
  foreach item 1 res
    [set result lput (precision (?1 / res-length) 4) result]

  report sort-by > result
end

to-report distribution-no-zeroes  ; reports the list of non infected turtles
  let a turtles with [message != 0]

  report sort-by > compute-reporter-new a
end


;used
to-report optional-infect-list             ;observer procedure
                                           ;this function reports a list of non-infected friends of infected nodes
  let mylist []
  ask turtles with [message != 0][ask link-neighbors with [message = 0][set mylist lput who mylist ] ]
  set mylist remove-duplicates mylist

  foreach mylist [ask turtle ?
    [
       set color green
      set size 1]]
  report mylist
end



to compute-distributions ;this function recompute all the distributions
  set final-distribution compute-reporter
  set dist-non-zero distribution-no-zeroes
end



;OK
to-report k-list [srl] ; this function receives as an INPUT the searth results opinion list
                       ; and reurtns as OUTPUT a list of k opinions that would be read by a user according to the SERP function
                       ; If the SERP function returns an opinion that is in position larger than the existing nuber of opinions, the function would not include this opinion in the list
  let klist []

  ; the a and b are the parameters in the equation  y=aX^-b which has an inverse inverse(y): y=(x/a)^(1/b)
  let a 0.11
  let b 0.46
  let lengthlist length srl

  repeat k-oppinion
  [
    let u random-float 1
    let rank exp(5 * u - (5 / 4) )
    set rank int(rank) + 1
    ifelse (rank < lengthlist)
      [set klist lput item rank srl klist]
      []
  ]
  ; produce a list of opinions that are located in positon
  report klist
end
@#$#@#$#@
GRAPHICS-WINDOW
340
10
805
496
54
54
4.18
1
10
1
1
1
0
0
0
1
-54
54
-54
54
1
1
1
ticks
30.0

BUTTON
5
10
71
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
205
117
306
150
spread
spread\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
103
117
203
150
spread once
spread
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
175
11
265
44
plot?
plot?
0
1
-1000

SWITCH
80
11
170
44
layout?
layout?
0
1
-1000

BUTTON
140
152
214
185
layout
do-layout
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
150
46
253
79
m
m
1
50
8
1
1
NIL
HORIZONTAL

SLIDER
3
46
147
79
num-nodes
num-nodes
3
5000
5000
1
1
NIL
HORIZONTAL

PLOT
4
200
305
361
Number infected
time
n
0.0
10.0
0.0
1.0
true
true
"" ""
PENS
"num-inf" 1.0 0 -2674135 true "" ""

SLIDER
2
82
147
115
prob-pref
prob-pref
0
1
1
0.01
1
NIL
HORIZONTAL

MONITOR
271
10
328
55
nodes
count turtles
3
1
11

BUTTON
3
117
107
150
reinfect once
reinfect-once
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
3
152
137
185
toggle infection tree
toggle-tree
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
848
241
966
286
num-infected
num-infected
3
1
11

SLIDER
5
385
177
418
num-infected-init
num-infected-init
1
20
45
1
1
NIL
HORIZONTAL

CHOOSER
848
140
990
185
Group-influence-type
Group-influence-type
"WEB" "WOM"
0

SLIDER
3
429
175
462
num-oppinions
num-oppinions
0
50
40
1
1
NIL
HORIZONTAL

SLIDER
847
193
1019
226
k-oppinion
k-oppinion
0
20
5
1
1
NIL
HORIZONTAL

PLOT
847
340
1265
490
Oppinion_Distribution
Oppinions
Num Nodes with oppinion x
1.0
55.0
0.0
10.0
true
true
"" ""
PENS
"colordist" 1.0 1 -16777216 false "" "histogram [message] of turtles"

MONITOR
812
59
1227
104
# opinions
sort-by > remove-duplicates [message] of turtles
17
1
11

MONITOR
814
10
1265
55
Proportion of opinions (Sorted)
dist-non-zero
4
1
11

@#$#@#$#@
## WHAT IS IT?

A model of diffusion of ideas in a many opinion environment that include two methods of spread.
1) WOM -> word of mouth
2) WEB -> search engines spread dynamics

## HOW IT WORKS
The model starts with "num-infected-init" (see slider) nodes which can have any of the "num-opinions" (see slider) opinions. 
At each step, the opinions might spread to any of their neighbors along a WOM dynamics, (word of mouth), by which each node can adopt the opinion of its social neighbors, or according to WEB dynamics (web search engine), by which a node adopts an opinion according to its likelihood to appear in a search engine query.

## HOW TO USE IT
1. Press "Setup" to create a power law network.

2. Press "Reinfect-once" to distribute the initial opinions to few random nodes.

3. Set the k-opinion slider, which represents the number of opinion which a user reads before choosing his/her own opinion.

4. Choose the model in the "group-influence-type" selection, to WOM or to WEB.

5. Press "spread" to repeatedly spreading the different ideas along the population.


## THINGS TO NOTICE

The distribution of ideas is more narrow (less ideas spread to more nodes, while rare ideas disappear) in the WEB as compared to the WOM model.
This can be seen by the histogram, (bottom right) as well as the "proportion of opinion" and "#opinion" monitors

## CREDITS AND REFERENCES

For more detail, see the Europhysics letters (EPL) article

Alon Sela, Louis Shekhtman, Shlomo Havlin and Irad Ben-Gal, 
Comparing the diversity of information by word-of-mouth vs. web spread, 
Europhysics letters (EPL), 114(5)

http://iopscience.iop.org/article/10.1209/0295-5075/114/58003/meta

Based on an initial model 
Copyright 2008 Uri Wilensky. Modified by Lada Adamic 2009.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
set layout? false
setup repeat 175 [ go ]
repeat 35 [ layout ]
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="17.11.15" repetitions="25" runMetricsEveryStep="true">
    <setup>setup
reinfect-once</setup>
    <go>spread</go>
    <timeLimit steps="1000"/>
    <metric>dist-non-zero</metric>
    <enumeratedValueSet variable="num-infected-init">
      <value value="15"/>
      <value value="30"/>
      <value value="45"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="m">
      <value value="2"/>
      <value value="4"/>
      <value value="8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="debug?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plot?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Group-influence-type">
      <value value="&quot;WEB&quot;"/>
      <value value="&quot;WOM&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-oppinion">
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prob-pref">
      <value value="0"/>
      <value value="0.5"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-nodes">
      <value value="5000"/>
      <value value="10000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="layout?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="remove-zero?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-oppinions">
      <value value="40"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
