; nivi.nlogo "NETLOGO INTERFACE VARIABLES INFORMATION"
; version 1.3
; Requires Netlogo 6.0
; 8 Feb 2017
; Author Doug Edmunds.
; Extracts variables and code hidden behind interface widgets.

extensions [csv]

globals [infile mydata mydata-list
  first_block button_count monitor_count input_count
  slider_count switch_count plot_count pen_count chooser_count
  report-title use-csv?]


to setup
  ca
  ask patches [set pcolor white]
  set first_block 0
  set button_count  0
  set monitor_count  0
  set input_count  0
  set slider_count  0
  set plot_count  0
  set pen_count  0
  set chooser_count 0
  set mydata-list []
  set use-csv? true

  file-close-all
  clear-output
  set infile user-file
  let file_ext ".nlogo"
  ifelse is-string? infile and
         substring infile (length infile - 6 ) (length infile) = file_ext
    [
    file-open infile
    set report-title "nivi - NETLOGO INTERFACE VARIABLES INFORMATION"
    output-print report-title
    output-print infile
    output-print word "Generated: " date-and-time
    reset-ticks
     ]
    [output-print "No file selected. *.nlogo files only"]
  ;reset-ticks
end

to go
  if is-string? infile
    [
    file-open infile
    ifelse file-at-end?
      [ output-print "end of infile"]
      [ parse-file ]
      file-close-all
    ]
end

to-report netlogo-delimiter
  report (word "@#$#" "@#$#@")
end

to parse-file
  while [first_block < 2]

  [ file-open infile
    ifelse file-at-end? ; should not happen
     [ set first_block 9999
       output-print "Reached end of file."
       output-print "Is this a Netlogo .logo file?"]
     [set mydata file-read-line]

    ;allow to exit the while loop
    if first_block = 1 and mydata = netlogo-delimiter [
      set first_block 2
      ;print "ending first_block = 2"
      ]


    if first_block = 1 [

     ;BUTTONS
     if button_count = 6 [output-print word "var: " mydata]
     if button_count = 6 [set button_count  0]  ; reset
     if button_count = 5 [output-print word"label: " mydata]
     if button_count = 5 [set button_count  6]
     if button_count = 4 [set button_count  5]
     if button_count = 3 [set button_count  4]
     if button_count = 2 [set button_count  3]
     if button_count = 1 [set button_count  2]
     if mydata = "BUTTON" [set button_count  1]
     if button_count = 1 [output-print  mydata]

     ;MONITORS
     if monitor_count = 6 [output-print word "var: " mydata ]
     if monitor_count = 6 [set monitor_count  0]
     if monitor_count = 5 [output-print word "label: " mydata]
     if monitor_count = 5 [set monitor_count  6]
     if monitor_count = 4 [set monitor_count  5]
     if monitor_count = 3 [set monitor_count  4]
     if monitor_count = 2 [set monitor_count  3]
     if monitor_count = 1 [set monitor_count  2]
     if mydata = "MONITOR" [set monitor_count 1]
     if monitor_count = 1 [output-print mydata]

     ;INPUT BOXES
     if input_count = 5 [output-print mydata]
     if input_count = 5 [set input_count  0]
     if input_count = 4 [set input_count  5]
     if input_count = 3 [set input_count  4]
     if input_count = 2 [set  input_count 3]
     if input_count = 1 [set input_count  2]
     if mydata = "INPUTBOX" [set input_count  1]
     if input_count = 1 [output-print mydata]

     ;SLIDERS
     if slider_count = 5 [output-print mydata ]
     if slider_count = 5 [set slider_count  0]
     if slider_count = 4 [set slider_count  5]
     if slider_count = 3 [set slider_count  4]
     if slider_count = 2 [set slider_count  3]
     if slider_count = 1 [set slider_count  2]
     if mydata = "SLIDER" [set slider_count  1]
     if slider_count = 1 [output-print mydata]

     ;SWITCHES
     if switch_count = 5 [output-print mydata]
     if switch_count = 5 [set switch_count  0]
     if switch_count = 4 [set switch_count  5]
     if switch_count = 3 [set switch_count  4]
     if switch_count = 2 [set switch_count  3]
     if switch_count = 1 [set switch_count  2]
     if mydata = "SWITCH" [set switch_count 1]
     if switch_count = 1 [output-print mydata]

     ;CHOOSERS
     if chooser_count = 7 [output-print mydata]
     if chooser_count = 7 [set chooser_count  0]
     if chooser_count = 6 [output-print mydata]
     if chooser_count = 6 [set chooser_count  7]
     if chooser_count = 5 [set chooser_count  6]
     if chooser_count = 4 [set chooser_count  5]
     if chooser_count = 3 [set chooser_count  4]
     if chooser_count = 2 [set chooser_count  3]
     if chooser_count = 1 [set chooser_count  2]
     if mydata = "CHOOSER" [set chooser_count 1]
     if chooser_count = 1 [output-print mydata]

     ;PLOTS AND PENS
     if plot_count = 14 [
        test-use-csv
        ifelse use-csv?
         [find-dq
          set mydata-list  ( csv:from-row mydata " " )
          revert-dq 0
          revert-dq 1
          output-print word "Plot setup: "  item 0 mydata-list
          output-print word "Plot update: " item 1 mydata-list ]
        [ output-print word "setup/update: " mydata ]
        ]
     if plot_count = 14 [set plot_count  0]
     if plot_count = 13 [set plot_count  14]
     if plot_count = 12 [set plot_count  13]
     if plot_count = 11 [set plot_count  12]
     if plot_count = 10 [set plot_count  11]
     if plot_count = 9  [set plot_count  10]
     if plot_count = 8  [set plot_count  9]
     if plot_count = 7  [set plot_count  8]
     if plot_count = 6  [set plot_count  7]
     if plot_count = 5  [output-print word "title: " mydata]
     if plot_count = 5  [set plot_count  6]
     if plot_count = 4  [set plot_count  5]
     if plot_count = 3  [set plot_count  4]
     if plot_count = 2  [set plot_count  3]
     if plot_count = 1  [set plot_count  2]
     if mydata = "PLOT" [set plot_count  1]
     if plot_count = 1  [output-print mydata]

     if pen_count = 2
      [if mydata != "" [
         test-use-csv
         ifelse use-csv?
          [ find-dq
            set mydata-list  (csv:from-row mydata " ")
            revert-dq 0
            revert-dq 5
            revert-dq 6
            output-print word "Name: " item 0 mydata-list
            output-print word " setup:  " item 5 mydata-list
            output-print word " update: " item 6 mydata-list
            ]
          [ output-print word "Name-setup-update: " mydata]
          ]
        if mydata = ""  [set pen_count  0]
       ]
     if mydata = "PENS"[set pen_count  1]
     if pen_count = 1  [output-print mydata]
     if pen_count = 1  [set pen_count  2]

  ] ; end of if first_block = 1


 ;file-read-line skips everything until this next line is true
 if first_block = 0 and mydata = netlogo-delimiter
      [ set first_block  1 ]
  tick
  ] ; end while [first_block < 2]
 end


to test-use-csv
  set use-csv? true
  ; false only if "@@" in the original
  let at-at? position "@@" mydata
  if is-number? at-at? [set use-csv? false]

end

to find-dq
  ; one string
  ; use @@ as the substitute, hopefully available
  ; if it already contains @@, then don't use csv:from-row
  let more-loops? true
  while [more-loops?]
  [
    let pos1 position "\\\"" mydata ; that finds \", all or nothing
    ifelse is-number? pos1  ; found pattern
      [  set mydata replace-item pos1 mydata "@"
         set mydata replace-item (pos1 + 1) mydata "@" ]
      [  set more-loops? false]
   ]
end


to revert-dq [myitem-number]
  ; this had to be done for each item Pens 0, 5, 6, Plots 0, 1
  let more-loops? true
  while [more-loops?]
  [
    let myitem-val item myitem-number mydata-list
    let pos1 position "@@" myitem-val
    ifelse is-number? pos1  ; found pattern
      [
        let pos2 pos1 + 1
        set myitem-val replace-item pos1 myitem-val "\\"
        set myitem-val replace-item pos2 myitem-val "\""
        set mydata-list replace-item myitem-number mydata-list myitem-val
        ]
      [ set more-loops? false ]
   ]
end
@#$#@#$#@
GRAPHICS-WINDOW
225
95
398
119
-1
-1
5.323
1
10
1
1
1
0
1
1
1
-15
15
-1
1
1
1
1
ticks
30.0

BUTTON
23
10
105
43
Select file
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

OUTPUT
205
10
584
480
12

BUTTON
110
10
173
43
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
25
70
180
120
Highlight the text then \ncopy/paste the output into \nyour file.
11
0.0
1

TEXTBOX
25
135
175
176
If \"Label\" is NIL, it means the widget is using the variable name as the label.
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

It is a handy tool.

1) Use it to document your own code
2) Use it to help figure out what's going on with a nlogo file.


It shows you what's behind the widgets on the interface.

## HOW IT WORKS

It reads the nlogo file line by line, and either displays something or ignores it.

## HOW TO USE IT

1) Press Select File and select a file.
2) Press Go

Beyond that, if you want to save the output, highlight everything in the output window and copy/paste it somewhere.

## THINGS TO NOTICE

How the code has a bazillion if clauses, but they are in a particular order.

## THINGS TO TRY

Try it on all kinds of nlogo files.  If you find a problem let the author know
(dougedmunds at gmail dot com).

## EXTENDING THE MODEL

With some hunting around, you could figure out other details about the widgets.


## CREDITS AND REFERENCES

Doug Edmunds developed version 1.0, September 2015.
The file is located at http://netlogo.dougedmunds.com

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
