breed [bacteria bacterium]

bacteria-own [resistance age division]
patches-own [drug]

globals [count-clone]

to setup
  ca

 ifelse Choose-view = "Bacteria" [setup-1][setup-2]

  reset-ticks

end


to setup-1
  setup-bacteria-1
  setup-patches
  ask bacteria [survival]
end


to setup-2
  setup-bacteria-2
  setup-patches
    ask bacteria [survival]
end


to setup-bacteria-1
create-bacteria 500
[
  set size 0.75
  set shape "bacteria"
  set age 1
  set resistance 1 + random-float 1
  set-color-resistance
  setxy random-xcor random-ycor]
end

to setup-bacteria-2
  ask patches with [abs pxcor = max-pxcor]
[sprout-bacteria 1
  [set size 0.85
  set-shape
  set age 1
  set resistance 1 + random-float 1
      ;set color 6]
    set-color-resistance]
  ]

end

to set-color-resistance
  if resistance < 10 [set color 6]
  if resistance < 25 and resistance >= 10 [set color 66]
  if resistance < 50 and resistance >= 25 [set color 46]
  if resistance >= 50 [set color 15]
end

to set-shape
  if resistance < 10 [set shape "face happy"]
  if resistance < 25 and resistance >= 10 [set shape "face neutral" ]
  if resistance < 50 and resistance >= 25 [set shape "face sad"]
  if resistance >= 50 [set shape "evil-b"]
end

to setup-patches
  ask patches [set pcolor 3.25 set drug 50]  ;first set peak drug zone
  ask patches with [pxcor > max-pxcor * 0.2] [set pcolor 2.5 set drug 25]  ;high drug zone
  ask patches with [pxcor < min-pxcor * 0.2] [set pcolor 2.5 set drug 25]  ;high drug zone
  ask patches with [pxcor >= max-pxcor * 0.5] [set pcolor 1.75 set drug 10]  ;medium drug zone
  ask patches with [pxcor <= min-pxcor * 0.5] [set pcolor 1.755 set drug 10]  ;medium drug zone
  ask patches with [pxcor >= max-pxcor * 0.75] [set pcolor 1 set drug 1]  ;low drug zone
  ask patches with [pxcor <= min-pxcor * 0.75] [set pcolor 1 set drug 1]  ;low drug zone

end


to go
  tick

  ifelse Choose-view = "Bacteria"
  [ask bacteria [move reproduce-1 survival death] overpopulation]
  [ask bacteria [grow reproduce-2 survival death]]

  if count bacteria <= 0 [stop]
end


to move
  if random 100 < 5
    [rt random 360 fd 0.5 survival]
  set age age + 1
end


to survival
  if drug > resistance [die]
end

to reproduce-1
  if color = 6 [if random 20 < Low-res-growth-rate [reproduction]]
  if color = 66 [if random 20 < medium-res-growth-rate [reproduction]]
  if color = 46 [if random 20 < high-res-growth-rate [reproduction]]
  if color = 15 [if random 20 < superbug-growth-rate [reproduction]]
end


to reproduction
  hatch 1
  [if random 100 < Mutation-rate
    [
    set age 1
    set shape "bacteria"
    ifelse random 2 = 0 [set resistance resistance + random-float mutation-range][set resistance resistance - random-float mutation-range]
    set-color-resistance
    survival
    fd 1
    ]]
end


to death
  if age >= 10 [die]
end

to overpopulation
  ask patches [
    let clone bacteria-here
    if clone != nobody and count bacteria-here > 25
    [
     ; if random 2 = 0 [
        ask clone [die]]]
 ; ]
end

to grow
  set age age + 1
end

to reproduce-2
  if color = 6 [if random 20 < Low-res-growth-rate [reproduction-1]]
  if color = 66 [if random 20 < medium-res-growth-rate [reproduction-1]]
  if color = 46 [if random 20 < high-res-growth-rate [reproduction-1]]
  if color = 15 [if random 20 < superbug-growth-rate [reproduction-1]]
end

to reproduction-1
  let p one-of neighbors with [not any? turtles-here]
  if p != nobody [
   hatch 1 [
    set age 1
    set-color-resistance
    set-shape
    if random 100 < Mutation-rate [
    ifelse random 2 = 0
      [set resistance resistance + random-float mutation-range]
      [set resistance resistance - random-float mutation-range]
    ]
      face p
      move-to p
     survival]
  ]
end

to increase-dose
  ask patches
[set drug drug + 10
if drug >= 200 [set drug 200]]

let no-drug one-of patches with [drug >= 200]
if no-drug != nobody
[user-message ("Certain zones have reached the highest dose. We can't increase it any higher.Click 'OK' to continue.")]

ask patches [
if mean [drug] of patches = 200 and variance [drug] of patches = 0
[set pcolor 0]
]
end

to decrease-dose
  ask patches
[set drug drug - 5
if drug <= 0 [set drug 0]]

let no-drug one-of patches with [drug <= 0]
if no-drug != nobody
[user-message ("There is no antibiotics in certain zones. Click 'OK' to continue.")]


ask patches [
if mean [drug] of patches = 0 and variance [drug] of patches = 0
[set pcolor 3]
]
end
@#$#@#$#@
GRAPHICS-WINDOW
11
10
655
319
-1
-1
12.0
1
10
1
1
1
0
1
1
1
-26
26
-12
12
0
0
1
ticks
30.0

BUTTON
665
60
782
93
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
666
98
783
131
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
10
371
297
557
Distribution of Antibiotic Resistance
NIL
NIL
0.0
60.0
0.0
200.0
true
false
"" ""
PENS
"default" 0.1 1 -5825686 true "set-plot-x-range 0 (round max [resistance] of bacteria) + 1\nhistogram [resistance] of bacteria" "set-plot-x-range 0 (round max [resistance] of bacteria) + 1\nhistogram [resistance] of bacteria"

SLIDER
667
183
850
216
Mutation-range
Mutation-range
0
3
3.0
0.5
1
NIL
HORIZONTAL

BUTTON
791
24
893
57
Increase dose
increase-dose
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
791
61
894
94
Decrease dose
decrease-dose
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
300
370
386
415
Low Dose
mean [drug] of patches with [pxcor <= min-pxcor * 0.75 or pxcor >= max-pxcor ]
1
1
11

MONITOR
300
510
385
555
Peak Dose
mean [drug] of patches with [pxcor >= min-pxcor * 0.2 and pxcor <= max-pxcor * 0.2 ]
1
1
11

MONITOR
300
464
385
509
High Dose
mean [drug] of patches with [(pxcor > min-pxcor * 0.5 and pxcor < min-pxcor * 0.2) or (pxcor < max-pxcor * 0.5 and pxcor > max-pxcor * 0.2)  ]
1
1
11

PLOT
516
370
891
556
# of bacteria with different resistance
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Low resistance" 1.0 0 -5987164 true "plot count bacteria with [resistance <= 5]" "plot count bacteria with [resistance < 10]"
"Medium resistance" 1.0 0 -13840069 true "plot count bacteria with [resistance > 5 and resistance <= 50]" "plot count bacteria with [resistance >= 10 and resistance < 25]"
"High resistance" 1.0 0 -987046 true "plot count bacteria with [resistance > 50]" "plot count bacteria with [resistance >= 25 and resistance < 50]"
"Superbug" 1.0 0 -2674135 true "" "plot count bacteria with [ resistance >= 50]"

MONITOR
10
323
117
368
Total # Bacteria
count bacteria
17
1
11

MONITOR
122
323
285
368
Current highest resistance
max [resistance] of bacteria
1
1
11

TEXTBOX
294
325
444
343
|Gray: Low resistance strain
11
4.0
1

TEXTBOX
446
325
645
353
|Green: Medium resistance strain
11
64.0
1

TEXTBOX
458
342
635
363
|Red: Superbug
11
15.0
1

TEXTBOX
35
297
117
315
Low Dose
9
9.9
1

TEXTBOX
197
297
251
315
High Dose
9
9.9
1

TEXTBOX
587
297
638
315
Low Dose
9
9.9
1

TEXTBOX
419
296
500
314
High Dose
9
9.9
1

TEXTBOX
316
297
423
315
Peak Dose
9
9.9
1

MONITOR
300
417
386
462
Medium Zone
mean [drug] of patches with [(pxcor > min-pxcor * 0.75 and pxcor <= min-pxcor * 0.5) or (pxcor < max-pxcor * 0.75 and pxcor >= max-pxcor * 0.5)  ]
1
1
11

TEXTBOX
294
341
487
362
|Yellow: High resistance strain
11
44.0
1

BUTTON
791
99
896
132
Clear Antibiotic
ask patches [set drug 0 set pcolor 0]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
667
220
888
253
Low-res-growth-rate
Low-res-growth-rate
1
20
20.0
1
1
NIL
HORIZONTAL

SLIDER
667
256
889
289
Medium-res-growth-rate
Medium-res-growth-rate
0
20
14.0
1
1
NIL
HORIZONTAL

SLIDER
667
292
890
325
High-res-growth-rate
High-res-growth-rate
1
20
10.0
1
1
NIL
HORIZONTAL

SLIDER
667
327
890
360
superbug-growth-rate
superbug-growth-rate
1
20
6.0
1
1
NIL
HORIZONTAL

TEXTBOX
498
297
569
315
Medium Dose
9
9.9
1

TEXTBOX
112
297
181
315
Medium Dose
9
9.9
1

MONITOR
389
370
513
415
Low-res-Bacteria
Count bacteria with [color = 6]
1
1
11

MONITOR
389
417
513
462
Medium-res-Bacteria
Count bacteria with [color = 66]
1
1
11

MONITOR
389
464
513
509
High-res-Bacteria
Count bacteria with [color = 46]
1
1
11

MONITOR
389
511
513
556
Superbug
Count bacteria with [color = red]
0
1
11

SLIDER
667
148
850
181
Mutation-rate
Mutation-rate
0
100
20.0
5
1
NIL
HORIZONTAL

CHOOSER
664
10
782
55
Choose-view
Choose-view
"Bacteria" "Icons"
0

@#$#@#$#@
## WHAT IS IT?

This model reveals the same scenario in the giant petri dish experiment on the evolution of antibiotic resistance conducted by the researchers from Harvard Medical School and Technion-Israel Institute of Technology (http://news.harvard.edu/gazette/story/2016/09/a-cinematic-approach-to-drug-resistance/). Mutation and reproduction rates are included to expand user's exploration of the process.


## HOW IT WORKS
* The antibiotic concentrations are set at low, medium, high, and peak levels from two sides to the center of the model.
* The model starts from the strain with resistance between 1-2.
* The bacteria reproduce asexually. 
* At a chance of defined mutation-rate, the offspring resistance may increase or decrease within the mutation range.
* In each tick, all bacteria may move a small distance in a random direction. 
* User may adjust the growth rates of the strain with different resistance. Note: we should not assume the growth rate being the same or different. Remember, this is a model. It helps us generate ideas. We need empirical evidence to test the ideas. 
* The nutrient in a patch may run out and lead to the death of the bacteria on the patch. But the nutrient is refilled in the next tick on the patch (which does not happen in real bacterial culture).
* The model has two views. The bacteria view gives a more realistic view, while the icon view allows the model to run faster. 

## WHAT CAN YOU TRY?

Quite a few things you can try in this simulation:

1. How does the mutation range affect the evolution of antibiotic resistance?
2. How does the growth rate affect the competition among strains with different resistance when antibiotics are present?
3. How does the growth rate affect the competition among strains with different resistance when antibiotics are absent?
4. What happens when all strains have the same growth rate?
5. Does the strain with higher resistance always appear where the antibiotic concentration is higher?
6. What will happen when you keep increasing dose?

## CREDITS AND REFERENCES

This model is made by Dr. Lin Xiang in 2017 and revised in 2021 at the University of Kentucky. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2021). Evolution of antibiotic resistance. Department of STEM Education, University of Kentucky , Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bacteria
true
0
Polygon -7500403 true true 150 30 135 30 117 40 105 60 102 150 105 240 117 260 135 270 150 270 165 270 184 260 195 240 199 151 195 60 183 38 165 30

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

evil-b
false
0
Circle -7500403 true true 0 0 300
Polygon -16777216 true false 117 128 98 116 68 86 53 71 38 86 38 116 38 131 53 146 98 146 128 146 143 146
Polygon -16777216 true false 183 128 202 116 232 86 247 71 262 86 262 116 262 131 247 146 202 146 172 146 157 146
Polygon -16777216 true false 21 165 38 205 65 235 111 265 167 275 220 259 263 220 280 176 283 161 263 196 228 219 182 234 132 233 75 220 44 197
Polygon -16777216 true false 160 124 157 146 167 156 189 162 159 161 149 146
Polygon -16777216 true false 140 124 143 146 133 156 111 162 141 161 151 146
Polygon -16777216 true false 245 73 258 67 278 101 280 132 268 91
Polygon -16777216 true false 55 73 42 67 22 101 20 132 32 91

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Line -16777216 false 75 210 225 210

face neutral-1
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 210

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count bacteria with [resistance &lt;= 10]</metric>
    <metric>count bacteria with [resistance &gt; 10 and resistance &lt;= 50]</metric>
    <metric>count bacteria with [resistance &gt; 50]</metric>
    <enumeratedValueSet variable="High-res-strain-growth-rate">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="super-bug-growth-rate">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Mutation-range">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Low-res-strain-growth-rate">
      <value value="10"/>
    </enumeratedValueSet>
    <steppedValueSet variable="bacteria-per-patch" first="10" step="5" last="40"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
