patches-own [
  new-pcolor ;; only for wheee demo
]

to-report deep-color-1 [ value ]
  report (
  red + 10 * (value mod 13) ;; base netlogo color
  ;; shift up or down
  +  .5 * ( (int (value / 13 )) mod 2 * 2 - 1) ;; alternate normal -1, +1
  ;; increase difference (gets brighter and darker)
  * (1 + int ( value / ( 2 * 13 )))
  )
end

to-report deep-color-2 [ value gamut shades ]
  ;; color from the wheel
  let hue (value mod gamut) / gamut * 360
  ;; ring determines shift in brightness
  let ring ( int (value / gamut) ) mod shades
  ;; thickness of the slice of brightness
  ;; 160, not 200, so that brightest is not white and darkest is not black
  let thick 160 / shades
  ;; calculate it (180 for same reasons as 160, above (min bright is 20, max sat is 180))
  let brightness 180 - ( ring * thick )
  let saturation 100
  if brightness > 100
  [ set saturation (200 - brightness)
    set brightness 100

  ]
  report HSB hue saturation (brightness)
end

to-report min-max [$value $min $max ]
  ( ifelse
    ( $value < $min ) [ report $min   ]
    ( $value > $max ) [ report $max   ]
    [                   report $value ]
  )
end

to adjust-world-view [ $width $height  $pix-width-limit $pix-height-limit]

  let #max-height min-max $height 1 $pix-height-limit
  let #max-width min-max $width 1 $pix-width-limit
  let #p1 min-max ($pix-height-limit / #max-height) 1 40
  let #p2 min-max ($pix-width-limit / #max-width) 1 40
  let #p max list 1 min list #p1 #p2
  set-patch-size #p
  resize-world 0 (#max-width - 1) 0 (#max-height - 1)
  set-patch-size #p
end

to test-deep-color-1
  ca
  adjust-world-view 13 16 1000 500
  foreach sort patches
  [ p ->
    ask p
    [ sprout 1
      [
        set color (deep-color-1 who)
        set pcolor color
      ]
    ]
  ]
end

to test-deep-color-2
  ca
  adjust-world-view $gamut $shades 1000 500
  foreach sort patches
  [ p ->
    ask p
    [
      sprout 1
      [
        set color (deep-color-2 who $gamut $shades)
        set pcolor color
      ]
    ]
  ]
end

to startup
  test-deep-color-1
end


;; setup and go here are mainly for the modeling commons thumbnail generator

to setup
   test-deep-color-1
end

to go
 ask turtles
  [ rt (random 2 * 2 - 1)
    jump 1 / patch-size
  ]
end

@#$#@#$#@
GRAPHICS-WINDOW
330
10
788
447
-1
-1
26.31578947368421
1
10
1
1
1
0
1
1
1
0
19
0
18
0
0
1
ticks
30.0

BUTTON
15
210
135
243
NIL
test-deep-color-1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
10
10
185
107
unique-colors
length remove-duplicates [ pcolor ] of patches
0
1
24

BUTTON
180
210
300
243
NIL
test-deep-color-2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
180
130
300
163
$gamut
$gamut
3
100
20.0
1
1
NIL
HORIZONTAL

SLIDER
180
170
300
203
$shades
$shades
1
50
19.0
1
1
NIL
HORIZONTAL

TEXTBOX
20
250
157
388
Deep-color1 - converts a number (like a WHO number) in to a NetLogo color, alternating between dimmer and brighter versions of the basic colors, with the difference increasing in intensity
11
0.0
1

TEXTBOX
185
250
315
354
Deep-color-2 -- convert an integer (like WHO) into a color by slicing up the \"color wheel\". Each time \"around the wheel\" the color gets darker. 
11
0.0
1

BUTTON
190
10
265
43
Wheee!
every .033 [ go ]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

Demonstrates a method of obtaining many unique colors.

Method one provides a variety of shades of the basic nectlogo colors.

Method two provides a variety of hues in various shades from the HSB color space.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

square
true
0
Polygon -7500403 true true 30 45 255 30 255 270 30 255
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

plain
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
false
0
@#$#@#$#@
1
@#$#@#$#@
