breed [Bs B]
breed [BHs BH]
breed [OHs OH]
breed [H3OS H30]
breed [legends legend]

turtles-own[ ]
globals [
  mode
  kb
  ka
  Num-H Num-OH num-B num-BH
  vol-1 vol-titrant
  current-conc-H
  current-conc-OH
  current-conc-B
  current-conc-BH
  current-ph
  current-pOH
  M-H
  M-T
  M-OH
  M-BH
  M-B
  M-B-1
  unit-num-b
   ]

to setup
  ca

  set-bk
  set-legends
  (ifelse
    Choose-a-base = "Sodium hydroxide" [set mode 1 set-NaOH]
    Choose-a-base = "Ammonia" [set mode 2 set-NH3])


  plot-ion-concentrations-log
  reset-ticks

end

to set-bk
  ask patches [set pcolor 91.5 + random-float 0.5]
  ask patches with [ pycor = max-pycor or pycor < 4] [set pcolor 101]
  ask patches with [ pxcor = min-pxcor or pxcor = max-pxcor] [set pcolor 101]
end

to set-NaOH
  set-default-shape ohs "ab-oh-1"
  set-default-shape h3os "ab-h3o-1"
  set-default-shape bs "ab-b-1"
  set-default-shape bhs "ab-b-2"

  set vol-1 Base-volume
  set vol-titrant 0
  set current-conc-OH Base-concentration
  set current-ph 14 - (-1 * (log current-conc-OH 10))
  set M-OH Base-concentration * vol-1 * 0.001   ;determine the mole of hydroxide
  set M-B M-OH
  set M-BH M-OH
  set current-conc-BH (M-BH / (vol-1 * 0.001))  ;determine initial conjugate acid concentration
  set current-conc-B 0                       ;there is no base molecule
  set current-Conc-H 10 ^ (-14) / current-conc-OH          ;calculate the concentration of H+
  set M-H current-Conc-H * vol-1 * 0.001                 ;calculate exisitng mole of H+

  set num-H round (1000 * (1.3895 ^ (-1 * current-ph)))     ;find the amount of visual H+
  set num-OH round (10000 / (num-H))                        ;find the amount of visual OH-

  if Hide-base-molecule-and-conjugate-acid? = false
   [create-BHs num-OH [set-tt-properties set size 1.25 set color 62]]

  if Hide-hydronium-and-hydroxide? = false
  [set num-H round (1000 * (1.3895 ^ (-1 * current-ph)))     ;find the amount of visual H+
   set num-OH round (10000 / (num-H))                        ;find the amount of visual OH-
   create-h3os num-H [set-tt-properties set size 1.25 ]
   create-ohs num-OH [set-tt-properties set size 1.25 set color 85]]
end

to set-NH3
  set-default-shape ohs "ab-oh-1"
  set-default-shape h3os "ab-h3o-1"
  set-default-shape Bs "ab-b-1"
  set-default-shape BHs "ab-b-2"

  set kb 1.8 * (10 ^ -5)
  set vol-1 Base-volume
  set vol-titrant 0
  set current-conc-OH (-0.5 * (kb - sqrt (kb * kb + 4 * kb * Base-concentration)))
  set current-ph 14 - (-1 * (log current-conc-OH 10))
  set M-B Base-concentration * vol-1 * 0.001   ;determine the mole of base
  set M-OH current-conc-OH * vol-1 * 0.001   ;determine the mole of OH-
  set M-BH M-OH
  set current-conc-B ((M-B - M-OH) / (vol-1 * 0.001))  ;determine initial base concentration
  set current-conc-BH (M-BH / (vol-1 * 0.001))  ;determine initial conjugate acid concentration

  if Hide-base-molecule-and-conjugate-acid? = false
  [set num-B round (2500 * sqrt (sqrt (M-B)))
   set num-BH round (100 * sqrt (sqrt (M-BH)))
   create-Bs num-B [set-tt-properties set size 1.25 set color 42]
   create-BHs num-BH[set-tt-properties set size 1.25 set color 62]
   set unit-num-b (M-b / num-b)]

  if Hide-hydronium-and-hydroxide? = false
  [set num-H round (1000 * (1.3895 ^ (-1 * current-ph)))     ;find the amount of visual H+
   set num-OH round (10000 / (num-H))                        ;find the amount of visual OH-
   create-h3os num-H [set-tt-properties set size 1.25 ]
   create-ohs num-OH [set-tt-properties set size 1.25 set color 85]]

 end

to set-tt-properties
   setxy 1 + random-float (max-pxcor - 2) 4 + random-float (max-pycor - 5)

end

to set-legends
 create-legends 8

 ask legend 0
  [set shape "ab-h3o-1"
    set size 1.75
    setxy 1.5 2]

  ask legend 1
  [set shape "blank"
    set size 1.5
    set label "Hydronium (H3O+)"
    set label-color white
    setxy 8.5 1.2]

  ask legend 2
   [set shape "ab-OH-1"
    set size 1.75
    set color 85
    setxy 12 2]

  ask legend 3
  [set shape "blank"
    set size 1.5
    set label "Hydroxide (OH-)"
    set label-color white
    setxy 18 1.2]

  ask legend 4
   [set shape "ab-b-1"
    set size 1.75
    set color 42.5
    setxy 22.5 2]

  ask legend 5
  [set shape "blank"
    set size 1.5
    set label "Base molecule"
    set label-color white
    setxy 27 1.2]

  ask legend 6
   [set shape "ab-b-2"
    set size 1.75
    set color 62.5
    setxy 32 2]

  ask legend 7
  [set shape "blank"
    set size 1.5
    set label "Conjugate acid"
    set label-color white
    setxy 37.5 1.2]
end

to go
if vol-titrant >= (Total-mL-of-HCl-added - 0.05) [user-message "Have added the specified amount of titrant." stop]

  move

  (ifelse
    Choose-a-base = "Sodium hydroxide" [if mode = 2 [setup] titration-NaOH]
    Choose-a-base = "Ammonia" [if mode = 1 [setup] titration-NH3])


  (ifelse
    Hide-base-molecule-and-conjugate-acid? = true and count BHs > 0
      [if any? BHs [ask BHs [die]] if any? Bs [ask Bs [die]]]
    Hide-base-molecule-and-conjugate-acid? = false and count BHs > 0
    [if Choose-a-base = "Ammonia" [dissociation]]
    Hide-base-molecule-and-conjugate-acid? = false and count BHs <= 0
    [ifelse Choose-a-base = "Ammonia"
      [set M-B-1 (current-conc-B * vol-1 * 0.001)
        let num-B-to-be round (M-B-1 / unit-num-b)
        create-bs num-b-to-be [set-tt-properties set size 1.25 set color 42]
        create-BHs (num-b - num-b-to-be + num-BH)[set-tt-properties set size 1.25 set color 62]]
      [create-BHs round (1000 * (1.3895 ^ (-1 * Base-concentration))) [set-tt-properties set size 1.25 set color 62]]])

   (ifelse
    Hide-hydronium-and-hydroxide? = true and count OHs > 0
    [ask h3os [die] ask ohs [die]]
    Hide-hydronium-and-hydroxide? = false and count ohs > 0
    [acid-base-equilibrium]
    Hide-hydronium-and-hydroxide? = false and count ohs <= 0
    [set num-H round (1000 * (1.3895 ^ (-1 * current-pH)))
     set num-OH round (10000 / (num-H))
     create-h3os num-H [set-tt-properties set size 1.25 ]
      create-ohs num-OH [set-tt-properties set size 1.25 set color 85]])


  plot-ion-concentrations-log

  tick
end


to move
  ask turtles with [breed != legends]    ;ask non-legend turtles
  [rt random 360                            ;rotate
    if [pcolor] of patch-at dx dy <= 92 and [pcolor] of patch-at dx dy >= 91.5    ;if the patch-ahead has the proper color
      [fd 0.5                                                                      ;move forward
       if ycor < 4 [set ycor 4]                                                   ;if ycor is low, put ycor higher
  ]]
end

to acid-base-equilibrium

  set num-H round (1000 * (1.3895 ^ (-1 * current-pH)))
  set num-OH round (10000 / (num-H))

  let current-H count H3Os
  let current-OH count OHs

  (ifelse
    (num-H) > current-H
     [create-h3os abs ((num-H) - current-H) [set-tt-properties set size 1.25]]
    (num-H) < current-H
    [ask n-of abs ((num-H) - current-H) h3os [die]])

   (ifelse
    (num-OH) > current-OH
    [create-ohs abs ((num-OH) - current-OH) [set-tt-properties set size 1.25 set color 85]]
    (num-OH) < current-OH
    [ask n-of abs ((num-OH) - current-OH) OHs [die]])
end

to dissociation
  set M-B-1 (current-conc-b * vol-1 * 0.001)
  let num-b-to-be round (M-b-1 / unit-num-b)
  let current-num-b count bs

  if current-num-b > num-b-to-be
   [if any? bs
      [ask up-to-n-of (current-num-b - num-b-to-be) bs [set breed bhs set color 62]]]

  let T-of-tick HCl-concentration * 0.001 * HCl-dose   ;calculate the added mole of H+ in this tick
  if M-B - M-T <= -0.5 * t-of-tick
    [if any? bs [ask bs [set breed bhs set color 62]]]

end

to titration-NaOH
     set current-Conc-H 10 ^ (-14) / current-conc-OH      ;calculate the concentration of H+
     set M-H current-Conc-H * (vol-1) * 0.001             ;calculate exisitng mole of H+
     set vol-titrant vol-titrant + HCl-dose               ;increase Titrant volume
     set vol-1 vol-1 + HCl-dose                           ;increase total volume
     let T-of-tick HCl-concentration * 0.001 * HCl-dose   ;calculate the added mole of H+ in this tick
     set M-T (M-T + t-of-tick)                                ;update total mole of titant

    (ifelse
       current-conc-OH >= 10 ^ (-7)                         ;if base + acid
        [(ifelse
          M-B > M-T                                          ;if more OH- than H+
          [set current-conc-OH (M-B - M-T) / (vol-1 * 0.001)              ;calculate the concentration of OH-
           set current-conc-BH (M-B / (vol-1 * 0.001))                    ;update BH concentration
           ifelse current-conc-OH > 10 ^ (-6)
            [set current-ph (14 - (- log current-conc-OH 10))]                   ;calculate the ph
            [set current-conc-OH (10 ^ (-7) + current-conc-OH)          ;consider water self-ionizaiton
             set current-ph (14 - (- log current-conc-OH 10))]]                 ; find current pH

          M-B < M-T
          [set M-H (M-T - M-B)                              ;if more H+ than OH-,calculate left mole of H+
           set current-conc-H M-H / (vol-1 * 0.001)             ;calculate the concentration of OH-
           set current-conc-BH (M-B / (vol-1 * 0.001))                    ;update BH concentration
           ifelse current-conc-H > 10 ^ (-6)
            [set current-ph (- log current-conc-H 10)]       ;calculate the concentration of H+
            [set current-conc-H ((10 ^ (-7) + current-conc-H))  ;consider water self-ionizaiton
             set current-ph (- log current-conc-H 10)]]         ;calculate the concentration of H+

          M-B = M-T
          [set current-conc-BH (M-B / (vol-1 * 0.001))                    ;update BH concentration
           set current-conc-H 10 ^ (-7) set current-ph (- log current-conc-H 10)])
        ]

       current-conc-OH < 10 ^ (-7)                                 ;if acid + acid
        [set current-conc-BH (M-B / (vol-1 * 0.001))                    ;update BH concentration
         let total-H (M-H + T-of-tick)                                ;calculate the total mole of H+
         set current-conc-H total-H / (vol-1 * 0.001)           ;calculate the concentration of OH-
        set current-ph (- log current-conc-H 10)])               ;Find ph


end

to titration-NH3
     set vol-titrant vol-titrant + HCl-dose               ;increase Titrant volume
     set vol-1 vol-1 + HCl-dose                           ;increase total volume
     let T-of-tick HCl-concentration * 0.001 * HCl-dose   ;calculate the added mole of OH- in this tick
     set M-T (M-T + t-of-tick)                                ;update total mole of titant


 (ifelse
      (M-B - M-T)  >= T-of-tick * 0.5                                     ;if more base (half tick mole) than H+, i.e., before the equivalent point
      [set current-conc-B (M-B - M-T) / (vol-1 * 0.001)             ;update base concentration
      ifelse  ((M-BH + M-T) / (vol-1 * 0.001)) -  (M-T / (vol-1 * 0.001)) > 0.001     ;update BH concentration. consider the initial BH concentration
        [set current-conc-BH ((M-BH + M-T) / (vol-1 * 0.001))]
        [set current-conc-BH (M-T / (vol-1 * 0.001))]
       set current-conc-OH (kb * current-conc-B / current-conc-BH)  ;find current OH- concentration
       set current-ph (14 - (- log current-conc-OH 10))]                 ; find current pH

      M-B - M-T < T-of-tick * 0.5  and  M-B - M-T > -0.5 * T-of-tick                    ;if at the equivalent point
      [set current-conc-BH ((Base-concentration * Base-volume * 0.001) / (vol-1 * 0.001))  ;update A- concentration
       set ka (10 ^ (-14) / kb)
       set current-conc-H (-0.5 * (ka - sqrt (ka * ka + 4 * ka * current-conc-BH)))  ;find H+ concentration using Ka
       set current-pH (- log current-conc-H 10)                                      ;find current ph using pH
       set current-conc-b current-conc-h]                                    ;update Base molecule concentration

      M-B - M-T <= -0.5 * T-of-tick                                          ; if after the equivalent point
      [set current-conc-b 0                                              ;update Base molecule concentration
       set current-conc-BH ((Base-concentration * Base-volume * 0.001) / (vol-1 * 0.001))   ;update BH concentration
       set current-conc-H ((M-T - M-B) / (vol-1 * 0.001))                ; find H+ concentration
       set current-ph (- log current-conc-H 10)])                        ;find current ph using pOH

end


to plot-ion-concentrations-log ;; this creates the bar graph

    set-current-plot "Base/Conjugate acid Concentrations"
    clear-plot
    set-plot-x-range 0 1
    set-plot-y-range 0 0.1
    plot-pen-down
    set-current-plot-pen "Base"
    plotxy 0 current-conc-B
    set-current-plot-pen "Conjugate acid"
    plotxy 1 current-conc-BH

end
@#$#@#$#@
GRAPHICS-WINDOW
360
10
778
429
-1
-1
10.0
1
9
1
1
1
0
1
1
1
0
40
0
40
1
1
1
ticks
10.0

BUTTON
795
336
935
374
Start/Restart
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
5
304
354
570
Base/Conjugate acid Concentrations
NIL
Concentration (M)
0.0
1.0
0.0
0.1
true
true
"" ""
PENS
"Base" 1.0 1 -7171555 true "" "plotxy 0 current-conc-B"
"Conjugate acid" 1.0 1 -15040220 true "" "plotxy 1 current-conc-BH"

BUTTON
795
376
935
415
Titration (Continously)
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
795
417
935
461
Titration (Manually)
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
447
431
609
476
H3O+ Concentration (M)
10 ^ (-1 * current-ph)
14
1
11

MONITOR
447
478
609
523
OH- Concentration (M)
10 ^ (-1 * (14 - current-ph))
14
1
11

SLIDER
794
110
981
143
Base-concentration
Base-concentration
0.01
0.1
0.1
0.01
1
M
HORIZONTAL

SLIDER
794
176
982
209
HCl-concentration
HCl-concentration
0.05
0.2
0.1
0.05
1
M
HORIZONTAL

SLIDER
794
211
982
244
HCl-dose
HCl-dose
0.05
0.2
0.1
0.05
1
ml/tick
HORIZONTAL

MONITOR
615
478
778
523
Titrant Volume (ml)
vol-titrant
1
1
11

MONITOR
360
431
445
476
Current pH
current-PH
3
1
11

PLOT
5
10
354
301
Changes in pH
Volume of HCl added (ml)
pH of Solution
0.0
10.0
0.0
15.0
true
true
"" ""
PENS
"current-pH" 1.0 0 -2674135 true "" "plotxy vol-titrant current-ph"
"pH 7" 1.0 0 -4399183 true "" "plotxy vol-titrant 7"

SWITCH
797
500
1084
533
Hide-base-molecule-and-conjugate-acid?
Hide-base-molecule-and-conjugate-acid?
1
1
-1000

SWITCH
797
536
1043
569
Hide-hydronium-and-hydroxide?
Hide-hydronium-and-hydroxide?
1
1
-1000

MONITOR
615
431
778
476
Total Current Volume (ml)
vol-1
1
1
11

INPUTBOX
794
246
982
306
Total-mL-of-HCl-added
100.0
1
0
Number

CHOOSER
794
27
981
72
Choose-a-base
Choose-a-base
"Sodium hydroxide" "Ammonia"
1

TEXTBOX
781
10
941
28
1. Determine base settings
11
125.0
1

TEXTBOX
783
317
1016
335
3. Confirm the settings and start titration.
11
125.0
1

SLIDER
794
75
981
108
Base-volume
Base-volume
10
100
100.0
10
1
ml
HORIZONTAL

TEXTBOX
782
156
995
174
2. Determine Titrant (HCl) settings
11
125.0
1

TEXTBOX
788
478
1039
496
(Optional): Select to hide/display certain ions
11
125.0
1

MONITOR
361
525
567
570
Base molecule concentration (M)
current-conc-b
5
1
11

MONITOR
569
525
778
570
Conjugate acid concentration (M)
current-conc-BH
5
1
11

MONITOR
361
478
445
523
Current pOH
14 - current-ph
3
1
11

@#$#@#$#@
## WHAT IS IT?

This model presents the differences in titrating a strong base (NaOH) and a weak base (Ammonia). Students are able to observe the changes in pH when titrating a strong/weak base with a HCl solution. Students may also change the concentrations of bases and the titrant and then observe the corresponding results. 

## HOW IT WORKS

The pH of the solution is calculated based on the equation: C1V1=C2V2.

This model can be used to address a range of misconceptions about pH, titration, and dissociation.

Both the molarities of the conjugate acid and titrant are used to calculate pH at the beginning of the titration (titration volume < approx 10 ml). Then, only the titrant's molarity is used to calculate pH.


## HOW TO USE IT

How to use:
1. Choose a base
2. Set the base concentration
3. Set HCi concentration
4. Set dose of HCl added per tick
5. Set the total amount of HCl added
6. Click "Set up"
7. Click "Titration"
8. Observe outpts in the monitors and plots.

-----*-----*------

Note: 
-Don't change HCl's concentration and dose during titration. 
-Use switches to hide some molecules or ions to help observations.

## THINGS TO NOTICE

* Dissociation of the strong base and weak base.
* The pH changes in the titration processes of the strong base and weak base.
* The equivalent points of the titration of the strong base and weak base.


## THINGS TO TRY

* Choose different bases
* Adjust base and/or titrant concentration
* Adjust the titratant does
* Hide some ions to help observations


## RELATED MODELS

See more chemistry models at https://sites.google.com/view/3d-science-abm/physics-chemistry

## CREDITS AND REFERENCES

Dr. Lin Xiang created this module at the University of Kentucky in 2022. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2022). Titration of base with a strong acid. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

ab-ace-acid-1
true
0
Circle -7500403 true true 105 30 150
Circle -7500403 true true 14 76 180
Circle -16777216 true false 161 133 120
Circle -7500403 true true 160 134 120
Circle -1 true false 204 234 42

ab-ace-acid-2
true
0
Circle -7500403 true true 105 30 150
Circle -7500403 true true 14 76 180
Circle -16777216 true false 161 133 120
Circle -7500403 true true 160 134 120

ab-b-1
true
0
Circle -7500403 true true 165 225 60
Circle -7500403 true true 15 75 60
Circle -7500403 true true 30 30 240
Circle -7500403 true true 45 210 60

ab-b-2
true
0
Circle -7500403 true true 165 225 60
Circle -7500403 true true 15 75 60
Circle -7500403 true true 30 30 240
Circle -7500403 true true 50 211 60
Circle -1 true false 203 40 60

ab-h2o
true
0
Circle -11221820 true false 90 90 120
Circle -1 true false 84 174 42
Circle -1 true false 189 144 42

ab-h2o-1
true
0
Circle -7500403 false true 75 75 148
Circle -7500403 true true 69 174 42
Circle -7500403 true true 204 144 42

ab-h3o-1
true
0
Circle -1 true false 114 54 42
Circle -2674135 true false 75 75 150
Circle -1 true false 69 189 42
Circle -1 true false 204 159 42

ab-ha-1
true
0
Circle -7500403 true true 45 45 210
Circle -1 true false 219 69 42
Circle -7500403 true true 30 45 120
Circle -7500403 true true 105 165 120

ab-ha-2
true
0
Circle -7500403 true true 45 45 210
Circle -7500403 true true 30 45 120
Circle -7500403 true true 105 165 120

ab-oh-1
true
0
Circle -7500403 true true 75 75 150
Circle -1 true false 189 174 42

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

blank
true
0

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

oa-co2
true
0
Circle -2674135 true false 180 90 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120

oa-co3
true
0
Circle -2674135 true false 120 0 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120
Circle -2674135 true false 150 165 120

oa-h2co3
true
0
Circle -2674135 true false 120 0 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120
Circle -2674135 true false 150 165 120
Circle -1 true false 122 0 42
Circle -1 true false 163 253 42

oa-h3o
true
0
Circle -1 true false 114 69 42
Circle -2674135 true false 90 90 120
Circle -1 true false 84 174 42
Circle -1 true false 189 159 42

oa-hco3
true
0
Circle -2674135 true false 120 0 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120
Circle -2674135 true false 150 165 120
Circle -1 true false 163 253 42

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
