globals [x y num-bugs allele-num p1 p2 p-type half-population-size b-x b-y beetle-ID
  list-1
  list-2
  list-3
  list-4
  list-5
  list-6
  ]
turtles-own [genotype phenotype gender]

breed [sperms sperm]
breed [eggs egg]
Breed [bugs bug]
breed [crosses cross]




to parents
  set p1 [phenotype] of bugs with [xcor = max-pxcor - 0.5 and ycor = (max-pycor / 2 ) - 1.5]
  set p2 [phenotype] of bugs with [xcor = max-pxcor - 0.5 and ycor = (max-pycor / 2 ) + 1.5]
  set p-type word p1 " "
  set p-type word p-type "X"
  set p-type word p-type " "
  set p-type word p-type p2

end




to start-gamates
  set half-population-size 18 + random 5                   ;set population size 45~60

if Cases = "Case 1" [                                  ; 9-spotted X black Cs > Cb (complete dominance)
  create-sperms 2 * half-population-size [
  set genotype item random 3 ["Cs" "Cb" "Cb" "Cv" "Cn"]     ;produce sperms either "Cs" or "Cb", there are more Cb
  gamete-trait]

  create-eggs 2 * half-population-size [
  set genotype item random 3 ["Cs" "Cb" "Cb" "Cv" "Cn"]     ;produce eggs either "Cs" or "Cb", there are more Cb
  gamete-trait]
]

if Cases = "Case 3" [                                  ;Cv and Cn codominace   elongated stripe, normal, and broken stripe (heterzygotes)
  create-sperms 2 * half-population-size [
  set genotype item random 2 ["Cv" "Cn" "Cb" "Cs"]     ;produce sperms either "Cv" or "Cn"
  gamete-trait]

  create-eggs 2 * half-population-size [
  set genotype item random 2 ["Cv" "Cn" "Cb" "Cs"]     ;produce eggs either "Cv" or "Cn"
  gamete-trait]
]

if Cases = "Case 2" [                                  ; 9-spotted, normal, and black Cs > Cn > Cb (complete dominance)
  create-sperms 2 * half-population-size [
  set genotype item random 3 ["Cs" "Cn" "Cb" "Cv"]     ;produce sperms of "Cs" "Cn" or "Cb"
  gamete-trait]

  create-eggs 2 * half-population-size [
  set genotype item random 3 ["Cs" "Cn" "Cb" "Cv"]     ;produce eggs of "Cs" "Cn" or "Cb"
  gamete-trait]
]

if Cases = "Case 4" [                                  ; all six forms of ladybug beetles Cs > Cn > Cb; Cv > Cb (complete dominance and codominance CvCn, CsCv)
  create-sperms 2 * half-population-size [
  set genotype item random 4 ["Cs" "Cn" "Cb" "Cv"]     ;produce sperms of "Cs" "Cn" "Cv" or "Cb"
  gamete-trait]

  create-eggs 2 * half-population-size [
  set genotype item random 4 ["Cs" "Cn" "Cb" "Cv"]     ;produce eggs of "Cs" "Cn" "Cv" or "Cb"
  gamete-trait]
]


if Cases = "Case 5" [                                  ;9-spotted, elongated stripe, 5-spotted (heterzygotes) and black; Complete dominance Cs > Cb and Cv > Cb; Cv and Cs codominace
  create-sperms 2 * half-population-size [
  set genotype item random 3 ["Cs" "Cv" "Cb" "Cn"]     ;produce sperms of "Cs" "Cv" or "Cb"
  gamete-trait]

  create-eggs 2 * half-population-size [
  set genotype item random 3 ["Cs" "Cv" "Cb" "Cn"]     ;produce eggs of "Cs" "Cv" or "Cb"
  gamete-trait]
]



end

to gamete-trait               ;set gamete characteristics
    set shape "dot"
    if genotype = "Cb" [set color 0]
    if genotype = "Cn" [set color red]
    if genotype = "Cv" [set color sky]
    if genotype = "Cs" [set color 8]
    set size 0.1
    setxy random (max-pxcor - 1) random (max-pycor + 1)
end

to set-tray        ;set background grid and cross area
  ask patches [ifelse pxcor < max-pxcor - 1
    [set pcolor 52 + random-float 0.25]
    [set pcolor 89 + random-float 0.25]
  ]

  create-crosses 3
    ask cross 0 [
    set shape "x"
    setxy max-pxcor - 0.5  max-pycor / 2
    set size 0.5
    set color 35]

     ask cross 1 [
    set shape "male"
    set heading 45
    setxy max-pxcor + 0.25 (max-pycor / 2) + 2
    set size 0.75
    set color 0]

     ask cross 2 [
    set shape "female"
    setxy max-pxcor + 0.25 (max-pycor / 2) - 2
    set size 0.75
    set color 0]

end

to set-position
  setxy  random (max-pxcor - 1) random (max-pycor + 1)
  if any? other bugs-here
  [set-position]
end

to fertilize
  ask sperms [ let mate one-of eggs
    if mate != nobody [
      hatch-bugs 1 [
        set size 0.75
        set heading 0
        set-position
        set genotype word genotype [genotype] of mate
        set-phenotype
      ]
      ask mate [die]]
    die
  ]


  ask bugs with [pxcor >= max-pxcor] [die]  ;make sure no beetles in the cross area


end

to set-phenotype

  ;rearrange and unify genotype expression

  if genotype = "CnCs" [set genotype "CsCn"]
  if genotype = "CbCs" [set genotype "CsCb"]
  if genotype = "CvCs" [set genotype "CsCv"]
  if genotype = "CnCv" [set genotype "CvCn"]
  if genotype = "CbCn" [set genotype "CnCb"]
  if genotype = "CbCv" [set genotype "CvCb"]

  ;Define phenotype

  if genotype = "CsCs" or genotype = "CsCn" or genotype = "CsCb" [set shape "ladybug-9 spotted" set color rgb 255 140 0 set phenotype "9-spotted"]
  if genotype = "CnCn" or genotype = "CnCb" [set shape "ladybug-normal" set color rgb 255 75 0 set phenotype "normal"]
  if genotype = "CvCv" or genotype = "CvCb" [set shape "ladybug-elongated stripe" set color rgb 255 130 0 set phenotype "elongated-stripe"]
  if genotype = "CbCb" [set shape "ladybug-black" set color rgb 255 140 0 set phenotype "black"]
  if genotype = "CvCn" [set shape "ladybug-broken strip" set color rgb 255 130 0 set phenotype "broken-stripe"]
  if genotype = "CsCv" [set shape "ladybug-5 spotted" set color rgb 255 140 0 set phenotype "5-spotted"]

end


;==================

to setup
  ca
 set-tray
 start-gamates
 fertilize

reset-ticks
end

to mating
  ifelse count bugs with [pxcor >= max-pxcor - 1] = 2     ;ensure there are two parent beetles
  [ parents
    gametogenesis
    fertilize
    output-results]
  [user-message "Please choose 2 beetles first!"]

end

;=================
to pick         ;choose two beetles for test cross
 clear-output
  if mouse-inside? [
    if mouse-down? [
      set x round mouse-xcor set y round mouse-ycor
      ask turtles with [pxcor = x and pycor = y]
       [(ifelse
          count bugs with [pxcor >= (max-pxcor - 1)] = 0
           [set size 1.25 setxy (max-pxcor - 0.5) ((max-pycor / 2 ) + 1.5) set gender "dad"]
          count bugs with [pxcor >= (max-pxcor - 1)] = 1
           [set size 1.25 setxy (max-pxcor - 0.5) ((max-pycor / 2 ) - 1.5) set gender "mom"])]
    ]]


  if count bugs with [pxcor >= (max-pxcor - 1)] = 2     ;Remove all other beetles once two parent beetles are chosen
  [ask bugs with [pxcor < max-pxcor - 1] [die]
   ask eggs [die]
   ask sperms [die]
   stop   ;must stop here to show parent phenotypes
  ]

end

to gametogenesis

 ; reset-allele-num
  set half-population-size 25 + random 5

  ask bugs with [gender = "mom"] [
     (ifelse
       genotype = "CsCs" [
          hatch-eggs 2 * half-population-size [gamete-trait set genotype "Cs"]]

       genotype = "CsCn" [
          hatch-eggs half-population-size [gamete-trait set genotype "Cs"]
          hatch-eggs half-population-size [gamete-trait set genotype "Cn"]]

       genotype = "CsCb" [
          hatch-eggs half-population-size [gamete-trait set genotype "Cs"]
          hatch-eggs half-population-size [gamete-trait set genotype "Cb"]]

       genotype = "CnCn" [
          hatch-eggs 2 * half-population-size [gamete-trait set genotype "Cn"]]

       genotype = "CnCb" [
          hatch-eggs half-population-size [gamete-trait set genotype "Cn"]
          hatch-eggs half-population-size [gamete-trait set genotype "Cb"]]

       genotype = "CbCb" [
          hatch-eggs 2 * half-population-size [gamete-trait set genotype "Cb"]]

       genotype = "CvCv" [
          hatch-eggs 2 * half-population-size [gamete-trait set genotype "Cv"]]

       genotype = "CvCb" [
          hatch-eggs half-population-size [gamete-trait set genotype "Cv"]
          hatch-eggs half-population-size [gamete-trait set genotype "Cb"]]

       genotype = "CvCn" [
          hatch-eggs half-population-size [gamete-trait set genotype "Cv"]
          hatch-eggs half-population-size [gamete-trait set genotype "Cn"]]

        genotype = "CsCv" [
          hatch-eggs half-population-size [gamete-trait set genotype "Cv"]
          hatch-eggs half-population-size [gamete-trait set genotype "Cs"]])
  ]

    ask bugs with [gender = "dad"] [
     (ifelse
      genotype = "CsCs" [
          hatch-sperms 2 * half-population-size [gamete-trait set genotype "Cs"] ]

       genotype = "CsCn" [
          hatch-sperms half-population-size [gamete-trait set genotype "Cs"]
          hatch-sperms half-population-size [gamete-trait set genotype "Cn"] ]

       genotype = "CsCb" [
          hatch-sperms half-population-size [gamete-trait set genotype "Cs"]
          hatch-sperms half-population-size [gamete-trait set genotype "Cb"] ]

       genotype = "CnCn" [
          hatch-sperms 2 * half-population-size [gamete-trait set genotype "Cn"] ]

       genotype = "CnCb" [
          hatch-sperms half-population-size [gamete-trait set genotype "Cn"]
          hatch-sperms half-population-size [gamete-trait set genotype "Cb"] ]

       genotype = "CbCb" [
          hatch-sperms 2 * half-population-size [gamete-trait set genotype "Cb"] ]

       genotype = "CvCv" [
          hatch-sperms 2 * half-population-size [gamete-trait set genotype "Cv"] ]

       genotype = "CvCb" [
          hatch-sperms half-population-size [gamete-trait set genotype "Cv"]
          hatch-sperms half-population-size [gamete-trait set genotype "Cb"] ]

       genotype = "CvCn" [
          hatch-sperms half-population-size [gamete-trait set genotype "Cv"]
          hatch-sperms half-population-size [gamete-trait set genotype "Cn"] ]

       genotype = "CsCv" [
          hatch-sperms half-population-size [gamete-trait set genotype "Cv"]
          hatch-sperms half-population-size [gamete-trait set genotype "Cs"] ])
  ]


end


to output-results   ;display parent phenotypes
  output-type p-type
end


to set-lists
  if any? bugs with [xcor <= 9] [

        set list-1 [who] of bugs with [phenotype = "9-spotted" and xcor < max-pxcor - 1]
        set list-2 [who] of bugs with [phenotype = "black" and xcor < max-pxcor - 1]
        set list-3 [who] of bugs with [phenotype = "broken-stripe" and xcor < max-pxcor - 1]
        set list-4 [who] of bugs with [phenotype = "normal" and xcor < max-pxcor - 1]
        set list-5 [who] of bugs with [phenotype = "elongated-stripe" and xcor < max-pxcor - 1]
        set list-6 [who] of bugs with [phenotype = "5-spotted" and xcor < max-pxcor - 1]

        set list-1 sentence list-1 list-2
        set list-1 sentence list-1 list-3

        set list-4 sentence list-4 list-5
        set list-4 sentence list-4 list-6

        set list-1 sentence list-1 list-4

        sorting ]

end

to sorting

   set b-x 0
        set b-y max-pycor
        set beetle-ID 0

        repeat length list-1
        [ask bugs with [who = item beetle-ID list-1] [setxy b-x b-y]
          ifelse b-y > 0 [set b-y b-y - 1][set b-y max-pycor set b-x b-x + 1]
          set beetle-ID beetle-ID + 1 ]

end
@#$#@#$#@
GRAPHICS-WINDOW
6
10
734
379
-1
-1
60.0
1
10
1
1
1
0
1
1
1
0
11
0
5
0
0
1
ticks
30.0

BUTTON
147
392
253
435
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
494
469
612
518
Total # of beetles
count bugs
17
1
12

BUTTON
291
393
473
435
Press and choose 2 beetles
pick
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
516
393
588
437
Cross!
mating
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
380
521
495
566
9-spotted
count bugs with [phenotype = \"9-spotted\"]
17
1
11

MONITOR
380
566
495
611
5-spotted
count bugs with [phenotype = \"5-spotted\"]
17
1
11

MONITOR
495
521
611
566
Normal
count bugs with [phenotype = \"normal\"]
17
1
11

MONITOR
611
521
727
566
Black
count bugs with [phenotype = \"black\"]
17
1
11

MONITOR
495
566
611
611
Elongated stripe
count bugs with [phenotype = \"elongated-stripe\"]
17
1
11

MONITOR
611
566
727
611
Broken stripe
count bugs with [phenotype = \"broken-stripe\"]
17
1
11

OUTPUT
3
485
349
545
12

TEXTBOX
3
465
153
483
Parents:
14
125.0
1

CHOOSER
8
390
109
435
Cases
Cases
"Case 1" "Case 2" "Case 3" "Case 4" "Case 5"
3

TEXTBOX
483
408
511
426
-->
11
0.0
1

TEXTBOX
119
408
144
426
-->
11
0.0
1

TEXTBOX
379
464
450
482
Progeny:
14
125.0
1

TEXTBOX
0
448
772
466
---------------------------------------------------------------------------------------------------------------------------
11
36.0
1

BUTTON
629
393
732
437
Sort Beetles
set-lists
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

@#$#@#$#@
## WHAT IS IT?

This model is based on the study from Houston (1979) in the inheritance of the color pattern of _Coelophora inaequalis_, commonly known as ladybug beetles, which reveals a dominance order among four alleles and incomplete dominance (referred to as codominance by Houston in the original publication) involved in three of the alleles.

## How to use?

1. Select one of five cases
2. Click on the **Start/reset** button to confirm.
3. Click on the **Press and choose 2 beetles** button.
4. Choose two ladybug beetles in the simulation window.
5. Click on the **cross!** button to conduct a test cross.
6. Examine offspring phenotypes in the simulation window and the **progeny** section.
7. Use **Sort beetles** button to sort out beetles.


## How it works?

Researchers have found that the color pattern of _Coelophora inaequalis_ is a multiallelic trait (Houston, 1979).  Existing work suggests six forms of color patterns in an Australian ladybug beetle species are determined by four alleles: Cs, Cn, Cv, and Cb. A dominance order was identified among these four alleles to determine four forms. In addition, two pairs of these alleles are found to show incomplete dominance and result in the other two phenotypes. 

In this simulation, gametes containing one of four alleles are first generated and randomly fuse to form beetles, which can be either homozygotes or heterozygotes. Users need to figure out the dominance order and dominance mechanisms through test crosses. 

When users choose two beetles for a test cross, the gametes from one beetle randomly fuse with the gametes of the other beetle to form offspring. 45~60 offspring beetles may be produced in each generation. 

## CREDITS 

This model was made by Dr. Lin Xiang at the University of Kentucky in 2018 and revised in 2023. If you mention or use this model in a publication, we ask that you include the citations below:

Xiang, L. (2018). Multiple allele inheritance and incomplete dominance in Ladybug Beetles. Department of STEM Education, University of Kentucky, Lexington, KY.


![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.

## References

Houston, K. J. (1979). Mosaic dominance in the inheritance of the colour patterns of Coelophora inaequalis (F.)(Coleoptera: Coccinellidae). Australian Journal of Entomology, 18(1), 45-51.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

female
false
0
Circle -7500403 false true 120 75 58
Line -7500403 true 150 210 150 135
Line -7500403 true 180 165 150 165
Line -7500403 true 120 165 150 165

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

ladybug
true
0
Circle -16777216 true false 139 65 23
Polygon -7500403 true true 150 78 161 68 183 65 209 68 222 69 231 79 240 98 245 116 251 140 253 173 248 198 234 221 217 240 194 259 179 270 165 278 150 281
Polygon -7500403 true true 152 78 141 68 119 65 93 68 80 69 71 79 62 98 57 116 51 140 49 173 54 198 68 221 85 240 108 259 123 270 137 278 152 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -16777216 true false 185 91 196 104 191 120 173 127 161 122 159 104 165 94
Polygon -16777216 true false 117 91 106 104 111 120 129 127 141 122 143 104 137 94
Polygon -16777216 true false 200 160 215 175 208 200 185 207 164 211 164 175 174 159
Polygon -16777216 true false 182 246 194 237 200 229 190 229 182 235 174 239 172 247
Polygon -16777216 true false 100 160 85 175 92 200 115 207 136 211 136 175 126 159
Polygon -16777216 true false 118 246 106 237 100 229 110 229 118 235 126 239 128 247
Polygon -16777216 true false 227 100 226 89 220 78 213 78 211 85 214 92 220 102
Polygon -16777216 true false 73 100 74 89 80 78 87 78 89 85 86 92 80 102
Polygon -16777216 true false 243 163 245 153 241 143 235 143 238 151 239 158 239 166
Polygon -16777216 true false 57 163 55 153 59 143 65 143 62 151 61 158 61 166
Polygon -1 true false 145 70 157 70 161 57 151 62 141 58

ladybug-1
true
0
Circle -16777216 true false 139 65 23
Polygon -16777216 true false 150 78 161 68 183 65 209 68 222 69 231 79 240 98 245 116 251 140 253 173 248 198 234 221 217 240 194 259 179 270 165 278 150 281
Polygon -16777216 true false 151 78 140 68 118 65 92 68 79 69 70 79 61 98 56 116 50 140 48 173 53 198 67 221 84 240 107 259 122 270 136 278 151 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -7500403 true true 215 109 233 131 225 165 195 180 160 162 161 128 163 106
Polygon -7500403 true true 85 109 67 131 75 165 105 180 140 162 139 128 137 106
Polygon -7500403 true true 190 223 193 230 187 241 178 246 169 243 168 234 174 222
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -7500403 true true 110 223 107 230 113 241 122 246 131 243 132 234 126 222

ladybug-5 spotted
true
0
Circle -16777216 true false 139 65 23
Polygon -7500403 true true 151 78 162 68 184 65 210 68 223 69 232 79 241 98 246 116 252 140 254 173 249 198 235 221 218 240 195 259 180 270 166 278 151 281
Polygon -7500403 true true 151 78 140 68 118 65 92 68 79 69 70 79 61 98 56 116 50 140 48 173 53 198 67 221 84 240 107 259 122 270 136 278 151 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -16777216 true false 154 253 161 253 159 263 150 267 141 263 139 253 147 253
Polygon -16777216 true false 199 236 205 228 209 218 199 218 191 224 190 231 192 237
Polygon -16777216 true false 203 106 206 100 200 89 193 89 191 96 194 103 198 108
Polygon -1 true false 145 70 157 70 161 57 151 62 141 58
Polygon -16777216 true false 97 106 94 100 100 89 107 89 109 96 106 103 102 108
Polygon -16777216 true false 101 236 95 228 91 218 101 218 109 224 110 231 108 237

ladybug-9 spotted
true
0
Circle -16777216 true false 139 65 23
Polygon -7500403 true true 151 78 162 68 184 65 210 68 223 69 232 79 241 98 246 116 252 140 254 173 249 198 235 221 218 240 195 259 180 270 166 278 151 281
Polygon -7500403 true true 151 78 140 68 118 65 92 68 79 69 70 79 61 98 56 116 50 140 48 173 53 198 67 221 84 240 107 259 122 270 136 278 151 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -16777216 true false 154 253 161 253 159 263 150 267 141 263 139 253 147 253
Polygon -16777216 true false 180 152 191 164 184 179 171 184 159 176 159 167 166 153
Polygon -16777216 true false 199 236 205 228 209 218 199 218 191 224 190 231 192 237
Polygon -16777216 true false 203 106 206 100 200 89 193 89 191 96 194 103 198 108
Polygon -16777216 true false 243 163 245 153 241 143 235 143 234 152 235 160 239 166
Polygon -1 true false 145 70 157 70 161 57 151 62 141 58
Polygon -16777216 true false 97 106 94 100 100 89 107 89 109 96 106 103 102 108
Polygon -16777216 true false 57 163 55 153 59 143 65 143 66 152 65 160 61 166
Polygon -16777216 true false 120 152 109 164 116 179 129 184 141 176 141 167 134 153
Polygon -16777216 true false 101 236 95 228 91 218 101 218 109 224 110 231 108 237

ladybug-black
true
0
Circle -16777216 true false 139 65 23
Polygon -16777216 true false 150 78 161 68 183 65 209 68 222 69 231 79 240 98 245 116 251 140 253 173 248 198 234 221 217 240 194 259 179 270 165 278 150 281
Polygon -16777216 true false 150 78 139 68 117 65 91 68 78 69 69 79 60 98 55 116 49 140 47 173 52 198 66 221 83 240 106 259 121 270 135 278 150 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 218 76 204 76 214 82 221 91 232 125 228 102 225 88
Polygon -1 true false 82 76 96 76 86 82 79 91 68 125 72 102 75 88

ladybug-broken strip
true
0
Circle -16777216 true false 139 65 23
Polygon -7500403 true true 151 78 162 68 184 65 210 68 223 69 232 79 241 98 246 116 252 140 254 173 249 198 235 221 218 240 195 259 180 270 166 278 151 281
Polygon -7500403 true true 151 78 140 68 118 65 92 68 79 69 70 79 61 98 56 116 50 140 48 173 53 198 67 221 84 240 107 259 122 270 136 278 151 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -16777216 true false 162 239 175 256 165 264 160 270 141 270 126 255 140 239
Polygon -1 true false 145 70 157 70 161 57 151 62 141 58
Polygon -16777216 true false 149 157 146 119 151 84 157 119 156 157 160 243 143 243
Polygon -16777216 true false 223 188 216 212 201 234 190 233 205 204 209 187 217 174
Polygon -16777216 true false 225 127 218 103 203 81 192 82 207 111 211 128 219 141
Polygon -16777216 true false 75 127 82 103 97 81 108 82 93 111 89 128 81 141
Polygon -16777216 true false 77 188 84 212 99 234 110 233 95 204 91 187 83 174

ladybug-elongated stripe
true
0
Circle -16777216 true false 139 65 23
Polygon -7500403 true true 151 78 162 68 184 65 210 68 223 69 232 79 241 98 246 116 252 140 254 173 249 198 235 221 218 240 195 259 180 270 166 278 151 281
Polygon -7500403 true true 151 78 140 68 118 65 92 68 79 69 70 79 61 98 56 116 50 140 48 173 53 198 67 221 84 240 107 259 122 270 136 278 151 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -16777216 true false 162 239 175 256 165 264 160 270 141 270 126 255 140 239
Polygon -1 true false 145 70 157 70 161 57 151 62 141 58
Polygon -16777216 true false 149 157 146 119 151 84 157 119 156 157 160 243 143 243
Polygon -16777216 true false 236 180 221 96 206 74 187 70 209 95 224 176 201 238
Polygon -16777216 true false 64 180 79 96 94 74 113 70 91 95 76 176 99 238

ladybug-normal
true
0
Circle -16777216 true false 139 65 23
Polygon -7500403 true true 151 78 162 68 184 65 210 68 223 69 232 79 241 98 246 116 252 140 254 173 249 198 235 221 218 240 195 259 180 270 166 278 151 281
Polygon -7500403 true true 151 78 140 68 118 65 92 68 79 69 70 79 61 98 56 116 50 140 48 173 53 198 67 221 84 240 107 259 122 270 136 278 151 281
Polygon -7500403 true true 129 34 115 29 112 17 115 15 116 26 130 32
Polygon -7500403 true true 169 35 183 30 186 18 183 16 182 27 168 33
Polygon -7500403 true true 105 64 94 55 98 39 83 33 80 27 75 25 81 35 94 40 86 56 98 70 108 71
Polygon -7500403 true true 196 63 207 54 203 38 218 32 221 26 226 24 220 34 207 39 215 55 203 69 193 70
Polygon -7500403 true true 59 116 40 122 31 139 33 140 41 126 45 130 59 121
Polygon -7500403 true true 241 116 260 122 269 139 267 140 259 126 255 130 241 121
Polygon -7500403 true true 246 189 256 202 241 228 223 253 235 269 217 253 234 224 250 203 244 198
Polygon -16777216 true false 151 38 130 33 119 36 103 42 95 56 103 66 119 70 134 71 151 72 151 45
Polygon -16777216 true false 149 38 170 33 181 36 197 42 205 56 197 66 181 70 166 71 149 72 149 45
Polygon -7500403 true true 54 189 44 202 59 228 77 253 65 269 83 253 66 224 50 203 56 198
Polygon -1 true false 172 36 194 44 201 55 192 64 179 66 158 47 162 38
Polygon -1 true false 128 36 106 44 99 55 108 64 121 66 142 47 138 38
Polygon -16777216 true false 162 239 175 256 165 264 160 270 141 270 126 255 140 239
Polygon -1 true false 145 70 157 70 161 57 151 62 141 58
Polygon -16777216 true false 215 141 222 104 207 82 184 82 181 103 194 110 208 146
Polygon -16777216 true false 246 172 245 153 240 138 229 138 227 148 230 172 238 182
Polygon -16777216 true false 183 140 194 152 187 167 174 172 162 164 162 155 169 141
Polygon -16777216 true false 215 228 226 204 214 208 212 189 190 191 180 216 188 239
Polygon -16777216 true false 149 157 146 119 151 84 157 119 156 157 160 243 143 243
Polygon -16777216 true false 117 140 106 152 113 167 126 172 138 164 138 155 131 141
Polygon -16777216 true false 85 141 78 104 93 82 116 82 119 103 106 110 92 146
Polygon -16777216 true false 54 172 55 153 60 138 71 138 73 148 70 172 62 182
Polygon -16777216 true false 85 228 74 204 86 208 88 189 110 191 120 216 112 239

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

male
true
0
Circle -7500403 false true 120 150 58
Line -7500403 true 150 150 150 75
Line -7500403 true 150 75 135 90
Line -7500403 true 150 75 165 90

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
