<?xml version="1.0" encoding="utf-8"?>
<model version="NetLogo 7.0.3" snapToGrid="false">
  <code><![CDATA[;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;; variable setup ;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

breed[ fov a-fov ]
breed[ fish a-fish ]
breed[ plants plant ]
breed[ feed piece-of-feed ]
breed[ nutrients nutrient ]

globals [
  GHGs
  lighting-GHGs
  feeding-GHGs
  heating-GHGs
  pumping-GHGs
  total-lighting-GHG-emissions
  total-heating-GHG-emissions
  total-feeding-GHG-emissions
  total-pumping-GHG-emissions
  total-GHG-emissions
  total-harvested-fish
  total-harvested-plants
  fish-death ]

patches-own [type-of-patch]

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; setup procedure ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  ;; PATCH SETUP ;;
  ask patches [
  set type-of-patch "water"
    if pxcor < max-pxcor - 5 [
      set pcolor blue + 0.5]
  set type-of-patch "air"
    if pxcor >  max-pxcor - 5 [
      set pcolor white ] ]
  ;; FISH SETUP ;;
  set-default-shape fov "circle"
  create-fish number-of-fish [
    if fish-type = "Tilapia" [
      set shape "fish 2"
      set color grey
      set size 0.5 ]
    if fish-type = "Walleye" [
      set shape "fish"
      set color green
      set size 0.5 ]
    if fish-type = "Salmon" or fish-type = "Default" [
      set shape "salmon"
      set color grey
      set size 1 ]
    if fish-type = "Catfish" [
      set shape "catfish"
      set color grey
      set size 1 ]
    set xcor 8 - random 23
    set ycor random-pycor ]
  ;; PLANT SETUP ;;
  ask patches with [(14) > pxcor and pxcor > (10) and pycor < (1)]
    [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ]
  ask patches with [(14) > pxcor and pxcor > (10) and pycor > (0)]
    [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5 ]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ]
  if number-of-plant-columns = 4 [
  ask patches with [pxcor = 14 and pycor > (0)]
   [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5 ]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ] ]
  if number-of-plant-columns = 4 [
  ask patches with [pxcor = 14 and pycor < (1)]
   [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5 ]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ] ]
  if number-of-plant-columns = 5 [
  ask patches with [pxcor = 14 and pycor > (0)]
   [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5 ]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ] ]
  if number-of-plant-columns = 5 [
  ask patches with [pxcor = 14 and pycor < (1)]
   [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5 ]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ] ]
  if number-of-plant-columns = 5 [
  ask patches with [pxcor < (11) and pxcor > (9) and pycor < (1)]
   [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5 ]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ] ]
  if number-of-plant-columns = 5 [
  ask patches with [pxcor > (9) and pxcor < (11) and pycor > (0)]
   [ sprout-plants 1 [
      if plant-type = "Basil" [
        set shape "flower budding"
        set color green - 1
        set size 0.5 ]
      if plant-type = "Lettuce" or plant-type = "Default" [
        set shape "plant small"
        set color green + 1
        set size 0.25 ]
      if plant-type = "Tomato" [
        set shape "plant medium"
        set color green
        set size 0.25 ]
      if plant-type = "Pepper" [
        set shape "plant"
        set color green - 1
        set size 0.25 ] ] ] ]
  ;; FEED SETUP ;;
  create-feed number-of-fish [
    set shape "circle"
    set color brown + 1.5
    set size 0.15
    set xcor 8 - random 23
    set ycor random-pycor ]
  create-feed number-of-fish [
    set shape "circle"
    set color brown + 1.5
    set size 0.15
    set xcor 8 - random 23
    set ycor random-pycor ]
    create-feed number-of-fish [
    set shape "circle"
    set color brown + 1.5
    set size 0.15
    set xcor 8 - random 23
      set ycor random-pycor ]
    if fish-type = "Tilapia" [
      set feeding-GHGs 0.0004152 ]
    if fish-type = "Walleye" [
      set feeding-GHGs 0.001313 ]
    if fish-type = "Salmon" [
      set feeding-GHGs 0.01383 ]
    if fish-type = "Catfish" [
      set feeding-GHGs 0.007620 ]
    set total-feeding-GHG-emissions total-feeding-GHG-emissions + (feeding-GHGs * number-of-fish * 3)
  ;; PUMP EMISSIONS SETUP ;;
  if climate = "Humid Continental" [
    set pumping-GHGs 0.0060948 ]
  if climate = "Temperate" [
    set pumping-GHGs 0.0060948 ]
  if climate = "Tropical" [
    set pumping-GHGs 0.0060948 ]
  if climate = "Humid Subtropical" [
    set pumping-GHGs 0.0060948 ]
  ;;; LIGHTING EMISSIONS SETUP ;;;
  ;;; Three & Four Columns ;;;
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0.010299]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0 ]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.048921]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0.02967]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Temperate" and season = "Winter"  [set lighting-GHGs 0.05506]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0.01700]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Tropical" and season = "Winter"  [set lighting-GHGs 0.02267]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0.08372]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.016744]

  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.02685]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0 ]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Winter"  [set lighting-GHGs 0.022089]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0 ]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Winter"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.05581]

  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0.01030]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.04892]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0.02967]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Temperate" and season = "Winter"  [ set lighting-GHGs 0.05506]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0.01700]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Tropical" and season = "Winter"  [set lighting-GHGs 0.02267]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0.08372]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.16744]

  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0.054439]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0.041197]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0.031265]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.093061]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0.095611]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Temperate" and season = "Winter"  [set lighting-GHGs 0.120997]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0.04534]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0.03967]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0.06234]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Tropical" and season = "Winter"  [ set lighting-GHGs 0.06801]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0.2233]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0.1674]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0.30697]
  if number-of-plant-columns = 3 or number-of-plant-columns = 4 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.3907]

  ;;;Five Columns;;;
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0.01545]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0 ]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.07338]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0.04451]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Temperate" and season = "Winter"  [set lighting-GHGs 0.08259]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0.02550]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Tropical" and season = "Winter"  [set lighting-GHGs 0.03401]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0.1256]
  if number-of-plant-columns = 5 and plant-type = "Basil" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.2512]

  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.04028]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0 ]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Temperate" and season = "Winter"  [set lighting-GHGs 0.03313]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0 ]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Tropical" and season = "Winter"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Lettuce" or plant-type = "Default" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.08372]

  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0.01545]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.07338]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0.04451]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Temperate" and season = "Winter"  [ set lighting-GHGs 0.08259]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0.02550]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Tropical" and season = "Winter"  [set lighting-GHGs 0.03401]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0.1256]
  if number-of-plant-columns = 5 and plant-type = "Tomato" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.2512]

  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Spring"  [set lighting-GHGs 0.08166]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Summer"  [set lighting-GHGs 0.06180]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Fall"  [set lighting-GHGs 0.04690]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Continental" and season = "Winter"  [set lighting-GHGs 0.1396]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Temperate" and season = "Spring"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Temperate" and season = "Summer"  [set lighting-GHGs 0]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Temperate" and season = "Fall"  [set lighting-GHGs 0.1434]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Temperate" and season = "Winter"  [set lighting-GHGs 0.1815]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Tropical" and season = "Spring"  [set lighting-GHGs 0.06801]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Tropical" and season = "Summer"  [set lighting-GHGs 0.05951]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Tropical" and season = "Fall"  [set lighting-GHGs 0.09351]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Tropical" and season = "Winter"  [ set lighting-GHGs 0.1020]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Spring"  [set lighting-GHGs 0.3349]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Summer"  [set lighting-GHGs 0.2512]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Fall"  [set lighting-GHGs 0.4604]
  if number-of-plant-columns = 5 and plant-type = "Pepper" and climate = "Humid Subtropical" and season = "Winter"  [set lighting-GHGs 0.5860]

  ;;; HEATING EMISSIONS SETUP ;;;
  if fish-type = "Tilapia" and climate = "Humid Continental" and season = "Spring" [set heating-GHGs 5.7451]
  if fish-type = "Tilapia" and climate = "Humid Continental" and season = "Summer" [set heating-GHGs 1.7258]
  if fish-type = "Tilapia" and climate = "Humid Continental" and season = "Fall" [set heating-GHGs 5.2001]
  if fish-type = "Tilapia" and climate = "Humid Continental" and season = "Winter" [set heating-GHGs 9.7815]
  if fish-type = "Tilapia" and climate = "Temperate" and season = "Spring" [set heating-GHGs 4.2918]
  if fish-type = "Tilapia" and climate = "Temperate" and season = "Summer" [set heating-GHGs 1.0219]
  if fish-type = "Tilapia" and climate = "Temperate" and season = "Fall" [set heating-GHGs 3.5765]
  if fish-type = "Tilapia" and climate = "Temperate" and season = "Winter" [set heating-GHGs 6.0290]
  if fish-type = "Tilapia" and climate = "Tropical" and season = "Spring" [set heating-GHGs 0.5734]
  if fish-type = "Tilapia" and climate = "Tropical" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Tilapia" and climate = "Tropical" and season = "Fall" [set heating-GHGs 0.11922]
  if fish-type = "Tilapia" and climate = "Tropical" and season = "Winter" [set heating-GHGs 1.6747]
  if fish-type = "Tilapia" and climate = "Humid Subtropical" and season = "Spring" [set heating-GHGs 3.9456]
  if fish-type = "Tilapia" and climate = "Humid Subtropical" and season = "Summer" [set heating-GHGs 0.62453]
  if fish-type = "Tilapia" and climate = "Humid Subtropical" and season = "Fall" [set heating-GHGs 2.7250]
  if fish-type = "Tilapia" and climate = "Humid Subtropical" and season = "Winter" [set heating-GHGs 6.2448]

  if fish-type = "Walleye" and climate = "Humid Continental" and season = "Spring" [set heating-GHGs 4.8936]
  if fish-type = "Walleye" and climate = "Humid Continental" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Walleye" and climate = "Humid Continental" and season = "Fall" [set heating-GHGs 4.3486]
  if fish-type = "Walleye" and climate = "Humid Continental" and season = "Winter" [set heating-GHGs 8.9299]
  if fish-type = "Walleye" and climate = "Temperate" and season = "Spring" [set heating-GHGs 3.4403]
  if fish-type = "Walleye" and climate = "Temperate" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Walleye" and climate = "Temperate" and season = "Fall" [set heating-GHGs 2.7250]
  if fish-type = "Walleye" and climate = "Temperate" and season = "Winter" [set heating-GHGs 5.1774]
  if fish-type = "Walleye" and climate = "Tropical" and season = "Spring" [set heating-GHGs 0]
  if fish-type = "Walleye" and climate = "Tropical" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Walleye" and climate = "Tropical" and season = "Fall" [set heating-GHGs 0]
  if fish-type = "Walleye" and climate = "Tropical" and season = "Winter" [set heating-GHGs 0.82316]
  if fish-type = "Walleye" and climate = "Humid Subtropical" and season = "Spring" [set heating-GHGs 3.0940]
  if fish-type = "Walleye" and climate = "Humid Subtropical" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Walleye" and climate = "Humid Subtropical" and season = "Fall" [set heating-GHGs 1.8734]
  if fish-type = "Walleye" and climate = "Humid Subtropical" and season = "Winter" [set heating-GHGs 5.3932]

  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Continental" and season = "Spring"  [set heating-GHGs 2.3389]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Continental" and season = "Summer"  [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Continental" and season = "Fall"  [set heating-GHGs 1.7939]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Continental" and season = "Winter"  [set heating-GHGs 6.3753]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Temperate" and season = "Spring" [set heating-GHGs 0.88561]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Temperate" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Temperate" and season = "Fall" [set heating-GHGs 0.17031]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Temperate" and season = "Winter" [set heating-GHGs 2.6228]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Tropical" and season = "Spring" [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Tropical" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Tropical" and season = "Fall" [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Tropical" and season = "Winter" [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Subtropical" and season = "Spring" [set heating-GHGs 0.53937]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Subtropical" and season = "Summer" [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Subtropical" and season = "Fall" [set heating-GHGs 0]
  if fish-type = "Salmon" or fish-type = "Default" and climate = "Humid Subtropical" and season = "Winter" [set heating-GHGs 2.8386]

  if fish-type = "Catfish" and climate = "Humid Continental" and season = "Spring"  [set heating-GHGs 6.5967]
  if fish-type = "Catfish" and climate = "Humid Continental" and season = "Summer"  [set heating-GHGs 2.5774]
  if fish-type = "Catfish" and climate = "Humid Continental" and season = "Fall"  [set heating-GHGs 6.0517]
  if fish-type = "Catfish" and climate = "Humid Continental" and season = "Winter"  [set heating-GHGs 10.6330]
  if fish-type = "Catfish" and climate = "Temperate" and season = "Spring" [set heating-GHGs 5.1434]
  if fish-type = "Catfish" and climate = "Temperate" and season = "Summer" [set heating-GHGs 1.8734]
  if fish-type = "Catfish" and climate = "Temperate" and season = "Fall" [set heating-GHGs 4.4281]
  if fish-type = "Catfish" and climate = "Temperate" and season = "Winter" [set heating-GHGs 6.8805]
  if fish-type = "Catfish" and climate = "Tropical" and season = "Spring" [set heating-GHGs 1.4249]
  if fish-type = "Catfish" and climate = "Tropical" and season = "Summer" [set heating-GHGs 0.22140]
  if fish-type = "Catfish" and climate = "Tropical" and season = "Fall" [set heating-GHGs 0.97077]
  if fish-type = "Catfish" and climate = "Tropical" and season = "Winter" [set heating-GHGs 2.5263]
  if fish-type = "Catfish" and climate = "Humid Subtropical" and season = "Spring" [set heating-GHGs 4.7971]
  if fish-type = "Catfish" and climate = "Humid Subtropical" and season = "Summer" [set heating-GHGs 1.4761]
  if fish-type = "Catfish" and climate = "Humid Subtropical" and season = "Fall" [set heating-GHGs 3.5765]
  if fish-type = "Catfish" and climate = "Humid Subtropical" and season = "Winter" [set heating-GHGs 7.0963]
  reset-ticks
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;; go procedure ;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go
;;; RELEASE MORE FEED ;;;
  if count fish = 0 [stop]
  ask feed [
    if count feed <= 6 [
      hatch-feed number-of-fish [
      set xcor max-pxcor - 10
      set ycor random max-pycor - random 18
      set heading random 360]
      set total-feeding-GHG-emissions total-feeding-GHG-emissions + (feeding-GHGs * number-of-fish)
      hatch-feed number-of-fish [
      set xcor max-pxcor - 16
      set ycor random max-pycor - random 12
      set heading random 360 ]
      set total-feeding-GHG-emissions total-feeding-GHG-emissions + (feeding-GHGs * number-of-fish)
      hatch-feed number-of-fish [
      set xcor max-pxcor - 24
      set ycor random max-pycor - random 22
      set heading random 360 ]
     set total-feeding-GHG-emissions total-feeding-GHG-emissions + (feeding-GHGs * number-of-fish) ]
   if count feed <= 50 and fish-type = "Salmon" or fish-type = "Default" [
      hatch-feed number-of-fish [
      set xcor max-pxcor - 10
      set ycor random max-pycor - random 18
      set heading random 360]
      set total-feeding-GHG-emissions total-feeding-GHG-emissions + (feeding-GHGs * number-of-fish)
      hatch-feed number-of-fish [
      set xcor max-pxcor - 16
      set ycor random max-pycor - random 12
      set heading random 360 ]
      set total-feeding-GHG-emissions total-feeding-GHG-emissions + (feeding-GHGs * number-of-fish)
      hatch-feed number-of-fish [
      set xcor max-pxcor - 24
      set ycor random max-pycor - random 22
      set heading random 360 ]
     set total-feeding-GHG-emissions total-feeding-GHG-emissions + (feeding-GHGs * number-of-fish) ] ]
;;; FEED MOVES & AVOIDS LEFT & RIGHT EDGES ;;;
  ask feed [
    ifelse not can-move? 0.5
    [set heading 90 fd 1 ]
    [ifelse pcolor = black or pcolor = white
      [set heading 270 fd 2 ]
      [lt random 70
       rt random 70
       fd random-float 4 ] ] ]
;;; FISH MOVES & AVOIDS LEFT & RIGHT EDGES ;;;
  ask fish [
   ifelse not can-move? 0.5
     [set heading 90 fd 1.5 ]
     [ifelse pcolor = black or pcolor = white
       [set heading 270 fd 2 ]
       [lt random 50
        rt random 50
        fd random-float 0.25 ] ] ]
;;; FISH EAT & FEED TURNS TO NUTRIENTS ;;;
  ask fish [
   let prey one-of feed-here
    if prey != nobody [
      ask prey [
        set breed nutrients
        set shape "circle"
        set size 0.15
        set color brown - 2
        set heading 90 ] ] ]
;;; FISH GROW ;;;
  ask fish [
    if size < 2.5 and fish-type = "Tilapia" and any? fish and any? feed and distance one-of fish <= 2.5 and distance one-of feed <= 2.5
    [ set size size + 0.2 ]
    if size < 2.5 and fish-type = "Walleye" and any? fish and any? feed and distance one-of fish <= 2.5 and distance one-of feed <= 2.5
    [ set size size + 0.2 ]
    if size < 3 and fish-type = "Salmon" or fish-type = "Default" and any? fish and any? feed and distance one-of fish <= 2.5 and distance one-of feed <= 2.5
    [ set size size + 0.2 ]
    if size < 3 and fish-type = "Catfish" and any? fish and any? feed and distance one-of fish <= 2.5 and distance one-of feed <= 2.5
    [ set size size + 0.2 ] ]
;;; NUTRIENTS MOVES ;;;
  ask nutrients [
   ifelse not can-move? 0.75
    [ set heading 90 fd random-float 5 ]
    [ rt random 90
      lt random 90
      fd random-float 10 ]
     if not can-move? 0.75
    [set heading 270 fd 4]
     if not can-move? 0.25
    [die] ]
;;; FISH MORTALITY ;;;
  ask fish [
    if size <= 0.5 and ticks = 7300 ;; or ticks = 8000 or ticks =  12000 or ticks = 16000 or ticks = 20000 ;;
    [ set fish-death fish-death + 1
      die] ]
;;; HARVEST FISH ;;;
  ask fish [
    ifelse
    (Restock? = "on") [
    if size >= 2.5 and fish-type = "Tilapia"
    [ set size 0.5
      set total-harvested-fish total-harvested-fish + 1 ]
    if size >= 2.5 and fish-type = "Walleye"
    [ set size 0.5
      set total-harvested-fish total-harvested-fish + 1 ]
    if size >= 3 and fish-type = "Salmon"
    [ set size 1
      set total-harvested-fish total-harvested-fish + 1 ]
     if size >= 3 and fish-type = "Catfish"
    [ set size 1
        set total-harvested-fish total-harvested-fish + 1 ] ]
    [ if size >= 2.5 and fish-type = "Tilapia"
    [ set total-harvested-fish total-harvested-fish + 1
        die]
    if size >= 2.5 and fish-type = "Walleye"
    [ set total-harvested-fish total-harvested-fish + 1
        die ]
    if size >= 3 and fish-type = "Salmon" or fish-type = "Default"
    [ set total-harvested-fish total-harvested-fish + 1
     die ]
     if size >= 3 and fish-type = "Catfish"
    [ set total-harvested-fish total-harvested-fish + 1
        die ] ] ]
;;; PLANTS EAT ;;;
  ask plants [
   let fertilizer one-of nutrients-here
    if fertilizer != nobody [
      ask fertilizer [die] ] ]
;;; PLANTS GROW ;;;
  ask plants [
    if size < 2 and plant-type = "Basil"
    [ if any? plants and any? nutrients [
      if distance one-of plants <= 2 and distance one-of nutrients <= 2 [
        set size size + 0.35 ] ] ]
    if size < 2.5 and plant-type = "Lettuce" or plant-type = "Default"
    [ if any? plants and any? nutrients [
      if distance one-of plants <= 2 and distance one-of nutrients <= 2 [
        set size size + 0.25 ] ] ]
    if size < 2.5 and plant-type = "Tomato"
    [ if any? plants and any? nutrients [
      if distance one-of plants <= 2 and distance one-of nutrients <= 2 [
        set size size + 0.25 ] ] ]
    if size < 2.5 and plant-type = "Pepper"
    [ if any? plants and any? nutrients [
      if distance one-of plants <= 2 and distance one-of nutrients <= 2 [
        set size size + 0.25 ] ] ] ]
;;; HARVEST PLANTS ;;;
  ask plants [
    if size >= 2 and plant-type = "Basil"
    [ set size 0.5
      set total-harvested-plants total-harvested-plants + 1 ]
     if size >= 2.5 and plant-type = "Lettuce" or plant-type = "Default"
    [ set size 0.25
      set total-harvested-plants total-harvested-plants + 1 ]
     if size >= 2.5 and plant-type = "Tomato"
    [ set size 0.25
      set total-harvested-plants total-harvested-plants + 1 ]
     if size >= 2.5 and plant-type = "Pepper"
    [ set size 0.25
      set total-harvested-plants total-harvested-plants + 1 ] ]
;;; REPORTING GHG EMISSIONS ;;;
 set total-lighting-GHG-emissions total-lighting-GHG-emissions + lighting-GHGs
 set total-heating-GHG-emissions total-heating-GHG-emissions + heating-GHGs
 set total-pumping-GHG-emissions total-pumping-GHG-emissions + pumping-GHGs
 tick
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;; reporters ;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to-report lighting-greenhouse-gas-emissions
  report total-lighting-GHG-emissions
end

to-report heating-greenhouse-gas-emissions
  report total-heating-GHG-emissions
end

to-report feeding-greenhouse-gas-emissions
  report total-feeding-GHG-emissions
end

to-report pumping-greenhouse-gas-emissions
  report total-pumping-GHG-emissions
end

to-report greenhouse-gas-emissions
  report total-heating-GHG-emissions + total-lighting-GHG-emissions + total-feeding-GHG-emissions + total-pumping-GHG-emissions
end

to-report harvested-fish
  report total-harvested-fish
end

to-report harvested-plants
  report total-harvested-plants
end

to-report fish-deaths
  report fish-death
end]]></code>
  <widgets>
    <view x="266" wrappingAllowedX="false" y="10" frameRate="30.0" minPycor="-14" height="584" showTickCounter="true" patchSize="20.0" fontSize="10" wrappingAllowedY="true" width="584" tickCounterLabel="ticks" maxPycor="14" updateMode="0" maxPxcor="14" minPxcor="-14"></view>
    <slider x="10" step="200" y="360" max="500" width="205" display="number-of-fish" height="50" min="100" direction="Horizontal" default="100.0" variable="number-of-fish" units="fish"></slider>
    <button x="19" y="38" height="40" disableUntilTicks="false" forever="false" kind="Observer" width="96">setup</button>
    <button x="123" y="38" height="40" disableUntilTicks="false" forever="true" kind="Observer" width="93">go</button>
    <chooser x="13" y="87" height="60" variable="Season" current="3" width="203" display="Season">
      <choice type="string" value="Spring"></choice>
      <choice type="string" value="Summer"></choice>
      <choice type="string" value="Fall"></choice>
      <choice type="string" value="Winter"></choice>
    </chooser>
    <chooser x="11" y="224" height="60" variable="fish-type" current="1" width="207" display="fish-type">
      <choice type="string" value="Default"></choice>
      <choice type="string" value="Tilapia"></choice>
      <choice type="string" value="Walleye"></choice>
      <choice type="string" value="Salmon"></choice>
      <choice type="string" value="Catfish"></choice>
    </chooser>
    <chooser x="11" y="292" height="60" variable="plant-type" current="1" width="206" display="plant-type">
      <choice type="string" value="Default"></choice>
      <choice type="string" value="Basil"></choice>
      <choice type="string" value="Lettuce"></choice>
      <choice type="string" value="Tomato"></choice>
      <choice type="string" value="Pepper"></choice>
    </chooser>
    <chooser x="12" y="156" height="60" variable="Climate" current="1" width="205" display="Climate">
      <choice type="string" value="Humid Continental"></choice>
      <choice type="string" value="Temperate"></choice>
      <choice type="string" value="Tropical"></choice>
      <choice type="string" value="Humid Subtropical"></choice>
    </chooser>
    <monitor x="122" precision="0" y="543" height="60" fontSize="12" width="100" display="Harvested Fish">harvested-fish</monitor>
    <monitor x="9" precision="0" y="539" height="60" fontSize="12" width="107" display="Harvested Plants">harvested-plants</monitor>
    <monitor x="121" precision="0" y="477" height="60" fontSize="12" width="100" display="Dead Fish">fish-deaths</monitor>
    <switch x="8" y="483" height="40" on="false" variable="Restock?" width="105" display="Restock?"></switch>
    <slider x="10" step="1" y="415" max="5" width="206" display="number-of-plant-columns" height="50" min="3" direction="Horizontal" default="3.0" variable="number-of-plant-columns" units="columns"></slider>
    <plot x="853" autoPlotX="true" yMax="25.0" autoPlotY="true" yAxis="GHG Emissions (kg CO2 eq)" y="309" xMin="0.0" height="276" legend="true" xMax="250.0" yMin="0.0" width="404" xAxis="Time (tick)" display="Lighting, Feeding, &amp; Pumping Greenhouse Gas Emissions">
      <setup></setup>
      <update></update>
      <pen interval="1.0" mode="0" display="Lighting" color="-10141563" legend="true">
        <setup></setup>
        <update>plot lighting-greenhouse-gas-emissions</update>
      </pen>
      <pen interval="1.0" mode="0" display="Pumping" color="-955883" legend="true">
        <setup></setup>
        <update>plot pumping-greenhouse-gas-emissions</update>
      </pen>
      <pen interval="1.0" mode="0" display="Feeding" color="-10899396" legend="true">
        <setup></setup>
        <update>plot feeding-greenhouse-gas-emissions</update>
      </pen>
    </plot>
    <plot x="853" autoPlotX="true" yMax="100.0" autoPlotY="true" yAxis="GHG Emissions (kg CO2 eq)" y="12" xMin="0.0" height="288" legend="true" xMax="250.0" yMin="0.0" width="404" xAxis="Time (ticks)" display="Total &amp; Heating Greenhouse Gas Emissions">
      <setup></setup>
      <update></update>
      <pen interval="1.0" mode="0" display="Total" color="-2674135" legend="true">
        <setup></setup>
        <update>plot greenhouse-gas-emissions</update>
      </pen>
      <pen interval="1.0" mode="0" display="Heating" color="-13345367" legend="true">
        <setup></setup>
        <update>plot heating-greenhouse-gas-emissions</update>
      </pen>
      <pen interval="1.0" mode="0" display="Feeding" color="-10899396" legend="true">
        <setup></setup>
        <update>plot feeding-greenhouse-gas-emissions</update>
      </pen>
    </plot>
  </widgets>
  <info><![CDATA[## WHAT IS IT?

A model of a commercial aquaponics operation with various parameters

## HOW TO USE IT & HOW IT WORKS

The users selects a climate, season, type of fish, and type of plant on the left side of the interface. Once selection is completed press "Setup" then press "Go."

The left side of the actual visual is the fish tank which contains the fish, feed (light brown), and poop (dark brown). The right side is the plant tank (section) which contains the plants and poop (nutrients). The fish, feed, and nutrients move about until they are either harvested or consumed. As the fish eat the feed and the plants eat the nutrients both will grow as the model progresses until all living fish are harvested (unless "Restock" is switched on).

3,650 ticks in the model represent approximately three months.

## THINGS TO NOTICE

1. How are the fish tank and plant tank working together?

2. How do the feed and nutrients move? How are they different?

3. At what tick is the first fish harvested?

4. What causes a fish to die?

5. How do the different fish types differ from one another?


## THINGS TO TRY


1. Try selecting parameters that will minimize or maximize the system's greenhouse gas emissions.

2. Try selecting the number of fish and plant columns to maximize the number of plants harvested. Why does this happen?

3. Try changing the color of the fish. 

4. Try changing how often the fish are fed. What changes?

5. Try changing how the fish 'wander.' How does this change the progression of the model?

## GENERAL MODEL NOTES & ASSUMPTIONS

Model Assumptions
1. Operation size: commercial 
2. Assumed relative humidity: 70%
3. Timescale: 40 ticks per day, 1.667 ticks/hr
4. All fish in the operation are held in the same tank (in the real world, most fish species would be separated by age/weight, sex, and for breeding)
5. Fish and plants are harvested in the simulation based on size
6. All season temperatures are determined using the corresponding month's averages
7. Greenhouse temperature and related greenhouse gas emissions is dependent on the fish type, climate, and season
8. Lighting duration is dependent on plant type, climate, and season
9. Heating method is dependent on climate (e.g., Japan generally utilizes electricty for their heating)
10. Water in the system is cycled through the system twice an hour and is based on the total modelled volume of the fish and plant tanks
11. Heating and electricity emissions were determined using the reference location's method of heating.


## CLIMATE & SEASON NOTES

When setting location and season, a specific temperature is assumed by the model (see below).

Humid Continental (reference location - Madison, WI, USA)
1. Spring: 34.5 F
2. Summer: 71 F
3. Fall: 49.5 F
4. Winter: 25 F

Temperate (reference location - Madrid, Spain)
1. Spring: 54.8 F
2. Summer: 74 F
3. Fall: 59 F
4. Winter: 44.6 F

Tropical (reference location - Miami, FL, USA)
1. Spring: 75 F
2. Summer: 82.3 F
3. Fall: 78 F
4. Winter: 68.2 F

Humid Subtropical (reference location - Tokyo, Japan)
1. Spring: 56.8 F
2. Summer: 76.3 F
3. Fall: 64 F
4. Winter:43.3 F

## FISH NOTES

Greenhouse Temperature:
Nile tilapia: 80 F
Hybrid walleye: 75 F
Atlantic salmon: 60 F
Channel catfish: 70 F

Protein content of feed:
Tilapia: 32%
Walleye: 55%
Salmon: 42.3%
Catfish: 32%


## EXTENDING THE MODEL

1. Add in a piping system to the model to show the more realistic flow of nutrients.

2. Change the model to make the fish be harvested around the same time.

3. Add in the ability to 'hand feed' the fish.

## NETLOGO FEATURES

Shapes of the fish were custom-made to look more like the actual fish species.


## CREDITS AND REFERENCES

Breitenstein, M., Hicks, A. (2025) University of Wisconsin-Madison]]></info>
  <turtleShapes>
    <shape name="default" rotatable="true" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="5"></point>
        <point x="40" y="250"></point>
        <point x="150" y="205"></point>
        <point x="260" y="250"></point>
      </polygon>
    </shape>
    <shape name="airplane" rotatable="true" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="0"></point>
        <point x="135" y="15"></point>
        <point x="120" y="60"></point>
        <point x="120" y="105"></point>
        <point x="15" y="165"></point>
        <point x="15" y="195"></point>
        <point x="120" y="180"></point>
        <point x="135" y="240"></point>
        <point x="105" y="270"></point>
        <point x="120" y="285"></point>
        <point x="150" y="270"></point>
        <point x="180" y="285"></point>
        <point x="210" y="270"></point>
        <point x="165" y="240"></point>
        <point x="180" y="180"></point>
        <point x="285" y="195"></point>
        <point x="285" y="165"></point>
        <point x="180" y="105"></point>
        <point x="180" y="60"></point>
        <point x="165" y="15"></point>
      </polygon>
    </shape>
    <shape name="arrow" rotatable="true" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="0"></point>
        <point x="0" y="150"></point>
        <point x="105" y="150"></point>
        <point x="105" y="293"></point>
        <point x="195" y="293"></point>
        <point x="195" y="150"></point>
        <point x="300" y="150"></point>
      </polygon>
    </shape>
    <shape name="box" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="285"></point>
        <point x="285" y="225"></point>
        <point x="285" y="75"></point>
        <point x="150" y="135"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="135"></point>
        <point x="15" y="75"></point>
        <point x="150" y="15"></point>
        <point x="285" y="75"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="15" y="75"></point>
        <point x="15" y="225"></point>
        <point x="150" y="285"></point>
        <point x="150" y="135"></point>
      </polygon>
      <line endX="150" startY="285" marked="false" color="255" endY="135" startX="150"></line>
      <line endX="15" startY="135" marked="false" color="255" endY="75" startX="150"></line>
      <line endX="285" startY="135" marked="false" color="255" endY="75" startX="150"></line>
    </shape>
    <shape name="bug" rotatable="true" editableColorIndex="0">
      <circle x="96" y="182" marked="true" color="-1920102913" diameter="108" filled="true"></circle>
      <circle x="110" y="127" marked="true" color="-1920102913" diameter="80" filled="true"></circle>
      <circle x="110" y="75" marked="true" color="-1920102913" diameter="80" filled="true"></circle>
      <line endX="80" startY="100" marked="true" color="-1920102913" endY="30" startX="150"></line>
      <line endX="220" startY="100" marked="true" color="-1920102913" endY="30" startX="150"></line>
    </shape>
    <shape name="butterfly" rotatable="true" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="165"></point>
        <point x="209" y="199"></point>
        <point x="225" y="225"></point>
        <point x="225" y="255"></point>
        <point x="195" y="270"></point>
        <point x="165" y="255"></point>
        <point x="150" y="240"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="165"></point>
        <point x="89" y="198"></point>
        <point x="75" y="225"></point>
        <point x="75" y="255"></point>
        <point x="105" y="270"></point>
        <point x="135" y="255"></point>
        <point x="150" y="240"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="139" y="148"></point>
        <point x="100" y="105"></point>
        <point x="55" y="90"></point>
        <point x="25" y="90"></point>
        <point x="10" y="105"></point>
        <point x="10" y="135"></point>
        <point x="25" y="180"></point>
        <point x="40" y="195"></point>
        <point x="85" y="194"></point>
        <point x="139" y="163"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="162" y="150"></point>
        <point x="200" y="105"></point>
        <point x="245" y="90"></point>
        <point x="275" y="90"></point>
        <point x="290" y="105"></point>
        <point x="290" y="135"></point>
        <point x="275" y="180"></point>
        <point x="260" y="195"></point>
        <point x="215" y="195"></point>
        <point x="162" y="165"></point>
      </polygon>
      <polygon color="255" filled="true" marked="false">
        <point x="150" y="255"></point>
        <point x="135" y="225"></point>
        <point x="120" y="150"></point>
        <point x="135" y="120"></point>
        <point x="150" y="105"></point>
        <point x="165" y="120"></point>
        <point x="180" y="150"></point>
        <point x="165" y="225"></point>
      </polygon>
      <circle x="135" y="90" marked="false" color="255" diameter="30" filled="true"></circle>
      <line endX="195" startY="105" marked="false" color="255" endY="60" startX="150"></line>
      <line endX="105" startY="105" marked="false" color="255" endY="60" startX="150"></line>
    </shape>
    <shape name="car" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="300" y="180"></point>
        <point x="279" y="164"></point>
        <point x="261" y="144"></point>
        <point x="240" y="135"></point>
        <point x="226" y="132"></point>
        <point x="213" y="106"></point>
        <point x="203" y="84"></point>
        <point x="185" y="63"></point>
        <point x="159" y="50"></point>
        <point x="135" y="50"></point>
        <point x="75" y="60"></point>
        <point x="0" y="150"></point>
        <point x="0" y="165"></point>
        <point x="0" y="225"></point>
        <point x="300" y="225"></point>
        <point x="300" y="180"></point>
      </polygon>
      <circle x="180" y="180" marked="false" color="255" diameter="90" filled="true"></circle>
      <circle x="30" y="180" marked="false" color="255" diameter="90" filled="true"></circle>
      <polygon color="255" filled="true" marked="false">
        <point x="162" y="80"></point>
        <point x="132" y="78"></point>
        <point x="134" y="135"></point>
        <point x="209" y="135"></point>
        <point x="194" y="105"></point>
        <point x="189" y="96"></point>
        <point x="180" y="89"></point>
      </polygon>
      <circle x="47" y="195" marked="true" color="-1920102913" diameter="58" filled="true"></circle>
      <circle x="195" y="195" marked="true" color="-1920102913" diameter="58" filled="true"></circle>
    </shape>
    <shape name="catfish" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="283" y="153"></point>
        <point x="288" y="149"></point>
        <point x="271" y="146"></point>
        <point x="285" y="135"></point>
        <point x="285" y="135"></point>
        <point x="247" y="119"></point>
        <point x="190" y="107"></point>
        <point x="104" y="117"></point>
        <point x="63" y="129"></point>
        <point x="53" y="131"></point>
        <point x="31" y="121"></point>
        <point x="7" y="125"></point>
        <point x="25" y="144"></point>
        <point x="6" y="168"></point>
        <point x="33" y="163"></point>
        <point x="56" y="150"></point>
        <point x="69" y="154"></point>
        <point x="64" y="164"></point>
        <point x="80" y="161"></point>
        <point x="86" y="156"></point>
        <point x="132" y="160"></point>
        <point x="209" y="164"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="207" y="164"></point>
        <point x="157" y="179"></point>
        <point x="158" y="161"></point>
        <point x="176" y="163"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="223" y="114"></point>
        <point x="220" y="101"></point>
        <point x="206" y="95"></point>
        <point x="191" y="91"></point>
        <point x="178" y="96"></point>
        <point x="190" y="107"></point>
      </polygon>
      <circle x="256" y="129" marked="false" color="-1" diameter="12" filled="true"></circle>
      <polygon color="-1653716737" filled="true" marked="false">
        <point x="108" y="117"></point>
        <point x="80" y="114"></point>
        <point x="80" y="126"></point>
      </polygon>
      <circle x="258" y="130" marked="false" color="255" diameter="6" filled="true"></circle>
      <polygon color="-1653716737" filled="true" marked="false">
        <point x="242" y="142"></point>
        <point x="217" y="139"></point>
        <point x="212" y="144"></point>
        <point x="211" y="149"></point>
        <point x="217" y="154"></point>
        <point x="244" y="149"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="129" y="159"></point>
        <point x="106" y="174"></point>
        <point x="59" y="168"></point>
        <point x="69" y="154"></point>
        <point x="84" y="155"></point>
      </polygon>
      <line endX="249" startY="147" marked="false" color="255" endY="167" startX="264"></line>
      <circle x="255" y="127" marked="false" color="255" diameter="14" filled="false"></circle>
      <line endX="115" startY="130" marked="false" color="255" endY="115" startX="54"></line>
      <line endX="188" startY="115" marked="false" color="255" endY="107" startX="117"></line>
      <line endX="250" startY="107" marked="false" color="255" endY="118" startX="190"></line>
      <line endX="220" startY="113" marked="false" color="255" endY="103" startX="224"></line>
      <line endX="179" startY="107" marked="false" color="255" endY="97" startX="190"></line>
      <line endX="190" startY="94" marked="false" color="255" endY="91" startX="181"></line>
      <line endX="77" startY="124" marked="false" color="255" endY="113" startX="78"></line>
      <line endX="109" startY="114" marked="false" color="255" endY="116" startX="80"></line>
      <line endX="31" startY="130" marked="false" color="255" endY="118" startX="50"></line>
      <line endX="6" startY="119" marked="false" color="255" endY="123" startX="32"></line>
      <line endX="24" startY="125" marked="false" color="255" endY="144" startX="8"></line>
      <line endX="5" startY="144" marked="false" color="255" endY="166" startX="25"></line>
      <line endX="33" startY="168" marked="false" color="255" endY="164" startX="8"></line>
      <line endX="55" startY="163" marked="false" color="255" endY="149" startX="34"></line>
      <line endX="68" startY="150" marked="false" color="255" endY="154" startX="55"></line>
      <line endX="204" startY="154" marked="false" color="255" endY="164" startX="65"></line>
      <line endX="271" startY="135" marked="false" color="255" endY="146" startX="283"></line>
      <line endX="285" startY="146" marked="false" color="255" endY="147" startX="269"></line>
      <line endX="281" startY="149" marked="false" color="255" endY="154" startX="287"></line>
      <line endX="279" startY="164" marked="false" color="255" endY="153" startX="203"></line>
      <line endX="57" startY="154" marked="false" color="255" endY="167" startX="68"></line>
      <line endX="105" startY="167" marked="false" color="255" endY="174" startX="58"></line>
      <line endX="129" startY="174" marked="false" color="255" endY="158" startX="105"></line>
      <line endX="156" startY="161" marked="false" color="255" endY="182" startX="157"></line>
      <line endX="202" startY="178" marked="false" color="255" endY="165" startX="158"></line>
      <line endX="217" startY="141" marked="false" color="255" endY="139" startX="243"></line>
      <line endX="210" startY="139" marked="false" color="255" endY="145" startX="217"></line>
      <line endX="217" startY="146" marked="false" color="255" endY="153" startX="210"></line>
      <line endX="244" startY="153" marked="false" color="255" endY="149" startX="218"></line>
      <line endX="242" startY="149" marked="false" color="255" endY="141" startX="243"></line>
    </shape>
    <shape name="circle" rotatable="false" editableColorIndex="0">
      <circle x="0" y="0" marked="true" color="-1920102913" diameter="300" filled="true"></circle>
    </shape>
    <shape name="circle 2" rotatable="false" editableColorIndex="0">
      <circle x="0" y="0" marked="true" color="-1920102913" diameter="300" filled="true"></circle>
      <circle x="30" y="30" marked="false" color="255" diameter="240" filled="true"></circle>
    </shape>
    <shape name="cow" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="200" y="193"></point>
        <point x="197" y="249"></point>
        <point x="179" y="249"></point>
        <point x="177" y="196"></point>
        <point x="166" y="187"></point>
        <point x="140" y="189"></point>
        <point x="93" y="191"></point>
        <point x="78" y="179"></point>
        <point x="72" y="211"></point>
        <point x="49" y="209"></point>
        <point x="48" y="181"></point>
        <point x="37" y="149"></point>
        <point x="25" y="120"></point>
        <point x="25" y="89"></point>
        <point x="45" y="72"></point>
        <point x="103" y="84"></point>
        <point x="179" y="75"></point>
        <point x="198" y="76"></point>
        <point x="252" y="64"></point>
        <point x="272" y="81"></point>
        <point x="293" y="103"></point>
        <point x="285" y="121"></point>
        <point x="255" y="121"></point>
        <point x="242" y="118"></point>
        <point x="224" y="167"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="73" y="210"></point>
        <point x="86" y="251"></point>
        <point x="62" y="249"></point>
        <point x="48" y="208"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="25" y="114"></point>
        <point x="16" y="195"></point>
        <point x="9" y="204"></point>
        <point x="23" y="213"></point>
        <point x="25" y="200"></point>
        <point x="39" y="123"></point>
      </polygon>
    </shape>
    <shape name="cylinder" rotatable="false" editableColorIndex="0">
      <circle x="0" y="0" marked="true" color="-1920102913" diameter="300" filled="true"></circle>
    </shape>
    <shape name="dot" rotatable="false" editableColorIndex="0">
      <circle x="90" y="90" marked="true" color="-1920102913" diameter="120" filled="true"></circle>
    </shape>
    <shape name="face happy" rotatable="false" editableColorIndex="0">
      <circle x="8" y="8" marked="true" color="-1920102913" diameter="285" filled="true"></circle>
      <circle x="60" y="75" marked="false" color="255" diameter="60" filled="true"></circle>
      <circle x="180" y="75" marked="false" color="255" diameter="60" filled="true"></circle>
      <polygon color="255" filled="true" marked="false">
        <point x="150" y="255"></point>
        <point x="90" y="239"></point>
        <point x="62" y="213"></point>
        <point x="47" y="191"></point>
        <point x="67" y="179"></point>
        <point x="90" y="203"></point>
        <point x="109" y="218"></point>
        <point x="150" y="225"></point>
        <point x="192" y="218"></point>
        <point x="210" y="203"></point>
        <point x="227" y="181"></point>
        <point x="251" y="194"></point>
        <point x="236" y="217"></point>
        <point x="212" y="240"></point>
      </polygon>
    </shape>
    <shape name="face neutral" rotatable="false" editableColorIndex="0">
      <circle x="8" y="7" marked="true" color="-1920102913" diameter="285" filled="true"></circle>
      <circle x="60" y="75" marked="false" color="255" diameter="60" filled="true"></circle>
      <circle x="180" y="75" marked="false" color="255" diameter="60" filled="true"></circle>
      <rectangle endX="240" startY="195" marked="false" color="255" endY="225" startX="60" filled="true"></rectangle>
    </shape>
    <shape name="face sad" rotatable="false" editableColorIndex="0">
      <circle x="8" y="8" marked="true" color="-1920102913" diameter="285" filled="true"></circle>
      <circle x="60" y="75" marked="false" color="255" diameter="60" filled="true"></circle>
      <circle x="180" y="75" marked="false" color="255" diameter="60" filled="true"></circle>
      <polygon color="255" filled="true" marked="false">
        <point x="150" y="168"></point>
        <point x="90" y="184"></point>
        <point x="62" y="210"></point>
        <point x="47" y="232"></point>
        <point x="67" y="244"></point>
        <point x="90" y="220"></point>
        <point x="109" y="205"></point>
        <point x="150" y="198"></point>
        <point x="192" y="205"></point>
        <point x="210" y="220"></point>
        <point x="227" y="242"></point>
        <point x="251" y="229"></point>
        <point x="236" y="206"></point>
        <point x="212" y="183"></point>
      </polygon>
    </shape>
    <shape name="fish" rotatable="false" editableColorIndex="14">
      <polygon color="-1" filled="true" marked="false">
        <point x="44" y="131"></point>
        <point x="29" y="107"></point>
        <point x="9" y="91"></point>
        <point x="0" y="120"></point>
        <point x="15" y="150"></point>
        <point x="0" y="180"></point>
        <point x="10" y="207"></point>
        <point x="30" y="197"></point>
        <point x="45" y="166"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="141" y="186"></point>
        <point x="118" y="208"></point>
        <point x="97" y="205"></point>
        <point x="78" y="196"></point>
        <point x="56" y="184"></point>
        <point x="80" y="171"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="96" y="101"></point>
        <point x="56" y="109"></point>
        <point x="70" y="117"></point>
        <point x="86" y="124"></point>
        <point x="140" y="113"></point>
        <point x="128" y="97"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="false">
        <point x="34" y="134"></point>
        <point x="156" y="109"></point>
        <point x="228" y="111"></point>
        <point x="280" y="126"></point>
        <point x="296" y="144"></point>
        <point x="277" y="162"></point>
        <point x="293" y="159"></point>
        <point x="264" y="182"></point>
        <point x="200" y="192"></point>
        <point x="148" y="188"></point>
        <point x="34" y="164"></point>
      </polygon>
      <circle x="261" y="133" marked="false" color="-1" diameter="20" filled="true"></circle>
      <polygon color="-1" filled="true" marked="false">
        <point x="262" y="183"></point>
        <point x="247" y="205"></point>
        <point x="221" y="216"></point>
        <point x="194" y="211"></point>
        <point x="207" y="190"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="247" y="116"></point>
        <point x="238" y="85"></point>
        <point x="181" y="95"></point>
        <point x="182" y="111"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="222" y="152"></point>
        <point x="186" y="142"></point>
        <point x="191" y="162"></point>
        <point x="185" y="174"></point>
        <point x="222" y="167"></point>
      </polygon>
      <circle x="263" y="138" marked="true" color="255" diameter="11" filled="true"></circle>
      <line endX="190" startY="142" marked="true" color="255" endY="158" startX="186"></line>
      <line endX="185" startY="158" marked="true" color="255" endY="175" startX="190"></line>
      <line endX="222" startY="174" marked="true" color="255" endY="167" startX="187"></line>
      <line endX="223" startY="140" marked="true" color="255" endY="152" startX="186"></line>
      <line endX="222" startY="153" marked="true" color="255" endY="167" startX="223"></line>
      <circle x="259" y="132" marked="true" color="255" diameter="22" filled="false"></circle>
      <line endX="156" startY="134" marked="true" color="255" endY="108" startX="35"></line>
      <line endX="35" startY="135" marked="true" color="255" endY="163" startX="35"></line>
      <line endX="151" startY="164" marked="true" color="255" endY="188" startX="35"></line>
      <line endX="246" startY="108" marked="true" color="255" endY="116" startX="159"></line>
      <line endX="277" startY="116" marked="true" color="255" endY="124" startX="246"></line>
      <line endX="294" startY="126" marked="true" color="255" endY="141" startX="280"></line>
      <line endX="279" startY="144" marked="true" color="255" endY="159" startX="296"></line>
      <line endX="291" startY="160" marked="true" color="255" endY="158" startX="277"></line>
      <line endX="199" startY="189" marked="true" color="255" endY="194" startX="156"></line>
      <line endX="263" startY="191" marked="true" color="255" endY="183" startX="198"></line>
      <line endX="290" startY="183" marked="true" color="255" endY="162" startX="263"></line>
      <line endX="29" startY="131" marked="true" color="255" endY="105" startX="46"></line>
      <line endX="10" startY="106" marked="true" color="255" endY="88" startX="28"></line>
      <line endX="-1" startY="90" marked="true" color="255" endY="121" startX="9"></line>
      <line endX="14" startY="123" marked="true" color="255" endY="150" startX="0"></line>
      <line endX="0" startY="150" marked="true" color="255" endY="173" startX="14"></line>
      <line endX="8" startY="181" marked="true" color="255" endY="206" startX="-1"></line>
      <line endX="46" startY="198" marked="true" color="255" endY="166" startX="29"></line>
      <line endX="28" startY="207" marked="true" color="255" endY="199" startX="10"></line>
      <line endX="58" startY="124" marked="true" color="255" endY="110" startX="86"></line>
      <line endX="124" startY="108" marked="true" color="255" endY="94" startX="56"></line>
      <line endX="139" startY="96" marked="true" color="255" endY="112" startX="128"></line>
      <line endX="181" startY="110" marked="true" color="255" endY="95" startX="182"></line>
      <line endX="238" startY="94" marked="true" color="255" endY="85" startX="182"></line>
      <line endX="247" startY="85" marked="true" color="255" endY="116" startX="238"></line>
      <line endX="56" startY="172" marked="true" color="255" endY="182" startX="76"></line>
      <line endX="97" startY="184" marked="true" color="255" endY="206" startX="57"></line>
      <line endX="116" startY="205" marked="true" color="255" endY="208" startX="96"></line>
      <line endX="140" startY="208" marked="true" color="255" endY="186" startX="118"></line>
      <line endX="192" startY="190" marked="true" color="255" endY="212" startX="205"></line>
      <line endX="221" startY="211" marked="true" color="255" endY="217" startX="196"></line>
      <line endX="248" startY="217" marked="true" color="255" endY="206" startX="222"></line>
      <line endX="263" startY="203" marked="true" color="255" endY="183" startX="249"></line>
    </shape>
    <shape name="fish 2" rotatable="false" editableColorIndex="14">
      <polygon color="-1653716737" filled="true" marked="false">
        <point x="56" y="133"></point>
        <point x="34" y="127"></point>
        <point x="12" y="105"></point>
        <point x="21" y="126"></point>
        <point x="23" y="146"></point>
        <point x="22" y="165"></point>
        <point x="10" y="194"></point>
        <point x="32" y="177"></point>
        <point x="55" y="173"></point>
      </polygon>
      <polygon color="255" filled="true" marked="true">
        <point x="124" y="211"></point>
        <point x="106" y="224"></point>
        <point x="84" y="223"></point>
        <point x="60" y="207"></point>
        <point x="43" y="194"></point>
        <point x="65" y="181"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="false">
        <point x="50" y="131"></point>
        <point x="154" y="91"></point>
        <point x="229" y="95"></point>
        <point x="264" y="123"></point>
        <point x="291" y="146"></point>
        <point x="271" y="155"></point>
        <point x="291" y="153"></point>
        <point x="266" y="190"></point>
        <point x="206" y="220"></point>
        <point x="147" y="222"></point>
        <point x="48" y="176"></point>
      </polygon>
      <circle x="227" y="121" marked="false" color="-1" diameter="30" filled="true"></circle>
      <circle x="241" y="127" marked="true" color="255" diameter="12" filled="true"></circle>
      <polygon color="-1653716737" filled="true" marked="false">
        <point x="166" y="221"></point>
        <point x="144" y="237"></point>
        <point x="195" y="237"></point>
        <point x="206" y="219"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="false">
        <point x="102" y="189"></point>
        <point x="109" y="203"></point>
      </polygon>
      <polygon color="-1653716737" filled="true" marked="false">
        <point x="215" y="182"></point>
        <point x="181" y="192"></point>
        <point x="171" y="177"></point>
        <point x="169" y="164"></point>
        <point x="152" y="142"></point>
        <point x="154" y="123"></point>
        <point x="170" y="119"></point>
        <point x="223" y="163"></point>
      </polygon>
      <polygon color="255" filled="true" marked="true">
        <point x="228" y="95"></point>
        <point x="205" y="77"></point>
        <point x="137" y="75"></point>
        <point x="75" y="108"></point>
        <point x="105" y="111"></point>
        <point x="154" y="92"></point>
      </polygon>
      <line endX="152" startY="118" marked="true" color="255" endY="125" startX="167"></line>
      <line endX="221" startY="118" marked="true" color="255" endY="162" startX="168"></line>
      <line endX="214" startY="163" marked="true" color="255" endY="183" startX="221"></line>
      <line endX="182" startY="183" marked="true" color="255" endY="192" startX="213"></line>
      <circle x="227" y="120" marked="true" color="255" diameter="31" filled="false"></circle>
      <line endX="151" startY="126" marked="true" color="255" endY="141" startX="152"></line>
      <line endX="169" startY="140" marked="true" color="255" endY="164" startX="150"></line>
      <line endX="170" startY="165" marked="true" color="255" endY="176" startX="170"></line>
      <line endX="181" startY="176" marked="true" color="255" endY="193" startX="170"></line>
      <line endX="146" startY="221" marked="true" color="255" endY="235" startX="166"></line>
      <line endX="195" startY="236" marked="true" color="255" endY="236" startX="142"></line>
      <line endX="206" startY="239" marked="true" color="255" endY="218" startX="197"></line>
      <line endX="145" startY="218" marked="true" color="255" endY="222" startX="209"></line>
      <line endX="267" startY="218" marked="true" color="255" endY="189" startX="210"></line>
      <line endX="48" startY="129" marked="true" color="255" endY="177" startX="50"></line>
      <line endX="147" startY="176" marked="true" color="255" endY="223" startX="47"></line>
      <line endX="151" startY="130" marked="true" color="255" endY="91" startX="51"></line>
      <line endX="226" startY="90" marked="true" color="255" endY="94" startX="151"></line>
      <line endX="290" startY="95" marked="true" color="255" endY="145" startX="230"></line>
      <line endX="273" startY="146" marked="true" color="255" endY="153" startX="290"></line>
      <line endX="292" startY="154" marked="true" color="255" endY="153" startX="273"></line>
      <line endX="35" startY="130" marked="true" color="255" endY="127" startX="52"></line>
      <line endX="14" startY="125" marked="true" color="255" endY="106" startX="34"></line>
      <line endX="21" startY="106" marked="true" color="255" endY="129" startX="11"></line>
      <line endX="21" startY="129" marked="true" color="255" endY="165" startX="21"></line>
      <line endX="8" startY="163" marked="true" color="255" endY="193" startX="21"></line>
      <line endX="32" startY="193" marked="true" color="255" endY="177" startX="10"></line>
      <line endX="48" startY="177" marked="true" color="255" endY="174" startX="32"></line>
    </shape>
    <shape name="flag" rotatable="false" editableColorIndex="0">
      <rectangle endX="75" startY="15" marked="true" color="-1920102913" endY="300" startX="60" filled="true"></rectangle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="90" y="150"></point>
        <point x="270" y="90"></point>
        <point x="90" y="30"></point>
      </polygon>
      <line endX="90" startY="135" marked="true" color="-1920102913" endY="135" startX="75"></line>
      <line endX="90" startY="45" marked="true" color="-1920102913" endY="45" startX="75"></line>
    </shape>
    <shape name="flower" rotatable="false" editableColorIndex="0">
      <polygon color="1504722175" filled="true" marked="false">
        <point x="135" y="120"></point>
        <point x="165" y="165"></point>
        <point x="180" y="210"></point>
        <point x="180" y="240"></point>
        <point x="150" y="300"></point>
        <point x="165" y="300"></point>
        <point x="195" y="240"></point>
        <point x="195" y="195"></point>
        <point x="165" y="135"></point>
      </polygon>
      <circle x="85" y="132" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="130" y="147" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="192" y="85" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="85" y="40" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="177" y="40" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="177" y="132" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="70" y="85" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="130" y="25" marked="true" color="-1920102913" diameter="38" filled="true"></circle>
      <circle x="96" y="51" marked="true" color="-1920102913" diameter="108" filled="true"></circle>
      <circle x="113" y="68" marked="false" color="255" diameter="74" filled="true"></circle>
      <polygon color="1504722175" filled="true" marked="false">
        <point x="189" y="233"></point>
        <point x="219" y="188"></point>
        <point x="249" y="173"></point>
        <point x="279" y="188"></point>
        <point x="234" y="218"></point>
      </polygon>
      <polygon color="1504722175" filled="true" marked="false">
        <point x="180" y="255"></point>
        <point x="150" y="210"></point>
        <point x="105" y="210"></point>
        <point x="75" y="240"></point>
        <point x="135" y="240"></point>
      </polygon>
    </shape>
    <shape name="flower budding" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="163" y="60"></point>
        <point x="139" y="121"></point>
        <point x="150" y="166"></point>
        <point x="150" y="196"></point>
        <point x="120" y="256"></point>
        <point x="135" y="256"></point>
        <point x="165" y="196"></point>
        <point x="161" y="121"></point>
        <point x="176" y="85"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="159" y="169"></point>
        <point x="189" y="124"></point>
        <point x="219" y="109"></point>
        <point x="249" y="124"></point>
        <point x="204" y="154"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="159" y="205"></point>
        <point x="129" y="160"></point>
        <point x="84" y="160"></point>
        <point x="54" y="190"></point>
        <point x="114" y="190"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="144" y="128"></point>
        <point x="132" y="102"></point>
        <point x="101" y="85"></point>
        <point x="64" y="77"></point>
        <point x="78" y="105"></point>
        <point x="111" y="126"></point>
        <point x="145" y="144"></point>
      </polygon>
    </shape>
    <shape name="house" rotatable="false" editableColorIndex="0">
      <rectangle endX="255" startY="120" marked="true" color="-1920102913" endY="285" startX="45" filled="true"></rectangle>
      <rectangle endX="180" startY="210" marked="false" color="255" endY="285" startX="120" filled="true"></rectangle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="15" y="120"></point>
        <point x="150" y="15"></point>
        <point x="285" y="120"></point>
      </polygon>
      <line endX="270" startY="120" marked="false" color="255" endY="120" startX="30"></line>
    </shape>
    <shape name="leaf" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="210"></point>
        <point x="135" y="195"></point>
        <point x="120" y="210"></point>
        <point x="60" y="210"></point>
        <point x="30" y="195"></point>
        <point x="60" y="180"></point>
        <point x="60" y="165"></point>
        <point x="15" y="135"></point>
        <point x="30" y="120"></point>
        <point x="15" y="105"></point>
        <point x="40" y="104"></point>
        <point x="45" y="90"></point>
        <point x="60" y="90"></point>
        <point x="90" y="105"></point>
        <point x="105" y="120"></point>
        <point x="120" y="120"></point>
        <point x="105" y="60"></point>
        <point x="120" y="60"></point>
        <point x="135" y="30"></point>
        <point x="150" y="15"></point>
        <point x="165" y="30"></point>
        <point x="180" y="60"></point>
        <point x="195" y="60"></point>
        <point x="180" y="120"></point>
        <point x="195" y="120"></point>
        <point x="210" y="105"></point>
        <point x="240" y="90"></point>
        <point x="255" y="90"></point>
        <point x="263" y="104"></point>
        <point x="285" y="105"></point>
        <point x="270" y="120"></point>
        <point x="285" y="135"></point>
        <point x="240" y="165"></point>
        <point x="240" y="180"></point>
        <point x="270" y="195"></point>
        <point x="240" y="210"></point>
        <point x="180" y="210"></point>
        <point x="165" y="195"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="195"></point>
        <point x="135" y="240"></point>
        <point x="120" y="255"></point>
        <point x="105" y="255"></point>
        <point x="105" y="285"></point>
        <point x="135" y="285"></point>
        <point x="165" y="240"></point>
        <point x="165" y="195"></point>
      </polygon>
    </shape>
    <shape name="line" rotatable="true" editableColorIndex="0">
      <line endX="150" startY="0" marked="true" color="-1920102913" endY="300" startX="150"></line>
    </shape>
    <shape name="line half" rotatable="true" editableColorIndex="0">
      <line endX="150" startY="0" marked="true" color="-1920102913" endY="150" startX="150"></line>
    </shape>
    <shape name="pentagon" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="15"></point>
        <point x="15" y="120"></point>
        <point x="60" y="285"></point>
        <point x="240" y="285"></point>
        <point x="285" y="120"></point>
      </polygon>
    </shape>
    <shape name="person" rotatable="false" editableColorIndex="0">
      <circle x="110" y="5" marked="true" color="-1920102913" diameter="80" filled="true"></circle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="105" y="90"></point>
        <point x="120" y="195"></point>
        <point x="90" y="285"></point>
        <point x="105" y="300"></point>
        <point x="135" y="300"></point>
        <point x="150" y="225"></point>
        <point x="165" y="300"></point>
        <point x="195" y="300"></point>
        <point x="210" y="285"></point>
        <point x="180" y="195"></point>
        <point x="195" y="90"></point>
      </polygon>
      <rectangle endX="172" startY="79" marked="true" color="-1920102913" endY="94" startX="127" filled="true"></rectangle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="195" y="90"></point>
        <point x="240" y="150"></point>
        <point x="225" y="180"></point>
        <point x="165" y="105"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="105" y="90"></point>
        <point x="60" y="150"></point>
        <point x="75" y="180"></point>
        <point x="135" y="105"></point>
      </polygon>
    </shape>
    <shape name="plant" rotatable="false" editableColorIndex="0">
      <rectangle endX="165" startY="90" marked="true" color="-1920102913" endY="300" startX="135" filled="true"></rectangle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="255"></point>
        <point x="90" y="210"></point>
        <point x="45" y="195"></point>
        <point x="75" y="255"></point>
        <point x="135" y="285"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="165" y="255"></point>
        <point x="210" y="210"></point>
        <point x="255" y="195"></point>
        <point x="225" y="255"></point>
        <point x="165" y="285"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="180"></point>
        <point x="90" y="135"></point>
        <point x="45" y="120"></point>
        <point x="75" y="180"></point>
        <point x="135" y="210"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="165" y="180"></point>
        <point x="165" y="210"></point>
        <point x="225" y="180"></point>
        <point x="255" y="120"></point>
        <point x="210" y="135"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="105"></point>
        <point x="90" y="60"></point>
        <point x="45" y="45"></point>
        <point x="75" y="105"></point>
        <point x="135" y="135"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="165" y="105"></point>
        <point x="165" y="135"></point>
        <point x="225" y="105"></point>
        <point x="255" y="45"></point>
        <point x="210" y="60"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="90"></point>
        <point x="120" y="45"></point>
        <point x="150" y="15"></point>
        <point x="180" y="45"></point>
        <point x="165" y="90"></point>
      </polygon>
    </shape>
    <shape name="plant medium" rotatable="false" editableColorIndex="0">
      <rectangle endX="165" startY="165" marked="true" color="-1920102913" endY="300" startX="135" filled="true"></rectangle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="255"></point>
        <point x="90" y="210"></point>
        <point x="45" y="195"></point>
        <point x="75" y="255"></point>
        <point x="135" y="285"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="165" y="255"></point>
        <point x="210" y="210"></point>
        <point x="255" y="195"></point>
        <point x="225" y="255"></point>
        <point x="165" y="285"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="180"></point>
        <point x="90" y="135"></point>
        <point x="45" y="120"></point>
        <point x="75" y="180"></point>
        <point x="135" y="210"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="165" y="180"></point>
        <point x="165" y="210"></point>
        <point x="225" y="180"></point>
        <point x="255" y="120"></point>
        <point x="210" y="135"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="165"></point>
        <point x="120" y="120"></point>
        <point x="150" y="90"></point>
        <point x="180" y="120"></point>
        <point x="165" y="165"></point>
      </polygon>
    </shape>
    <shape name="plant small" rotatable="false" editableColorIndex="0">
      <rectangle endX="165" startY="240" marked="true" color="-1920102913" endY="300" startX="135" filled="true"></rectangle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="255"></point>
        <point x="90" y="210"></point>
        <point x="45" y="195"></point>
        <point x="75" y="255"></point>
        <point x="135" y="285"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="165" y="255"></point>
        <point x="210" y="210"></point>
        <point x="255" y="195"></point>
        <point x="225" y="255"></point>
        <point x="165" y="285"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="135" y="240"></point>
        <point x="120" y="195"></point>
        <point x="150" y="165"></point>
        <point x="180" y="195"></point>
        <point x="165" y="240"></point>
      </polygon>
    </shape>
    <shape name="salmon" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="283" y="153"></point>
        <point x="287" y="147"></point>
        <point x="271" y="146"></point>
        <point x="287" y="142"></point>
        <point x="285" y="135"></point>
        <point x="247" y="119"></point>
        <point x="190" y="107"></point>
        <point x="104" y="117"></point>
        <point x="54" y="133"></point>
        <point x="39" y="134"></point>
        <point x="20" y="114"></point>
        <point x="12" y="116"></point>
        <point x="19" y="142"></point>
        <point x="12" y="171"></point>
        <point x="20" y="175"></point>
        <point x="40" y="158"></point>
        <point x="69" y="154"></point>
        <point x="64" y="164"></point>
        <point x="80" y="161"></point>
        <point x="86" y="156"></point>
        <point x="132" y="160"></point>
        <point x="209" y="164"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="209" y="164"></point>
        <point x="168" y="169"></point>
        <point x="145" y="161"></point>
        <point x="177" y="161"></point>
      </polygon>
      <polygon color="255" filled="true" marked="false">
        <point x="196" y="108"></point>
        <point x="186" y="97"></point>
        <point x="175" y="92"></point>
        <point x="161" y="99"></point>
        <point x="149" y="102"></point>
        <point x="128" y="112"></point>
      </polygon>
      <circle x="256" y="129" marked="false" color="-1" diameter="12" filled="true"></circle>
      <polygon color="255" filled="true" marked="false">
        <point x="78" y="125"></point>
        <point x="63" y="118"></point>
        <point x="63" y="130"></point>
      </polygon>
      <circle x="258" y="130" marked="false" color="255" diameter="6" filled="true"></circle>
      <polygon color="255" filled="true" marked="false">
        <point x="232" y="146"></point>
        <point x="207" y="143"></point>
        <point x="202" y="148"></point>
        <point x="201" y="153"></point>
        <point x="207" y="158"></point>
        <point x="234" y="153"></point>
      </polygon>
      <polygon color="-1" filled="true" marked="false">
        <point x="85" y="156"></point>
        <point x="79" y="160"></point>
        <point x="62" y="164"></point>
        <point x="67" y="154"></point>
        <point x="84" y="155"></point>
      </polygon>
      <line endX="54" startY="134" marked="false" color="255" endY="133" startX="40"></line>
      <line endX="99" startY="132" marked="false" color="255" endY="116" startX="55"></line>
      <line endX="195" startY="116" marked="false" color="255" endY="107" startX="105"></line>
      <line endX="10" startY="112" marked="false" color="255" endY="115" startX="18"></line>
      <line endX="19" startY="117" marked="false" color="255" endY="144" startX="11"></line>
      <line endX="10" startY="144" marked="false" color="255" endY="168" startX="19"></line>
      <line endX="18" startY="170" marked="false" color="255" endY="176" startX="10"></line>
      <line endX="39" startY="175" marked="false" color="255" endY="157" startX="20"></line>
      <line endX="73" startY="157" marked="false" color="255" endY="153" startX="38"></line>
      <line endX="145" startY="154" marked="false" color="255" endY="160" startX="75"></line>
      <line endX="208" startY="159" marked="false" color="255" endY="163" startX="146"></line>
      <line endX="285" startY="165" marked="false" color="255" endY="152" startX="210"></line>
      <line endX="286" startY="164" marked="false" color="255" endY="155" startX="204"></line>
      <line endX="285" startY="154" marked="false" color="255" endY="148" startX="285"></line>
      <line endX="273" startY="146" marked="false" color="255" endY="145" startX="283"></line>
      <line endX="286" startY="145" marked="false" color="255" endY="144" startX="274"></line>
      <line endX="286" startY="143" marked="false" color="255" endY="137" startX="287"></line>
      <line endX="252" startY="137" marked="false" color="255" endY="118" startX="287"></line>
      <line endX="195" startY="120" marked="false" color="255" endY="107" startX="254"></line>
      <line endX="58" startY="155" marked="false" color="255" endY="163" startX="66"></line>
      <line endX="79" startY="165" marked="false" color="255" endY="162" startX="61"></line>
      <line endX="87" startY="161" marked="false" color="255" endY="157" startX="80"></line>
      <circle x="254" y="128" marked="false" color="255" diameter="14" filled="false"></circle>
    </shape>
    <shape name="sheep" rotatable="false" editableColorIndex="15">
      <circle x="203" y="65" marked="true" color="-1" diameter="88" filled="true"></circle>
      <circle x="70" y="65" marked="true" color="-1" diameter="162" filled="true"></circle>
      <circle x="150" y="105" marked="true" color="-1" diameter="120" filled="true"></circle>
      <polygon color="-1920102913" filled="true" marked="false">
        <point x="218" y="120"></point>
        <point x="240" y="165"></point>
        <point x="255" y="165"></point>
        <point x="278" y="120"></point>
      </polygon>
      <circle x="214" y="72" marked="false" color="-1920102913" diameter="67" filled="true"></circle>
      <rectangle endX="179" startY="223" marked="true" color="-1" endY="298" startX="164" filled="true"></rectangle>
      <polygon color="-1" filled="true" marked="true">
        <point x="45" y="285"></point>
        <point x="30" y="285"></point>
        <point x="30" y="240"></point>
        <point x="15" y="195"></point>
        <point x="45" y="210"></point>
      </polygon>
      <circle x="3" y="83" marked="true" color="-1" diameter="150" filled="true"></circle>
      <rectangle endX="80" startY="221" marked="true" color="-1" endY="296" startX="65" filled="true"></rectangle>
      <polygon color="-1" filled="true" marked="true">
        <point x="195" y="285"></point>
        <point x="210" y="285"></point>
        <point x="210" y="240"></point>
        <point x="240" y="210"></point>
        <point x="195" y="210"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="false">
        <point x="276" y="85"></point>
        <point x="285" y="105"></point>
        <point x="302" y="99"></point>
        <point x="294" y="83"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="false">
        <point x="219" y="85"></point>
        <point x="210" y="105"></point>
        <point x="193" y="99"></point>
        <point x="201" y="83"></point>
      </polygon>
    </shape>
    <shape name="square" rotatable="false" editableColorIndex="0">
      <rectangle endX="270" startY="30" marked="true" color="-1920102913" endY="270" startX="30" filled="true"></rectangle>
    </shape>
    <shape name="square 2" rotatable="false" editableColorIndex="0">
      <rectangle endX="270" startY="30" marked="true" color="-1920102913" endY="270" startX="30" filled="true"></rectangle>
      <rectangle endX="240" startY="60" marked="false" color="255" endY="240" startX="60" filled="true"></rectangle>
    </shape>
    <shape name="star" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="151" y="1"></point>
        <point x="185" y="108"></point>
        <point x="298" y="108"></point>
        <point x="207" y="175"></point>
        <point x="242" y="282"></point>
        <point x="151" y="216"></point>
        <point x="59" y="282"></point>
        <point x="94" y="175"></point>
        <point x="3" y="108"></point>
        <point x="116" y="108"></point>
      </polygon>
    </shape>
    <shape name="target" rotatable="false" editableColorIndex="0">
      <circle x="0" y="0" marked="true" color="-1920102913" diameter="300" filled="true"></circle>
      <circle x="30" y="30" marked="false" color="255" diameter="240" filled="true"></circle>
      <circle x="60" y="60" marked="true" color="-1920102913" diameter="180" filled="true"></circle>
      <circle x="90" y="90" marked="false" color="255" diameter="120" filled="true"></circle>
      <circle x="120" y="120" marked="true" color="-1920102913" diameter="60" filled="true"></circle>
    </shape>
    <shape name="tree" rotatable="false" editableColorIndex="0">
      <circle x="118" y="3" marked="true" color="-1920102913" diameter="94" filled="true"></circle>
      <rectangle endX="180" startY="195" marked="false" color="-1653716737" endY="300" startX="120" filled="true"></rectangle>
      <circle x="65" y="21" marked="true" color="-1920102913" diameter="108" filled="true"></circle>
      <circle x="116" y="41" marked="true" color="-1920102913" diameter="127" filled="true"></circle>
      <circle x="45" y="90" marked="true" color="-1920102913" diameter="120" filled="true"></circle>
      <circle x="104" y="74" marked="true" color="-1920102913" diameter="152" filled="true"></circle>
    </shape>
    <shape name="triangle" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="30"></point>
        <point x="15" y="255"></point>
        <point x="285" y="255"></point>
      </polygon>
    </shape>
    <shape name="triangle 2" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="150" y="30"></point>
        <point x="15" y="255"></point>
        <point x="285" y="255"></point>
      </polygon>
      <polygon color="255" filled="true" marked="false">
        <point x="151" y="99"></point>
        <point x="225" y="223"></point>
        <point x="75" y="224"></point>
      </polygon>
    </shape>
    <shape name="truck" rotatable="false" editableColorIndex="0">
      <rectangle endX="195" startY="45" marked="true" color="-1920102913" endY="187" startX="4" filled="true"></rectangle>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="296" y="193"></point>
        <point x="296" y="150"></point>
        <point x="259" y="134"></point>
        <point x="244" y="104"></point>
        <point x="208" y="104"></point>
        <point x="207" y="194"></point>
      </polygon>
      <rectangle endX="195" startY="60" marked="false" color="-1" endY="105" startX="195" filled="true"></rectangle>
      <polygon color="255" filled="true" marked="false">
        <point x="238" y="112"></point>
        <point x="252" y="141"></point>
        <point x="219" y="141"></point>
        <point x="218" y="112"></point>
      </polygon>
      <circle x="234" y="174" marked="false" color="255" diameter="42" filled="true"></circle>
      <rectangle endX="214" startY="185" marked="true" color="-1920102913" endY="194" startX="181" filled="true"></rectangle>
      <circle x="144" y="174" marked="false" color="255" diameter="42" filled="true"></circle>
      <circle x="24" y="174" marked="false" color="255" diameter="42" filled="true"></circle>
      <circle x="24" y="174" marked="true" color="-1920102913" diameter="42" filled="false"></circle>
      <circle x="144" y="174" marked="true" color="-1920102913" diameter="42" filled="false"></circle>
      <circle x="234" y="174" marked="true" color="-1920102913" diameter="42" filled="false"></circle>
    </shape>
    <shape name="turtle" rotatable="true" editableColorIndex="0">
      <polygon color="1504722175" filled="true" marked="false">
        <point x="215" y="204"></point>
        <point x="240" y="233"></point>
        <point x="246" y="254"></point>
        <point x="228" y="266"></point>
        <point x="215" y="252"></point>
        <point x="193" y="210"></point>
      </polygon>
      <polygon color="1504722175" filled="true" marked="false">
        <point x="195" y="90"></point>
        <point x="225" y="75"></point>
        <point x="245" y="75"></point>
        <point x="260" y="89"></point>
        <point x="269" y="108"></point>
        <point x="261" y="124"></point>
        <point x="240" y="105"></point>
        <point x="225" y="105"></point>
        <point x="210" y="105"></point>
      </polygon>
      <polygon color="1504722175" filled="true" marked="false">
        <point x="105" y="90"></point>
        <point x="75" y="75"></point>
        <point x="55" y="75"></point>
        <point x="40" y="89"></point>
        <point x="31" y="108"></point>
        <point x="39" y="124"></point>
        <point x="60" y="105"></point>
        <point x="75" y="105"></point>
        <point x="90" y="105"></point>
      </polygon>
      <polygon color="1504722175" filled="true" marked="false">
        <point x="132" y="85"></point>
        <point x="134" y="64"></point>
        <point x="107" y="51"></point>
        <point x="108" y="17"></point>
        <point x="150" y="2"></point>
        <point x="192" y="18"></point>
        <point x="192" y="52"></point>
        <point x="169" y="65"></point>
        <point x="172" y="87"></point>
      </polygon>
      <polygon color="1504722175" filled="true" marked="false">
        <point x="85" y="204"></point>
        <point x="60" y="233"></point>
        <point x="54" y="254"></point>
        <point x="72" y="266"></point>
        <point x="85" y="252"></point>
        <point x="107" y="210"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="119" y="75"></point>
        <point x="179" y="75"></point>
        <point x="209" y="101"></point>
        <point x="224" y="135"></point>
        <point x="220" y="225"></point>
        <point x="175" y="261"></point>
        <point x="128" y="261"></point>
        <point x="81" y="224"></point>
        <point x="74" y="135"></point>
        <point x="88" y="99"></point>
      </polygon>
    </shape>
    <shape name="wheel" rotatable="false" editableColorIndex="0">
      <circle x="3" y="3" marked="true" color="-1920102913" diameter="294" filled="true"></circle>
      <circle x="30" y="30" marked="false" color="255" diameter="240" filled="true"></circle>
      <line endX="150" startY="285" marked="true" color="-1920102913" endY="15" startX="150"></line>
      <line endX="285" startY="150" marked="true" color="-1920102913" endY="150" startX="15"></line>
      <circle x="120" y="120" marked="true" color="-1920102913" diameter="60" filled="true"></circle>
      <line endX="79" startY="40" marked="true" color="-1920102913" endY="269" startX="216"></line>
      <line endX="269" startY="84" marked="true" color="-1920102913" endY="221" startX="40"></line>
      <line endX="269" startY="216" marked="true" color="-1920102913" endY="79" startX="40"></line>
      <line endX="221" startY="40" marked="true" color="-1920102913" endY="269" startX="84"></line>
    </shape>
    <shape name="wolf" rotatable="false" editableColorIndex="0">
      <polygon color="255" filled="true" marked="false">
        <point x="253" y="133"></point>
        <point x="245" y="131"></point>
        <point x="245" y="133"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="2" y="194"></point>
        <point x="13" y="197"></point>
        <point x="30" y="191"></point>
        <point x="38" y="193"></point>
        <point x="38" y="205"></point>
        <point x="20" y="226"></point>
        <point x="20" y="257"></point>
        <point x="27" y="265"></point>
        <point x="38" y="266"></point>
        <point x="40" y="260"></point>
        <point x="31" y="253"></point>
        <point x="31" y="230"></point>
        <point x="60" y="206"></point>
        <point x="68" y="198"></point>
        <point x="75" y="209"></point>
        <point x="66" y="228"></point>
        <point x="65" y="243"></point>
        <point x="82" y="261"></point>
        <point x="84" y="268"></point>
        <point x="100" y="267"></point>
        <point x="103" y="261"></point>
        <point x="77" y="239"></point>
        <point x="79" y="231"></point>
        <point x="100" y="207"></point>
        <point x="98" y="196"></point>
        <point x="119" y="201"></point>
        <point x="143" y="202"></point>
        <point x="160" y="195"></point>
        <point x="166" y="210"></point>
        <point x="172" y="213"></point>
        <point x="173" y="238"></point>
        <point x="167" y="251"></point>
        <point x="160" y="248"></point>
        <point x="154" y="265"></point>
        <point x="169" y="264"></point>
        <point x="178" y="247"></point>
        <point x="186" y="240"></point>
        <point x="198" y="260"></point>
        <point x="200" y="271"></point>
        <point x="217" y="271"></point>
        <point x="219" y="262"></point>
        <point x="207" y="258"></point>
        <point x="195" y="230"></point>
        <point x="192" y="198"></point>
        <point x="210" y="184"></point>
        <point x="227" y="164"></point>
        <point x="242" y="144"></point>
        <point x="259" y="145"></point>
        <point x="284" y="151"></point>
        <point x="277" y="141"></point>
        <point x="293" y="140"></point>
        <point x="299" y="134"></point>
        <point x="297" y="127"></point>
        <point x="273" y="119"></point>
        <point x="270" y="105"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="-1" y="195"></point>
        <point x="14" y="180"></point>
        <point x="36" y="166"></point>
        <point x="40" y="153"></point>
        <point x="53" y="140"></point>
        <point x="82" y="131"></point>
        <point x="134" y="133"></point>
        <point x="159" y="126"></point>
        <point x="188" y="115"></point>
        <point x="227" y="108"></point>
        <point x="236" y="102"></point>
        <point x="238" y="98"></point>
        <point x="268" y="86"></point>
        <point x="269" y="92"></point>
        <point x="281" y="87"></point>
        <point x="269" y="103"></point>
        <point x="269" y="113"></point>
      </polygon>
    </shape>
    <shape name="x" rotatable="false" editableColorIndex="0">
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="270" y="75"></point>
        <point x="225" y="30"></point>
        <point x="30" y="225"></point>
        <point x="75" y="270"></point>
      </polygon>
      <polygon color="-1920102913" filled="true" marked="true">
        <point x="30" y="75"></point>
        <point x="75" y="30"></point>
        <point x="270" y="225"></point>
        <point x="225" y="270"></point>
      </polygon>
    </shape>
  </turtleShapes>
  <linkShapes>
    <shape name="default" curviness="0.0">
      <lines>
        <line x="-0.2" visible="false">
          <dash value="0.0"></dash>
          <dash value="1.0"></dash>
        </line>
        <line x="0.0" visible="true">
          <dash value="1.0"></dash>
          <dash value="0.0"></dash>
        </line>
        <line x="0.2" visible="false">
          <dash value="0.0"></dash>
          <dash value="1.0"></dash>
        </line>
      </lines>
      <indicator>
        <shape name="link direction" rotatable="true" editableColorIndex="0">
          <line endX="90" startY="150" marked="true" color="-1920102913" endY="180" startX="150"></line>
          <line endX="210" startY="150" marked="true" color="-1920102913" endY="180" startX="150"></line>
        </shape>
      </indicator>
    </shape>
  </linkShapes>
  <previewCommands>setup repeat 75 [ go ]</previewCommands>
  <experiments>
    <experiment name="PH_100_3C_Tilapia_Basil_Winter_TE" repetitions="1000" sequentialRunOrder="true" runMetricsEveryStep="false" timeLimit="20000">
      <setup>setup</setup>
      <go>go</go>
      <metrics>
        <metric>harvested-plants</metric>
      </metrics>
      <constants>
        <enumeratedValueSet variable="number-of-fish">
          <value value="100"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="number-of-plant-columns">
          <value value="3"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="fish-type">
          <value value="&quot;Tilapia&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="plant-type">
          <value value="&quot;Basil&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="Season">
          <value value="&quot;Winter&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="Climate">
          <value value="&quot;Temperate&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="Restock?">
          <value value="false"></value>
        </enumeratedValueSet>
      </constants>
    </experiment>
    <experiment name="GHGs_100_3C_Tilapia_Basil_Winter_TE" repetitions="1000" sequentialRunOrder="true" runMetricsEveryStep="false" timeLimit="20000">
      <setup>setup</setup>
      <go>go</go>
      <metrics>
        <metric>greenhouse-gas-emissions</metric>
      </metrics>
      <constants>
        <enumeratedValueSet variable="number-of-fish">
          <value value="100"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="number-of-plant-columns">
          <value value="3"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="fish-type">
          <value value="&quot;Tilapia&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="plant-type">
          <value value="&quot;Basil&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="Season">
          <value value="&quot;Winter&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="Climate">
          <value value="&quot;Temperate&quot;"></value>
        </enumeratedValueSet>
        <enumeratedValueSet variable="Restock?">
          <value value="false"></value>
        </enumeratedValueSet>
      </constants>
    </experiment>
  </experiments>
</model>
