breed [ bugs bug ]
breed [ predators predator]
breed [ grass a-grass ]
breed [ bugs-starting a-bug-starting]
patches-own [energy]
bugs-own [speed wander-angle detects-predator-within]
bugs-starting-own [speed wander-angle detects-predator-within]
globals [total-caught total-6-caught total-5-caught total-4-caught total-3-caught total-2-caught total-1-caught
         time start-time time-last-caught time-this-caught total-frequency-of-catching
        changed-color-map? old-color-map histogram-interval-size
        avg-radius-starting
        avg-wander-starting
        show-path?
        ]
to setup
  ca
  set total-caught 0
  set time 0
  set start-time 0
  set show-path? false
  set histogram-interval-size 1
  set old-color-map speed-color-map
  set changed-color-map? false
  ask patches [set pcolor white]
  create-bugs number-bugs-each-speed [set speed 1 assign-random-attributes]
  create-bugs number-bugs-each-speed [set speed 2 assign-random-attributes]
  create-bugs number-bugs-each-speed [set speed 3 assign-random-attributes]
  create-bugs number-bugs-each-speed [set speed 4 assign-random-attributes]
  create-bugs number-bugs-each-speed [set speed 5 assign-random-attributes]
  create-bugs number-bugs-each-speed [set speed 6 assign-random-attributes]
  ask bugs [
    set shape "bug"
    setxy random 100
          random 100
    hatch 1 [set breed bugs-starting set hidden? true]
  ]
  create-predators 1 [set hidden? true]
  ask bugs [set-colors]

  set avg-radius-starting mean [detects-predator-within] of bugs
  set avg-wander-starting mean [wander-angle] of bugs
  setup-plots
end



to assign-random-attributes
   ifelse random-attribute-start?
     [
       set wander-angle (random 360)
       set detects-predator-within (random (max-pxcor))
     ]
     [set wander-angle 20
     set detects-predator-within max-pxcor
     ]
end


to go
    let bugs-remaining 0
     set time (time + 1)
     check-color-map-change
     check-caught
     move-predator
     move-bugs
     do-plots
     show-path
     set bugs-remaining (count bugs)
     set changed-color-map? false
end
to show-path
 if (show-path? and (time - start-time) < 200) [ask turtle 0 [pendown]]
 if (show-path? and (time - start-time) >= 200) [ask turtle 0 [penup] set show-path? false]
end
to move-predator        ;; show the hawk shape under the mouse-pointer in the graphics window if predator? is true
   if (mouse-inside?)
    [ask predators [setxy mouse-xcor mouse-ycor]]
end

to move-bugs
   let predator-agent one-of predators
   let heading-toward 0
   let distance-from-predator nobody
   ask bugs [
         set distance-from-predator distance-nowrap predator-agent
         ;; if bugs are close enough to the mouse pinter, calculate the heading toward the mouse pointer and set the heading of the bugs to be in the opposite direction
         if (mouse-inside? and distance-from-predator < detects-predator-within)
            [
             set heading-toward towards predator-agent set heading (-1 * heading-toward)]
         fd (speed * speed-factor)
         rt random wander-angle lt random wander-angle
         ]
end

to check-caught
   let speed-of-caught 0
   let period-to-catch 0
   let snap-mouse-xcor mouse-xcor
   let snap-mouse-ycor mouse-ycor
     if mouse-down? and mouse-inside? [

       if (any? bugs-on patch snap-mouse-xcor snap-mouse-ycor) [
           set total-caught (total-caught + 1)
           set time-last-caught time-this-caught
           set time-this-caught time
           set period-to-catch (time-this-caught - time-last-caught)
           set total-frequency-of-catching (total-frequency-of-catching + (1 / period-to-catch))
           reproduce-one
           ;; kill only one of the bugs at the mouse location
           ask one-of bugs-on patch snap-mouse-xcor snap-mouse-ycor [
              set speed-of-caught speed
              if (speed-of-caught = 1) [set total-6-caught (total-6-caught + 1)]
              if (speed-of-caught = 2) [set total-5-caught (total-5-caught + 1)]
              if (speed-of-caught = 3) [set total-4-caught (total-4-caught + 1)]
              if (speed-of-caught = 4) [set total-3-caught (total-3-caught + 1)]
              if (speed-of-caught = 5) [set total-2-caught (total-2-caught + 1)]
              if (speed-of-caught = 6) [set total-1-caught (total-1-caught + 1)]
              die]
          ]
      ]
end

to reproduce-one
   ask one-of bugs [
     hatch 1 [
       set heading (random 360)
       if mutations? [mutate-offspring-attributes]
       ]
       ]
end
to mutate-offspring-attributes
   if  random-attribute-start?
     [
       set wander-angle (wander-angle + (random-float angle-drift))
       set detects-predator-within (detects-predator-within + (random-float detects-drift) - 1)
       if (random 100 < probability-mutation) [set speed (speed + (random (speed-drift + 1) ) ) ]
       if speed < 1 [set speed 1]
       if speed > 6 [set speed 6]
     ]
end
to check-color-map-change  ;; apply color map change only once: when a new value for speed-color-map is selected
    if (old-color-map != speed-color-map)
     [
       ask bugs [
          set old-color-map speed-color-map
          set changed-color-map? true
          set-colors
          ]
     ]
end

to do-plots
  set-current-plot "Avg. radius vs. time"
  set-current-plot-pen "starting"
  plotxy time avg-radius-starting
  set-current-plot-pen "changing"
  plotxy time mean [detects-predator-within] of bugs
  set-current-plot "Avg. wander-angle vs. time"
  set-current-plot-pen "starting"
  plotxy time avg-wander-starting
  set-current-plot-pen "changing"
  plotxy time mean [wander-angle] of bugs

  set-current-plot "radius distribution"
  clear-plot
    if show-starting? [
        set-histogram-num-bars 10
        set-current-plot-pen "starting"
        set-plot-pen-interval 1
        histogram [detects-predator-within] of bugs-starting
     ]
  set-histogram-num-bars 10
  set-current-plot-pen "current"
  set-plot-pen-interval 1
  histogram [detects-predator-within] of bugs

  set-current-plot "wander angle distribution"
  clear-plot
  if show-starting? [
    set-histogram-num-bars 10
    set-current-plot-pen "starting"
    set-plot-pen-interval 36
    histogram [wander-angle] of bugs-starting
  ]
 set-histogram-num-bars 10
  set-current-plot-pen "current"
 set-plot-pen-interval 36
  histogram [wander-angle] of bugs

  set-current-plot "bugs caught vs. time"
  plot-caught
  set-current-plot "number of bugs vs. time"
  plot-populations
  set-current-plot "consumption rate vs. time"
  if (total-caught > 0)
   [ plotxy time (total-frequency-of-catching / total-caught)]
  set-current-plot "frequency of bugs"
  plot-histograms

end
to setup-plots

  set-current-plot "bugs caught vs. time"
  plotxy time total-caught
  set-current-plot "frequency of bugs"
  plot-histograms

end

to set-colors
    if (speed-color-map = "all green") [set color green]
    if (speed-color-map = "blue red") [recolor-twocolor  ]
    if (speed-color-map = "violet shades") [recolor-shade  ]
    if (speed-color-map = "rainbow") [recolor-rainbow  ]
end
to recolor-twocolor
   ifelse (speed <= 3) [set color blue]
   [set color red]
end
to recolor-shade
  set color (112 + speed )
end

to recolor-rainbow
   if (speed = 6) [set color red]
   if (speed = 5) [set color orange]
   if (speed = 4) [set color (yellow - 1)]
   if (speed = 3) [set color green]
   if (speed = 2) [set color blue]
   if (speed = 1) [set color violet]
end

to plot-histograms
    set-histogram-num-bars 8
    set-current-plot-pen "pen1"
    set-plot-pen-interval histogram-interval-size
    histogram [speed] of bugs with [speed = 1]
    set-histogram-num-bars 8
    set-current-plot-pen "pen2"
        set-plot-pen-interval histogram-interval-size
    histogram [speed] of bugs with [speed = 2]
    set-histogram-num-bars 8
    set-current-plot-pen "pen3"
        set-plot-pen-interval histogram-interval-size
    histogram [speed] of bugs with [speed = 3]
    set-histogram-num-bars 8
    set-current-plot-pen "pen4"
        set-plot-pen-interval histogram-interval-size
    histogram [speed] of bugs with [speed = 4]
    set-histogram-num-bars 8
    set-current-plot-pen "pen5"
        set-plot-pen-interval histogram-interval-size
    histogram [speed] of bugs with [speed = 5]
    set-histogram-num-bars 8
    set-current-plot-pen "pen6"
        set-plot-pen-interval histogram-interval-size
    histogram [speed] of bugs with [speed = 6]
end
to plot-populations

    set-current-plot-pen "speed=1"
    plot (count bugs with [speed = 1])
    set-current-plot-pen "speed=2"
    plot (count bugs with [speed = 2])
    set-current-plot-pen "speed=3"
    plot (count bugs with [speed = 3])
    set-current-plot-pen "speed=4"
    plot (count bugs with [speed = 4])
    set-current-plot-pen "speed=5"
    plot (count bugs with [speed = 5])
    set-current-plot-pen "speed=6"
    plot (count bugs with [speed = 6])

end

to plot-caught
   ;; set-current-plot-pen "total"
   ;; plotxy time total-caught
    set-current-plot-pen "speed=1"
    plotxy time total-1-caught
    set-current-plot-pen "speed=2"
    plotxy time total-2-caught
    set-current-plot-pen "speed=3"
    plotxy time total-3-caught
    set-current-plot-pen "speed=4"
    plotxy time total-4-caught
    set-current-plot-pen "speed=5"
    plotxy time total-5-caught
    set-current-plot-pen "speed=6"
    plotxy time total-6-caught
end

@#$#@#$#@
GRAPHICS-WINDOW
422
10
812
421
9
9
20.0
1
10
1
1
1
0
1
1
1
-9
9
-9
9
CC-WINDOW
5
743
874
838
Command Center
0
MONITOR
310
10
393
55
total caught
total-caught
0
1
11
BUTTON
3
10
64
43
NIL
setup
NIL
1
T
OBSERVER
T
NIL
NIL
T
BUTTON
4
44
64
78
NIL
go
T
1
T
OBSERVER
T
NIL
NIL
T
PLOT
198
210
415
383
bugs caught vs. time
time
time
0.0
1000.0
0.0
10.0
true
false
PENS
"total" 1.0 0 -16777216 true
"speed=1" 1.0 0 -8630108 true
"speed=2" 1.0 0 -13345367 true
"speed=3" 1.0 0 -10899396 true
"speed=4" 1.0 0 -3355648 true
"speed=5" 1.0 0 -955883 true
"speed=6" 1.0 0 -2674135 true
PLOT
4
383
198
559
frequency of bugs
speeds
frequency
0.0
8.0
0.0
50.0
true
false
PENS
"default" 0.1 1 -16777216 true
"pen1" 0.1 1 -8630108 true
"pen2" 0.1 1 -13345367 true
"pen3" 0.1 1 -10899396 true
"pen4" 0.1 1 -3355648 true
"pen5" 0.1 1 -955883 true
"pen6" 0.1 1 -2674135 true
CHOOSER
194
10
306
55
speed-color-map
speed-color-map
"all green" "rainbow" "blue red" "violet shades"
0
SLIDER
68
10
191
43
speed-factor
speed-factor
0.01
0.4
0.03
0.01
1
NIL
PLOT
1
210
198
383
consumption rate vs. time
time
rate
0.0
1000.0
0.0
0.5
true
false
PENS
"default" 1.0 0 -16777216 true
PLOT
198
383
415
559
number of bugs vs. time
time
number
0.0
1000.0
0.0
20.0
true
false
PENS
"total" 1.0 0 -16777216 true
"speed=1" 1.0 0 -8630108 true
"speed=2" 1.0 0 -13345367 true
"speed=3" 1.0 0 -10899396 true
"speed=4" 1.0 0 -3355648 true
"speed=5" 1.0 0 -955883 true
"speed=6" 1.0 0 -2674135 true
MONITOR
297
61
394
106
bugs on screen
(count bugs)
0
1
11
SLIDER
11
84
198
117
number-bugs-each-speed
number-bugs-each-speed
2
50
9
1
1
NIL
SWITCH
11
120
193
153
random-attribute-start?
random-attribute-start?
0
1
-1000
SLIDER
12
160
113
193
angle-drift
angle-drift
0
100
5
1
1
NIL
MONITOR
285
623
417
668
avg. wander-angle
mean [wander-angle] of bugs
3
1
11
MONITOR
287
570
416
615
avg. radius
mean [detects-predator-within] of bugs
3
1
11
PLOT
427
428
627
578
Avg. radius vs. time
time
radius
0.0
10.0
0.0
10.0
true
false
PENS
"starting" 1.0 0 -16777216 true
"changing" 1.0 0 -2674135 true
PLOT
427
579
627
729
Avg. wander-angle vs. time
time
angle
0.0
10.0
0.0
10.0
true
false
PENS
"starting" 1.0 0 -16777216 true
"changing" 1.0 0 -2674135 true
PLOT
630
579
864
729
wander angle distribution
angle
number
0.0
360.0
0.0
10.0
true
false
PENS
"default" 1.0 1 -16777216 true
"starting" 36.0 1 -16777216 true
"current" 36.0 1 -10899396 true
PLOT
630
427
865
578
radius distribution
radius
number
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 1 -16777216 true
"starting" 1.0 1 -16777216 true
"current" 1.0 1 -10899396 true
SWITCH
70
46
191
79
mutations?
mutations?
0
1
-1000
SLIDER
201
121
369
154
probability-mutation
probability-mutation
0
1
0.5
0.1
1
NIL
SLIDER
225
160
332
193
speed-drift
speed-drift
0
5
1
1
1
NIL
SLIDER
116
160
221
193
detects-drift
detects-drift
0
10
1
1
1
NIL
BUTTON
26
580
189
613
snap-shot-path
set start-time time\\nset show-path? true
NIL
1
T
OBSERVER
T
NIL
NIL
T
MONITOR
206
579
277
624
NIL
time
0
1
11
SWITCH
258
680
410
713
show-starting?
show-starting?
1
1
-1000
@#$#@#$#@
VERSION
-------
$Id: Bug Hunt Scurry.nlogo 37529 2008-01-03 20:38:02Z craig $

WHAT IS IT?
-----------
A natural selection model that shows the result of two competing forces on natural selection of the speed of prey.
One force is that predators that chase prey, tend to catch slower moving prey more often, thereby selecting for prey that are faster over many generations of offspring.
Another force is that predators who wait for their prey without moving, tend to catch prey that are moving faster more often, thereby selecting for prey that are slower over many generations of offspring.
By also adjusting whether bugs try to avoid the predator and the predictability of their motion, a different one of these competing forces will tend to dominate the selective pressure on the population.

HOW IT WORKS
------------
You assume the role of a predator amongst a population of bugs.  To begin your pursuit of bugs as a predator, press SETUP to create a population of bugs, determined by the six times the NUMBER-BUGS-EACH-SPEED slider.  These bugs that are created are randomly distributed around the graphics window.  Each of these bugs may have one of six speeds assigned to it, at which it will always travel when the model is running.
When you press GO the bugs begin to move at their designated speeds.  As they move around, try to eat as many bugs as fast as you can by clicking on them in the graphics window.  Alternatively, you may hold the mouse button down and move the mouse pointer over the bugs in the graphics window.
The six different speeds that a bug might move at are distributed amongst six different sub-populations of the bugs.  These speeds are genetically inherited.  With each bug you eat, a new bug is randomly chosen from the population to reproduce one offspring.  This bug's offspring is an exact duplicate of the parent (in terms of its speed, orientation, and location).  The creation of this new offspring keeps the overall number population of the bugs on the screen constant.
Initially there are equal numbers of each sub-population of bug (e.g. ten bugs at each of the 6 speeds).  Overtime, however, as you eat bugs, the distribution of the bugs will change as shown in the "frequency of bugs" histogram and the "number of bugs vs. time" graph.  In the histogram, you might see the distribution shift to the left (showing that more slow bugs are surviving) or to the right (showing that more fast bugs are surviving).  Sometimes one sub-population of a single speed of bug will be exterminated.  At this point, no other bugs of this speed can be created in the population.
Bugs will avoid the predator (your mouse pointer in the graphics window) if the DETECTS-PREDATOR-AT slider is greater than zero.  Bugs will also diverge from walking in a straight line based on the amount of WANDER-ANGLE specified is greater than zero.

HOW TO USE IT
-------------
NUMBER-BUGS-EACH-SPEED is the number of bugs you start with in each of the six sub-populations.  The overall population of bugs is determined by multiplying this value by 6.
WANDER-ANGLE is the amount of possible change in the angle of orientation that each of the bugs might have with each step.
SPEED-FACTOR is an overall speed coefficient to use to speed up or slow down all the bugs, without making their motion jerky.  This is an important slider to adjust to compensate for different speed platforms the model might run on.
DETECTS-PREDITOR-AT is the radius that the bugs can detect the mouse pointer (the predator) from.  If they can see the mouse pointer, they determine what direction the mouse pointer is in, and they will turn around in the opposite direction.
SPEED-COLOR-MAP settings help you apply color visualization to the speed of the bugs.  The "all green" setting does not show a different color for each bug based on its speed".  Keeping the color settings switched to something besides "all green" can tend to result in the predator (the user) unconsciously selecting bugs based on color instead of speed.
The "rainbow" setting shows 6 distinct colors for the 6 different speeds a bug might have.  These color settings correspond to the plot pen colors in the graphs.
The "blue red" setting shows the lower half of the speeds of the starting population as blue, and the upper half as red.
The "purple shades" setting shows a gradient of dark purple to light purple for slow to fast bug speed.

THINGS TO NOTICE
----------------
This histogram tends to shift right if you assume the role of chasing easy prey.
This histogram tends to shift left if you assume the role of waiting for prey come to you.  (The same effect is achieved with moving the mouse around the screen randomly)

THINGS TO TRY
-------------
Different combinations of WANDER-ANGLE and SPEED-FACTOR and DETECTS-PREDITOR-AT often lead to different selective forces dominating the outcome of a model run.  For example, a SPEED-FACTOR that is low and a WANDER-ANGLE that is high and DETECTS-PREDITOR-AT of 0, lead to bugs that just twitch in place.  In this scenario all of these bugs are equally easy to catch, therefore there is no selective mechanism here for the predator to catch one sub-population of the prey over another.
Try different combinations of WANDER-ANGLE and SPEED-FACTOR and DETECTS-PREDITOR-AT.

EXTENDING THE MODEL
-------------------
It would be interesting to model energy gain from consumption of bugs and energy loss from your amount of motion around the screen.
You could add a slider to assign the random chance that a bug that is an offspring inherits a mutation, resulting in a speed that is not the same as its parent.
You could have each bug inherit WANDER-ANGLE as well as speed.
You could have each bug inherit DETECTS-PREDATOR-AT.  It is envisioned that this would tend to select for bugs that the maximum value for this.  To balance this with a competing selective force, you could have bugs consume grass or seeds to gain energy and consume energy as they move.
A HubNet version of the model with adjustable starting populations of bugs would help show what happens when two or more competitors assume similar vs. different hunting strategies on the same population at the same time.
RELATED MODELS
--------------
See Bug Hunt.

CREDITS AND REFERENCES
----------------------
Inspired by EvoDots software:
http://faculty.washington.edu/~herronjc/SoftwareFolder/EvoDots.html

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 30 30 240
circle 2
false
0
Circle -7500403 true true 16 16 270
Circle -16777216 true false 46 46 210
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
cylinder
false
0
Circle -7500403 true true 30 30 240
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.0pre5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
