globals [
mylist-x
mylist-y
mylist-z
  g
  X
  Y
  Z
  dt
]

to setup
  clear-all
  draw-axes

  set mylist-x list 0 (X)
  set mylist-y list 0 (Y)
  set mylist-z list 0 (Z)
  zoom 20
  orbit-up 5
  orbit-right 10
  system-dynamics-setup
  system-dynamics-do-plot
end

to draw-axes
  create-turtles 1 [ set shape "line"
          set heading 90
          set color red
          set size world-width
          stamp
          die ]
  create-turtles 1 [ set shape "line"
          set color yellow
          set heading 0
          set size world-height
          stamp
          die ]
  create-turtles 1 [ set shape "line"
          set pitch 90
          set color blue
          set size world-depth
          stamp
          die ]
  ask patch max-pxcor 0 0 [ set plabel "x-axis" ]
  ask patch 0 max-pycor 0 [ set plabel "y-axis" ]
  ask patch 0 0 max-pzcor [ set plabel "z-axis" ]
end


to system-dynamics-setup
  reset-ticks
  set dt 0.01
  set g 10
  set X 1
  set Y 0
  set z 0
end

to go
  system-dynamics-go
  system-dynamics-do-plot
  set mylist-x lput result-x mylist-x
  set mylist-y lput result-y mylist-y
  set mylist-z lput result-z mylist-z

  crt 1 [
  set color green
  set xcor (last mylist-x ) * 0.2
  set ycor (last mylist-y ) * 0.2
  set zcor (last mylist-z ) * 0.2
  set size 0.2
  set shape "circle"
  ]

end

to system-dynamics-go

  let local-b b
  let local-r r
  let local-inflow inflow
  let local-inflow1 inflow1
  let local-inflow2 inflow2


  let new-X ( X + local-inflow1 )
  let new-Y ( Y + local-inflow )
  let new-Z ( Z + local-inflow2 )
  set X new-X
  set Y new-Y
  set Z new-Z

  tick-advance dt
end

to-report result-x
  report X
end

to-report result-y
    report Y
end

to-report result-z
    report Z
end

to-report inflow
  report ( X * ( r - Z ) - Y
  ) * dt
end

to-report inflow1
  report ( g * ( Y - X )
  ) * dt
end

to-report inflow2
  report ( X * Y - b * Z
  ) * dt
end

to-report b
  report 8 / 3
end

to-report r
  report rho-slider
end

to system-dynamics-do-plot
  if plot-pen-exists? "X" [
    set-current-plot-pen "X"
    plotxy ticks X
  ]
  if plot-pen-exists? "Y" [
    set-current-plot-pen "Y"
    plotxy ticks Y
  ]
  if plot-pen-exists? "z" [
    set-current-plot-pen "z"
    plotxy ticks z
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
0
0
439
460
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
-16
16
1
0
1
ticks
30.0

SLIDER
14
79
186
112
rho-slider
rho-slider
10
50
40.0
1
1
NIL
HORIZONTAL

BUTTON
11
28
75
61
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
109
28
172
61
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
226
15
612
260
 X, Y, Z over time
ticks/time
NIL
0.0
10.0
0.0
0.1
true
true
"" ""
PENS
"Z" 1.0 0 -13791810 true "" ""
"Y" 1.0 0 -2674135 true "" ""
"X" 1.0 0 -13840069 true "" ""

BUTTON
21
128
95
161
Zoom +
zoom 3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
117
129
187
162
Zoom -
zoom -1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
14
173
107
206
Orbit-right 
orbit-right 1\ndisplay
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
115
174
204
207
Orbit-left
orbit-left 1\ndisplay
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
14
221
108
254
Orbit-up 
orbit-up 1\ndisplay
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
114
221
205
254
Orbit-down
orbit-down 1\ndisplay
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
NB: Since NetLogo Web does not support ‘.nlogo3d’ files you can run this model only on your PC after downloading it.

## WHAT IS IT?

This is a model of the phase-space of a system consisting of three ordinary differential equations, known as Lorenz system.

It has chaotic solutions for certain parameter values. A particular set of chaotic solutions of the Lorenz system when plotted, resembles a butterfly or figure eight and is presented as Lorenz attractor. 

The model is intended to visualize                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  