breed [jeleni jelen]  
breed [vlci vlk]
breed [lide clovek]
turtles-own [energie]
lide-own [zemedelec zasoby]
patches-own [odpocet ochrana]

to setup
  clear-all
  ask patches [ set pcolor green ]
    ask patches [
      set odpocet random doba-rustu-rostlin 
      set pcolor one-of [66 37]
      set ochrana false  
    ]
  ask one-of patches [
    if chranene-uzemi > 0 [set ochrana true]
  ]
  repeat (chranene-uzemi / 100 * count patches - 1) [
    ask one-of patches with [ochrana] [
      if-else any? neighbors with [not ochrana] 
      [ask one-of neighbors with [not ochrana] [set ochrana true]]
      [ask one-of patches with [not ochrana] [set ochrana true]]
    ]
  ]
  ask patches with [ochrana] [set pcolor pcolor - 3]
  set-default-shape jeleni "jelen"
  create-jeleni poc-pocet-jelenu  
  [
    set color 32
    set size 2  
    set label-color blue - 2
    set energie random (2 * zisk-energie-z-rostliny)
    setxy random-xcor random-ycor
  ]
  set-default-shape vlci "vlk"
  create-vlci poc-pocet-vlku  
  [
    set color 4
    set size 2
    set energie random (2 * zisk-energie-z-jelena)
    setxy random-xcor random-ycor
  ]
  set-default-shape lide "person"
  create-lide poc-pocet-lidi
  [
    set color 14
    set size 2
    set energie random (2 * zisk-energie-z-jelena)
    setxy random-xcor random-ycor
    set zemedelec false
  ]
  ask n-of (podil-zemedelcu / 100 * count lide) lide [
    set zemedelec true
    set color 62
  ]
  reset-ticks
end

to krokuj [kroky]
 repeat kroky [ go ]
end

to go
  if not any? turtles [ stop ]
  ask lide with [zemedelec] [
    pohyb-lide-sklizen
    set energie energie - 1
    jist-rostliny-lide
    reprodukovat-lidi
    smrt-hladem
  ]
  ask lide with [not zemedelec] [
    pohyb-lide-lov
    set energie energie - 1
    chytat-korist
    reprodukovat-lidi
    smrt-hladem
  ]
  ask jeleni [
    pohyb
    set energie energie - 1  ; jeleni pohybem ztraceji energii
    jist-rostliny
    reprodukovat-jeleny
    smrt-hladem
  ]
  ask vlci [
    pohyb
    set energie energie - 1  ; vlci pohybem ztraceji energii
    chytat-jeleny
    reprodukovat-vlky
    smrt-hladem
  ]
  ask patches [ rust-rostlin ]
  tick
end


to pohyb  
  rt random 50
  lt random 50
  fd 1
end

to pohyb-lide-sklizen
  ifelse any? neighbors with [count lide-here = 0 and (pcolor = 66)] [
    face one-of neighbors with [count lide-here = 0 and (pcolor = 66)]
  ]
  [
    rt random 50
    lt random 50
  ]
  fd 1
end

to pohyb-lide-lov  
  ifelse any? jeleni with [distance myself <= 1 and not [ochrana] of patch-here ] [
    face one-of jeleni with [distance myself <= 1 and not [ochrana] of patch-here ]  
  ]
  [
    ifelse any? vlci with [distance myself <= 1 and not [ochrana] of patch-here ] [
      face one-of vlci with [distance myself <= 1 and not [ochrana] of patch-here ]
    ]
    [
      rt random 50
      lt random 50
    ]
  ]
  fd 1
end

to jist-rostliny  
  if (pcolor = 66 or pcolor = 63) [
    set pcolor ifelse-value ochrana [34] [37]
    set energie energie + zisk-energie-z-rostliny  
  ]
end

to jist-rostliny-lide  
  if (pcolor = 66) [
    set pcolor 37
    set energie energie + zisk-energie-z-rostliny  
  ]
end

to reprodukovat-jeleny
  if random-float 100 < jeleni-reprodukce [ 
    set energie (energie / 2)                
    hatch 1 [ rt random-float 360 fd 1 ]
  ]
end

to reprodukovat-vlky  
  if random-float 100 < vlci-reprodukce [  
    set energie (energie / 2)              
    hatch 1 [ rt random-float 360 fd 1 ]  
  ]
end

to reprodukovat-lidi
  if random-float 100 < lidska-reprodukce [  
    set energie (energie / 2)              
    hatch 1 [ 
      if-else random-float 100 <= podil-zemedelcu 
      [ set zemedelec true
        set color 62 ]
      [ set zemedelec false
        set color 14 ]
      rt random-float 360 
      fd 1 
    ]  
  ]
end

to chytat-jeleny
  let korist one-of jeleni in-radius 0.5                   
  if korist != nobody                             
    [ ask korist [ die ]                          
      set energie energie + zisk-energie-z-jelena ]
end

to chytat-korist
  let korist one-of (turtle-set jeleni vlci) with [distance myself <= 0.5 and [not ochrana] of patch-here]
  if korist != nobody                             
    [ let zisk-energie ifelse-value ([breed] of korist = "jelen") [zisk-energie-z-jelena] [zisk-energie-z-vlka]
      ask korist [ die ]                          
      set energie energie + zisk-energie ]
end

to smrt-hladem
  if energie < 0 [ die ]
end

to rust-rostlin  
  if (pcolor = 37 or pcolor = 34) [
    ifelse odpocet <= 0
      [ set pcolor ifelse-value ochrana [63] [66]
        set odpocet doba-rustu-rostlin ]
      [ set odpocet odpocet - 1 ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
310
10
779
500
25
25
9.0
1
14
1
1
1
0
1
1
1
-25
25
-25
25
1
1
1
ticks
30.0

SLIDER
10
138
155
171
poc-pocet-jelenu
poc-pocet-jelenu
0
250
150
1
1
NIL
HORIZONTAL

SLIDER
159
73
304
106
zisk-energie-z-rostliny
zisk-energie-z-rostliny
0.0
50.0
2
1.0
1
NIL
HORIZONTAL

SLIDER
10
172
155
205
jeleni-reprodukce
jeleni-reprodukce
1.0
20.0
3
1.0
1
%/k
HORIZONTAL

SLIDER
159
138
304
171
poc-pocet-vlku
poc-pocet-vlku
0
250
20
1
1
NIL
HORIZONTAL

SLIDER
10
206
155
239
zisk-energie-z-jelena
zisk-energie-z-jelena
0.0
100.0
30
1.0
1
NIL
HORIZONTAL

SLIDER
159
172
304
205
vlci-reprodukce
vlci-reprodukce
0.0
20.0
4
1.0
1
%/k
HORIZONTAL

SLIDER
10
73
155
106
doba-rustu-rostlin
doba-rustu-rostlin
0
100
10
1
1
k
HORIZONTAL

BUTTON
9
10
83
43
Inicializace
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
165
10
233
43
25 kroků
krokuj 25
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
11
301
304
500
populace
čas [k]
počet
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"jeleni" 1.0 0 -13345367 true "" "plot count jeleni"
"vlci" 1.0 0 -2674135 true "" "plot count vlci"
"rostliny / 4" 1.0 0 -10899396 true "" "plot count patches with [ pcolor = 66 ] / 4 + count patches with [pcolor = 63] / 4"
"zemedelci" 1.0 0 -7500403 true "" "plot count lide with [zemedelec]"
"lovci" 1.0 0 -6459832 true "" "plot count lide with [not zemedelec]"

MONITOR
11
255
102
300
Jeleni
count jeleni
3
1
11

MONITOR
106
255
198
300
Vlci
count vlci
3
1
11

MONITOR
202
255
304
300
Rostliny / 4
count patches with [ pcolor = 66 ] / 4 + count patches with [pcolor = 63] / 4
0
1
11

TEXTBOX
72
117
108
136
Jeleni
11
0.0
0

TEXTBOX
224
117
250
135
Vlci
11
0.0
0

BUTTON
87
10
161
43
Jeden krok
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
141
51
186
69
Rostliny
11
0.0
1

BUTTON
237
10
306
43
100 kroků
krokuj 100
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
786
10
925
43
poc-pocet-lidi
poc-pocet-lidi
0
100
10
1
1
NIL
HORIZONTAL

SLIDER
786
44
925
77
podil-zemedelcu
podil-zemedelcu
0
100
50
1
1
%
HORIZONTAL

SLIDER
159
206
304
239
zisk-energie-z-vlka
zisk-energie-z-vlka
0
20
10
1
1
NIL
HORIZONTAL

SLIDER
786
78
925
111
lidska-reprodukce
lidska-reprodukce
0
20
1
1
1
%/k
HORIZONTAL

MONITOR
785
455
854
500
Zemědělci
count lide with [zemedelec]
0
1
11

MONITOR
855
455
924
500
Lovci
count lide with [not zemedelec]
17
1
11

TEXTBOX
843
431
868
449
Lidé
11
0.0
1

SLIDER
786
117
925
150
chranene-uzemi
chranene-uzemi
0
100
0
1
1
%
HORIZONTAL

TEXTBOX
788
164
928
182
Predátor - kořist a lidé
14
0.0
1

TEXTBOX
788
195
935
377
Vytvořeno v rámci projektu ESF CZ.1.07/1.1.00/08.0094 Vzdělávání pro udržitelný rozvoj v environmentálních a ekonomických souvislostech řešeného Asociací pedagogů základního školství ČR. Tento projekt je spolufinancován Evropským sociálním fondem a státním rozpočtem České republiky. \n\nhttp://www.vcele.eu 
11
0.0
1

@#$#@#$#@
#PREDÁTOR - KOŘIST A LIDÉ

##CÍL

Interaktivní výukové prostředí Predátor – kořist a lidé vychází z klasického modelu vztahů v potravním řetězci. V tomto případě se jedná o populace rostlin, jelenů (zástupci býložravců) a vlků (zástupci predátorů), do jejichž populace zasahuje člověk. Jeleni a vlci se pohybují náhodně po ploše a snaží se získat ve svém místě potravu. Mají-li k tomu příležitost, živočichové se rozmnožují, rostliny jsou na celé ploše a po určité době se obnovují. Navíc je do těchto vztahů zahrnut vliv člověka, a to ve dvou směrech - lov a zemědělství.

Cílem je ukázat, jak je výsledný ekosystém se zásahy člověka stabilní či nestabilní.

K jakým otázkám by použití interaktivního výukového prostředí mělo vést?

* Jaký je možný vývoj velikostí jednotlivých populací v čase?
* Jak je vývoj ekosystému citlivý na nastavení vztahů mezi populacemi?
* Jak je ekosystém stabilní při různých lidských zásazích, jako je například změna skladby pěstovaných rostlin?
* Jak udržitelně v těchto podmínkách hospodařit?
* Jak veliké území je třeba chránit, aby se všechny populace udržely?

##OVLÁDÁNÍ
Interaktivní výukové prostředí se dle nastavených parametrů inicializuje kliknutím na tlačítko [Inicializace]. Jeleni, vlci a lidé se podle nastavených parametrů náhodně rozmístí po ploše. Dle nastavení se také vytvoří chráněné území, které je graficky vyznačené tmavší barvou.

Následně je možné krokovat simulaci v čase (1 krok, 25 kroků a 100 kroků) a sledovat vývoj jednotlivých populací.

Parametr podíl zemědělců určuje, kolik lidí se v populaci po narození stane zemědělci, z ostatních se stanou lovci.

Zemědělci mají zelenou barvu, lovci červenou.

##UKÁZKOVÉ PŘÍKLADY K ŘEŠENÍ
Vývoj jednotlivých populací v čase závisí velmi silně na nastavených parametrech. 

U prvního příkladu se ekosystém udržuje v dynamické rovnováze, což lze vyzkoušet nastavením následujících parametrů:

* Doba růstu rostlin = 10 kroků
* Zisk energie z rostliny = 2
* Počáteční počet jelenů = 150
* Jelení míra reprodukce = 3 %/krok
* Zisk energie z jelena = 30
* Počáteční počet vlků = 20
* Vlčí míra reprodukce = 4 %/krok
* Zisk energie z vlka = 10
* Počáteční počet lidí = 0 

Nastavení je v tomto případně takové, že vliv lidí neexistuje. Populace se dostanou do dynamické rovnováhy a v ní setrvávají. 

V dalším                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           