globals [ max-whaleshark artificial-plankton artificial-plankton-threshold]

  ; whaleshark and fishingboats are both breeds of turtle.
breed [ whaleshark one-whaleshark ]
breed [ fishingboats fishingboat ]
breed [ touristboats touristboat ]

turtles-own [ energy      ; both fishingboats and whaleshark have energy
              eaten-artificial-plankton ; Added for whalesharks to indicate if they have eaten artificial plankton
              artificial-plankton-timer; Counter for ticks since eating artificial plankton
              time-on-artificial-plankton  ; New variable to track time on artificial plankton patch
              artificial-plankton-consumed  ; New variable to track amount of artificial plankton consumed
              ticks-since-last-reproduction
]

patches-own [ countdown ]

to setup
  clear-all
  ifelse netlogo-web? [set max-whaleshark 10000] [set max-whaleshark 20000]

  set artificial-plankton-threshold 50  ; Example value

  ask patches [
      set pcolor one-of [ cyan sky ]
      ifelse pcolor = cyan
        [ set countdown plankton-regrowth-time ]
      [ set countdown random plankton-regrowth-time ] ; initialize plankton regrowth clocks randomly for sky patches
    set artificial-plankton false  ; Initially, no patch has artificial plankton
    ]

  create-whaleshark initial-number-whaleshark  ; create the whaleshark, then initialize their variables
  [
    set shape  "whale shark"
    set color gray
    set size 2  ; easier to see
    set label-color sky - 2
    set energy random (2 * whaleshark-gain-from-food)
    setxy random-xcor random-ycor
    set eaten-artificial-plankton false
    set artificial-plankton-timer -1  ; Initialize with -1 to indicate not consumed artificial plankton
    set time-on-artificial-plankton 0
    set artificial-plankton-consumed 0
    set ticks-since-last-reproduction 50  ; Start with 50 so they can reproduce immediately
  ]

  create-fishingboats initial-number-fishingboats  ; create the fishingboats, then initialize their variables
  [
    set shape "boat"
    set color orange
    set size 3  ; easier to see
    set energy random (2 * fishingboat-gain-from-food)
    setxy random-xcor random-ycor
  ]

    ; Create a single touristboat only if model-version is "artificial plankton"
  if model-version = "artificial-plankton" [
    create-touristboats 1 [
      set shape "boat"
      set color red  ; or any color that distinguishes it
      set size 5
      setxy random-xcor random-ycor
    ]
  ]

  display-labels
  reset-ticks
end

to go
  ; stop the simulation if no fishingboats or whaleshark
  if not any? turtles [ stop ]
  ; stop the model if there are no fishingboats and the number of whaleshark gets very large
  if count whaleshark > max-whaleshark [ user-message "The whale sharks have inherited the ocean." stop ]
  if not any? whaleshark [ user-message "Oh no! The whale sharks are extinct!" stop ]

  if count whaleshark > whaleshark-threshold and count fishingboats < max-fishingboats [
    create-fishingboats 1 [ initialize-fishingboat ]
    ]

   ; Whaleshark behavior
  ask whaleshark [
    if pcolor = yellow [  ; Check if whaleshark is on an artificial plankton patch
      set time-on-artificial-plankton time-on-artificial-plankton + 1
    ] if pcolor != yellow [
      set time-on-artificial-plankton 0  ; Reset the counter if not on artificial plankton
    ]
    move
    set energy energy - 1
    eat-plankton
    death
    set ticks-since-last-reproduction ticks-since-last-reproduction + 1  ; Increment reproduction timer
    reproduce-whaleshark
    flee-from-fishingboats
    move-towards-touristboats
    set eaten-artificial-plankton false  ; Reset at the end of each tick

    ]

  ask fishingboats [
    chase-whaleshark ;; fishingboats chase whalesharks
    eat-whaleshark ; fishingboats eat a whaleshark on their patch
    check-energy-and-leave ; fishingboats leave if out of energy
  ]

  ask touristboats [
    dispense-artificial-plankton  ; Ensure this is being called
    ; Other touristboat behaviors
  ]

  ; always grow plankton
  ask patches [ grow-plankton ]

  update-color-after-artificial-plankton  ; Include this call in your simulation loop

  tick
  display-labels
end

to initialize-fishingboat  ; Initialize new fishingboat
  set shape "boat"
  set color orange
  set size 3  ; easier to see
  setxy random-xcor random-ycor
  set energy 10  ; Initialize energy to 0
end

to dispense-artificial-plankton
  ask patches in-radius 2 [  ; Assuming a radius around the tourist boat
    set artificial-plankton true
    set pcolor yellow
  ]
end

to chase-whaleshark
  let target one-of whaleshark in-cone 10 180  ; 10 is the radius, 180 is the angle
  if target != nobody [
    face target  ; Turn towards the whaleshark
    fd 1  ; Move forward towards the whaleshark
  ] if target = nobody [
    move  ; Call a procedure for random movement
  ]
  if energy <= 0 [ die ]  ; Check energy level
end

to check-energy-and-leave  ; Check energy level of fishingboats
  if energy >= min-energy-to-leave [ die ]  ; Leave if minimum energy is reached
end

to move  ; turtle procedure
  rt random 50
  lt random 50
  fd 1
end

to eat-plankton  ; whaleshark procedure
  ; whaleshark eat plankton, turn the patch sky
  if pcolor = cyan [
    set pcolor sky
    set energy energy + whaleshark-gain-from-food  ; whaleshark gain energy by eating
  ]
  if pcolor = yellow [
    set energy energy + (whaleshark-gain-from-food * 0.5)
    set artificial-plankton-consumed artificial-plankton-consumed + 1
    set color yellow
    set pcolor sky
    set artificial-plankton-timer 0  ; Start the timer
  ]
end

to reproduce-whaleshark
  let reproduction-chance whaleshark-reproduce
  if model-version = "artificial-plankton" [
  if artificial-plankton-timer >= 0 and artificial-plankton-timer < artificial-plankton-interval [
    set reproduction-chance reproduction-chance * 0.5  ; Halve the chance if within the effect window
  ]
]
  if ticks-since-last-reproduction >= reproduction-interval [  ; Check if it's time to reproduce
    if random-float 1 < reproduction-chance [  ; Chance to reproduce
     set energy (energy / 2)
      hatch 1 [
        set ticks-since-last-reproduction 0  ; Reset timer for offspring
        rt random-float 360
        fd 1
      ]
      set ticks-since-last-reproduction 0  ; Reset timer for parent
    ]
  ]
end

to eat-whaleshark  ; fishingboat procedure
  let prey one-of whaleshark-here                    ; grab a random whaleshark
  if prey != nobody  [                          ; did we get one?  if so,
    ask prey [ die ]                            ; kill it, and...
    set energy energy + fishingboat-gain-from-food     ; get energy from eating
  ]
end

to death  ; turtle procedure (i.e. both fishingboat nd whaleshark procedure)
  ; when energy dips below zero, die
  if energy < 0 [ die ]
end

to grow-plankton  ; patch procedure
  ; countdown on sky patches: if reach 0, grow some plankton
  if pcolor = sky [
    ifelse countdown <= 0
      [ set pcolor cyan
        set countdown plankton-regrowth-time ]
      [ set countdown countdown - 1 ]
  ]
end

to-report plankton
    report patches with [pcolor = cyan]
end

to update-color-after-artificial-plankton
  ask whaleshark [
    if artificial-plankton-timer >= 0 [  ; Check if the timer is active
      if artificial-plankton-timer < artificial-plankton-interval [
        set artificial-plankton-timer artificial-plankton-timer + 1
      ]
      if artificial-plankton-timer = artificial-plankton-interval [
        set color gray  ; Revert color to gray
        set eaten-artificial-plankton false  ; Reset the effect on reproduction
        set artificial-plankton-timer -1  ; Reset the timer
      ]
    ]
  ]
end

to flee-from-fishingboats
  let nearest-fishingboat min-one-of fishingboats [distance myself]
  if nearest-fishingboat != nobody [
    if (artificial-plankton-timer >= 0) and (artificial-plankton-timer < artificial-plankton-interval) [  ; Check if under the influence of artificial plankton
      face nearest-fishingboat  ; Move towards the fishing boat
      fd 1
    ]
    if (artificial-plankton-timer < 0) or (artificial-plankton-timer >= artificial-plankton-interval) [
       if random-float 1 < 0.2 [  ; flee-probability is the chance of fleeing
      face nearest-fishingboat
      rt 180
      fd 1
      ]
    ]
  ]
end

to move-towards-touristboats
  if artificial-plankton-consumed < artificial-plankton-threshold [  ; Only move towards if under the threshold
    let nearest-touristboat min-one-of touristboats [distance myself]
    if nearest-touristboat != nobody and distance nearest-touristboat < attraction-distance [
      face nearest-touristboat
      fd 1
    ]
  ]
end

to display-labels
  ask turtles [ set label "" ]
  if show-energy? [
    ask fishingboats [ set label round energy ]
    ask whaleshark [ set label round energy ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
355
10
873
529
-1
-1
10.0
1
14
1
1
1
0
1
1
1
-25
25
-25
25
1
1
1
ticks
30.0

SLIDER
175
15
350
48
initial-number-whaleshark
initial-number-whaleshark
0
250
16.0
1
1
NIL
HORIZONTAL

SLIDER
5
380
175
413
whaleshark-gain-from-food
whaleshark-gain-from-food
0.0
50.0
6.0
1.0
1
NIL
HORIZONTAL

SLIDER
5
415
175
448
whaleshark-reproduce
whaleshark-reproduce
1.0
20.0
2.0
1.0
1
%
HORIZONTAL

SLIDER
175
55
350
88
initial-number-fishingboats
initial-number-fishingboats
0
250
0.0
1
1
NIL
HORIZONTAL

SLIDER
180
380
350
413
fishingboat-gain-from-food
fishingboat-gain-from-food
0.0
100.0
10.0
1.0
1
NIL
HORIZONTAL

SLIDER
177
95
352
128
plankton-regrowth-time
plankton-regrowth-time
0
100
20.0
1
1
NIL
HORIZONTAL

BUTTON
5
75
74
125
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
90
75
165
125
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
5
185
345
355
populations
time
pop.
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"whaleshark" 1.0 0 -7500403 true "" "plot count whaleshark"
"fishingboats" 1.0 0 -955883 true "" "plot count fishingboats"
"plankton / 100" 1.0 0 -11221820 true "" "plot count plankton / 100"

MONITOR
5
135
77
180
whaleshark
count whaleshark
3
1
11

MONITOR
80
135
157
180
fishingboats
count fishingboats
3
1
11

MONITOR
160
135
222
180
plankton
count plankton / 4
0
1
11

TEXTBOX
5
365
145
383
whaleshark settings
11
0.0
1

TEXTBOX
180
365
293
383
fishingboat settings
11
0.0
1

SWITCH
225
140
345
173
show-energy?
show-energy?
0
1
-1000

CHOOSER
5
15
170
60
model-version
model-version
"artificial-plankton" "no-artificial-plankton"
1

SLIDER
180
450
352
483
whaleshark-threshold
whaleshark-threshold
0
100
15.0
1
1
NIL
HORIZONTAL

SLIDER
180
415
352
448
max-fishingboats
max-fishingboats
0
100
20.0
1
1
NIL
HORIZONTAL

SLIDER
180
485
350
518
min-energy-to-leave
min-energy-to-leave
0
100
40.0
1
1
NIL
HORIZONTAL

SLIDER
5
505
175
538
artificial-plankton-interval
artificial-plankton-interval
0
100
100.0
1
1
NIL
HORIZONTAL

TEXTBOX
5
490
190
516
artificial plankton effectivity
11
0.0
1

SLIDER
5
540
175
573
attraction-distance
attraction-distance
0
10
10.0
1
1
NIL
HORIZONTAL

SLIDER
5
450
175
483
reproduction-interval
reproduction-interval
50
100
80.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model explores the impact of illegal fishing and artificial plankton feeding for tourism on whaleshark populations. Such controversial practices have been linked to a decrease of 63% of whaleshark populations in the last decade, especially in tourist spots such as Oslob, Philippines, which I visited in October 2023.

Little is known in the scientific world about the mysterious whale shark, but what we do know is that they may soon be extinct due to human activities. Whale sharks are solitary fish with slow growth, late maturation, long lifespans and no known predators, and illegal fishing is the biggest cause of mortality for them. 

Artificial plankton feeding at tourist spots, which is a more recent phenomenon, has been linked to reducing their nutrition, increasing their risk of baterial infections and abrasions from contact with boats, changing their behavior to swim towards instead of away from boats, and disrupting their migration patterns for breeding. 


## HOW IT WORKS

There are two main variations to this model.

In the first variation, the "no-artificial-plankton" version, whale sharks wander randomly and eat plankton, while illegal fishing boats appear and hunt them whenever a big enough group of whale sharks are spotted (when the whaleshark-threshold is reached). They also disappear when the whale shark population falls below the threshold.

The fishing boats chase the whalesharks that are near them. There is a maximum number of fishing boats that can be set. In turn, the whale sharks have a probality of fleeing when they are near the fishing boats. 

Both the whale sharks and the fishing boats have energy, but use it differently. For whale sharks, each step costs energy, and the whale sharks must eat plankton to replenish energy. Fishing boats don't consume energy or need it to move, but gain energy (food) every time they successfully hunt a whale shark, leave when they have gained enough food (min-energy-to-leave). 

The whale sharks have a probability of reproducing at each time step, and the plankton replenishes after a fixed amount of time.

In the second variation "artificial-plankton", we model the idea of artificial plankton feeding from tourist boats as an additional food source. When whale sharks come near the artificial plankton, they are attracted to the tourist boat and gorge on the plankton, even though they earn less energy from the lower nutritional content. Their reproductive rate is reduced for a defined time interval (shown by a temporary change in their color to YELLOW), and they temporarily swim towards fishing boats instead of fleeing from them.

## HOW TO USE IT

1. Set the model-version chooser to "artificial-plankton" to include artificial plankton feeding in the model, or to "no-artificial-plankton" to only include whale sharks, fishing boats and plankton.
2. Adjust the slider parameters (see below), or use the default settings.
3. Press the SETUP button.
4. Press the GO button to begin the simulation.
5. Look at the monitors to see the current population sizes.
6. Look at the POPULATIONS plot to watch the populations fluctuate over time.

Parameters:
MODEL-VERSION: Whether we model "artificial-plankton" or "no-artificial-plankton"
INITIAL-NUMBER-WHALESHARK: The initial size of whale shark population
INITIAL-NUMBER-FISHINGBOATS: The initial number of fishing boats hunting whale sharks
PLANKTON-REGROWTH-TIME: How long it takes for plankton to regrow once it is eaten 
SHOW-ENERGY?: Whether or not to show the energy of each whale shark or fishing boat as a number

WHALESHARK-GAIN-FROM-FOOD: The amount of energy whale sharks get for every plankton patch eaten 
WHALESHARK-REPRODUCE: The probability of a whaleshark reproducing at each time step
REPRODUCTION-INTERVAL: The number of ticks before whale sharks reproduce again

FISHINGBOAT-GAIN-FROM-FOOD: The amount of energy fishing boats get for every whaleshark hunted
MAX-FISHINGBOATS: The maximum number of fishing boats that can be deployed 
WHALESHARK-THRESHOLD: The minimum number of whalesharks needed for a boat to appear
MIN-ENERGY-TO-LEAVE:The minimum food (energy) gathered needed for a fishing boat to leave

ARTIFICIAL-PLANKTON-INTERVAL: The number of ticks that artificial plankton effects work on whale sharks that have eaten it 
ATTRACTION-DISTANCE: The distance from the tourist boat at which whale sharks start being attracted to the artificial plankton	

Notes:
There are three monitors to show the populations of the whale sharks, plankton and fishing boats and a populations plot to display the population values over time.

If there are either too many whale sharks or if they become extinct, the model run stops.

## THINGS TO NOTICE

There are different ways to arrange the variables in the model to see what could make whale sharks either extinct or grow in population.

1. Increasing or decreasing the maximum number of fishing boats impacts the speed at which whale sharks become extinct.
2. The fertility rate of the whale sharks also affects their survival.
3. Ingesting the artificial plankton also impacts the mortality rate of the whale sharks.  

Some variations may be stable while others are not.


## THINGS TO TRY

Try adjusting the parameters to see under which settings the whale sharks will have a sustainable population, or else overrun the ocean, or else become extinct.

## EXTENDING THE MODEL

The reproduction effect could be made more complex to more closely match the breeding behavior of whale sharks.

the artificial plankton effects could be tweaked to add tourists and model their impact on the whale sharks. 

The behavior of the whale sharks could be made more complex so that their movements follow seasonal or migratory patterns.

## CREDITS AND REFERENCES

* Wilensky, U. (1997).  NetLogo Wolf Sheep Predation model.  http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

***This model is originally based on the sheep-wolves-grass model of predator-prey ecosystems. The model is far from perfect and greatly simplifies these behaviors, but it can be the starting point for more complex modelling.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

boat
false
3
Polygon -6459832 true true 0 135 300 135 300 135 255 180 30 180 0 135 150 135 150 0 225 90 150 135

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

whale shark
true
0
Polygon -1 true false 87 103 53 110 20 136 23 112 47 86 82 66
Polygon -1 true false 188 98 222 105 255 131 252 107 228 81 193 61
Polygon -1 true false 131 256 87 279 86 285 120 300 150 285 180 300 214 287 212 280 166 255
Polygon -7500403 true true 134 258 76 137 80 62 89 18 145 -4 159 -4 169 1 209 18 209 93 211 137 165 258
Circle -16777216 true false 95 23 30
Circle -16777216 true false 169 25 30
Circle -1 true false 110 89 30
Circle -1 true false 107 135 30
Circle -1 true false 131 192 30
Circle -1 true false 150 88 30
Circle -1 true false 145 135 30
Line -1 false 180 120 210 135
Line -1 false 180 90 210 105
Line -1 false 75 135 105 120
Line -1 false 75 105 105 90

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
set model-version "sheep-wolves-grass"
set show-energy? false
setup
repeat 75 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
