;; THE GARBAGE CAN MODEL




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Variables declaration ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
globals [
          ;; Agents available for decision-making
          free-participants ;; cumulative number of non-blocked participants
          ave-free-participants ;; average number of non-blocked participants
          free-opportunities ;; cumulative number of non-blocked opportunities
          ave-free-opportunities ;; average number of non-blocked opportunities
          free-solutions ;; cumulative number of non-blocked solutions
          ave-free-solutions ;; average number of non-blocked solutions
          free-problems ;; cumulative number of non-blocked problems
          ave-free-problems ;; average number of non-blocked problems
          
          ;; Kinds of decision-making and kinds of flights.
          num-oversight ;; cumulative number of decisions by oversight
          num-blocked-oversight ;; cumulative number of decisions by oversight following a blocked decision process
          num-resolution ;; cumulative number of decisions by resolution
          num-blocked-resolution ;; cumulative number of decisions by resolution following a blocked decision process
          num-postponement ;; cumulative number of flights by postponement
          num-buck-passing ;; cumulative number of flights by buck-passing
          
          ;; Blocked decisions, postponed problems, passed problems.
          num-blocked ;; cumulative number of blocked decision processes
          ave-num-blocked ;; average number of blocked decision processes
          size-blocked ;; cumulative size of blocked decision processes
          ave-size-blocked ;; average size of blocked decision processes
          life-blocked ;; cumulative lives of blocked decision processes
          ave-life-blocked ;; average life of blocked decision processes
          num-postponed ;; cumulative number of postponed problems
          ave-num-postponed ;; average number of postponed problems
          life-postponed ;; cumulative lives of pairs opportunity-problem
          ave-life-postponed ;; average life of pairs opportunity-problem
          num-passed ;; cumulative number of passed problems
          ave-num-passed ;; average number of passed problems
          life-passed ;; cumulative lives of pairs participant-problem
          ave-life-passed ;; average life of pairs participant-problem
          
          ;; The counters of meetings with already-met opportunities, solutions and problems.
          meetings-known-opp
          meetings-opp
          meetings-known-sol
          meetings-sol
          meetings-known-pro
          meetings-pro
          
          ;; These are necessary in order to impose decision structure and access structure.
          arrivals-departures_par ;; the number of arrivals minus the number of departures of participants
          arrivals-departures_opp ;; the number of arrivals minus the number of departures of opportunities
          arrivals-departures_sol ;; the number of arrivals minus the number of departures of solutions
          arrivals-departures_pro ;; the number of arrivals minus the number of departures of problems
          
          ;; Indicators of decision-making by oversight and resolution at different hierarchical levels.
          countOveHigh ;; the number of oversights making use of opportunities at high hierarchical levels
          countOveLow ;; the number of oversights making use of opportunities at low hierarchical levels
          countResHigh ;; the number of resolutions making use of opportunities at high hierarchical levels
          countResLow ;; the number of resolutions making use of opportunities at low hierarchical levels          
        ]
patches-own [pcolor-white-since] ;; since when it hosts a blocked decision process
turtles-own [blocked?] ;; whether an agent is allowed to move
breed [solution]
breed [opportunity]
breed [participant]
breed [problem] 
participant-own [ participant_id ;; the identification number of participants
                  ability ;; the ability of participants
                  charged? ;; eventually, this participant is charged...
                  with-problem ;; ...with this problem
                  encountered ;; the agents this participant has already met
                ]
opportunity-own [ opportunity_id ;; the identification number of opportunities
                  charged? ;; eventually, this opportunity is charged...
                  with-problem ;; ...with this problem
                ]
solution-own [ solution_id ;; the identification number of solutions
               efficiency ;; the efficiency of solutions
             ] 
problem-own [ problem_id ;; the identification number of problems
              difficulty ;; the difficulty of problems
              postponed? ;; eventually, this problem has been postponed...
              to-opportunity ;; ...to this opportunity
              passed? ;; eventually, this problem has been passed...
              to-participant ;; ...to this participant
              since ;; when the flight began
            ]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;







;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;; What is done when the "Setup" button is pressed ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup 
  clear-all
  reset-ticks  
  
  ;; Initializes the counters of the variations of the number of agents.
  set arrivals-departures_par 0
  set arrivals-departures_opp 0
  set arrivals-departures_sol 0
  set arrivals-departures_pro 0
  
  ;; Initializes the counters of agents avaiilable for decision-making.
  set free-participants 0
  set free-opportunities 0
  set free-solutions 0
  set free-problems 0
  
  ;; Initializes the number of kinds of decision-making and flights.
  set num-oversight 0
  set num-blocked-oversight 0
  set num-resolution 0
  set num-blocked-resolution 0
  set num-postponement 0
  set num-buck-passing 0

  ;; Initializes the number of blocked decisions, the number of postponed problems and the number of passed problems.
  set num-blocked 0
  set size-blocked 0
  set life-blocked 0
  set num-postponed 0
  set life-postponed 0
  set num-passed 0
  set life-passed 0

  ;; Initializes the counters of the meetings with opportunities, solutions and problems that had already been met.
  set meetings-known-opp 0
  set meetings-opp 0
  set meetings-known-sol 0
  set meetings-sol 0
  set meetings-known-pro 0
  set meetings-pro 0
  
  ;; Initializes the counters of oversights and resolutions at high and low hierarchical levels.
  ifelse (opportunities-exit? and (decision-structure != "anarchy" or availability-structure != "anarchy" or access-structure != "anarchy")) [
    set countOveHigh 0
    set countOveLow 0
    set countResHigh 0
    set countResLow 0
  ] [
    set countOveHigh "N/A"
    set countOveLow "N/A"
    set countResHigh "N/A"
    set countResLow "N/A"
  ]
  
  ;; Initializes the counter of how long a decision process stays blocked.
  ask patches
    [set pcolor-white-since 0]

  ;; Creates the agents that are initially present in the organization.
  set-default-shape participant "participant"
  create-participant initial-participants  ;; creates the participants and initializes their variables
  [ 
    setxy random world-width random world-height
    set blocked? false
    set charged? false
    set with-problem nobody
    set participant_id who
    set encountered []
  ]
  set-default-shape opportunity "opportunity"
  create-opportunity initial-opportunities  ;; creates the choice opportunities and initializes their variables
  [ 
    setxy random world-width random world-height
    set blocked? false
    set charged? false
    set with-problem nobody
    set opportunity_id (who - initial-participants)
  ]
  set-default-shape solution "solution"
  create-solution initial-solutions  ;; creates the solutions and initializes their variables
  [ 
    setxy random world-width random world-height
    set blocked? false
    set solution_id (who - initial-participants - initial-opportunities)
  ]
  set-default-shape problem "problem"
  create-problem initial-problems  ;; creates the problems and initializes their variables
  [ 
    setxy random world-width random world-height
    set blocked? false
    set postponed? false
    set to-opportunity nobody
    set passed? false
    set to-participant nobody
    set since 0
    set problem_id (who - initial-participants - initial-opportunities - initial-solutions)
  ]
  
  ;; Participants and problems are endowed with energy, solutions are endowed with efficiency
  assign-ability
  assign-difficulty
  assign-efficiency

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;












;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; What is done when the "Go Step" button is pressed and what is repeated at each step when the "Go Until" button is pressed
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to go







  ;;;;;;;;;;;;;;;;;;;;;; MISCELLANEOUS
        
  ;; The number of ticks is updated. Eventually, the simulation is stopped.
  tick
  if ((stop-at > 0) and (ticks = stop-at)) [
    if (show-details?)
      [write-survivors]
    stop
  ]
  
  ;; Eventually, labels are depicted near the agents. Labels show participants' ability, solutions' efficiency and problems' difficulty, respectively.
  if (show-details?)
    [show-labels]




  
  
  
  
  
  ;;; THE SIMULATION IS NOT ALLOWED TO BEGIN IF MINIMUM VALUES OF ABILITY, EFFICIENCY AND DIFFICULTY ARE GREATER THAN THE CORRESPONDING MAXIMUM VALUES

  if (min-ability > max-ability) [
    type "MINIMUM ABILITY SHOULD NOT BE GREATER THAN MAXIMUM ABILITY"
    stop
  ]
  if (min-efficiency > max-efficiency) [
    type "MINIMUM EFFICIENCY SHOULD NOT BE GREATER THAN MAXIMUM EFFICIENCY"
    stop
  ]
  if (min-difficulty > max-difficulty) [
    type "MINIMUM DIFFICULTY SHOULD NOT BE GREATER THAN MAXIMUM DIFFICULTY"
    stop
  ]












  ;;;;;;;;;;;;;;; ABILITY, EFFICIENCY AND DIFFICULTY MAY NEED TO BE ASSIGNED AGAIN
  
  ;; If ability, efficiency and difficulty are distributed according to the numbering of agents (competence or incompetence)
  ;; and if some participants, problems or solutions exit, then ability, efficiency and difficulty must be re-distributed to all of them.
  ;; Note that this may impact on the number of flights, since blocked agents may be assigned new values of ability, efficiency or difficulty.

  if ((dist-ability = "competence" or dist-ability = "incompetence") and participants-exit?) [
    assign-ability
  ]
  if ((dist-efficiency = "competence" or dist-efficiency = "incompetence") and solutions-exit?) [
    assign-efficiency
  ]
  if ((dist-difficulty = "competence" or dist-difficulty = "incompetence") and problems-exit?) [
    assign-difficulty
  ]











;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DECISION - MAKING

  ;; Though decisions are made by participants, it is more convenient to let patches operate.
  ask patches [
    ;; Resets the world on black, except flying couples.
    ifelse (any? problem-here with [postponed? or passed?])
      [set pcolor brown] [
        if (pcolor != white)
          [set pcolor black]
      ]
    ;; If there is at least one participant, one choice opportunity and one solution, then a decision is made.
    if (any? participant-here and any? opportunity-here and any? solution-here) [
      ;; Agents paired because of a flight enter the decision process on equal status with the others.
      ask participant-here [
        if (charged?) [
          set charged? false
          set with-problem nobody
        ]
      ]
      ask opportunity-here [
        if (charged?) [
          set charged? false
          set with-problem nobody
        ]
      ]
      ask problem-here [
        if (postponed?) [
          set postponed? false
          set to-opportunity nobody
        ]
        if (passed?) [
          set passed? false
          set to-participant nobody
        ]
      ]
      ;; If there are problems as well, either they are resolved if their ability is sufficient or all agents stay put until another opportunity or another participant passes by and takes a problem away.
      ifelse (any? problem-here) [
        ;; If the sum of the ability of all participants on a patch, multiplied by the efficiency of the most efficient solution on the
        ;; same patch, is greater or equal than the sum of the difficulty of all problems on the same patch, then decisions are made by resolution.
        ifelse ((sum [ability] of participant-here)*([efficiency] of max-one-of solution-here [efficiency]) >= (sum [difficulty] of problem-here)) [
          set num-resolution num-resolution + 1
          ;; A decision by resolution is marked by a green square. The counters of the life of blocked decisions and flying pairs are reset.
          if (pcolor = white)
            [set num-blocked-resolution num-blocked-resolution + 1]
          set pcolor lime
          set pcolor-white-since 0
          ask problem-here [set since 0]
          ;; Write information on the control center.
          if (show-details?)
            [write-resolutions]
          ;; The indicators of the percentages of resolutions on low and high hierarchical levels.
          let chosenOppRes one-of opportunity-here
          if (opportunities-exit? and (decision-structure != "anarchy" or availability-structure != "anarchy" or access-structure != "anarchy")) [ 
            ifelse ([opportunity_id] of chosenOppRes < (count opportunity) * 0.5)
              [set countResHigh countResHigh + 1]
              [set countResLow countResLow + 1]
          ]
          ;; If participants exit after a decision is made, all participants on the patch are killed.
          if (participants-exit?) [
            kill participant-here
          ]
          ;; If opportunities exit after a decision is made, one of the opportunities that are on the patch is picked up and killed.
          if (opportunities-exit?) [
            kill chosenOppRes
          ]
          ;; If solutions exit after a decision is made, the most efficient solution on the patch is killed.
          if (solutions-exit?) [
            kill max-one-of solution-here [efficiency]
          ]
          ;; If problems exit after a decision is made, all problems on the patch are killed.
          if (problems-exit?) [
            kill problem-here
          ]
          ;; If there are still agents on the patch, they must be free to move. This is not obvious, because they may stem from a flight.
          ask turtles-here [
            if (blocked?) [set blocked? false]
          ]
        ]
        ;; If the ability of the participants is not sufficient to make a decision, all agents on the patch are blocked.
        ;; Eventually, a flight might enable the remaining agents to make a decision either by resolution or by oversight.
        [
          ask turtles-here [set blocked? true]
          ;; A blocked decision process is marked by a white square.
          if (pcolor != white) [
            set pcolor white
            set pcolor-white-since ticks
          ]
          ;; Eventually, a flight by postponement takes place.
          ifelse (postpone? and count opportunity-here > 1) [
            ;; An opportunity and a problem are chosen to be paired to one another.
            let which-opportunity max-one-of opportunity-here [opportunity_id]
            let which-problem-for-opportunity max-one-of problem-here [difficulty]
            ;; Checks that there is at least one place to which the chosen opportunity can move.
            if (
                (decision-structure = "anarchy" and access-structure = "anarchy" and availability-structure = "anarchy") or

                (decision-structure = "anarchy" and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at 1 0) with [solution_id > [opportunity_id] of which-opportunity])) or   
                (decision-structure = "anarchy" and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 1) with [solution_id > [opportunity_id] of which-opportunity])) or   
                (decision-structure = "anarchy" and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at -1 0) with [solution_id > [opportunity_id] of which-opportunity])) or   
                (decision-structure = "anarchy" and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 -1) with [solution_id > [opportunity_id] of which-opportunity])) or   

                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at 1 0) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or
                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 1) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or
                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at -1 0) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or
                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 -1) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or

                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 1 0) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and availability-structure = "anarchy") or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 1) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and availability-structure = "anarchy") or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at -1 0) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and availability-structure = "anarchy") or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 -1) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and availability-structure = "anarchy") or


                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 1 0) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at 1 0) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 1) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 1) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at -1 0) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at -1 0) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 -1) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 -1) with [problem_id > [opportunity_id] of which-opportunity]) and availability-structure = "anarchy") or

                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at 1 0) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at 1 0) with [solution_id > [opportunity_id] of which-opportunity])) or
                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 1) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 1) with [solution_id > [opportunity_id] of which-opportunity])) or
                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at -1 0) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at -1 0) with [solution_id > [opportunity_id] of which-opportunity])) or
                (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 -1) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 -1) with [solution_id > [opportunity_id] of which-opportunity])) or

                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 1 0) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at 1 0) with [solution_id > [opportunity_id] of which-opportunity])) or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 1) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 1) with [solution_id > [opportunity_id] of which-opportunity])) or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at -1 0) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at -1 0) with [solution_id > [opportunity_id] of which-opportunity])) or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 -1) with [participant_id > [opportunity_id] of which-opportunity]) and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 -1) with [solution_id > [opportunity_id] of which-opportunity])) or


                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 1 0) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at 1 0) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at 1 0) with [solution_id > [opportunity_id] of which-opportunity])) or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 1) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 1) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 1) with [solution_id > [opportunity_id] of which-opportunity])) or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at -1 0) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at -1 0) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at -1 0) with [solution_id > [opportunity_id] of which-opportunity])) or
                ((decision-structure = "hierarchy" and not any? (participant-on patch-at 0 -1) with [participant_id > [opportunity_id] of which-opportunity]) and (access-structure = "hierarchy" and not any? (problem-on patch-at 0 -1) with [problem_id > [opportunity_id] of which-opportunity]) and (availability-structure = "hierarchy" and not any? (solution-on patch-at 0 -1) with [solution_id > [opportunity_id] of which-opportunity]))
                ) [
              ;; If yes, a flight by postponement takes place.
              set num-postponement num-postponement + 1
              ;; A flight takes place by postponing the most difficult problem to the least important opportunity.
              ask which-opportunity [
                set blocked? false
                set charged? true
                set with-problem which-problem-for-opportunity
              ]
              ask which-problem-for-opportunity [
                set blocked? false
                set postponed? true
                set to-opportunity which-opportunity
                set since ticks
              ]
              ;; Write information on the control center.
              if (show-details?)
                [write-postponements]
            ]
          ]
          ;; After the possibility of a flight by postponement, the possibility of a flight by buck-passing is considered.
          [
            ;; Eventually, a flight by buck-passing takes place.
            if (buckpass? and count participant-here > 1) [
              ;; A participant and a problem are chosen to be paired to one another.
              let which-participant min-one-of participant-here [ability]     
              let which-problem-for-participant max-one-of problem-here [difficulty]    
              ;; Checks that there is at least one place to which the chosen participant can move.
              if (decision-structure = "anarchy" or (decision-structure = "hierarchy" and
                  (not any? (opportunity-on patch-at 1 0) with [opportunity_id < [participant_id] of which-participant] or
                   not any? (opportunity-on patch-at 0 1) with [opportunity_id < [participant_id] of which-participant] or
                   not any? (opportunity-on patch-at -1 0) with [opportunity_id < [participant_id] of which-participant] or
                   not any? (opportunity-on patch-at 0 -1) with [opportunity_id < [participant_id] of which-participant]))
                 ) [
                set num-buck-passing num-buck-passing + 1
                ;; A flight takes place by buck-passing the most difficult problem to the least able participant.
                ask which-participant [
                  set blocked? false
                  set charged? true
                  set with-problem which-problem-for-participant
                ]
                ask which-problem-for-participant [
                  set blocked? false
                  set passed? true
                  set to-participant which-participant
                  set since ticks
                ]
                ;; Write information on the control center.
                if (show-details?)
                  [write-buck-passings]
              ]
            ]
          ]
        ]
      ]
      ;; On the contrary, if there are no problems to be solved, decisions are made by oversight. Since decision-making by oversight
      ;; has no energy requirements, there is no reason to use more than one choice opportunity. Thus, if there are several participants, 
      ;; several solutions and several opportunities on the same patch, all participants and all solutions make a decision exploiting
      ;; only one opportunity and making use of only one solution. If these agents exit after making a decision, all participants on the
      ;; patch exit, but only one randomly chosen solution exits and only one randomly chosen opportunity exits.
      [
        set num-oversight num-oversight + 1
        ;; A decision by oversight is marked by a sky-blue square. The counter of the life of blocked decisions is reset.
        if (pcolor = white)
          [set num-blocked-oversight num-blocked-oversight + 1]
        set pcolor sky
        set pcolor-white-since 0
        ;; Write information on the control center
        if (show-details?)
          [write-oversights]
        ;; The indicators of the percentages of oversights on low and high hierarchical levels.
        let chosenOppOve one-of opportunity-here
        if (opportunities-exit? and (decision-structure != "anarchy" or availability-structure != "anarchy" or access-structure != "anarchy")) [ 
          ifelse ([opportunity_id] of chosenOppOve < (count opportunity) * 0.5)
            [set countOveHigh countOveHigh + 1]
            [set countOveLow countOveLow + 1]
        ]
        ;; If participants exit after a decision is made, all participants on the patch are killed.
        if (participants-exit?) [
          kill participant-here
        ]
        ;; If opportunities exit after a decision is made, one of the opportunities that are on the patch is picked up and killed.
        if (opportunities-exit?) [
          kill chosenOppOve
        ]
        ;; If solutions exit after a decision is made, one of the solutions that are on the patch is picked up and killed.
        if (solutions-exit?) [
          kill one-of solution-here
        ]
        ;; If there are still agents on the patch, they must be free to move. This is not obvious, because they may stem from a flight.
        ask turtles-here [
          if (blocked?) [set blocked? false]
        ]
      ]
    ]
  ]








  ;;;;;;;;;;;;;;;;;;;;;;;;;; AND FINALLY MOVE
  
  ;; Agents are only allowed to turn by multiples of 90 degrees.
  ;; The movement of participants may be constrained by the decision structure.
  ;; The movement of solutions may be constrained by the availability structure.
  ;; The movement of problems may be constrained by the access structure.
  ;; The movement of opportunities may me constrained by the decision structure, the availability structure and the access structure.
  
  ;; Flying couples move first. Their movements take account of the positions of other agents.
  ask patches [
    ;; Paired problems and opportunities move together.
    ;; Opportunities must consider where they are allowed to move. Problems just follow opportunities.
    ask opportunity-here with [not blocked? and charged?] [
      set heading ((random 4) * 90)
      let initialheading heading
      let stop? false
      while [stop? = false] [
        if (
            (decision-structure = "anarchy" and access-structure = "anarchy" and availability-structure = "anarchy") or
            (decision-structure = "anarchy" and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself])) or   
            (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and availability-structure = "anarchy") or
            (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself])) or
            ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and access-structure = "anarchy" and availability-structure = "anarchy") or
            ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself])) or   
            ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and availability-structure = "anarchy") or
            ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself]))
            ) [
          if (pcolor = brown)
            [set pcolor black]
          move-to patch-ahead 1
          set pcolor brown
          set stop? true
        ]
        set heading ((heading + 90) mod 360)
        if (heading = initialheading)
          [set stop? true]
      ]
    ]
    ask problem-here with [not blocked? and postponed? and to-opportunity != nobody] [
      move-to to-opportunity
    ]
    ;; Paired problems and participants move together.
    ;; Participants must consider where they are allowed to move. Problems just follow participants.
    ask participant-here with [not blocked? and charged?] [
      set heading ((random 4) * 90)
      let initialheading heading
      let stop? false
      while [stop? = false] [
        if (
            (decision-structure = "anarchy") or
            ((decision-structure = "hierarchy") and (not any? (opportunity-on patch-ahead 1) with [opportunity_id < [participant_id] of myself]))
            ) [
          if (pcolor = brown)
            [set pcolor black]
          move-to patch-ahead 1
          set pcolor brown
          set stop? true
        ]
        set heading ((heading + 90) mod 360)
        if (heading = initialheading)
          [set stop? true]
      ]
    ]
    ask problem-here with [not blocked? and passed? and to-participant != nobody] [
      move-to to-participant
    ]
  ]

  ;; Uncoordinated agents move in different, randomly chosen directions.
  ;; However, participants must take account of the decision structure, solutions take account of the availability structure and problems
  ;; take account of the access structure.
  ;; Finally, opportunities must take account of both the decision structure, the availability structure and the access structure.
  ;; The highest-ranked agents are those with lowest ID.
  ask participant with [not blocked? and not charged?] [
    set heading ((random 4) * 90)
    if ((decision-structure = "anarchy") or
        ((decision-structure = "hierarchy") and (not any? (opportunity-on patch-ahead 1) with [opportunity_id < [participant_id] of myself]))) [
      move-to patch-ahead 1
    ]
  ]
  ask opportunity with [not blocked? and not charged?] [
    set heading ((random 4) * 90)
    if (
        (decision-structure = "anarchy" and access-structure = "anarchy" and availability-structure = "anarchy") or
        (decision-structure = "anarchy" and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself])) or   
        (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and availability-structure = "anarchy") or
        (decision-structure = "anarchy" and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself])) or
        ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and access-structure = "anarchy" and availability-structure = "anarchy") or
        ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and access-structure = "anarchy" and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself])) or   
        ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and availability-structure = "anarchy") or
        ((decision-structure = "hierarchy" and not any? (participant-on patch-ahead 1) with [participant_id > [opportunity_id] of myself]) and (access-structure = "hierarchy" and not any? (problem-on patch-ahead 1) with [problem_id > [opportunity_id] of myself]) and (availability-structure = "hierarchy" and not any? (solution-on patch-ahead 1) with [solution_id > [opportunity_id] of myself]))
        ) [
      move-to patch-ahead 1
    ]
  ]
  ask solution with [not blocked?] [
    set heading ((random 4) * 90)
    if ((availability-structure = "anarchy") or
        ((availability-structure = "hierarchy") and (not any? (opportunity-on patch-ahead 1) with [opportunity_id < [solution_id] of myself]))) [
      move-to patch-ahead 1
    ]
  ]
  ask problem with [not blocked? and not postponed? and not passed?] [ 
    set heading ((random 4) * 90)
    if ((access-structure = "anarchy") or
        ((access-structure = "hierarchy") and (not any? (opportunity-on patch-ahead 1) with [opportunity_id < [problem_id] of myself]))) [
      move-to patch-ahead 1
    ]
  ]
  
  
  
  
  
  
  
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;,,,;;;;;; THE NUMBER OF AGENTS AVAILABLE FOR DECISION-MAKING

  set free-participants free-participants + count participant with [not blocked? and not charged?]
  set ave-free-participants free-participants / ticks
  set free-opportunities free-opportunities + count opportunity with [not blocked?]
  set ave-free-opportunities free-opportunities / ticks
  set free-solutions free-solutions + count solution with [not blocked?]
  set ave-free-solutions free-solutions / ticks
  set free-problems free-problems + count problem with [not blocked?]
  set ave-free-problems free-problems / ticks


  

  
  
  ;;;;;;;;;;;; MEASURES WHETHER OPPORTUNITIES, SOLUTIONS AND PROBLEMS ARE MET, THAT HAD ALREADY BEEN MET
  
  ;; Participants who are in blocked decision processes, as well as participants charged with problems, are excluded.
  ask participant with [not blocked? and not charged?] [
    set meetings-known-opp meetings-known-opp + count opportunity-here with [member? who [encountered] of myself]
    set meetings-opp meetings-opp + count opportunity-here
    set meetings-known-sol meetings-known-sol + count solution-here with [member? who [encountered] of myself]
    set meetings-sol meetings-sol + count solution-here
    set meetings-known-pro meetings-known-pro + count problem-here with [member? who [encountered] of myself]
    set meetings-pro meetings-pro + count problem-here
    ;; Agents that had not been previously met, are added to the list.
    if (any? turtles-here with [breed != participant and not (member? who [encountered] of myself)]) [
      foreach [who] of turtles-here with [breed != participant and not (member? who [encountered] of myself)] [
        set encountered fput ? encountered
      ]
    ]
  ]

      
      
      
    
  ;;;;;;;;;; COUNTS THE NUMBER OF BLOCKED DECISIONS, THE NUMBER OF POSTPONED PROBLEMS AND THE NUMBER OF PASSED PROBLEMS
  
  if (any? patches with [pcolor = white]) [
    ;; Number of blocked decision processes.
    set num-blocked num-blocked + count patches with [pcolor = white]
    set ave-num-blocked num-blocked / ticks
    ;; Size of blocked decision processes.
    set size-blocked size-blocked + count turtles with [blocked?] / count patches with [pcolor = white]
    set ave-size-blocked size-blocked / ticks
    ;; Life of blocked decision processes.
    let life-blocked-now 0
    ask patches with [pcolor = white] [
      set life-blocked-now life-blocked-now + (ticks - pcolor-white-since)
    ]
    set life-blocked-now life-blocked-now / count patches with [pcolor = white]
    set life-blocked life-blocked + life-blocked-now
    set ave-life-blocked life-blocked / ticks
  ]
  if (any? problem with [postponed?]) [
    ;; Number of postponed problems.
    set num-postponed num-postponed + count opportunity with [charged?]
    set ave-num-postponed num-postponed / ticks
    ;; Life of postponed problems
    let life-postponed-now 0
    ask problem with [postponed?] [
      set life-postponed-now life-postponed-now + (ticks - since)
    ]
    set life-postponed-now life-postponed-now / count problem with [postponed?]
    set life-postponed life-postponed + life-postponed-now
    set ave-life-postponed life-postponed / ticks
  ]
  if (any? problem with [passed?]) [
    ;; Number of passed problems.
    set num-passed num-passed + count participant with [charged?]
    set ave-num-passed num-passed / ticks
    ;; Life of passed problems.
    let life-passed-now 0
    ask problem with [passed?] [
      set life-passed-now life-passed-now + (ticks - since)
    ]
    set life-passed-now life-passed-now / count problem with [passed?]
    set life-passed life-passed + life-passed-now
    set ave-life-passed life-passed / ticks
  ]





end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


















;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;; Procedures to distribute ability to participants, efficiency to solutions, and difficulty to problems ;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to assign-ability
  if (dist-ability = "random") [
    ask participant [set ability random-float (max-ability - min-ability) + min-ability]
  ]
  if (dist-ability = "competence") [
    ifelse (count participant > 1) [
      ask participant [set ability min-ability + ((count participant - 1 - participant_id) / (count participant - 1)) * (max-ability - min-ability)]
    ] [
      ask participant [set ability (min-ability + max-ability) / 2]
    ]
  ]
  if (dist-ability = "incompetence") [
    ifelse (count participant > 1) [
      ask participant [set ability min-ability + (participant_id / (count participant - 1)) * (max-ability - min-ability)]
    ] [
      ask participant [set ability (min-ability + max-ability) / 2]
    ]
  ]
end

to assign-efficiency
  if (dist-efficiency = "random") [
    ask solution [set efficiency random-float (max-efficiency - min-efficiency) + min-efficiency]
  ]
  if (dist-efficiency = "competence") [
    ifelse (count solution > 1) [
      ask solution [set efficiency min-efficiency + ((count solution - 1 - solution_id) / (count solution - 1)) * (max-efficiency - min-efficiency)]
    ] [
      ask solution [set efficiency (min-efficiency + max-efficiency) / 2]
    ]
  ]
  if (dist-efficiency = "incompetence") [
    ifelse (count solution > 1) [
      ask solution [set efficiency min-efficiency + (solution_id / (count solution - 1)) * (max-efficiency - min-efficiency)]
    ] [
      ask solution [set efficiency (min-efficiency + max-efficiency) / 2]
    ]
  ]
end

to assign-difficulty
  if (dist-difficulty = "random") [
    ask problem [set difficulty random-float (max-difficulty - min-difficulty) + min-difficulty]
  ]
  if (dist-difficulty = "competence") [
    ifelse (count problem > 1) [
      ask problem [set difficulty min-difficulty + ((count problem - 1 - problem_id) / (count problem - 1)) * (max-difficulty - min-difficulty)]
    ] [
      ask problem [set difficulty (min-difficulty + max-difficulty) / 2]
    ]
  ]
  if (dist-difficulty = "incompetence") [
    ifelse (count problem > 1) [
      ask problem [set difficulty min-difficulty + (problem_id / (count problem - 1)) * (max-difficulty - min-difficulty)]
    ] [
      ask problem [set difficulty (max-difficulty - min-difficulty) / 2]
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

















;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; If participants, choice opportunities, solutions or problems exit after a decision is made, these procedures are acvtivated
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to kill [morituri]
  if (morituri != nobody) [
    ask morituri [
      if (breed = participant) [
        ;; If it is a participant charged with a problem, free the problem.
        if (charged?) [
          let this-problem-to-participant with-problem
          if (any? problem with [who = this-problem-to-participant]) [
            ask this-problem-to-participant [
              set passed? false
              set to-participant nobody
            ]
          ]
        ]
        ;; If the participant to be killed must be replaced, a new one is created.
        if (replace-participants?) [
          ;; Move the participant to be replaced.
          let found? false
          let localcounter 0
          while [not found?] [
            let newxcor random world-width
            let newycor random world-height
            if (not any? turtles-on patch newxcor newycor) [
              set found? true
              set xcor newxcor
              set ycor newycor
            ]
            set localcounter localcounter + 1
            if (localcounter > 10000) [
              type "TOO HIGH AGENT DENSITY"
              stop
            ]
          ]
          ;; Clone it, but with the following differences.
          hatch 1 [ 
            set blocked? false
            set charged? false
            set with-problem nobody
            set encountered []
          ]
        ]
        ;; The participants who met it, forget it.
        ask other participant [
          foreach encountered [
            if (? = [who] of myself)
              [set encountered remove ? encountered]
          ]
        ]
        ;; Finally kills it.
        die
      ]
      if (breed = opportunity) [
        if (charged?) [
          let this-problem with-problem
          if (any? problem with [who = this-problem]) [
            ask this-problem [
              set postponed? false
              set to-opportunity nobody
            ]
          ]
        ]
        ;; If the opportunity to be killed must be replaced, a new one is created.
        if (replace-opportunities?) [
          ;; Move the opportunity to be replaced.
          let found? false
          let localcounter 0
          while [not found?] [
            let newxcor random world-width
            let newycor random world-height
            if (not any? turtles-on patch newxcor newycor) [
              set found? true
              set xcor newxcor
              set ycor newycor
            ]
            set localcounter localcounter + 1
            if (localcounter > 10000) [
              type "TOO HIGH AGENT DENSITY"
              stop
            ]
          ]
          ;; Clone it, but with the following differences.
          hatch 1 [ 
            set blocked? false
            set charged? false
            set with-problem nobody
          ]
        ]
        ;; The participants who met it, forget it.
        ask participant [
          foreach encountered [
            if (? = [who] of myself)
              [set encountered remove ? encountered]
          ]
        ]
        ;; Finally kills it.
        die
      ]
      if (breed = solution) [
        ;; If the solution to be killed must be replaced, a new one is created.
        if (replace-solutions?) [
          ;; Move the solution to be replaced.
          let found? false
          let localcounter 0
          while [not found?] [
            let newxcor random world-width
            let newycor random world-height
            if (not any? turtles-on patch newxcor newycor) [
              set found? true
              set xcor newxcor
              set ycor newycor
            ]
            set localcounter localcounter + 1
            if (localcounter > 10000) [
              type "TOO HIGH AGENT DENSITY"
              stop
            ]
          ]
          ;; Clone it, but with the following differences.
          hatch 1 [ 
            set blocked? false
          ]
        ]
        ;; The participants who met it, forget it.
        ask participant [
          foreach encountered [
            if (? = [who] of myself)
              [set encountered remove ? encountered]
          ]
        ]
        ;; Finally kills it.
        die   
      ]
      if (breed = problem) [
        ;; If it is a postponed problem, free the opportunity to which it is postponed.
        if (postponed?) [
          let this-opportunity to-opportunity
          if (any? opportunity with [who = this-opportunity]) [
            ask this-opportunity [
              set charged? false
              set with-problem nobody
            ]
          ]
        ]
        ;; If is it a problem passed to somebody else, free this participant.
        if (passed?) [
          let this-participant to-participant
          if (any? participant with [who = this-participant]) [
            ask this-participant [
              set charged? false
              set with-problem nobody
            ]
          ]
        ]
        ;; If the problem to be killed must be replaced, a new one is created.
        if (replace-problems?) [
          ;; Move the problem to be replaced.
          let found? false
          let localcounter 0
          while [not found?] [
            let newxcor random world-width
            let newycor random world-height
            if (not any? turtles-on patch newxcor newycor) [
              set found? true
              set xcor newxcor
              set ycor newycor
            ]
            set localcounter localcounter + 1
            if (localcounter > 10000) [
              type "TOO HIGH AGENT DENSITY"
              stop
            ]
          ]
          ;; Clone it, but with the following differences.
          hatch 1 [ 
            set blocked? false
            set postponed? false
            set to-opportunity nobody
            set passed? false
            set to-participant nobody
            set since 0
          ]
        ]
        ;; The participants who met it, forget it.
        ask participant [
          foreach encountered [
            if (? = [who] of myself)
              [set encountered remove ? encountered]
          ]
        ]
        ;; Finally kills it.
        die
      ]
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;












;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;; Writes labels on the screen and information on decision-making on the command center ;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to show-labels
  ask participant [
    set label round ability
  ]
  ask problem [
    set label round difficulty
  ]
  ask solution [
    set label precision efficiency 1
  ]
end


to write-oversights
  type "OVERSIGHT N."
  write num-oversight
  actors-involved
end

to write-resolutions
  type "RESOLUTION N."
  write num-resolution
  actors-involved
end

to write-postponements
  type "FLIGHT BY POSTPONEMENT N."
  write num-postponement
  actors-involved
end

to write-buck-passings
  type "FLIGHT BY BUCK-PASSING N."
  write num-buck-passing
  actors-involved
end

to actors-involved
  ask participant-here [
    type "      Identity:"
    write who
    type ". One of:"
    write count participant
    type " participants. Ability:"
    write ability
    type ". Charged?"
    write charged?
    type ". With problem:"
    write with-problem
    type "."
  ]
  ask opportunity-here [
    type "      Identity:"
    write who
    type ". One of:"
    write count opportunity
    type " opportunities."
    type " Charged?"
    write charged?
    type ". With problem:"
    write with-problem
    type "."
  ]
  ask solution-here [
    type "      Identity:"
    write who
    type ". One of:"
    write count solution
    type " solutions. Efficiency:"
    write efficiency
    type "."
  ]
  ask problem-here [
    type "      Identity:"
    write who
    type ". One of:"
    write count problem
    type " problems. Difficulty:"
    write difficulty
    type ". Postponed?"
    write postponed?
    type ". To opportunity:"
    write to-opportunity
    type ". Passed?"
    write passed?
    type ". To participant:"
    write to-participant
    type "."
  ]
  print " "
end


to write-survivors
  print ""
  type "SURVIVING PARTICIPANTS"
  print ""
  ifelse (any? participant) [
    type "Identities:"
    ask participant [ write participant_id ]
    print " "
  ]
  [ type "none" ]
  type "SURVIVING OPPORTUNITIES"
  print ""
  ifelse (any? opportunity) [
    type "Identities:"
    ask opportunity [ write opportunity_id ]
    print " "
  ]
  [ type "none" ]
  type "SURVIVING SOLUTIONS"
  print ""
  ifelse (any? solution) [
    type "Identities:"
    ask solution [ write solution_id ]
    print " "
  ]
  [ type "none" ]
  type "SURVIVING PROBLEMS"
  print ""
  ifelse (any? problem) [
    type "Identities:"
    ask problem [ write problem_id ]
    print " "
  ]
  [ type "none" ]
  print ""
end
@#$#@#$#@
GRAPHICS-WINDOW
450
10
1454
978
17
16
28.4
1
10
1
1
1
0
1
1
1
-17
17
-16
16
0
0
1
ticks
30.0

SLIDER
9
81
145
114
initial-opportunities
initial-opportunities
0
500
100
1
1
NIL
HORIZONTAL

SLIDER
9
48
145
81
initial-participants
initial-participants
0
500
100
1
1
NIL
HORIZONTAL

BUTTON
157
10
212
43
Set Up
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
82
429
155
474
problems
count problem
0
1
11

MONITOR
9
429
82
474
solutions
count solution
0
1
11

BUTTON
267
10
327
43
Go Until
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
212
10
267
43
Go Step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
300
275
445
308
min-difficulty
min-difficulty
0
10
0
0.1
1
NIL
HORIZONTAL

SLIDER
155
275
300
308
min-efficiency
min-efficiency
0
1
0
0.1
1
NIL
HORIZONTAL

SLIDER
9
275
155
308
min-ability
min-ability
0
10
0
0.1
1
NIL
HORIZONTAL

PLOT
9
654
445
816
Decisions and Flights
step
NIL
0.0
100.0
0.0
1.0
true
true
"" ""
PENS
"Oversights" 1.0 0 -13791810 true "" "plot num-oversight"
"Resolutions" 1.0 0 -13840069 true "" "plot num-resolution"
"Postponements" 1.0 0 -6459832 true "" "plot num-postponement"
"Buck-Passings" 1.0 0 -16777216 true "" "plot num-buck-passing"

MONITOR
301
384
445
429
Decisions by Resolution
num-resolution
0
1
11

MONITOR
155
384
301
429
Decisions by Oversight
num-oversight
0
1
11

MONITOR
301
429
445
474
Flights by Buck-Passing
num-buck-passing
0
1
11

MONITOR
9
384
82
429
participants
count participant
0
1
11

MONITOR
82
384
155
429
opportunities
count opportunity
0
1
11

SLIDER
9
114
145
147
initial-solutions
initial-solutions
0
500
100
1
1
NIL
HORIZONTAL

SLIDER
9
147
145
180
initial-problems
initial-problems
0
500
100
1
1
NIL
HORIZONTAL

SWITCH
145
48
287
81
participants-exit?
participants-exit?
1
1
-1000

SWITCH
145
81
287
114
opportunities-exit?
opportunities-exit?
0
1
-1000

SWITCH
145
114
287
147
solutions-exit?
solutions-exit?
0
1
-1000

SWITCH
145
147
287
180
problems-exit?
problems-exit?
0
1
-1000

SLIDER
9
308
155
341
max-ability
max-ability
0
10
10
0.1
1
NIL
HORIZONTAL

SLIDER
300
308
445
341
max-difficulty
max-difficulty
0
10
10
0.1
1
NIL
HORIZONTAL

SLIDER
155
308
300
341
max-efficiency
max-efficiency
0
1
1
0.1
1
NIL
HORIZONTAL

MONITOR
155
429
301
474
Flights by Postponement
num-postponement
0
1
11

CHOOSER
9
230
155
275
dist-ability
dist-ability
"random" "competence" "incompetence"
0

CHOOSER
300
230
445
275
dist-difficulty
dist-difficulty
"random" "competence" "incompetence"
0

CHOOSER
155
230
300
275
dist-efficiency
dist-efficiency
"random" "competence" "incompetence"
0

CHOOSER
300
185
445
230
access-structure
access-structure
"anarchy" "hierarchy"
0

CHOOSER
9
185
155
230
decision-structure
decision-structure
"anarchy" "hierarchy"
0

SLIDER
9
10
157
43
stop-at
stop-at
0
5000
5000
1
1
NIL
HORIZONTAL

PLOT
9
816
445
978
Overall Balance
step
NIL
0.0
100.0
0.0
10.0
true
true
"" ""
PENS
"Ability of Participants" 1.0 0 -1184463 true "" "plot sum [ability] of participant"
"Efficiency of Solutions" 1.0 0 -2674135 true "" "plot sum [efficiency] of solution"
"Ability x Efficiency" 1.0 0 -955883 true "" "ifelse (any? solution) [plot ((sum [ability] of participant) * (sum [efficiency] of solution)/(count solution))] [plot 0]"
"Difficulty of Problems" 1.0 0 -8630108 true "" "plot sum [difficulty] of problem"

SWITCH
327
10
445
43
show-details?
show-details?
1
1
-1000

SWITCH
9
346
114
379
postpone?
postpone?
1
1
-1000

SWITCH
114
346
219
379
buckpass?
buckpass?
1
1
-1000

MONITOR
155
474
301
519
Postponed Problems
count opportunity with [charged?]
17
1
11

MONITOR
301
474
445
519
Passed Problems
count participant with [charged?]
17
1
11

MONITOR
9
474
155
519
Blocked Decisions
count patches with [pcolor = white]
17
1
11

MONITOR
9
564
155
609
Deja-vu Opportunities
meetings-known-opp / meetings-opp\n
17
1
11

MONITOR
155
564
301
609
Deja-vu Solutions
meetings-known-sol / meetings-sol
17
1
11

MONITOR
301
564
445
609
Deja-vu Problems
meetings-known-pro / meetings-pro
17
1
11

MONITOR
9
609
155
654
Ove/Res High Levels
countOveHigh / countResHigh
17
1
11

MONITOR
155
609
301
654
Ove/Res Low Levels
countOveLow / countResLow
17
1
11

MONITOR
301
609
445
654
Dec. Low / Dec. High
(countResLow + countOveLow) / (countResHigh + countOveHigh)
17
1
11

SWITCH
287
48
445
81
replace-participants?
replace-participants?
1
1
-1000

SWITCH
287
81
445
114
replace-opportunities?
replace-opportunities?
0
1
-1000

SWITCH
287
114
445
147
replace-solutions?
replace-solutions?
0
1
-1000

SWITCH
287
147
445
180
replace-problems?
replace-problems?
0
1
-1000

CHOOSER
155
185
300
230
availability-structure
availability-structure
"anarchy" "hierarchy"
0

MONITOR
9
519
155
564
Life Blocked Decisions
ave-life-blocked
17
1
11

MONITOR
155
519
301
564
Life Postponed Problems
ave-life-postponed
17
1
11

MONITOR
301
519
445
564
Life Passed Problems
ave-life-passed
17
1
11

@#$#@#$#@
## WHAT IS IT?

The Garbage Can Model (GCM) of Organizational Choice (Cohen, March and Olsen 1972) is the most famous model of organizational decision-making. We previously reproduced the original Garbage Can model in an agent-based setting (Fioretti and Lomi 2008a, 2008b). With this code, we added an additional feature to the original model and, furthermore, we eliminated some unnecessary indicators.

In the GCM, decision is made when the members of an organization apply a solution to an opportunity for making a choice. Note that solutions exist before problems, and that decisions can be made even without solving any problem. Eventually, a problem may be there to be solved, but this is not necessarily the case.

In this decision process, choice opportunities take the role of "garbage cans" where solutions and problems are dumped. Hence the name of the model.

The GCM can be seen as a sort of chemical reactor where participants (decision-makers), choice opportunities, solutions and problems have been dumped. Through random meetings of these elements, decisions are made. The space where these components meet represents the organization where decisions are made.

We interpreted the GCM as an agent-based model where participants, opportunities, solutions and problems are four classes of agents. Participants are denoted by yellow men. Opportunities are denoted by orange squares. Solutions are denoted by red circles. Problems are denoted by violet triangles.

Exogenous structures may be imposed on participants, opportunities, solutions and problems:

- If "decision-structure = anarchy" participants move freely within the organization;  
- If "availability-structure = anarchy" solutions move freely within the organization;  
- If "access-structure = anarchy" problems move freely within the organization.
Furthermore:
- If "decision-structure = hierarchy" participants and choice opportunities are ranked in order of importance and participants are only allowed to move on to opportunities of less or equal importance;  
- If "availability-structure = hierarchy" solutions and choice opportunities are ranked in order of importance and solutions are only allowed to move on to opportunities of less or equal importance;  
- If "access-structure = hierarchy" problems and opportunities are ranked in order of importance and problems are only allowed to move on to opportunities of less or equal importance.

Participants are characterized by their ability in solving problems. Solutions are characterized by their efficiency. Problems are characterized by their difficulty.

Ability, efficiency and difficulty take values within a range specified by the sliders "min-ability" and "max-ability", "min-efficiency" and "max-efficiency", "min-difficulty" and "max-difficulty", respectively. They may be assigned to participants, solutions and problems according to one the following three criteria, to be selected by means of the the sliders "dist-ability", "dist-efficiency" and "dist-difficulty", respectively:

Random: The values of ability, efficiency and difficulty are assigned at random according to a uniform distribution that spans the range between minimum and maximum values;

Competence: The participants, solutions or problems with lowest identification number (conventionally, the most important participants, problems and solutions) receive the highest values of ability, efficiency or difficulty, respectively;

Incompetence: The participants, solutions or problems with lowest identification number (conventionally, the most important participants, solutions and problems) receive the lowest values of ability, efficiency or difficulty, respectively.

A problem is solved when a participant has sufficient ability and a sufficiently efficient solution such that their product is greater or equal to the difficulty of the problem. When a problem is solved, the GCM says that a decision is made "by resolution".

However, a key feature of the Garbage Can model is that a lot of decision-making may not solve any problem at all. For instance, choice opportunities may be used as showrooms in corporate politics rather than as occasions to solve problems. In these cases, decision is made "by oversight".

Decision-making by resolution takes place when at least one participant, at least one opportunity, at least one solution, at least one problem are on the same patch and the sum of the abilities of the participants on the patch, multiplied by the efficiency of the most efficient solution on the patch, is greater or equal to the sum of the difficulties of the problems on the patch. Most often, decision-making by resolution occurs when just one participant, one choice opportunity, one solution and one problem happen to be on the same patch and the ability of the participant, multiplied by the efficiency of the solution, is greater or equal to the difficulty of the problem. The patch where a decision by resolution is made takes a green color.

Decision-making by oversight takes place when at least one participant, at least one choice opportunity and at least one solution are on the same patch. No problem must be there to be solved. Thus, decision-making by oversight occurs most often when a participant, a solution and a choice opportunity happen to be on the same patch. The patch where a decision by oversight is made takes a sky-blue color.

An organization starts its life with a given number of participants, opportunities, solutions and problems. These initial values are set by means of the sliders "initial-participants", "initial-opportunities", initial-solutions" and "initial-problems", respectively. These parameters may take any integer value between 0 and 500.

Participants, opportunities, solutions and problems may be required to exit the organization after decision-making. This option is chosen by means of the switches "participants-exit?", "opportunities-exit?", "solutions-exit?" and "problems-exit?", respectively.

If the switch "participants-exit?" is ON, on each patch where a decision is made, all participants exit. If the switch "opportunities-exit?" is ON, on each patch where a decision is made one opportunity exits. If the switch "solutions-exit?" is ON, on each patch where a decision is made one solution exits: the most efficient solution if it is a decision by resolution, or a randomly chosen solution if it is a decision by oversight. If the switch "problems-exit?" is ON, all problems on the patches where a decision by resolution is made, exit.

If the switch "replace-participants?" is ON, any leaving participant is immediately replaced. The switches "replace-opportunities?", "replace-solutions?" and "replace-problems?" have a similar meaning.

If problems are on the same patch with participants, solutions and choice opportunities, but the sum of the abilities of the participants multiplied by the efficiency of the most efficient solution is less than the sum of the difficulties of the problems, all agents on the patch are blocked and no decision is made. The patch where a decision process is blocked takes a white color.

Participants can fly away from the most difficult problem involved in a blocked decision process. This is called "flight".

In the original GCM, a flight is obtained by postponing the most difficult problem. This is accomplished if an additional opportunity walks on the patch where a decision process is blocked. The most difficult problem on the patch is bound to the least important opportunity on the patch (a choice that has no effect if no hierarchical structure was imposed), and the two start walking together. The patch where they find themselves takes a brown color. The possibility of postponing decision-making is enabled by the switch "postpone?".

We added to the GCM the possibility that a flight is obtained by buck-passing. This is accomplished if only one participant is on the patch where a decision process is blocked, and an additional participant walks on it: the most difficult problem is bound to the least able among the participants on the patch, and the two start walking together. The patch where they find themselves takes a brown color. The possibility of buck-passing is enabled by the switch "buckpass?".

Once the most difficult problem left, the remaining agents may be able to make a decision, either by resolution or by oversight. Thus, flight is very important in organizational decision-making.

The switch "show-details?" allows to visualize ability, efficiency and difficulty of each agent. Furthermore, it prints an information line each time a decision is made. Each line says whether the decision was made by oversight or resolution, which agents it involved as well as the time step when they were created. If the option "show-details?" is chosen, it is advisable to enlarge the Command Center.

In previous versions, we reproduced all the indicators of the original GCM. However, our experiment highlighted that most of these indicators are redundant (Fioretti and Lomi 2008a, 2008b). At the same time, other indicators are in required in order to derive all the features of the model as emergent properties. In the end, we ended up with the following set of indicators:

- The number of participants, opportunities, solutions and problems that are in the organization at any point in time;

- The number of decisions by oversight and the number of decisions by resolution;

- The number of flights by postponement and the number of flights by buck-passing;

- The  number of blocked decision processes, the number of postponed problems and the number of passed problems in the organization;

- The average life of blocked decision processes, of postponements and of buck-passings;

- The percent of times that a participant meets an opportunity that (s)he has already met, the percent of times that a participant meets a solution that (s)he has already met, and the percent of times that a participant meets a problem that (s)he has already met;

- The ratio of oversights to resolutions at high hierarchical levels, the ratio of oversights to resolutions at low hierarchical levels, and the ratio of decisions (either by oversight or by resolution) at low hierarchical levels to decisions (either by oversight or by resolution) at high hierarchical levels.

Finally, the following graphs are available:  
- Decisions by oversight, decisions by resolution, flights by postponement and flights by buck-passing at each simulation step;  
- Overall balance between the total ability of participants, the total efficiency of solutions, the product between total ability and average efficiency, and the total difficulty of problems.



## HOW TO USE IT

The population of participants, opportunities, solutions and problems should collectively not exceed 1000 units, unless the simulation space is enlarged. Conversely, at least a few tens of each breed are needed in order to obtain interesting outcomes.

The difficulty of problems should not be too different from the ability of participants multiplied by the efficiency of solutions. Depending on configurations, maximum differences of one or two units are recommended.

With hierarchical or specialized decision structures, availability structures or access structures, the number of decisions and particularly the number of decisions by resolution tends to be small. Thus, it is advisable to run the model with many opportunities, many problems, sufficiently high values of participant ability, sufficiently high values of solution efficiency and sufficiently low values of problem difficulty.



## THINGS TO NOTICE

The most important and most robust conclusion of the Garbage Can model is that most decisions are made by oversight, few problems are solved and flight is widespread. A large number of flights do not cause decision-making. Most, but not all configurations are such that flights that cause decisions by oversight are many more than the flights causing decisions by resolution.

Participants eventually meet the same problems more often that they meet the same opportunities or the same solutions. This can be seen by comparing the indicator "% Deja-vu Problems" with "% Deja-vu Opportunities" and "% Deja-vu Solutions" when participants do not exit the organization after decision-making whereas opportunities, solutions and problems do. 

Another interesting conclusion is that the most important opportunities are less likely to solve problems than the least important opportunities. This can be seen by experimenting with hierarchical decision, availability and access structures. Compare the indicators "Ove/Res" at low and high hierarchical levels.



## THINGS TO TRY

The default values of parameters have been chosen in order to resemble the original model by Cohen, March and Olsen as closely as possible. The user is invited to move away fron default values exploring alternative combinations.

The user can try different combinations of:  
1)  
Population, through the initial number of participants, opportunities, solutions and problems, their flows in or out of the organization and the time when these flows stop;  
2)  
Structures of interaction, through the decision structure and the access structure;  
3)  
Energy endowments, through minimum and maximum values as well as their distribution.



## EXTENDING THE MODEL

This is an agent-based version of the original Garbage Can model. A common criticism of this model is that organizational structures (decision structure, access structure) are not endogenous, which is weird for a model of organizational decision-making. In subsequent variations of the original model, we shall overcome this shortcoming.



## NETLOGO FEATURES

This model was originally developed NetLogo 4.0.4. It has been updated to NetLogo 5.0.4.
A previous version, available under the rubric "User Community Models" with the name "GarbageCan", was developed on NetLogo 2.1.0. Its NetLogo 4.0.4 version is available under the rubric "User Community Models" with the name "GarbageCan_docker"

With respect to the previous version, the following changes have been made:  
- Agents stay always at the center of their patch;  
- Colored patches mark resolutions (green), oversights (sky-blue), blocked decision processes (white), postponed decision problems (brown) and problems passed on to participants (brown);  
- The opportunity to which a problem is eventually attached is not chosen randomly among those involved in a blocked decision process; rather, the least important opportunity is chosen;  
- The possibility of flight by buck-passing is introduced;  
- Flights by postponement and by buck-passing can be disabled, and separately from one another;  
- A bug concerning the movements of opportunities and problems bound to one another has been discovered, and fixed.

This and many other implementations of the Garbage Can Model are available at www.cs.unibo.it/fioretti.



## CREDITS AND REFERENCES

Cohen M.D., March J.G. and Olsen J.P. (1972) A Garbage Can Model of Organizational Choice. Administrative Science Quarterly, 17 (1): 1-25.

Fioretti G. and Lomi A. (2008a) The Garbage Can Model of Organizational Choice: An agent-based reconstruction. Simulation Modelling Practice and Theory, 16 (): 192-217.

Fioretti G. and Lomi A. (2008b) An Agent-Based Representation of the Garbage Can Model of Organizational Choice. Journal of Artificial Societies and Social Simulation, 11. 

This model was built by:  
Guido Fioretti  
University of Bologna
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

ant
true
0
Polygon -7500403 true true 136 61 129 46 144 30 119 45 124 60 114 82 97 37 132 10 93 36 111 84 127 105 172 105 189 84 208 35 171 11 202 35 204 37 186 82 177 60 180 44 159 32 170 44 165 60
Polygon -7500403 true true 150 95 135 103 139 117 125 149 137 180 135 196 150 204 166 195 161 180 174 150 158 116 164 102
Polygon -7500403 true true 149 186 128 197 114 232 134 270 149 282 166 270 185 232 171 195 149 186
Polygon -7500403 true true 225 66 230 107 159 122 161 127 234 111 236 106
Polygon -7500403 true true 78 58 99 116 139 123 137 128 95 119
Polygon -7500403 true true 48 103 90 147 129 147 130 151 86 151
Polygon -7500403 true true 65 224 92 171 134 160 135 164 95 175
Polygon -7500403 true true 235 222 210 170 163 162 161 166 208 174
Polygon -7500403 true true 249 107 211 147 168 147 168 150 213 150

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bee
true
0
Polygon -1184463 true false 151 152 137 77 105 67 89 67 66 74 48 85 36 100 24 116 14 134 0 151 15 167 22 182 40 206 58 220 82 226 105 226 134 222
Polygon -16777216 true false 151 150 149 128 149 114 155 98 178 80 197 80 217 81 233 95 242 117 246 141 247 151 245 177 234 195 218 207 206 211 184 211 161 204 151 189 148 171
Polygon -7500403 true true 246 151 241 119 240 96 250 81 261 78 275 87 282 103 277 115 287 121 299 150 286 180 277 189 283 197 281 210 270 222 256 222 243 212 242 192
Polygon -16777216 true false 115 70 129 74 128 223 114 224
Polygon -16777216 true false 89 67 74 71 74 224 89 225 89 67
Polygon -16777216 true false 43 91 31 106 31 195 45 211
Line -1 false 200 144 213 70
Line -1 false 213 70 213 45
Line -1 false 214 45 203 26
Line -1 false 204 26 185 22
Line -1 false 185 22 170 25
Line -1 false 169 26 159 37
Line -1 false 159 37 156 55
Line -1 false 157 55 199 143
Line -1 false 200 141 162 227
Line -1 false 162 227 163 241
Line -1 false 163 241 171 249
Line -1 false 171 249 190 254
Line -1 false 192 253 203 248
Line -1 false 205 249 218 235
Line -1 false 218 235 200 144

bird1
false
0
Polygon -7500403 true true 2 6 2 39 270 298 297 298 299 271 187 160 279 75 276 22 100 67 31 0

bird2
false
0
Polygon -7500403 true true 2 4 33 4 298 270 298 298 272 298 155 184 117 289 61 295 61 105 0 43

boat1
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 33 230 157 182 150 169 151 157 156
Polygon -7500403 true true 149 55 88 143 103 139 111 136 117 139 126 145 130 147 139 147 146 146 149 55

boat2
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 157 54 175 79 174 96 185 102 178 112 194 124 196 131 190 139 192 146 211 151 216 154 157 154
Polygon -7500403 true true 150 74 146 91 139 99 143 114 141 123 137 126 131 129 132 139 142 136 126 142 119 147 148 147

boat3
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 37 172 45 188 59 202 79 217 109 220 130 218 147 204 156 158 156 161 142 170 123 170 102 169 88 165 62
Polygon -7500403 true true 149 66 142 78 139 96 141 111 146 139 148 147 110 147 113 131 118 106 126 71

butterfly1
true
0
Polygon -16777216 true false 151 76 138 91 138 284 150 296 162 286 162 91
Polygon -7500403 true true 164 106 184 79 205 61 236 48 259 53 279 86 287 119 289 158 278 177 256 182 164 181
Polygon -7500403 true true 136 110 119 82 110 71 85 61 59 48 36 56 17 88 6 115 2 147 15 178 134 178
Polygon -7500403 true true 46 181 28 227 50 255 77 273 112 283 135 274 135 180
Polygon -7500403 true true 165 185 254 184 272 224 255 251 236 267 191 283 164 276
Line -7500403 true 167 47 159 82
Line -7500403 true 136 47 145 81
Circle -7500403 true true 165 45 8
Circle -7500403 true true 134 45 6
Circle -7500403 true true 133 44 7
Circle -7500403 true true 133 43 8

circle
false
0
Circle -7500403 true true 34 34 230

opportunity
true
0
Rectangle -955883 true false 46 47 255 255

participant
true
0
Circle -1184463 true false 125 5 63
Rectangle -1184463 true false 120 90 195 225
Polygon -1184463 true false 120 90 30 150 45 180 113 139 120 140
Polygon -1184463 true false 195 90 285 150 270 180 185 137
Polygon -1184463 true false 120 225 100 309 138 309 150 195
Polygon -1184463 true false 165 195 180 308 212 308 180 180
Rectangle -1184463 true false 150 30 165 120

problem
true
0
Polygon -8630108 true false 149 1 31 239 271 239

solution
true
0
Circle -2674135 true false 75 73 151
Circle -2674135 true false 11 12 273

spacecraft
true
0
Polygon -7500403 true true 150 0 180 135 255 255 225 240 150 180 75 240 45 255 120 135

thin-arrow
true
0
Polygon -7500403 true true 150 0 0 150 120 150 120 293 180 293 180 150 300 150

truck-down
false
0
Polygon -7500403 true true 225 30 225 270 120 270 105 210 60 180 45 30 105 60 105 30
Polygon -8630108 true false 195 75 195 120 240 120 240 75
Polygon -8630108 true false 195 225 195 180 240 180 240 225

truck-left
false
0
Polygon -7500403 true true 120 135 225 135 225 210 75 210 75 165 105 165
Polygon -8630108 true false 90 210 105 225 120 210
Polygon -8630108 true false 180 210 195 225 210 210

truck-right
false
0
Polygon -7500403 true true 180 135 75 135 75 210 225 210 225 165 195 165
Polygon -8630108 true false 210 210 195 225 180 210
Polygon -8630108 true false 120 210 105 225 90 210

turtle
true
0
Polygon -7500403 true true 138 75 162 75 165 105 225 105 225 142 195 135 195 187 225 195 225 225 195 217 195 202 105 202 105 217 75 225 75 195 105 187 105 135 75 142 75 105 135 105

wolf-left
false
3
Polygon -6459832 true true 117 97 91 74 66 74 60 85 36 85 38 92 44 97 62 97 81 117 84 134 92 147 109 152 136 144 174 144 174 103 143 103 134 97
Polygon -6459832 true true 87 80 79 55 76 79
Polygon -6459832 true true 81 75 70 58 73 82
Polygon -6459832 true true 99 131 76 152 76 163 96 182 104 182 109 173 102 167 99 173 87 159 104 140
Polygon -6459832 true true 107 138 107 186 98 190 99 196 112 196 115 190
Polygon -6459832 true true 116 140 114 189 105 137
Rectangle -6459832 true true 109 150 114 192
Rectangle -6459832 true true 111 143 116 191
Polygon -6459832 true true 168 106 184 98 205 98 218 115 218 137 186 164 196 176 195 194 178 195 178 183 188 183 169 164 173 144
Polygon -6459832 true true 207 140 200 163 206 175 207 192 193 189 192 177 198 176 185 150
Polygon -6459832 true true 214 134 203 168 192 148
Polygon -6459832 true true 204 151 203 176 193 148
Polygon -6459832 true true 207 103 221 98 236 101 243 115 243 128 256 142 239 143 233 133 225 115 214 114

wolf-right
false
3
Polygon -6459832 true true 170 127 200 93 231 93 237 103 262 103 261 113 253 119 231 119 215 143 213 160 208 173 189 187 169 190 154 190 126 180 106 171 72 171 73 126 122 126 144 123 159 123
Polygon -6459832 true true 201 99 214 69 215 99
Polygon -6459832 true true 207 98 223 71 220 101
Polygon -6459832 true true 184 172 189 234 203 238 203 246 187 247 180 239 171 180
Polygon -6459832 true true 197 174 204 220 218 224 219 234 201 232 195 225 179 179
Polygon -6459832 true true 78 167 95 187 95 208 79 220 92 234 98 235 100 249 81 246 76 241 61 212 65 195 52 170 45 150 44 128 55 121 69 121 81 135
Polygon -6459832 true true 48 143 58 141
Polygon -6459832 true true 46 136 68 137
Polygon -6459832 true true 45 129 35 142 37 159 53 192 47 210 62 238 80 237
Line -16777216 false 74 237 59 213
Line -16777216 false 59 213 59 212
Line -16777216 false 58 211 67 192
Polygon -6459832 true true 38 138 66 149
Polygon -6459832 true true 46 128 33 120 21 118 11 123 3 138 5 160 13 178 9 192 0 199 20 196 25 179 24 161 25 148 45 140
Polygon -6459832 true true 67 122 96 126 63 144

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="anarchy-random" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>ave-free-participants</metric>
    <metric>ave-free-opportunities</metric>
    <metric>ave-free-solutions</metric>
    <metric>ave-free-problems</metric>
    <metric>num-oversight</metric>
    <metric>num-resolution</metric>
    <metric>num-blocked-oversight</metric>
    <metric>num-blocked-resolution</metric>
    <metric>num-postponement</metric>
    <metric>num-buck-passing</metric>
    <metric>ave-num-blocked</metric>
    <metric>ave-num-postponed</metric>
    <metric>ave-num-passed</metric>
    <metric>ave-size-blocked</metric>
    <metric>ave-life-blocked</metric>
    <metric>ave-life-postponed</metric>
    <metric>ave-life-passed</metric>
    <metric>meetings-known-opp</metric>
    <metric>meetings-opp</metric>
    <metric>meetings-known-sol</metric>
    <metric>meetings-sol</metric>
    <metric>meetings-known-pro</metric>
    <metric>meetings-pro</metric>
    <enumeratedValueSet variable="stop-at">
      <value value="5000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-details?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-participants">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="participants-exit?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-participants?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-opportunities">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="opportunities-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-opportunities?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-solutions">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="solutions-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-solutions?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-problems">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="problems-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-problems?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="postpone?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="buckpass?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decision-structure">
      <value value="&quot;anarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="availability-structure">
      <value value="&quot;anarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="access-structure">
      <value value="&quot;anarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-ability">
      <value value="&quot;random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-ability">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-ability">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-efficiency">
      <value value="&quot;random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-efficiency">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-efficiency">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-difficulty">
      <value value="&quot;random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-difficulty">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-difficulty">
      <value value="10"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="hierarchy-competence" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>ave-free-participants</metric>
    <metric>ave-free-opportunities</metric>
    <metric>ave-free-solutions</metric>
    <metric>ave-free-problems</metric>
    <metric>num-oversight</metric>
    <metric>num-resolution</metric>
    <metric>num-blocked-oversight</metric>
    <metric>num-blocked-resolution</metric>
    <metric>num-postponement</metric>
    <metric>num-buck-passing</metric>
    <metric>ave-num-blocked</metric>
    <metric>ave-num-postponed</metric>
    <metric>ave-num-passed</metric>
    <metric>ave-size-blocked</metric>
    <metric>ave-life-blocked</metric>
    <metric>ave-life-postponed</metric>
    <metric>ave-life-passed</metric>
    <metric>meetings-known-opp</metric>
    <metric>meetings-opp</metric>
    <metric>meetings-known-sol</metric>
    <metric>meetings-sol</metric>
    <metric>meetings-known-pro</metric>
    <metric>meetings-pro</metric>
    <metric>countOveHigh</metric>
    <metric>countResHigh</metric>
    <metric>countOveLow</metric>
    <metric>countResLow</metric>
    <enumeratedValueSet variable="stop-at">
      <value value="5000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-details?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-participants">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="participants-exit?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-participants?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-opportunities">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="opportunities-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-opportunities?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-solutions">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="solutions-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-solutions?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-problems">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="problems-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-problems?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="postpone?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="buckpass?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decision-structure">
      <value value="&quot;hierarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="availability-structure">
      <value value="&quot;hierarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="access-structure">
      <value value="&quot;hierarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-ability">
      <value value="&quot;competence&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-ability">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-ability">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-efficiency">
      <value value="&quot;competence&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-efficiency">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-efficiency">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-difficulty">
      <value value="&quot;competence&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-difficulty">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-difficulty">
      <value value="10"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="hierarchy-incompetence" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>ave-free-participants</metric>
    <metric>ave-free-opportunities</metric>
    <metric>ave-free-solutions</metric>
    <metric>ave-free-problems</metric>
    <metric>num-oversight</metric>
    <metric>num-resolution</metric>
    <metric>num-blocked-oversight</metric>
    <metric>num-blocked-resolution</metric>
    <metric>num-postponement</metric>
    <metric>num-buck-passing</metric>
    <metric>ave-num-blocked</metric>
    <metric>ave-num-postponed</metric>
    <metric>ave-num-passed</metric>
    <metric>ave-size-blocked</metric>
    <metric>ave-life-blocked</metric>
    <metric>ave-life-postponed</metric>
    <metric>ave-life-passed</metric>
    <metric>meetings-known-opp</metric>
    <metric>meetings-opp</metric>
    <metric>meetings-known-sol</metric>
    <metric>meetings-sol</metric>
    <metric>meetings-known-pro</metric>
    <metric>meetings-pro</metric>
    <metric>countOveHigh</metric>
    <metric>countResHigh</metric>
    <metric>countOveLow</metric>
    <metric>countResLow</metric>
    <enumeratedValueSet variable="stop-at">
      <value value="5000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-details?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-participants">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="participants-exit?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-participants?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-opportunities">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="opportunities-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-opportunities?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-solutions">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="solutions-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-solutions?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-problems">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="problems-exit?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replace-problems?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="postpone?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="buckpass?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decision-structure">
      <value value="&quot;hierarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="availability-structure">
      <value value="&quot;hierarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="access-structure">
      <value value="&quot;hierarchy&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-ability">
      <value value="&quot;incompetence&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-ability">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-ability">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-efficiency">
      <value value="&quot;incompetence&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-efficiency">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-efficiency">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dist-difficulty">
      <value value="&quot;incompetence&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-difficulty">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-difficulty">
      <value value="10"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
