globals [patch-data countries donors new-volunteers new-bribees new-exits weightedavgnd-gain gross-bribe enthusiast-left]

patches-own [enthusiast member benefit payoff emissions emissions-r gdp gdp-r nd-gain vulnerability mdc population WTA WTB WTB/WTA WTB-WTA bribe]

to setup
  ca
  reset-ticks
  resize-world 0 14 0 9
  use-data
  set countries patches with [emissions-r > 0]                                                                        ; ignores the patches with negative emissions, and empty patches.
  ask patches with [emissions-r <= 0][set pcolor white]
  set-enthusiasm
  
  ask countries [
    set gdp gdp-r / sum [gdp-r] of countries                                                                          ; these are adjusted values so that they sum to one. gdp-r sums to .98 due to missing data
    set emissions emissions-r / sum [emissions-r] of countries
  ]
  
  who-pays
  set-damage-costs  
  
  ask countries with [enthusiast = 1][
    set member 1 
    set pcolor green
  ]
  ask countries with [enthusiast = 0] [
    set member 0
    ]
end


to use-data
file-open "Output_GCP.txt"                                                                                              ; THIS DATA FILE MUST BE STORED IN THE SAME FOLDER AS THE MODEL
set patch-data []
while [not file-at-end?]
[
 set patch-data sentence patch-data (list (list file-read file-read file-read file-read file-read file-read file-read))
]
file-close
foreach patch-data [ask patch first ? item 1 ? [set plabel item 2 ? set emissions-r item 3 ? set gdp-r item 4 ? set nd-gain item 5 ? set population item 6 ?]]
end

to set-damage-costs
  ifelse vulnerability-index = true [
  set weightedavgnd-gain (sum [nd-gain * (gdp / mean [gdp] of countries)] of countries) / count countries               ; this calculates the nd-gain avg weighted by gdp for use below
  
  ask countries[                                                                                                        ; this calculates vulnerability and mdc so that global damages sum to globalMDC. based on above avg nd-gain which is weighed by gdp
    set vulnerability (nd-gain + (vulnerability-weight - 1) * (nd-gain - weightedavgnd-gain)) /  weightedavgnd-gain 
    set mdc globalMDC * vulnerability
  ]
  ][
  ask countries [
    set mdc globalMDC
  ] 
  ]
end


to who-pays                                                                                                             ; determinse whether only enthusiasts or all members can contribute to side-payments
  ifelse only-enthusiasts-pay = false[
     set donors countries
  ][
     set donors countries with [enthusiast = 1]
  ]
end


to go                                                                                                                   ; THE OVERARCHING PROCEDURE. BELOW ARE SUB-PROCEDURES.
  tick
  if count countries with [member = 0] > 0 [ 
    join-or-leave                                                                                                       ; this loops until no more volunteers want to join (volunteering is rare in this model)
  ]
  if new-volunteers = 0 and count countries with [member = 1] > 0 and side-payment = true [                             ; each negotiation stage is a tick. side payments will only be offered when no more states want to join voluntarily
    side-payments  
    ]
  if new-volunteers = 0 and new-bribees = 0 [                                                                           ; once no more countries can be bribed into the club, enthusiasts consider leaving
    enthusiasts-leave
  ]
  ask countries [
    calculate-payoff
  ]
end


to join-or-leave                                                                                                        ; This procedure checks whether anyone has incentive for unilater action (rarely the case)
  set new-volunteers 0                                                                                                  ; this is a counter to determine when to enter next stage
  ask countries with [member = 0][
    calculate-benefit
    ]
  
  ask max-one-of countries with [member = 0][benefit - 1][
    if benefit > 1[                                                                                                     ; measured in % of gdp
      set member 1 set pcolor blue
      set new-volunteers new-volunteers + 1
      ]
  ]
  end

to side-payments                                                                                                        ;This is the side-payment procecure
    set new-bribees 0
  if count countries with [member = 0 ] = 0 [stop]
  ask countries with [member = 0][                                                                                      ; it is repeated for every non-member in random order
    calculate-benefit
    set WTA (1 - benefit) * gdp                                                                                         ; WTA is compensation needed to join, measured in aboslute terms (% of ggp)
    calculate-WTB                                                                                                       ; this calls a sub-procedure that calculates each potential donor's benefit if a given non-member joins.
    ifelse equity = false[                                                                                              ; the procedure differs depending on whether the "equity" option is chosen
      set WTB/WTA sum [WTB * gdp] of donors with [member = 1] / WTA                                                     ; ratio between club WTB and entrant WTA. can be moved to ask max-one-of to speed up the model
      set WTB-WTA sum [WTB * gdp] of donors with [member = 1] - WTA                                                     ; difference between WTA and club WTB, measured in % of ggp
      ][
      set WTB/WTA sum [WTB * gdp] of donors with [member = 1 and (gdp / population) > [gdp / population] of myself] / WTA
      set WTB-WTA sum [WTB * gdp] of donors with [member = 1 and (gdp / population) > [gdp / population] of myself] - WTA
      ] 
  ] 
  
  ask donors [set WTB 0]                                                                                                ; reset needed for technical reasons
  
  ask max-one-of countries with [member = 0] [WTB-WTA][                                                                  ; the entrant giving the largest net benefits enters first
    if WTB/WTA > 1 [                                                                                                     ; it will only enter if both it and the club can benefit from it. this could be expressed in terms of WTB-WTA too.
      calculate-WTB
      ifelse equity = false [                                                                                            ; the procedure differs depending on whether the "equity" option is chosen
        ask donors with [member = 1][
          set bribe bribe - WTB * gdp / [WTB/WTA] of myself                                                              ; donors share the cost according to their benefit from expansion (See Barrett 2001)
        ]                                                                                                                ; "bribe" is negative for those who pay. It measures accumulated bribes, in absolute terms (% of GGP)
         ][
        let members-richer-than-entrant donors with [member = 1 and (gdp / population) > [gdp / population] of myself]   ; if "equity" is on, only the members richer than the entrant share the cost
        ask members-richer-than-entrant[
          set bribe bribe - WTB * gdp / [WTB/WTA] of myself                                                             
        ]                                                                                                                ; end most likely entrant asks members
        ]
      set member 1
      set pcolor orange
      set bribe bribe + WTA                                                                                              ; "bribe" is negative for those who pay. It measures accumulated bribes, in absolute terms (% of GGP)
      print WTA * 755.9                                                                                                  ; to convert from % of GGP to US$, multiply by 755.9, as GGP 2013 in current US$  was 75.59 trillion (worldbank.org)
      set gross-bribe gross-bribe + WTA * 755.9                                                                          ; this is a checker
      set new-bribees new-bribees + 1
    ]
  ]                                                                                                                      ; end if pareto improvements are possible
  ask countries with [bribe < 0]                                                                                         ; actors who make net side-payments have their names displayed in black
     [set plabel-color 0]       
end


to enthusiasts-leave
     ask countries with [enthusiast = 1][
      calculate-payoff
      if payoff < (- mdc) [                                                                                              ; payoff in the non cooperative outcome
           set member 0
           set pcolor grey
           set enthusiast 0
           set enthusiast-left 1                                                                                         ; enthusiasts leave the club
           ]
         ]
      ask countries with [pcolor = orange][
      calculate-benefit
      if benefit < 1 [ 
          set pcolor red                                                                                                 ; those who require continous bribes are red
      ]
    ]
    if enthusiast-left = 1 [                                                                                             ; if enthusiasts leave, those who no longer benefit, leave too. New negotiations will start if there are remaining enthusiasts.
       ask countries with [member = 1 and enthusiast = 0] [ 
          calculate-benefit
          if benefit < 1 [
            set member 0
            set pcolor black                                                                                             
        ]
        ]
       set enthusiast-left 0
       ask countries [set bribe 0]                                                                                       ; bribe is reset to allow new negotiations to start.
    ]
end


to calculate-benefit                                                                                                     ; benefit is measured in % of gdp
    set benefit mdc * emissions
      end

to calculate-WTB                                                                                                         ; WTB is measured in % of gdp, so must often be multiplied by gdp when used 
  ask donors with [member = 1][                                                                                          ; the potential entrant asks members
      set WTB mdc * [emissions] of myself
      ]
 end


to calculate-payoff                                                                                                      ; measured in % of gdp. Payoff is normalized to be (- Damage cost) in the BAU, and (-Club fee) if all countries are club members.
  ifelse member = 1[
      set payoff  (- 1) - mdc * (sum [emissions] of countries with [member = 0]) + bribe / gdp][                         ; payoff for members
      set payoff  (- mdc) * sum [emissions] of countries with [member = 0]                                               ; payoff for non-members
        ]
 end


to set-enthusiasm
  ask patches with [plabel = "China"][set enthusiast china-enthusiast]
  ask patches with [plabel = "United States"][set enthusiast usa-enthusiast]
  ask patches with [plabel = "European Union"][set enthusiast eu-enthusiast]
  ask patches with [plabel = "Russian Federation"][set enthusiast russia-enthusiast]
  ask patches with [plabel = "India"][set enthusiast india-enthusiast]
  ask patches with [plabel = "Brazil"][set enthusiast brazil-enthusiast]
  ask patches with [plabel = "Japan"][set enthusiast japan-enthusiast]
  ask patches with [plabel = "Indonesia"][set enthusiast indonesia-enthusiast]
  ask patches with [plabel = "Australia"][set enthusiast australia-enthusiast]
  ask patches with [plabel = "Iran, Islamic Rep."][set enthusiast iran-enthusiast]
  ask patches with [plabel = "Canada"][set enthusiast canada-enthusiast]
  ask patches with [plabel = "Mexico"][set enthusiast mexico-enthusiast]
  ask patches with [plabel = "Korea, Rep."][set enthusiast korea-enthusiast]
  ask patches with [plabel = "South Africa"][set enthusiast sa-enthusiast]
 end
@#$#@#$#@
GRAPHICS-WINDOW
252
10
1567
911
-1
-1
87.0
1
10
1
1
1
0
1
1
1
0
14
0
9
0
0
1
ticks
30.0

INPUTBOX
189
789
254
849
max-x
14
1
0
Number

INPUTBOX
189
851
251
911
max-y
9
1
0
Number

BUTTON
65
10
128
43
step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
3
10
66
43
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
-5
185
71
245
globalMDC
3
1
0
Number

CHOOSER
3
449
98
494
china-enthusiast
china-enthusiast
0 1
1

CHOOSER
4
492
96
537
usa-enthusiast
usa-enthusiast
0 1
1

CHOOSER
3
534
95
579
eu-enthusiast
eu-enthusiast
0 1
0

CHOOSER
8
581
100
626
russia-enthusiast
russia-enthusiast
0 1
0

CHOOSER
9
628
101
673
india-enthusiast
india-enthusiast
0 1
0

CHOOSER
7
673
145
718
brazil-enthusiast
brazil-enthusiast
0 1
0

CHOOSER
9
719
147
764
japan-enthusiast
japan-enthusiast
0 1
0

CHOOSER
11
764
150
809
indonesia-enthusiast
indonesia-enthusiast
0 1
0

CHOOSER
14
810
152
855
australia-enthusiast
australia-enthusiast
0 1
0

CHOOSER
13
856
151
901
iran-enthusiast
iran-enthusiast
0 1
0

MONITOR
3
43
66
88
Members
count patches with [member = 1]
0
1
11

MONITOR
66
45
179
90
Emissions covered
sum [emissions] of patches with [member = 1]
3
1
11

SWITCH
-5
309
131
342
side-payment
side-payment
0
1
-1000

CHOOSER
99
446
237
491
canada-enthusiast
canada-enthusiast
0 1
0

CHOOSER
97
494
235
539
mexico-enthusiast
mexico-enthusiast
0 1
0

CHOOSER
97
541
235
586
korea-enthusiast
korea-enthusiast
0 1
0

CHOOSER
101
585
239
630
sa-enthusiast
sa-enthusiast
0 1
0

SWITCH
-5
245
152
278
vulnerability-index
vulnerability-index
0
1
-1000

INPUTBOX
71
185
179
245
vulnerability-weight
1
1
0
Number

SWITCH
-1
376
89
409
equity
equity
0
1
-1000

PLOT
1341
10
1568
207
Coverage
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "if ticks > 0 [plot sum [emissions] of patches with [member = 1]]"

BUTTON
121
10
184
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
-1
343
171
376
only-enthusiasts-pay
only-enthusiasts-pay
1
1
-1000

MONITOR
0
135
158
180
Bribes % enthusiasts' GDP
abs sum [bribe] of countries with [enthusiast = 1] / sum [gdp] of countries with [enthusiast = 1]
2
1
11

MONITOR
1
87
120
132
Gross bribe $ billion
gross-bribe
0
1
11

MONITOR
119
87
227
132
Net bribe $ billion
sum [abs bribe] of patches / 2 * 755.90
0
1
11

@#$#@#$#@
## WHAT IS IT?
For a description of the model, see manuscript entitled: Side-payments: An effective instrument for building climate clubs? and the accompanying technical appendix.

The input data file "Output_GCP.txt" must be stored in the same folder as the model.

The agents in the model are patches, which represent countries. Enthusiasts are green, non-members are black, and members that received a side-payment to enter are red. Countries whose names are written in black make net side-payments out. Which countries are enthusiasts is chosen in the Interface.

PATCHES-OWN
Emissions and GDP are shares of the global totals. Emissions-r and gdp-r are the the empirical data entered. Due to missing data, these sum to .97 and .98. The attributes gdp and emissions sum to 1.

Damage costs, abatement costs, club benefits, and payoff are measured in percentage of own gdp.

Bribes are measured as a percentage of ggp. Remember to divide by gdp to obtain a country's expenditure.

Damage costs and club benefits are assumed to be proportional to GDP.
Damage costs are a function of the emissions of non-members
Abatement costs are set to 1% of gdp for all.

CALCULATING INDIVIDUAL VULNERABILITIES AND DAMAGE COSTS
When vulnerability-index is on, damage costs are differentiated based on nd-gain scores. Global damages always sum to globalMDC. When vulnerability-weight is 1, vulnerability is a country's nd-gain score as a share of the gdp-weigthed average nd-gain score. If the weight is 2, the difference is doubled, so that a score of 1.1 becomes 1.2. Some countries might get negative mdc, e.g., Norway when the weight is 4. Should probably avoid such values, or check that the model can handle negative mdc. When weight is 1, the EU followed by the USA have the largest absolute damages. With weight 2, it is China.

SIDE-PAYMENTS
Costs of side payments are distributed according to wtp, i.e., so it's a function of vulnerability and gdp. See Barrett 2001. (unless cost-sharing-gdp is chosen).

-Option 'equity' allows side payments only where the recipient has lower gdp/capita than the donor.
-Option "only-enthusiasts-pay" specifies that only enthusiasts share the cost of side-payments.


## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="isa01" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <exitCondition>ticks = 20</exitCondition>
    <metric>sum [emissions] of patches with [member = 1]</metric>
    <metric>sum [abs bribe] of patches / 2</metric>
    <metric>[pcolor] of patch 0 0</metric>
    <metric>[pcolor] of patch 0 1</metric>
    <metric>[pcolor] of patch 0 2</metric>
    <metric>[pcolor] of patch 0 3</metric>
    <metric>[pcolor] of patch 0 4</metric>
    <metric>[pcolor] of patch 0 5</metric>
    <metric>[pcolor] of patch 0 6</metric>
    <metric>[pcolor] of patch 0 7</metric>
    <metric>[pcolor] of patch 0 8</metric>
    <metric>[pcolor] of patch 0 9</metric>
    <metric>[pcolor] of patch 1 0</metric>
    <metric>[pcolor] of patch 1 1</metric>
    <metric>[pcolor] of patch 1 2</metric>
    <metric>[pcolor] of patch 1 3</metric>
    <metric>[pcolor] of patch 1 4</metric>
    <metric>count row with [pcolor = black]</metric>
    <metric>count row with [pcolor = red]</metric>
    <metric>count row with [pcolor = orange]</metric>
    <metric>count row with [pcolor = blue]</metric>
    <enumeratedValueSet variable="random-seed">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="row-enthusiasts">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="usa-enthusiast">
      <value value="0"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-y">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-x">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="st-dev-intensity">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="eu-enthusiast">
      <value value="0"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="CBscale">
      <value value="0"/>
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="side-payment">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="china-enthusiast">
      <value value="0"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="indonesia-enthusiast">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="globalMDC">
      <value value="3"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
