globals [peopleShapes averageNumberLinksActual averagePContact averagePMask infectionRate networkSpaceColor roomColor ]

breed [people person]

people-own [infected infectedTime immune recoveredTime pContactPerLink pMask pCheck lastInfectionRate schedule testDate quarantined?]

patches-own [load spaceID airTurnover physical? masked?]

to setup
  clear-all
  reset-ticks

  set peopleShapes  ["person business" "person doctor" "person farmer" "person graduate" "person lumberjack"
  "person police" "person service" "person soldier" "person student"]

  set networkSpaceColor 3
  set roomColor 93

  set classCap 10

  ;;initialize patches
  ask patches [set load 0 set spaceID "N/A" set airTurnover 0 set physical? false]

   ;; set up the space
  ask patches with [pxcor < 0] [set spaceID "network" set pcolor networkSpaceColor]
  make-room 2 2 15 15 fracAirTurnover false "dining hall"
  make-room 18 2 5 10 fracAirTurnover true "class 1"
  make-room 24 2 5 10 fracAirTurnover true "class 2"
  make-room 18 20 5 10 fracAirTurnover true "class 3"
  make-room 24 20 5 10 fracAirTurnover true "class 4"
  make-room 2 20 5 10 fracAirTurnover true "class 5"
  make-room 8 20 5 10 fracAirTurnover true "class 6"


  ;;make default schedule (currently in 12 parts - 2h)
  let defaultSchedule (list "network" "network" "network" "network" "network" "network" "network" "network" "network" "network" "network" "network")

  create-people numberPeople [

    go-to-space "network"
    set color green
    set infected false
    set immune false
    set quarantined? false
    set testDate 0

    set pContactPerLink max list 0 random-normal pContactPerLinkPerDay_Mean pContactPerLink_SD
    set pCheck max list 0 random-normal pCheck_mean pCheck_SD

    set lastInfectionRate 0

    set pMask max list 0 random-normal pMask_Initial_Mean pMask_Initial_SD

    set schedule defaultSchedule

    ;;add mealtime to schedule
    if groupLunch? [
      let lunchDraw random-float 1
      if-else lunchDraw < 0.3 [set schedule replace-item 5 schedule "dining hall"] [
        if-else lunchDraw < 0.6 [set schedule replace-item 6 schedule "dining hall"] [
          set schedule replace-item 7 schedule "dining hall"]
      ]
    ]


    ;;assign a shape randomly
    set shape one-of peopleShapes
  ]

  ;;make schedules
  ask n-of classCap people with [item 4 schedule = "network"] [set schedule replace-item 4 schedule "class 1"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 5 schedule "class 1"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 6 schedule "class 1"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 7 schedule "class 1"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 8 schedule "class 1"]
  ask n-of classCap people with [item 9 schedule = "network"] [set schedule replace-item 9 schedule "class 1"]
  ask n-of classCap people with [item 10 schedule = "network"] [set schedule replace-item 10 schedule "class 1"]

  ask n-of classCap people with [item 4 schedule = "network"] [set schedule replace-item 4 schedule "class 2"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 5 schedule "class 2"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 6 schedule "class 2"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 7 schedule "class 2"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 8 schedule "class 2"]
  ask n-of classCap people with [item 9 schedule = "network"] [set schedule replace-item 9 schedule "class 2"]
  ask n-of classCap people with [item 10 schedule = "network"] [set schedule replace-item 10 schedule "class 2"]

  ask n-of classCap people with [item 4 schedule = "network"] [set schedule replace-item 4 schedule "class 3"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 5 schedule "class 3"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 6 schedule "class 3"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 7 schedule "class 3"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 8 schedule "class 3"]
  ask n-of classCap people with [item 9 schedule = "network"] [set schedule replace-item 9 schedule "class 3"]
  ask n-of classCap people with [item 10 schedule = "network"] [set schedule replace-item 10 schedule "class 3"]

  ask n-of classCap people with [item 4 schedule = "network"] [set schedule replace-item 4 schedule "class 4"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 5 schedule "class 4"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 6 schedule "class 4"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 7 schedule "class 4"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 8 schedule "class 4"]
  ask n-of classCap people with [item 9 schedule = "network"] [set schedule replace-item 9 schedule "class 4"]
  ask n-of classCap people with [item 10 schedule = "network"] [set schedule replace-item 10 schedule "class 4"]

  ask n-of classCap people with [item 4 schedule = "network"] [set schedule replace-item 4 schedule "class 5"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 5 schedule "class 5"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 6 schedule "class 5"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 7 schedule "class 5"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 8 schedule "class 5"]
  ask n-of classCap people with [item 9 schedule = "network"] [set schedule replace-item 9 schedule "class 5"]
  ask n-of classCap people with [item 10 schedule = "network"] [set schedule replace-item 10 schedule "class 5"]

  ask n-of classCap people with [item 4 schedule = "network"] [set schedule replace-item 4 schedule "class 6"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 5 schedule "class 6"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 6 schedule "class 6"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 7 schedule "class 6"]
  ask n-of classCap people with [item 8 schedule = "network"] [set schedule replace-item 8 schedule "class 6"]
  ask n-of classCap people with [item 9 schedule = "network"] [set schedule replace-item 9 schedule "class 6"]
  ask n-of classCap people with [item 10 schedule = "network"] [set schedule replace-item 10 schedule "class 6"]



  ;;inital infections
  ask n-of initialInfections people [
    set infected true
    set infectedTime ticks
  ]

  ;;create social network links
  let numLinks averageLinksPerAgent * numberPeople / 2
  while [numLinks > 0] [

    ask one-of people [create-link-with one-of other people]
    set numLinks numLinks - 1
  ]


  ;; update global variables
  update-globals

end


to go


   ask links [
      if (any? both-ends with [infected = true]) and (count both-ends with [quarantined? = false] = 2) and (count both-ends with [physical? = false] = 2) [
        let currentPContact [pContactPerLink] of one-of both-ends * (timeStep / 24) ;;
        let currentPMasks [pMask] of both-ends
        let currentPInfection pInfectionPerContact
        if random-float 1 < item 0 currentPMasks [set currentPInfection currentPInfection / riskReductionFactor_mask ]
        if random-float 1 < item 1 currentPMasks [set currentPInfection currentPInfection / riskReductionFactor_mask ]
        if random-float 1 < currentPInfection * currentPContact [
          ask both-ends [
          if not immune and not infected [set infected true set infectedTime ticks]
          ]
        ]
      ]
    ]

    let numContacts numberRandomContactsPerStep
    while [numContacts > 0] [

      let currentPair n-of 2 people

      if any? currentPair with [infected = true] and (count currentPair with [quarantined? = false] = 2)  and (count currentPair with [physical? = false] = 2) [

        let currentPMasks [pMask] of currentPair
        let currentPInfection pInfectionPerContact
        if random-float 1 < item 0 currentPMasks [set currentPInfection currentPInfection / riskReductionFactor_mask ]
        if random-float 1 < item 1 currentPMasks [set currentPInfection currentPInfection / riskReductionFactor_mask ]

        if random-float 1 < currentPInfection  [
          ask currentPair [
            if not immune and not infected [set infected true set infectedTime ticks]
          ]
        ]

      ]

     set numContacts numContacts - 1
    ]


  ask people [


    ;; move people if they are in the wrong place for this time
    let localTime ticks mod (24 / timeStep)
    set  localTime floor localTime / (24 / timeStep / length schedule)

    if quarantined? = false and [spaceID] of patch-here != item localTime schedule [
      go-to-space item localTime schedule
    ]

    if [physical?] of patch-here = true [
      ;;let people move
      let currentRoom [spaceID] of patch-here
      if random-float 1 < probTurn [facexy [pxcor] of one-of patches with [spaceID = currentRoom] [pxcor] of one-of patches with [spaceID = currentRoom]]
      forward speed

      ;;drop viral load if infected]
      let factor 1
      if infected [
        ask patch-here [
          if masked? = true [set factor factor / riskReductionFactor_mask]
          set load load + viralLoad / factor]]

      ;;test if newly infected
      if (not immune and not infected and random-float 1 < pInfectionPerLoad / factor * load ) [
        set infected true
        set infectedTime ticks
      ]
    ]

    ;;test if died
    if (infected and random-float 1 < caseMortalityRate / (recoveryTimeFromInfection_Days * (24 / timeStep)) ) [

      let currentAgentSet self
      let currentDegrees degreesConsidered
      let currentBump pMaskBump_die
      while [currentDegrees > 0] [
        ask currentAgentSet [
          ask out-link-neighbors [set pMask pMask + currentBump]
        ]
        set currentBump currentBump * (1 - pMaskBumpDecay_degree)
        set currentAgentSet out-link-neighbors
        set currentDegrees currentDegrees - 1
      ]

      die
    ]

    ;;check if recovered
    if (infected and ticks - infectedTime > recoveryTimeFromInfection_Days * (24 / timeStep) ) [
      set infected false
      set immune true
      set recoveredTime ticks
    ]


    ;; test if immunity lost
    if (immune and ticks - recoveredTime > immunityTime_Days * (24 / timeStep) ) [
     set immune false
    ]

    ;;update agent color based on infection
    if infected [set color red]
    if not infected [set color green]
    if immune [set color blue]

    ;;update other visualization parameters
    if seeNetwork? = true [ ask links [set hidden? false]]
    if seeNetwork? = false [ ask links [set hidden? true]]


    ;;update individual parameters
    set pMask pMask * (1 - pMask_decay)
    if random-float 1 < pCheck [
      if infectionRate > lastInfectionRate [
        set pMask pMask + pMaskBump_rise
      ]
      set lastInfectionRate infectionRate
    ]
  ]


  ;;run testing program once per day
  if ticks mod (24 / timeStep) = 0 [
    ask up-to-n-of testingCapacityPerDay people with [testDate < ticks] [
      ifelse infected = true [set quarantined? true go-to-space "network"  ] [set quarantined? false]
      set testDate ticks + testingFrequency * (24 / timeStep)
    ]
  ]

  ;;update physical spaces
  ;;update patch color based on load
  ;;diffuse load diffuseShare
  ask patches with [physical? = false] [set load 0]
  ask patches with [physical? = true] [
    ;;set load load * (1 - 1 / virusLifetime)
    update-virus-in-space

    if-else seeCovid? [

     set pcolor scale-color yellow load 0 viralLoad
    ] [
     set pcolor black
    ]
  ]



  ;; update global variables
  update-globals

  tick
end

to update-globals

  set averageNumberLinksActual count links / count people
  set averagePContact sum [pContactPerLink] of people / count people
  set averagePMask sum [pMask] of people / count people
  set infectionRate count people with [infected = true] / count people

end

to make-room [x y h w a m id]
  ask patches with [pxcor >= x and pxcor < x + h and pycor >= y and pycor < y + w] [
    set spaceID id
    set airTurnover a
    set physical? true
    set masked? m
  ]

  draw-box x y h w

end

to draw-box [x y h w]
  ask patches with [pxcor = x and pycor >= y and pycor < y + w] [
    sprout 1 [set shape "line" set color white set heading 0 set xcor xcor - 0.5 stamp die]
  ]
  ask patches with [pxcor = x + h - 1 and pycor >= y and pycor < y + w] [
    sprout 1 [set shape "line" set color white set heading 0 set xcor xcor + 0.5 stamp die]
  ]
  ask patches with [pycor = y and pxcor >= x and pxcor < x + h] [
    sprout 1 [set shape "line" set color white set heading 90 set ycor ycor - 0.5 stamp die]
  ]
  ask patches with [pycor = y + w - 1 and pxcor >= x and pxcor < x + h] [
    sprout 1 [set shape "line" set color white set heading 90 set ycor ycor + 0.5 stamp die]
  ]
end

to go-to-space [id]
  let newPatch one-of patches with [spaceID = id]
  setxy [pxcor] of newPatch + (random 1 - 0.25) [pycor] of newPatch + (random 1 - 0.25)

end

to update-virus-in-space

  ;;let virus diffuse
  let roomNeighbors neighbors with [spaceID = [spaceID] of self]
  let loadOut load * diffuseShare
  ask roomNeighbors [set load load + loadOut / count roomNeighbors]
  set load max (list 0 (load - loadOut))

  ;;let virus decay
  set load load * (1 - 1 / virusLifetime)

  ;;let air flow (flow is always from lower x to higher x, by default
  let movedLoad load * airTurnover
  set load load - movedLoad
  ask patch-at 1 0 [set load load + movedLoad]


end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
1011
422
-1
-1
13.0
1
10
1
1
1
0
0
0
1
-30
30
0
30
0
0
1
ticks
30.0

BUTTON
27
29
93
62
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
28
88
91
121
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
26
193
198
226
numberPeople
numberPeople
10
600
200.0
5
1
NIL
HORIZONTAL

SLIDER
322
780
494
813
speed
speed
0
10
0.0
1
1
NIL
HORIZONTAL

SLIDER
321
822
493
855
probTurn
probTurn
0
1
0.08
0.01
1
NIL
HORIZONTAL

SLIDER
25
237
197
270
initialInfections
initialInfections
0
10
30.0
1
1
NIL
HORIZONTAL

SLIDER
324
461
497
494
viralLoad
viralLoad
0
10
2.0
1
1
NIL
HORIZONTAL

SLIDER
326
504
499
537
pInfectionPerLoad
pInfectionPerLoad
0.00
.01
0.002
.001
1
NIL
HORIZONTAL

SLIDER
327
549
500
582
diffuseShare
diffuseShare
0
1
0.6
.05
1
NIL
HORIZONTAL

SLIDER
326
591
499
624
virusLifetime
virusLifetime
0
20
5.0
1
1
NIL
HORIZONTAL

SLIDER
31
459
300
492
recoveryTimeFromInfection_Days
recoveryTimeFromInfection_Days
8
16
12.0
1
1
NIL
HORIZONTAL

SLIDER
30
501
203
534
caseMortalityRate
caseMortalityRate
0
0.05
0.03
0.005
1
NIL
HORIZONTAL

SLIDER
30
543
224
576
immunityTime_Days
immunityTime_Days
0
200
100.0
1
1
NIL
HORIZONTAL

PLOT
1033
12
1405
416
plot 1
Days
People
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"All people" 1.0 0 -16777216 true "" "plotxy ticks / (24 / timeStep) count people "
"Infected" 1.0 0 -7500403 true "" "plotxy ticks / (24 / timeStep) count people with [infected = true]"
"Immune" 1.0 0 -2674135 true "" "plotxy ticks / (24 / timeStep) count people with [immune = true]"
"Quarantined" 1.0 0 -955883 true "" "plotxy ticks / (24 / timeStep) count people with [quarantined? = true]"

SWITCH
29
327
161
360
seeCovid?
seeCovid?
0
1
-1000

SLIDER
27
708
218
741
averageLinksPerAgent
averageLinksPerAgent
0
10
2.0
0.1
1
NIL
HORIZONTAL

SLIDER
28
750
213
783
pInfectionPerContact
pInfectionPerContact
0
1
0.072
0.001
1
NIL
HORIZONTAL

SLIDER
28
794
268
827
pContactPerLinkPerDay_Mean
pContactPerLinkPerDay_Mean
0
1
0.08
0.01
1
NIL
HORIZONTAL

SLIDER
26
666
281
699
numberRandomContactsPerStep
numberRandomContactsPerStep
0
100
22.0
1
1
NIL
HORIZONTAL

SLIDER
28
836
207
869
pContactPerLink_SD
pContactPerLink_SD
0
1
0.099
0.001
1
NIL
HORIZONTAL

PLOT
1033
435
1406
740
Average P Mask
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot averagePMask"

SLIDER
526
464
698
497
pMask_decay
pMask_decay
0
0.2
0.02
0.01
1
NIL
HORIZONTAL

SLIDER
527
855
745
888
riskReductionFactor_mask
riskReductionFactor_mask
1
4
3.0
1
1
NIL
HORIZONTAL

SLIDER
526
504
698
537
pMaskBump_rise
pMaskBump_rise
0
0.4
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
526
670
698
703
pCheck_mean
pCheck_mean
0
1
0.2
0.01
1
NIL
HORIZONTAL

SLIDER
527
715
699
748
pCheck_SD
pCheck_SD
0
1
0.05
0.01
1
NIL
HORIZONTAL

SLIDER
527
545
699
578
pMaskBump_die
pMaskBump_die
0
0.5
0.0
0.01
1
NIL
HORIZONTAL

SLIDER
525
586
739
619
pMaskBumpDecay_degree
pMaskBumpDecay_degree
0
1
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
526
629
700
662
degreesConsidered
degreesConsidered
0
3
0.0
1
1
NIL
HORIZONTAL

SWITCH
29
365
171
398
seeNetwork?
seeNetwork?
0
1
-1000

SLIDER
27
281
199
314
timeStep
timeStep
0.25
3
0.25
0.25
1
hours
HORIZONTAL

SLIDER
527
758
700
791
pMask_Initial_mean
pMask_Initial_mean
0
1
1.0
.01
1
NIL
HORIZONTAL

SLIDER
528
801
700
834
pMask_Initial_SD
pMask_Initial_SD
0
1
0.0
.01
1
NIL
HORIZONTAL

SLIDER
766
461
959
494
testingFrequency
testingFrequency
0
10
5.0
1
1
days
HORIZONTAL

SLIDER
765
507
1001
540
testingCapacityPerDay
testingCapacityPerDay
0
200
30.0
10
1
people
HORIZONTAL

SLIDER
324
680
497
713
classCap
classCap
5
15
10.0
1
1
NIL
HORIZONTAL

SWITCH
325
728
464
761
groupLunch?
groupLunch?
0
1
-1000

SLIDER
326
633
498
666
fracAirTurnover
fracAirTurnover
0
1
0.0
0.1
1
NIL
HORIZONTAL

TEXTBOX
30
169
180
187
Simulation Params
11
0.0
1

TEXTBOX
34
436
184
454
Virus Params
11
0.0
1

TEXTBOX
326
439
476
457
Physical Model Params
11
0.0
1

TEXTBOX
28
644
178
662
Network Model Params
11
0.0
1

TEXTBOX
527
439
677
457
Mask-wearing Params
11
0.0
1

TEXTBOX
766
439
916
457
Testing Params\n
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

A model of virus spreading in a school environment.  Virus propagation is handled by a physical agent-based model approach in shared lunchrooms and classes, while it is handled by a network agent-based model for time in which students are outside of the shared university environment (i.e., socializing with each other or outside of the university network).

## HOW IT WORKS

Student agents attend classes or eat lunch according to their fixed schedule, and interact stochastically with others in the network outside of their scheduled time.  As well, students have individual specific likelihoods of wearing masks, which decay over time but are bumped back up by specific events - students observing jumps in overall infection rate, or experiencing that someone close to them in their network has become ill or died.  Students are scheduled to participate in a testing program that takes students in up to some capacity each timestep.

## HOW TO USE IT

The model can be run by first clicking 'setup' and then 'go.'

Parameter sets are grouped into i) general simulation parameters, ii) virus characteristics general to both physical and network approaches, iii) network-approach specific parameters, iv) physical-approach specific parameters, v) agent mask-wearing parameters, and vi) testing parameters.

All parameters have been given descriptive names.  In case the meaning of a parameter is unclear, we encourage the user to look for its use in the code tab.

Most parameters are adjustable along the simulation.  Parameters that are only adjustable before setup are: numberPeople, initialInfections, averageLinksPerAgent, classCap.

## THINGS TO NOTICE

Watch the plot of susceptible, infected, immune, and quarantined - under what conditions do you see repeated waves of the virus?  How much does the average likelihood of mask-wearing shape the likelihood of a return wave?

## THINGS TO TRY

Consider how best to choose parameters such that transmission in the network model is meaningfully similar to transmission in the physical model.  

Explore the relative importance of i) mask wearing, ii) quarantining, iii) in-person learning, iv) testing in shaping the path of the virus.

## EXTENDING THE MODEL

The model does not differentiate symptomatic vs. asymptomatic cases, nor does it implement a vaccine program (or vaccine hesitancy).  How would you add these?

## NETLOGO FEATURES

Users may be interested to see how the model space is broken up into one part that is governed by physical processes (virus transmission) and one that is not.

## CREDITS AND REFERENCES

This model was developed by Andrew Reid Bell, Bianka Kiedrowska, Noor Eatamadi, and Olivia Osborne Kato as part of the course 'Modeling Pandemics and the Environment' in Spring 2020 at New York University - Abu Dhabi.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person business
false
0
Rectangle -1 true false 120 90 180 180
Polygon -13345367 true false 135 90 150 105 135 180 150 195 165 180 150 105 165 90
Polygon -7500403 true true 120 90 105 90 60 195 90 210 116 154 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 183 153 210 210 240 195 195 90 180 90 150 165
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 76 172 91
Line -16777216 false 172 90 161 94
Line -16777216 false 128 90 139 94
Polygon -13345367 true false 195 225 195 300 270 270 270 195
Rectangle -13791810 true false 180 225 195 300
Polygon -14835848 true false 180 226 195 226 270 196 255 196
Polygon -13345367 true false 209 202 209 216 244 202 243 188
Line -16777216 false 180 90 150 165
Line -16777216 false 120 90 150 165

person construction
false
0
Rectangle -7500403 true true 123 76 176 95
Polygon -1 true false 105 90 60 195 90 210 115 162 184 163 210 210 240 195 195 90
Polygon -13345367 true false 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Circle -7500403 true true 110 5 80
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Rectangle -16777216 true false 179 164 183 186
Polygon -955883 true false 180 90 195 90 195 165 195 195 150 195 150 120 180 90
Polygon -955883 true false 120 90 105 90 105 165 105 195 150 195 150 120 120 90
Rectangle -16777216 true false 135 114 150 120
Rectangle -16777216 true false 135 144 150 150
Rectangle -16777216 true false 135 174 150 180
Polygon -955883 true false 105 42 111 16 128 2 149 0 178 6 190 18 192 28 220 29 216 34 201 39 167 35
Polygon -6459832 true false 54 253 54 238 219 73 227 78
Polygon -16777216 true false 15 285 15 255 30 225 45 225 75 255 75 270 45 285

person doctor
false
0
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -13345367 true false 135 90 150 105 135 135 150 150 165 135 150 105 165 90
Polygon -7500403 true true 105 90 60 195 90 210 135 105
Polygon -7500403 true true 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -1 true false 105 90 60 195 90 210 114 156 120 195 90 270 210 270 180 195 186 155 210 210 240 195 195 90 165 90 150 150 135 90
Line -16777216 false 150 148 150 270
Line -16777216 false 196 90 151 149
Line -16777216 false 104 90 149 149
Circle -1 true false 180 0 30
Line -16777216 false 180 15 120 15
Line -16777216 false 150 195 165 195
Line -16777216 false 150 240 165 240
Line -16777216 false 150 150 165 150

person farmer
false
0
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 60 195 90 210 114 154 120 195 180 195 187 157 210 210 240 195 195 90 165 90 150 105 150 150 135 90 105 90
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -13345367 true false 120 90 120 180 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 180 90 172 89 165 135 135 135 127 90
Polygon -6459832 true false 116 4 113 21 71 33 71 40 109 48 117 34 144 27 180 26 188 36 224 23 222 14 178 16 167 0
Line -16777216 false 225 90 270 90
Line -16777216 false 225 15 225 90
Line -16777216 false 270 15 270 90
Line -16777216 false 247 15 247 90
Rectangle -6459832 true false 240 90 255 300

person graduate
false
0
Circle -16777216 false false 39 183 20
Polygon -1 true false 50 203 85 213 118 227 119 207 89 204 52 185
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -8630108 true false 90 19 150 37 210 19 195 4 105 4
Polygon -8630108 true false 120 90 105 90 60 195 90 210 120 165 90 285 105 300 195 300 210 285 180 165 210 210 240 195 195 90
Polygon -1184463 true false 135 90 120 90 150 135 180 90 165 90 150 105
Line -2674135 false 195 90 150 135
Line -2674135 false 105 90 150 135
Polygon -1 true false 135 90 150 105 165 90
Circle -1 true false 104 205 20
Circle -1 true false 41 184 20
Circle -16777216 false false 106 206 18
Line -2674135 false 208 22 208 57

person lumberjack
false
0
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -2674135 true false 60 196 90 211 114 155 120 196 180 196 187 158 210 211 240 196 195 91 165 91 150 106 150 135 135 91 105 91
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -6459832 true false 174 90 181 90 180 195 165 195
Polygon -13345367 true false 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Polygon -6459832 true false 126 90 119 90 120 195 135 195
Rectangle -6459832 true false 45 180 255 195
Polygon -16777216 true false 255 165 255 195 240 225 255 240 285 240 300 225 285 195 285 165
Line -16777216 false 135 165 165 165
Line -16777216 false 135 135 165 135
Line -16777216 false 90 135 120 135
Line -16777216 false 105 120 120 120
Line -16777216 false 180 120 195 120
Line -16777216 false 180 135 210 135
Line -16777216 false 90 150 105 165
Line -16777216 false 225 165 210 180
Line -16777216 false 75 165 90 180
Line -16777216 false 210 150 195 165
Line -16777216 false 180 105 210 180
Line -16777216 false 120 105 90 180
Line -16777216 false 150 135 150 165
Polygon -2674135 true false 100 30 104 44 189 24 185 10 173 10 166 1 138 -1 111 3 109 28

person police
false
0
Polygon -1 true false 124 91 150 165 178 91
Polygon -13345367 true false 134 91 149 106 134 181 149 196 164 181 149 106 164 91
Polygon -13345367 true false 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Polygon -13345367 true false 120 90 105 90 60 195 90 210 116 158 120 195 180 195 184 158 210 210 240 195 195 90 180 90 165 105 150 165 135 105 120 90
Rectangle -7500403 true true 123 76 176 92
Circle -7500403 true true 110 5 80
Polygon -13345367 true false 150 26 110 41 97 29 137 -1 158 6 185 0 201 6 196 23 204 34 180 33
Line -13345367 false 121 90 194 90
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Rectangle -16777216 true false 109 183 124 227
Rectangle -16777216 true false 176 183 195 205
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Polygon -1184463 true false 172 112 191 112 185 133 179 133
Polygon -1184463 true false 175 6 194 6 189 21 180 21
Line -1184463 false 149 24 197 24
Rectangle -16777216 true false 101 177 122 187
Rectangle -16777216 true false 179 164 183 186

person service
false
0
Polygon -7500403 true true 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Polygon -1 true false 120 90 105 90 60 195 90 210 120 150 120 195 180 195 180 150 210 210 240 195 195 90 180 90 165 105 150 165 135 105 120 90
Polygon -1 true false 123 90 149 141 177 90
Rectangle -7500403 true true 123 76 176 92
Circle -7500403 true true 110 5 80
Line -13345367 false 121 90 194 90
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Rectangle -16777216 true false 179 164 183 186
Polygon -2674135 true false 180 90 195 90 183 160 180 195 150 195 150 135 180 90
Polygon -2674135 true false 120 90 105 90 114 161 120 195 150 195 150 135 120 90
Polygon -2674135 true false 155 91 128 77 128 101
Rectangle -16777216 true false 118 129 141 140
Polygon -2674135 true false 145 91 172 77 172 101

person soldier
false
0
Rectangle -7500403 true true 127 79 172 94
Polygon -10899396 true false 105 90 60 195 90 210 135 105
Polygon -10899396 true false 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Polygon -10899396 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -6459832 true false 120 90 105 90 180 195 180 165
Line -6459832 false 109 105 139 105
Line -6459832 false 122 125 151 117
Line -6459832 false 137 143 159 134
Line -6459832 false 158 179 181 158
Line -6459832 false 146 160 169 146
Rectangle -6459832 true false 120 193 180 201
Polygon -6459832 true false 122 4 107 16 102 39 105 53 148 34 192 27 189 17 172 2 145 0
Polygon -16777216 true false 183 90 240 15 247 22 193 90
Rectangle -6459832 true false 114 187 128 208
Rectangle -6459832 true false 177 187 191 208

person student
false
0
Polygon -13791810 true false 135 90 150 105 135 165 150 180 165 165 150 105 165 90
Polygon -7500403 true true 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 100 210 130 225 145 165 85 135 63 189
Polygon -13791810 true false 90 210 120 225 135 165 67 130 53 189
Polygon -1 true false 120 224 131 225 124 210
Line -16777216 false 139 168 126 225
Line -16777216 false 140 167 76 136
Polygon -7500403 true true 105 90 60 195 90 210 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="calibration" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="48"/>
    <exitCondition>count turtles with [infected = true] = 0</exitCondition>
    <metric>count (turtles-on patches with [spaceID = "dining hall"] )</metric>
    <metric>count (turtles-on patches with [spaceID = "dining hall"] ) with [infected = true]</metric>
    <metric>count (turtles-on patches with [spaceID = "dining hall"] ) with [immune = true]</metric>
    <steppedValueSet variable="probTurn" first="0" step="0.04" last="0.08"/>
    <enumeratedValueSet variable="numberRandomContactsPerStep">
      <value value="22"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="numberPeople">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="riskReductionFactor_mask">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="degreesConsidered">
      <value value="0"/>
    </enumeratedValueSet>
    <steppedValueSet variable="diffuseShare" first="0.2" step="0.2" last="0.6"/>
    <enumeratedValueSet variable="averageLinksPerAgent">
      <value value="1.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="testingFrequency">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="testingCapacityPerDay">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBumpDecay_degree">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pCheck_SD">
      <value value="0.05"/>
    </enumeratedValueSet>
    <steppedValueSet variable="viralLoad" first="1" step="0.5" last="3"/>
    <steppedValueSet variable="virusLifetime" first="1" step="2" last="7"/>
    <enumeratedValueSet variable="pMaskBump_die">
      <value value="0"/>
    </enumeratedValueSet>
    <steppedValueSet variable="pInfectionPerLoad" first="0.001" step="0.001" last="0.005"/>
    <enumeratedValueSet variable="pContactPerLinkPerDay_Mean">
      <value value="0.08"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="timeStep">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pContactPerLink_SD">
      <value value="0.099"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_Initial_mean">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="caseMortalityRate">
      <value value="0.03"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seeCovid?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="recoveryTimeFromInfection_Days">
      <value value="12"/>
    </enumeratedValueSet>
    <steppedValueSet variable="initialInfections" first="30" step="20" last="70"/>
    <enumeratedValueSet variable="pInfectionPerContact">
      <value value="0.012"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="speed">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pCheck_mean">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seeNetwork?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_decay">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBump_rise">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_Initial_SD">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="immunityTime_Days">
      <value value="100"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="4000"/>
    <exitCondition>count turtles with [infected] = 0</exitCondition>
    <metric>count turtles with [infected]</metric>
    <metric>averagePmask</metric>
    <enumeratedValueSet variable="probTurn">
      <value value="0.08"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="numberRandomContactsPerStep">
      <value value="22"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="numberPeople">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="classCap">
      <value value="0"/>
      <value value="10"/>
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="riskReductionFactor_mask">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="degreesConsidered">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="diffuseShare">
      <value value="0.6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="averageLinksPerAgent">
      <value value="1"/>
      <value value="1.5"/>
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="testingFrequency">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="testingCapacityPerDay">
      <value value="0"/>
      <value value="10"/>
      <value value="20"/>
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBumpDecay_degree">
      <value value="0"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pCheck_SD">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="viralLoad">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="virusLifetime">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBump_die">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="groupLunch?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pInfectionPerLoad">
      <value value="0.002"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pContactPerLinkPerDay_Mean">
      <value value="0.08"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="timeStep">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pContactPerLink_SD">
      <value value="0.099"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_Initial_mean">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="caseMortalityRate">
      <value value="0.03"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seeCovid?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="recoveryTimeFromInfection_Days">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initialInfections">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pInfectionPerContact">
      <value value="0.072"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pCheck_mean">
      <value value="0.1"/>
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="speed">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seeNetwork?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_decay">
      <value value="0"/>
      <value value="0.01"/>
      <value value="0.02"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBump_rise">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_Initial_SD">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="immunityTime_Days">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fracAirTurnover">
      <value value="0"/>
      <value value="0.3"/>
      <value value="0.6"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="5" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="4000"/>
    <metric>count turtles with [infected]</metric>
    <metric>averagePMask</metric>
    <enumeratedValueSet variable="probTurn">
      <value value="0.08"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="numberRandomContactsPerStep">
      <value value="22"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="numberPeople">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="classCap">
      <value value="0"/>
      <value value="10"/>
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="riskReductionFactor_mask">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="degreesConsidered">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="diffuseShare">
      <value value="0.6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="averageLinksPerAgent">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="testingFrequency">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="testingCapacityPerDay">
      <value value="0"/>
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBumpDecay_degree">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pCheck_SD">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="viralLoad">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="virusLifetime">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBump_die">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="groupLunch?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pInfectionPerLoad">
      <value value="0.002"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pContactPerLinkPerDay_Mean">
      <value value="0.08"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fracAirTurnover">
      <value value="0"/>
      <value value="0.3"/>
      <value value="0.6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="timeStep">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pContactPerLink_SD">
      <value value="0.099"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_Initial_mean">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="caseMortalityRate">
      <value value="0.03"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seeCovid?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="recoveryTimeFromInfection_Days">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initialInfections">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pInfectionPerContact">
      <value value="0.072"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pCheck_mean">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="speed">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seeNetwork?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_decay">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMaskBump_rise">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="pMask_Initial_SD">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="immunityTime_Days">
      <value value="100"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
