globals [
  counters
  total-cost
  Logistics-sustainable-current-cost
  Supplier-sustainable-current-cost
  product-sustainable-current-cost



  Logistics-price-current-cost
  Supplier-price-current-cost
  product-price-current-cost

  ;; Production cost and STDEV
  production-Golden-Crust-Classic
  stdev-production-Golden-Crust-Classic

  production-Harvest-Grain-Loaf
  stdev-production-Harvest-Grain-Loaf

  production-Sunrise-Sourdough
  stdev-production-Sunrise-Sourdough

  production-Honey-Wheat-Harmony
  stdev-production-Honey-Wheat-Harmony

  production-Rye-and-Shine
  stdev-production-Rye-and-Shine

  ;; Sustainability cost and STDEV
  sustainability-Golden-Crust-Classic
  stdev-sustainability-Golden-Crust-Classic

  sustainability-Harvest-Grain-Loaf
  stdev-sustainability-Harvest-Grain-Loaf

  sustainability-Sunrise-Sourdough
  stdev-sustainability-Sunrise-Sourdough

  sustainability-Honey-Wheat-Harmony
  stdev-sustainability-Honey-Wheat-Harmony

  sustainability-Rye-and-Shine
  stdev-sustainability-Rye-and-Shine

  ;; Totals
  total-sustainability-cost
  total-supplier-cost
  total-logistics-cost
  total-pcost
  demand
  price

    generated-cost-Golden
  generated-cost-Harvest
  generated-cost-Sunrise
  generated-cost-Honey
  generated-cost-Rye

    ;; Golden Grain
  sustainability-Golden-Grain-random
  price-Golden-Grain-random

  ;; Harvest Hearth
  sustainability-Harvest-Hearth-random
  price-Harvest-Hearth-random

  ;; Pure Field
  sustainability-Pure-Field-random
  price-Pure-Field-random

  ;; Millstone
  sustainability-Millstone-random
  price-Millstone-random

  ;; Bakers Root
  sustainability-Bakers-Root-random
  price-Bakers-Root-random

  ;; Fresh Route
  sustainability-Fresh-Route-random
  price-Fresh-Route-random

  ;; Crate Freight
  sustainability-Crate-Freight-random
  price-Crate-Freight-random

  ;; Swift Bite
  sustainability-Swift-Bite-random
  price-Swift-Bite-random

  ;; Daily Haul
  sustainability-Daily-Haul-random
  price-Daily-Haul-random

  ;; Urban Crate
  sustainability-Urban-Crate-random
  price-Urban-Crate-random

  sustainability-golden
  production-golden
  sustainability-harvest
  production-harvest
  sustainability-sunrise
  production-sunrise
  sustainability-honey
  production-honey
  sustainability-rye
  production-rye

  ;; Supplier cost components
  sustainability-Golden-Grain
  stdev-sustainability-Golden-Grain
  price-Golden-Grain
  stdev-price-Golden-Grain

  sustainability-Harvest-Hearth
  stdev-sustainability-Harvest-Hearth
  price-Harvest-Hearth
  stdev-price-Harvest-Hearth

  sustainability-Pure-Field
  stdev-sustainability-Pure-Field
  price-Pure-Field
  stdev-price-Pure-Field

  sustainability-Millstone
  stdev-sustainability-Millstone
  price-Millstone
  stdev-price-Millstone

  sustainability-Bakers-Root
  stdev-sustainability-Bakers-Root
  price-Bakers-Root
  stdev-price-Bakers-Root

  ;; Generated costs
  cost-Golden-Grain
  cost-Harvest-Hearth
  cost-Pure-Field
  cost-Millstone
  cost-Bakers-Root

  ;; Fresh-Route Logistics
  sustainability-Fresh-Route
  stdev-sustainability-Fresh-Route
  price-Fresh-Route
  stdev-price-Fresh-Route

  ;; Crate & Freight Co.
  sustainability-Crate-Freight
  stdev-sustainability-Crate-Freight
  price-Crate-Freight
  stdev-price-Crate-Freight

  ;; Swift-Bite Transport
  sustainability-Swift-Bite
  stdev-sustainability-Swift-Bite
  price-Swift-Bite
  stdev-price-Swift-Bite

  ;; Daily-Haul Distribution
  sustainability-Daily-Haul
  stdev-sustainability-Daily-Haul
  price-Daily-Haul
  stdev-price-Daily-Haul

  ;; Urban-Crate Express
  sustainability-Urban-Crate
  stdev-sustainability-Urban-Crate
  price-Urban-Crate
  stdev-price-Urban-Crate

  ;; Generated logistics costs
  cost-Fresh-Route
  cost-Crate-Freight
  cost-Swift-Bite
  cost-Daily-Haul
  cost-Urban-Crate

    ;; supplier choices

 golden-grain
  harvest-hearth
  pure-field
  millstone-select
  bakers-root

  ;; logistics choices

  fresh-route
  crate-freight
  swift-bite
  daily-haul
  urban-crate

qty-golden
qty-harvest
qty-sunrise
qty-honey
qty-rye

  R-t
  P-t
  d ;; disposal cose

  PM-t

    PS-t1 ;product sustainability
  PS-t2 ;product sustainability
  SS-t1 ;sustainability of supplier
  SS-t2 ;sustainability of supplier
  LS-t1 ;sustainability of logistics service
  LS-t2 ;sustainability of logistics service
  FES-t
  FSS-t
  FES-tt
  FSS-tt
  priceL
  PMT-tt
    ]


to setup
  clear-all



  ;; Golden Crust Classic
  set production-Golden-Crust-Classic 7
  set stdev-production-Golden-Crust-Classic 2
  set sustainability-Golden-Crust-Classic 70
  set stdev-sustainability-Golden-Crust-Classic 10


  ;; Harvest Grain Loaf
  set production-Harvest-Grain-Loaf 7.5
  set stdev-production-Harvest-Grain-Loaf 1
  set sustainability-Harvest-Grain-Loaf 75
  set stdev-sustainability-Harvest-Grain-Loaf 5

  ;; Sunrise Sourdough
  set production-Sunrise-Sourdough 9
  set stdev-production-Sunrise-Sourdough 1.5
  set sustainability-Sunrise-Sourdough 90
  set stdev-sustainability-Sunrise-Sourdough 5

  ;; Honey Wheat Harmony
  set production-Honey-Wheat-Harmony 9.2
  set stdev-production-Honey-Wheat-Harmony 1.5
  set sustainability-Honey-Wheat-Harmony 92
  set stdev-sustainability-Honey-Wheat-Harmony 3

  ;; Rye and Shine
  set production-Rye-and-Shine 9.2
  set stdev-production-Rye-and-Shine 1.5
  set sustainability-Rye-and-Shine 91
  set stdev-sustainability-Rye-and-Shine 3

    ;; Golden Grain Mills
  set sustainability-Golden-Grain 70
  set stdev-sustainability-Golden-Grain 10
  set price-Golden-Grain 7
  set stdev-price-Golden-Grain 2

  ;; Harvest & Hearth Flour Co.
  set sustainability-Harvest-Hearth 75
  set stdev-sustainability-Harvest-Hearth 5
  set price-Harvest-Hearth 7.5
  set stdev-price-Harvest-Hearth 1

  ;; Pure-Field Grains
  set sustainability-Pure-Field 90
  set stdev-sustainability-Pure-Field 3
  set price-Pure-Field 9
  set stdev-price-Pure-Field 1.5

  ;; Millstone Select
  set sustainability-Millstone 92
  set stdev-sustainability-Millstone 5
  set price-Millstone 9.5
  set stdev-price-Millstone 2.5

  ;; Bakers’ Root Supply
  set sustainability-Bakers-Root 90
  set stdev-sustainability-Bakers-Root 7
  set price-Bakers-Root 9
  set stdev-price-Bakers-Root 3

    ;; Fresh-Route Logistics
  set sustainability-Fresh-Route 70
  set stdev-sustainability-Fresh-Route 10
  set price-Fresh-Route 7
  set stdev-price-Fresh-Route 2

  ;; Crate & Freight Co.
  set sustainability-Crate-Freight 75
  set stdev-sustainability-Crate-Freight 5
  set price-Crate-Freight 7.5
  set stdev-price-Crate-Freight 1

  ;; Swift-Bite Transport
  set sustainability-Swift-Bite 90
  set stdev-sustainability-Swift-Bite 3
  set price-Swift-Bite 9
  set stdev-price-Swift-Bite 1.5


  ;; Daily-Haul Distribution
  set sustainability-Daily-Haul 92
  set stdev-sustainability-Daily-Haul 7
  set price-Daily-Haul 9.5
  set stdev-price-Daily-Haul 3

  ;; Urban-Crate Express
  set sustainability-Urban-Crate 90
  set stdev-sustainability-Urban-Crate 5
  set price-Urban-Crate 9
  set stdev-price-Urban-Crate 2.5


  ;; set suppler

  set golden-grain 0
  set harvest-hearth 0
  set pure-field 0
  set millstone-select 0
  set bakers-root 0

;; logistics

  set fresh-route 0
  set crate-freight 0
  set swift-bite 0
  set daily-haul 0
  set urban-crate 0

  set FES-tt 0
  set FSS-tt 0
  set priceL 0
  set PMT-tt 0

resize-world -15 15 -10 10
  set demand random-normal 100 10   ; change this at other places as well. chaning here will not be the final one
draw-balance

  set counters 1
  reset-ticks

end

to go
  repeat 12 [
    calculate-total-cost
  ]
  draw-balance
end



to generate-random-costs

  set demand random-normal 100 10

set sustainability-golden random-normal sustainability-Golden-Crust-Classic stdev-sustainability-Golden-Crust-Classic
set production-golden max list (random-normal production-Golden-Crust-Classic stdev-production-Golden-Crust-Classic) (production-Golden-Crust-Classic - 2 * stdev-production-Golden-Crust-Classic)
;set production-golden random-normal production-Golden-Crust-Classic stdev-production-Golden-Crust-Classic
set generated-cost-Golden sustainability-golden + production-golden
;  set min-price-Golden-Crust-Classic production-Golden-Crust-Classic - 2 * stdev-production-Golden-Crust-Classic


set sustainability-harvest random-normal sustainability-Harvest-Grain-Loaf stdev-sustainability-Harvest-Grain-Loaf
;set production-harvest random-normal production-Harvest-Grain-Loaf stdev-production-Harvest-Grain-Loaf
  set production-harvest max list (random-normal production-Harvest-Grain-Loaf stdev-production-Harvest-Grain-Loaf) (production-Harvest-Grain-Loaf - 2 *  stdev-production-Harvest-Grain-Loaf)
set generated-cost-Harvest sustainability-harvest + production-harvest

set sustainability-sunrise random-normal sustainability-Sunrise-Sourdough stdev-sustainability-Sunrise-Sourdough
; set production-sunrise random-normal production-Sunrise-Sourdough stdev-production-Sunrise-Sourdough
  set production-sunrise max list (random-normal production-Sunrise-Sourdough stdev-production-Sunrise-Sourdough) (production-Sunrise-Sourdough - 2 * stdev-production-Sunrise-Sourdough)
set generated-cost-Sunrise sustainability-sunrise + production-sunrise

set sustainability-honey random-normal sustainability-Honey-Wheat-Harmony stdev-sustainability-Honey-Wheat-Harmony
;set production-honey random-normal production-Honey-Wheat-Harmony stdev-production-Honey-Wheat-Harmony
  set production-honey max list (random-normal production-Honey-Wheat-Harmony stdev-production-Honey-Wheat-Harmony) (production-Honey-Wheat-Harmony - 2 * stdev-production-Honey-Wheat-Harmony)
set generated-cost-Honey sustainability-honey + production-honey

set sustainability-rye random-normal sustainability-Rye-and-Shine stdev-sustainability-Rye-and-Shine
;set production-rye random-normal production-Rye-and-Shine stdev-production-Rye-and-Shine
  set production-rye max list (random-normal production-Rye-and-Shine stdev-production-Rye-and-Shine) (production-Rye-and-Shine - 2 * stdev-production-Rye-and-Shine)
set generated-cost-Rye sustainability-rye + production-rye

 ;; Golden Grain
set sustainability-Golden-Grain-random random-normal sustainability-Golden-Grain stdev-sustainability-Golden-Grain
;set price-Golden-Grain-random random-normal price-Golden-Grain stdev-price-Golden-Grain
  set price-Golden-Grain-random max list (random-normal price-Golden-Grain stdev-price-Golden-Grain) (price-Golden-Grain - 2 * stdev-price-Golden-Grain)
set cost-Golden-Grain sustainability-Golden-Grain-random + price-Golden-Grain-random

;; Harvest Hearth
set sustainability-Harvest-Hearth-random random-normal sustainability-Harvest-Hearth stdev-sustainability-Harvest-Hearth
;set price-Harvest-Hearth-random random-normal price-Harvest-Hearth stdev-price-Harvest-Hearth
  set price-Harvest-Hearth-random max list (random-normal price-Harvest-Hearth stdev-price-Harvest-Hearth) (price-Harvest-Hearth - 2 * stdev-price-Harvest-Hearth)
set cost-Harvest-Hearth sustainability-Harvest-Hearth-random + price-Harvest-Hearth-random

;; Pure Field
set sustainability-Pure-Field-random random-normal sustainability-Pure-Field stdev-sustainability-Pure-Field
;set price-Pure-Field-random random-normal price-Pure-Field stdev-price-Pure-Field
  set price-Pure-Field-random max list (random-normal price-Pure-Field stdev-price-Pure-Field) (price-Pure-Field - 2 * stdev-price-Pure-Field)
set cost-Pure-Field sustainability-Pure-Field-random + price-Pure-Field-random

;; Millstone
set sustainability-Millstone-random random-normal sustainability-Millstone stdev-sustainability-Millstone
;set price-Millstone-random random-normal price-Millstone stdev-price-Millstone
  set price-Millstone-random max list (random-normal price-Millstone stdev-price-Millstone) (price-Millstone - 2 * stdev-price-Millstone)
set cost-Millstone sustainability-Millstone-random + price-Millstone-random

;; Bakers Root
set sustainability-Bakers-Root-random random-normal sustainability-Bakers-Root stdev-sustainability-Bakers-Root
;set price-Bakers-Root-random random-normal price-Bakers-Root stdev-price-Bakers-Root
  set price-Bakers-Root-random max list (random-normal price-Bakers-Root stdev-price-Bakers-Root) (price-Bakers-Root - 2 * stdev-price-Bakers-Root)
set cost-Bakers-Root sustainability-Bakers-Root-random + price-Bakers-Root-random



;; Fresh Route
set sustainability-Fresh-Route-random random-normal sustainability-Fresh-Route stdev-sustainability-Fresh-Route
;set price-Fresh-Route-random random-normal price-Fresh-Route stdev-price-Fresh-Route
  set price-Fresh-Route-random max list (random-normal price-Fresh-Route stdev-price-Fresh-Route) (price-Fresh-Route - 2 * stdev-price-Fresh-Route)
set cost-Fresh-Route sustainability-Fresh-Route-random + price-Fresh-Route-random

;; Crate Freight
set sustainability-Crate-Freight-random random-normal sustainability-Crate-Freight stdev-sustainability-Crate-Freight
;set price-Crate-Freight-random random-normal price-Crate-Freight stdev-price-Crate-Freight
  set price-Crate-Freight-random max list (random-normal price-Crate-Freight stdev-price-Crate-Freight) (price-Crate-Freight - 2 * stdev-price-Crate-Freight)
set cost-Crate-Freight sustainability-Crate-Freight-random + price-Crate-Freight-random

;; Swift Bite
set sustainability-Swift-Bite-random random-normal sustainability-Swift-Bite stdev-sustainability-Swift-Bite
;set price-Swift-Bite-random random-normal price-Swift-Bite stdev-price-Swift-Bite
  set price-Swift-Bite-random max list (random-normal price-Swift-Bite stdev-price-Swift-Bite) (price-Swift-Bite - 2 * stdev-price-Swift-Bite)
set cost-Swift-Bite sustainability-Swift-Bite-random + price-Swift-Bite-random

;; Daily Haul
set sustainability-Daily-Haul-random random-normal sustainability-Daily-Haul stdev-sustainability-Daily-Haul
;set price-Daily-Haul-random random-normal price-Daily-Haul stdev-price-Daily-Haul
  set price-Daily-Haul-random max list (random-normal price-Daily-Haul stdev-price-Daily-Haul) (price-Daily-Haul - 2 * stdev-price-Daily-Haul)
set cost-Daily-Haul sustainability-Daily-Haul-random + price-Daily-Haul-random

;; Urban Crate
set sustainability-Urban-Crate-random random-normal sustainability-Urban-Crate stdev-sustainability-Urban-Crate
;set price-Urban-Crate-random random-normal price-Urban-Crate stdev-price-Urban-Crate
  set price-Urban-Crate-random max list (random-normal price-Urban-Crate stdev-price-Urban-Crate) (price-Urban-Crate - 2 *  stdev-price-Urban-Crate)
set cost-Urban-Crate sustainability-Urban-Crate-random + price-Urban-Crate-random



set qty-golden 0
set qty-harvest 0
set qty-sunrise 0
set qty-honey 0
set qty-rye 0


; Set the selected one to 1
if product-choice = "Golden Crust Classic" [
 set qty-golden production
    set PS-t1 random-normal sustainability-Golden-Crust-Classic stdev-sustainability-Golden-Crust-Classic
    set PS-t2 random-normal sustainability-Golden-Crust-Classic stdev-sustainability-Golden-Crust-Classic
]
if product-choice = "Harvest Grain Loaf" [
set qty-harvest production
 set PS-t1  random-normal sustainability-Harvest-Grain-Loaf stdev-sustainability-Harvest-Grain-Loaf
 set PS-t2  random-normal sustainability-Harvest-Grain-Loaf stdev-sustainability-Harvest-Grain-Loaf
]
if product-choice = "Sunrise Sourdough" [
 set qty-sunrise production
 set PS-t1 random-normal sustainability-Sunrise-Sourdough stdev-sustainability-Sunrise-Sourdough
 set PS-t2 random-normal sustainability-Sunrise-Sourdough stdev-sustainability-Sunrise-Sourdough
]
if product-choice = "Honey Wheat Harmony" [
 set qty-honey production
 set PS-t1 random-normal sustainability-Honey-Wheat-Harmony stdev-sustainability-Honey-Wheat-Harmony
 set PS-t2 random-normal sustainability-Honey-Wheat-Harmony stdev-sustainability-Honey-Wheat-Harmony
]
if product-choice = "Rye & Shine" [
 set qty-rye production
 set PS-t1  random-normal sustainability-Rye-and-Shine stdev-sustainability-Rye-and-Shine
 set PS-t2  random-normal sustainability-Rye-and-Shine stdev-sustainability-Rye-and-Shine
]



  if supplier-choice = "Golden Grain Mills" [
    set golden-grain 1
  set SS-t1  random-normal sustainability-Golden-Grain stdev-sustainability-Golden-Grain
 set SS-t2 random-normal sustainability-Golden-Grain stdev-sustainability-Golden-Grain
        set Supplier-sustainable-current-cost sustainability-Golden-Grain-random
    set Supplier-price-current-cost price-Golden-Grain-random
]
if supplier-choice = "Harvest & Hearth Flour Co." [
set harvest-hearth 1
  set SS-t1 random-normal sustainability-Harvest-Hearth stdev-sustainability-Harvest-Hearth
  set SS-t2 random-normal sustainability-Harvest-Hearth stdev-sustainability-Harvest-Hearth
    set Supplier-sustainable-current-cost sustainability-Harvest-Hearth-random
    set Supplier-price-current-cost price-Harvest-Hearth-random
]
if supplier-choice = "Pure-Field Grains" [
 set pure-field 1
  set SS-t1  random-normal sustainability-Pure-Field stdev-sustainability-Pure-Field
 set SS-t2  random-normal sustainability-Pure-Field stdev-sustainability-Pure-Field
     set Supplier-sustainable-current-cost sustainability-Pure-Field-random
    set Supplier-price-current-cost price-Pure-Field-random
]
 if supplier-choice = "Millstone Select" [
 set millstone-select 1
  set SS-t1  random-normal sustainability-Millstone stdev-sustainability-Millstone
 set SS-t2 random-normal sustainability-Millstone stdev-sustainability-Millstone
     set Supplier-sustainable-current-cost sustainability-Millstone-random
    set Supplier-price-current-cost price-Millstone-random
 ]
 if supplier-choice = "Bakers’ Root Supply" [
 set bakers-root 1
  set SS-t1  random-normal sustainability-Bakers-Root stdev-sustainability-Bakers-Root
 set SS-t2 random-normal sustainability-Bakers-Root stdev-sustainability-Bakers-Root
     set Supplier-sustainable-current-cost sustainability-Bakers-Root-random
    set Supplier-price-current-cost price-Bakers-Root-random
 ]

if logistics-choice = "Fresh-Route Logistics" [
set fresh-route 1
  set LS-t1  random-normal sustainability-Fresh-Route stdev-sustainability-Fresh-Route
  set LS-t2  random-normal sustainability-Fresh-Route stdev-sustainability-Fresh-Route
    set Logistics-sustainable-current-cost sustainability-Fresh-Route-random
    set Logistics-price-current-cost  price-Fresh-Route-random
]
if logistics-choice = "Crate & Freight Co." [
set crate-freight 1
  set LS-t1  random-normal sustainability-Crate-Freight stdev-sustainability-Crate-Freight
  set LS-t2  random-normal sustainability-Crate-Freight stdev-sustainability-Crate-Freight
    set Logistics-sustainable-current-cost sustainability-Crate-Freight-random
    set Logistics-price-current-cost  price-Crate-Freight-random
]
if logistics-choice = "Swift-Bite Transport" [
 set swift-bite 1
  set LS-t1  random-normal sustainability-Swift-Bite stdev-sustainability-Swift-Bite
  set LS-t2  random-normal sustainability-Swift-Bite stdev-sustainability-Swift-Bite
    set Logistics-sustainable-current-cost sustainability-Swift-Bite-random
    set Logistics-price-current-cost  price-Swift-Bite-random
]
if logistics-choice = "Daily-Haul Distribution" [
 set daily-haul 1
  set LS-t1  random-normal sustainability-Daily-Haul stdev-sustainability-Daily-Haul
  set LS-t2  random-normal sustainability-Daily-Haul stdev-sustainability-Daily-Haul
    set Logistics-sustainable-current-cost sustainability-Daily-Haul-random
    set Logistics-price-current-cost  price-Daily-Haul-random
]
if logistics-choice = "Urban-Crate Express" [
set urban-crate 1
  set LS-t1  random-normal sustainability-Urban-Crate stdev-sustainability-Urban-Crate
  set LS-t2  random-normal sustainability-Urban-Crate stdev-sustainability-Urban-Crate
    set Logistics-sustainable-current-cost sustainability-Urban-Crate-random
    set Logistics-price-current-cost  price-Urban-Crate-random
 ]

  set d 10
end



to calculate-total-cost
  ;; First generate randomised costs
  generate-random-costs
  draw-balance

  ;; Calculate totalproduction  cost using generated values
  set total-pcost (
    (qty-golden * generated-cost-Golden) +
    (qty-harvest * generated-cost-Harvest) +
    (qty-sunrise * generated-cost-Sunrise) +
    (qty-honey * generated-cost-Honey) +
    (qty-rye * generated-cost-Rye)
  )
    ;; Calculate total supploer  cost using generated values
  set   total-supplier-cost (
    (cost-Golden-Grain * golden-grain + cost-Harvest-Hearth * harvest-hearth + cost-Pure-Field * pure-field + cost-Millstone * millstone-select + cost-Bakers-Root * bakers-root) * qty-golden +
    (cost-Golden-Grain * golden-grain + cost-Harvest-Hearth * harvest-hearth + cost-Pure-Field * pure-field + cost-Millstone * millstone-select + cost-Bakers-Root * bakers-root) * qty-harvest +
    (cost-Golden-Grain * golden-grain + cost-Harvest-Hearth * harvest-hearth + cost-Pure-Field * pure-field + cost-Millstone * millstone-select + cost-Bakers-Root * bakers-root) * qty-sunrise +
    (cost-Golden-Grain * golden-grain + cost-Harvest-Hearth * harvest-hearth + cost-Pure-Field * pure-field + cost-Millstone * millstone-select + cost-Bakers-Root * bakers-root) * qty-honey +
    (cost-Golden-Grain * golden-grain + cost-Harvest-Hearth * harvest-hearth + cost-Pure-Field * pure-field + cost-Millstone * millstone-select + cost-Bakers-Root * bakers-root) * qty-rye
  )
   show (word "Golden Grain Mills - Combined Cost: " cost-Golden-Grain)
  show (word "Harvest & Hearth Flour Co. - Combined Cost: " cost-Harvest-Hearth)
  show (word "Pure-Field Grains - Combined Cost: " cost-Pure-Field)
  show (word "Millstone Select - Combined Cost: " cost-Millstone)
  show (word "Bakers’ Root Supply - Combined Cost: " cost-Bakers-Root)


    ;; Calculate tota logistics  cost using generated values
  set total-logistics-cost(
    (cost-Fresh-Route * fresh-route + cost-Crate-Freight * crate-freight + cost-Swift-Bite * swift-bite + cost-Daily-Haul * daily-haul + cost-Urban-Crate * urban-crate) *  qty-golden +
    (cost-Fresh-Route * fresh-route + cost-Crate-Freight * crate-freight + cost-Swift-Bite * swift-bite + cost-Daily-Haul * daily-haul + cost-Urban-Crate * urban-crate) *  qty-harvest +
    (cost-Fresh-Route * fresh-route + cost-Crate-Freight * crate-freight + cost-Swift-Bite * swift-bite + cost-Daily-Haul * daily-haul + cost-Urban-Crate * urban-crate) *  qty-sunrise +
    (cost-Fresh-Route * fresh-route + cost-Crate-Freight * crate-freight + cost-Swift-Bite * swift-bite + cost-Daily-Haul * daily-haul + cost-Urban-Crate * urban-crate) *  qty-honey +
    (cost-Fresh-Route * fresh-route + cost-Crate-Freight * crate-freight + cost-Swift-Bite * swift-bite + cost-Daily-Haul * daily-haul + cost-Urban-Crate * urban-crate) *  qty-rye

  )



    ;; Display results
  show (word "Fresh-Route Logistics - Combined Cost: " cost-Fresh-Route)
  show (word "Crate & Freight Co. - Combined Cost: " cost-Crate-Freight)
  show (word "Swift-Bite Transport - Combined Cost: " cost-Swift-Bite)
  show (word "Daily-Haul Distribution - Combined Cost: " cost-Daily-Haul)
  show (word "Urban-Crate Express - Combined Cost: " cost-Urban-Crate)

  set total-cost (
    total-logistics-cost +  total-supplier-cost + total-pcost
    )

  show (word "Total Product Cost: " total-pcost)
  show (word "Total supplier  Cost: " total-supplier-cost)
  show (word "Total logistics  Cost: " total-logistics-cost)
  show (word "Total sustainability  Cost: " total-cost)



;output-print (word "Total Supplier Cost: £" precision total-supplier-cost 2)
;output-print (word "Total Logistics Cost: £" precision total-logistics-cost 2)
;output-print (word "Total Production Cost: £" precision total-pcost 2)
  ;output-print (word "Total Sustainability Cost: £" precision total-cost 2)

;; finding max sustainable value
 let Lvalues (list sustainability-Urban-Crate-random sustainability-Daily-Haul-random sustainability-Swift-Bite-random sustainability-Crate-Freight-random sustainability-Fresh-Route-random)
 let Svalues (list sustainability-Bakers-Root-random sustainability-Millstone-random sustainability-Pure-Field-random sustainability-Harvest-Hearth-random  sustainability-Golden-Grain-random)
 let Pvalues (list sustainability-rye sustainability-honey  sustainability-sunrise sustainability-harvest sustainability-golden)
 ;;let Logisticsrouteprices (list cost-Fresh-Route cost-Crate-Freight cost-Swift-Bite cost-Daily-Haul cost-Urban-Crate )
 ;;let Supplierprices (list cost-Golden-Grain  cost-Harvest-Hearth cost-Pure-Field cost-Millstone cost-Bakers-Root)

  ;;let single-logistics-cost(cost-Fresh-Route * fresh-route + cost-Crate-Freight * crate-freight + cost-Swift-Bite * swift-bite + cost-Daily-Haul * daily-haul + cost-Urban-Crate * urban-crate)
  ;;let single-supplier-cost (cost-Golden-Grain * golden-grain + cost-Harvest-Hearth * harvest-hearth + cost-Pure-Field * pure-field + cost-Millstone * millstone-select + cost-Bakers-Root * bakers-root)

;; let names (list "Urban-Crate" "Daily-Haul" "Swift-Bite")
let Lmax-value max Lvalues
  let Smax-value max Svalues
  let Pmax-value max Pvalues
;; let max-index position max-value values
;; let max-name item max-index names
show (word "Max logistics  Cost: " Lmax-value)
show (word "Max supplier  Cost: " Smax-value)
  show (word "Max product  Cost: " Pmax-value)







set product-sustainable-current-cost
  ((qty-golden * sustainability-golden) +
   (qty-harvest * sustainability-harvest) +
   (qty-sunrise * sustainability-sunrise) +
   (qty-honey * sustainability-honey) +
   (qty-rye * sustainability-rye))
  /
  (qty-golden + qty-harvest + qty-sunrise + qty-honey + qty-rye)

set product-price-current-cost
    ((qty-golden * production-golden) +
   (qty-harvest * production-harvest) +
   (qty-sunrise * production-sunrise) +
   (qty-honey * production-honey) +
   (qty-rye * production-rye))
  /
  (qty-golden + qty-harvest + qty-sunrise + qty-honey + qty-rye)


; Your corrected pricing code:
ifelse (Logistics-sustainable-current-cost = Lmax-value) and
  (Supplier-sustainable-current-cost = Smax-value) and
  (Pmax-value = product-sustainable-current-cost) [
 set price 110
] [
 set price min (list Logistics-sustainable-current-cost Supplier-sustainable-current-cost product-sustainable-current-cost)
]

  set priceL ( priceL + price)

show (word "Max price  Cost: " price)
  show (word "Logistics-sustainable-current-cost: " Logistics-sustainable-current-cost)
  show (word "Supplier-sustainable-current-cost: " Supplier-sustainable-current-cost)
  show (word "product-sustainable-current-cost: " product-sustainable-current-cost)

set R-t price *  min (list demand production)
  set P-t R-t - d * (production - min (list demand production)) - production * (product-price-current-cost   + Logistics-price-current-cost + Supplier-price-current-cost)
  set PM-t P-t / R-t
set PMT-tt (PMT-tt + PM-t )

  show (word "R-t: " R-t)
  show (word "P-t: " P-t)
  show (word "PM-t: " PM-t)

;; Demand
    set-current-plot "Demand Production and Price"
    set-current-plot-pen "demand"
        plotxy counters demand

   set-current-plot-pen "production"
        plotxy counters production

  set-current-plot-pen "price"
        plotxy counters price

  ;set-current-plot-pen "total-cost"
   ; plot total-cost

  ; Supplier’s performance

set-current-plot "Supplier’s performance"
    set-current-plot-pen "Supplier’s cost"
    plotxy counters Supplier-price-current-cost
 set-current-plot-pen "Supplier’s environmental sustainability"
    plotxy counters SS-t1
 set-current-plot-pen "Supplier’s social sustainability"
    plotxy counters SS-t2

 ; The firm’s performance

set-current-plot "The firm’s performance"
    set-current-plot-pen "Firm’s profit margin"
    ;plot PM-t
      plotxy counters product-sustainable-current-cost
 set-current-plot-pen "Firm’s environmental sustainability"
        plotxy counters PS-t1
 set-current-plot-pen "Firm’s social sustainability"
        plotxy counters PS-t2

  ; Logistics service provider’s performance
  set-current-plot "Logistics service provider’s performance"
    set-current-plot-pen "Logistics service provider’s cost"
      plotxy counters Logistics-price-current-cost
 set-current-plot-pen "Logistics service provider’s environmental sustainability"
        plotxy counters LS-t1
 set-current-plot-pen "Logistics service provider’s social sustainability"
        plotxy counters  LS-t2

    set FES-t 0.5 * PS-t1 + 0.25 * SS-t1 + 0.25 * LS-t1
  set FSS-t 0.5 * PS-t2 + 0.25 * SS-t2 + 0.25 * LS-t2
  set FES-tt (FES-t + FES-tt)  ;/ (ticks + 1)
  set FSS-tt (FSS-t + FSS-tt) ; / (ticks + 1)

set counters counters + 1

if counters mod 12 = 0 [
; print final outputs
output-print (word "Annual profit margin (in %) : " precision (PMT-tt * 100 / (counters)) 2)
output-print (word "Annual environmental sustainability : " precision (FES-tt / (counters)) 2)
output-print (word "Annual social sustainability : " precision (FSS-tt / counters) 2)
output-print (word "Average price : £" precision (priceL / (counters)) 2)
    ;output-print (word "Average price : £" precision counters 2)
stop
]


    tick

end


; animation

to draw-balance
  clear-patches

  ; Draw supply block (left side) - height based on supply value
  let supply-height production / 10  ; scale the height
  let counter 0
  repeat supply-height [
    ask patch -8 (counter - 4) [ set pcolor red ]
    ask patch -7 (counter - 4) [ set pcolor red ]
    ask patch -6 (counter - 4) [ set pcolor red ]
    ask patch -5 (counter - 4) [ set pcolor red ]
    set counter counter + 1
  ]

  ; Draw demand block (right side) - height based on demand value
  let demand-height demand / 10  ; scale the height
  set counter 0
  repeat demand-height [
    ask patch 5 (counter - 4) [ set pcolor blue ]
    ask patch 6 (counter - 4) [ set pcolor blue ]
    ask patch 7 (counter - 4) [ set pcolor blue ]
    ask patch 8 (counter - 4) [ set pcolor blue ]
    set counter counter + 1
  ]

  ; Draw balance beam (brown)
  ask patch -10 -5 [ set pcolor brown ]
  ask patch -9 -5 [ set pcolor brown ]
  ask patch -8 -5 [ set pcolor brown ]
  ask patch -7 -5 [ set pcolor brown ]
  ask patch -6 -5 [ set pcolor brown ]
  ask patch -5 -5 [ set pcolor brown ]
  ask patch -4 -5 [ set pcolor brown ]
  ask patch -3 -5 [ set pcolor brown ]
  ask patch -2 -5 [ set pcolor brown ]
  ask patch -1 -5 [ set pcolor brown ]
  ask patch 0 -5 [ set pcolor brown ]
  ask patch 1 -5 [ set pcolor brown ]
  ask patch 2 -5 [ set pcolor brown ]
  ask patch 3 -5 [ set pcolor brown ]
  ask patch 4 -5 [ set pcolor brown ]
  ask patch 5 -5 [ set pcolor brown ]
  ask patch 6 -5 [ set pcolor brown ]
  ask patch 7 -5 [ set pcolor brown ]
  ask patch 8 -5 [ set pcolor brown ]
  ask patch 9 -5 [ set pcolor brown ]
  ask patch 10 -5 [ set pcolor brown ]

  ; Draw fulcrum supports (gray)
  ask patch -1 -6 [ set pcolor gray ]
  ask patch 0 -6 [ set pcolor gray ]
  ask patch 1 -6 [ set pcolor gray ]

  ; Add labels
  ask patch -6 8 [
    set plabel "Production"
    set plabel-color red
  ]

  ask patch 6 8 [
    set plabel "Demand"
    set plabel-color blue
  ]

  ; Show balance status
  if production = demand [
    ask patch 0 6 [
      set plabel "BALANCED"
      set plabel-color green
    ]
  ]
  if production > demand [
    ask patch 0 6 [
      set plabel ""
    ]
  ]
  if demand > production [
    ask patch 0 6 [
      set plabel ""
    ]
  ]
end

; Copyright 2024 Dr. Mohit Kumar Singh & Dr. D- Tan.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
436
137
818
399
-1
-1
12.065
1
10
1
1
1
0
1
1
1
-15
15
-10
10
0
0
1
ticks
30.0

BUTTON
38
15
107
48
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
11
286
375
319
Calculate Costs once
calculate-total-cost
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
282
10
405
55
supplier-choice
supplier-choice
"Golden Grain Mills" "Harvest & Hearth Flour Co." "Pure-Field Grains" "Millstone Select" "Bakers’ Root Supply"
0

CHOOSER
405
10
538
55
logistics-choice
logistics-choice
"Fresh-Route Logistics" "Crate & Freight Co." "Swift-Bite Transport" "Daily-Haul Distribution" "Urban-Crate Express"
0

OUTPUT
10
324
376
388
11

CHOOSER
106
10
215
55
product-choice
product-choice
"Golden Crust Classic" "Harvest Grain Loaf" "Sunrise Sourdough" "Honey Wheat Harmony" "Rye & Shine"
3

INPUTBOX
216
10
282
70
production
100.0
1
0
Number

BUTTON
544
10
768
55
Run for year
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
11
399
374
683
Demand Production and Price
Months
Demand/Production/Price
1.0
12.0
0.0
3.0
true
true
"" ""
PENS
"demand" 1.0 0 -16777216 true "" ""
"production" 1.0 0 -2674135 true "" ""
"price" 1.0 0 -13345367 true "" ""

TEXTBOX
25
80
422
220
Step 1: Click on \"Setup\" button to set the values you chose in Step 1 (do not repeat this step for subsequent rounds)\n\nStep 2: Choose your                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               